/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.print;

import com.nokia.em.poseidon.frameworks.print.PPrintableArea;
import com.nokia.em.poseidon.frameworks.print.PPrintableObject;
import com.nokia.em.poseidon.frameworks.print.PPrintablePage;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class PPrintImage
extends PPrintableObject {
    private Image myImage;
    private BufferedImage myScaledImage;
    private boolean myShowPageNumber = false;
    private String myPageNumber = " ";
    private PPrintableArea myParent;
    private Font myFont;

    public PPrintImage(Image image, int width, int height, PPrintableArea parentArea) {
        this.myParent = parentArea;
        this.setStartPoint(0.0, 0.0);
        this.myImage = image;
    }

    public PPrintImage(Image image, PPrintableArea parentArea) {
        this(image, 0, 0, parentArea);
    }

    @Override
    public double getWidestPointLength() {
        return this.getStartPointX() + (double)this.myScaledImage.getWidth();
    }

    @Override
    public double getHighestPointLength() {
        return this.getStartPointY() + (double)this.myScaledImage.getHeight();
    }

    @Override
    protected void clear() {
        super.clear();
    }

    @Override
    protected boolean calculatePrintableArea(PPrintableArea area) {
        double scaleRate = 1.0;
        double scaleRateX = 1.0;
        double scaleRateY = 1.0;
        int imageWidth = ((BufferedImage)this.myImage).getWidth();
        int imageHeight = ((BufferedImage)this.myImage).getHeight();
        Dimension pageDimensions = this.getPageDimensions();
        if (area instanceof PPrintablePage) {
            PPrintablePage pPrintablePage = (PPrintablePage)area;
            pageDimensions = pPrintablePage.getInitialPageAvailableArea().getSize();
        }
        if (pageDimensions.getWidth() < (double)imageWidth) {
            scaleRateX = pageDimensions.getWidth() / (double)imageWidth;
        }
        if (pageDimensions.getHeight() < (double)imageHeight) {
            scaleRateY = pageDimensions.getHeight() / (double)imageHeight;
        }
        scaleRate = Math.min(scaleRateX, scaleRateY);
        this.myScaledImage = ((BufferedImage)this.myImage).getSubimage((int)this.getStartPointX(), (int)this.getStartPointY(), (int)((double)imageWidth * scaleRate), (int)((double)imageHeight * scaleRate));
        this.setArea(new Rectangle((int)((double)imageWidth * scaleRate), (int)((double)imageHeight * scaleRate)));
        return true;
    }

    @Override
    protected void draw(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.drawImage(this.myImage, (int)this.getStartPointX(), (int)this.getStartPointY() - g2d.getFont().getSize(), this.myScaledImage.getWidth(), this.myScaledImage.getHeight(), null);
        if (this.myShowPageNumber) {
            double pageNumberX = this.getArea().width - g2d.getFontMetrics().stringWidth(this.myPageNumber);
            double imageHeightShift = 0.0;
            if ((double)this.myScaledImage.getWidth() > pageNumberX) {
                imageHeightShift = this.myScaledImage.getHeight();
            }
            g2d.drawString(this.myPageNumber, (float)pageNumberX, (float)(imageHeightShift + this.getStartPointY()));
        }
    }

    @Override
    protected PPrintableObject getExceedingPart() {
        return null;
    }

    @Override
    protected void showHeaderPageNumber(boolean showPageNumber) {
        this.myShowPageNumber = showPageNumber;
    }

    @Override
    protected void setHeaderPageNumber(int pageNumber) {
        this.myPageNumber = String.valueOf(pageNumber);
    }

    @Override
    protected PPrintableArea getParent() {
        return this.myParent;
    }

    @Override
    protected Font getFont() {
        if (this.myFont == null) {
            this.myFont = this.getParent().getFont();
        }
        return this.myFont;
    }

    @Override
    protected PPrintableObject getObjectCopy() {
        PPrintImage copyObject = new PPrintImage(this.myImage, this.getParent());
        return copyObject;
    }

    @Override
    protected void setParent(PPrintableArea parent) {
        this.myParent = parent;
    }
}

