/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.print;

import com.nokia.em.poseidon.frameworks.print.PPrintableArea;
import com.nokia.em.poseidon.frameworks.print.PPrintableObject;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class PPrintLine
extends PPrintableObject {
    private static final int LINE_HEIGHT = 10;
    private int myStartX;
    private int myStartY;
    private int myStopX;
    private int myStopY;
    private double myRelativeStartX;
    private double myRelativeStartY;
    private double myRelativeStopX;
    private double myRelativeStopY;
    private PPrintableArea myParent;
    private Font myFont;

    public PPrintLine(double startX, double endX, double startY, double endY, PPrintableArea parentArea) {
        this.myParent = parentArea;
        this.myRelativeStartX = startX;
        this.myRelativeStartY = startY;
        this.myRelativeStopX = endX;
        this.myRelativeStopY = endY;
        this.setStartPoint(0.0, 0.0);
    }

    @Override
    protected void clear() {
        super.clear();
    }

    @Override
    public double getWidestPointLength() {
        return this.myStopX;
    }

    @Override
    public double getHighestPointLength() {
        return this.myStopY;
    }

    @Override
    protected boolean calculatePrintableArea(PPrintableArea area) {
        this.myStartX = (int)this.myRelativeStartX * this.getPageDimensions().width;
        this.myStopX = (int)this.myRelativeStopX * this.getPageDimensions().width;
        this.myStartY = 0;
        this.myStopY = (int)(this.myRelativeStopY * (double)this.getPageDimensions().height);
        this.setArea(new Rectangle(this.myStopX - this.myStartX, 10));
        return true;
    }

    @Override
    protected void draw(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics;
        int startPointY = (int)this.getStartPointY();
        double startY = this.myStartY + startPointY < 5 ? this.myStartY + startPointY : this.myStartY + startPointY - 5;
        double stopY = this.myStopY + startPointY < 5 ? this.myStopY + startPointY : this.myStopY + startPointY - 5;
        g2d.drawLine(this.myStartX + (int)this.getStartPointX(), (int)startY, this.myStopX + (int)this.getStartPointX(), (int)stopY);
    }

    @Override
    protected PPrintableObject getExceedingPart() {
        return null;
    }

    @Override
    protected void showHeaderPageNumber(boolean showPageNumber) {
    }

    @Override
    protected void setHeaderPageNumber(int pageNumber) {
    }

    @Override
    protected PPrintableArea getParent() {
        return this.myParent;
    }

    @Override
    protected Font getFont() {
        if (this.myFont == null) {
            this.myFont = this.getParent().getFont();
        }
        return this.myFont;
    }

    @Override
    protected PPrintableObject getObjectCopy() {
        PPrintLine copyObject = new PPrintLine(this.myRelativeStartX, this.myRelativeStopX, this.myRelativeStartY, this.myRelativeStopY, this.getParent());
        return copyObject;
    }

    @Override
    protected void setParent(PPrintableArea parent) {
        this.myParent = parent;
    }

    public int getLineHeight() {
        return 10;
    }
}

