/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.print;

import com.nokia.em.poseidon.frameworks.print.PIconCellPrinter;
import com.nokia.em.poseidon.frameworks.print.PPrintableArea;
import com.nokia.em.poseidon.frameworks.print.PPrintableObject;
import com.nokia.em.poseidon.frameworks.print.PPrintablePage;
import com.nokia.em.poseidon.frameworks.print.PTableCellPrinter;
import com.nokia.em.poseidon.frameworks.print.PTextCellPrinter;
import com.nokia.widgets.table.PTable;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class PPrintTable
extends PPrintableObject {
    private static final PTableCellPrinter DEFAULT_CELL_PRINTER = new PTextCellPrinter();
    protected int myTopMarginal = 10;
    protected int myBottomMarginal = 10;
    protected int myLeftMarginal = 10;
    protected int myRightMarginal = 10;
    protected JTable myTable;
    private PTable mySubTable;
    protected int myColumnsCount;
    protected int myRowsCount;
    private Map<Integer, Object> myHeaderGroups;
    private static final int HEADERROW_NUMBER_THREE = 3;
    private static final int HEADERROW_NUMBER_TWO = 2;
    protected List myLines = new ArrayList();
    private Font myFont;
    protected double[] myColumnWidths;
    protected double[] myRowHeights;
    protected double[] myColumnCoordinates;
    protected double[] myRowCoordinates;
    protected double myTableWidth;
    protected double myTableHeight;
    protected double mySubTableHeight;
    protected int myRowsFitsToFirstPage;
    protected boolean myDrawLines = true;
    private boolean myShowPageNumber = false;
    private String myPageNumber = " ";
    protected PPrintableArea myParent;
    private Map<Class, PTableCellPrinter> myCellPrinters;
    protected int myColumnMaxWidth = 1;
    protected boolean myPaintHeader;
    protected boolean myPaintHeaderLine;
    protected boolean myHeaderDivided;
    protected int myHeaderRows = 1;
    protected double myHeaderLineBasis;

    public PPrintTable(TableModel table, PPrintableArea parentArea) {
        this(new JTable(table), parentArea);
    }

    public PPrintTable(JTable table, PPrintableArea parentArea) {
        this.myParent = parentArea;
        this.myTable = table;
        this.myCellPrinters = new HashMap<Class, PTableCellPrinter>();
        this.setCellPrinter(String.class, new PTextCellPrinter());
        this.setCellPrinter(Icon.class, new PIconCellPrinter());
        this.setCellPrinter(ImageIcon.class, new PIconCellPrinter());
        this.myFont = this.getParent().getFont();
        Object headerGroup = table.getClientProperty("OrangeTouch.headerGroups");
        if (headerGroup != null) {
            this.myHeaderGroups = (Map)headerGroup;
        }
    }

    public void setCellPrinter(Class cellClass, PTableCellPrinter cellPrinter) {
        this.myCellPrinters.put(cellClass, cellPrinter);
    }

    public PTableCellPrinter getCellPrinter(Class cellClass) {
        if (this.myCellPrinters.containsKey(cellClass)) {
            return this.myCellPrinters.get(cellClass);
        }
        return DEFAULT_CELL_PRINTER;
    }

    public void setDrawTableLines(boolean drawLines) {
        this.myDrawLines = drawLines;
    }

    public boolean getDrawTableLines() {
        return this.myDrawLines;
    }

    public void setCellTopMarginal(int topMarginal) {
        this.myTopMarginal = topMarginal;
    }

    public void setCellBottomMarginal(int bottomMarginal) {
        this.myBottomMarginal = bottomMarginal;
    }

    public void setCellLeftMarginal(int leftMarginal) {
        this.myLeftMarginal = leftMarginal;
    }

    public void setCellRightMarginal(int rightMarginal) {
        this.myRightMarginal = rightMarginal;
    }

    public int getCellTopMarginal() {
        return this.myTopMarginal;
    }

    public int getCellBottomMarginal() {
        return this.myBottomMarginal;
    }

    public int getCellLeftMarginal() {
        return this.myLeftMarginal;
    }

    public int getCellRightMarginal() {
        return this.myRightMarginal;
    }

    public void setColumnMaxWidth(int columnMaxWidth) {
        this.myColumnMaxWidth = columnMaxWidth;
    }

    public int getColumnMaxWidth() {
        return this.myColumnMaxWidth;
    }

    public int getColumnContentMaxWidth() {
        return this.myColumnMaxWidth - this.myLeftMarginal - this.myRightMarginal;
    }

    public void setPaintTableHeader(boolean paintHeader) {
        this.myPaintHeader = paintHeader;
    }

    public boolean getPaintTableHeader() {
        return this.myPaintHeader;
    }

    public void setPaintHeaderLine(boolean paintLine) {
        this.myPaintHeaderLine = paintLine;
    }

    public boolean getPaintHeaderLine() {
        return this.myPaintHeaderLine;
    }

    public void setFont(Font font) {
        this.myFont = font;
        Set<Class> printerKeys = this.myCellPrinters.keySet();
        Iterator<Class> iter = printerKeys.iterator();
        while (iter.hasNext()) {
            this.myCellPrinters.get(iter.next()).setFont(font);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(" Table columns: ");
        builder.append(this.myTable.getColumnCount());
        builder.append(" Rows: ");
        builder.append(this.myTable.getRowCount());
        builder.append(" Draw lines: ");
        builder.append(this.myDrawLines);
        builder.append(" Draw header: ");
        builder.append(this.myPaintHeader);
        builder.append(super.toString());
        return builder.toString();
    }

    @Override
    public Font getFont() {
        if (this.myFont == null) {
            this.myFont = this.getParent().getFont();
        }
        return this.myFont;
    }

    @Override
    public double getWidestPointLength() {
        return this.myTableWidth;
    }

    @Override
    protected boolean calculatePrintableArea(PPrintableArea area) {
        this.setApproximateColMaxWidth();
        this.myColumnsCount = this.myTable.getColumnCount();
        this.myRowsCount = this.myTable.getRowCount();
        if (this.myPaintHeader) {
            ++this.myRowsCount;
        }
        if (this.isPaintHeaderGroups()) {
            ++this.myRowsCount;
            ++this.myHeaderRows;
        }
        this.calculateCellDimensions();
        this.myRowsFitsToFirstPage = this.myRowsCount;
        this.mySubTableHeight = this.myTableHeight;
        boolean fitsToPage = this.fitsToPage(area);
        this.defineTableLines();
        this.setArea(new Rectangle((int)this.myTableWidth, (int)this.mySubTableHeight + 1));
        return fitsToPage;
    }

    private boolean isPaintHeaderGroups() {
        return this.myHeaderGroups != null && !this.myHeaderGroups.isEmpty();
    }

    public void setApproximateColMaxWidth() {
        if (this.myTableWidth > this.getPageDimensions().getWidth() && this.myColumnWidths != null) {
            double maxColWidth = this.getPageDimensions().getWidth() / (double)this.myColumnWidths.length;
            this.setColumnMaxWidth((int)maxColWidth);
        }
    }

    protected void drawHeaderLine(Graphics graphics) {
        graphics.drawLine((int)this.getStartPointX(), (int)(this.getStartPointY() + this.myHeaderLineBasis), (int)(this.getStartPointX() + this.myTableWidth), (int)(this.getStartPointY() + this.myHeaderLineBasis));
    }

    protected void defineTableLines() {
        this.myLines.clear();
        this.myColumnCoordinates = new double[this.myColumnsCount + 1];
        this.myRowCoordinates = new double[this.myRowsCount + 1];
        this.myColumnCoordinates[0] = 0.0;
        this.myRowCoordinates[0] = 0.0;
        int index = 0;
        while (index < this.myColumnCoordinates.length - 1) {
            this.myColumnCoordinates[index + 1] = this.myColumnCoordinates[index] + (double)((int)this.myColumnWidths[index]);
            int[] nArray = new int[4];
            nArray[0] = (int)this.myColumnCoordinates[index + 1];
            nArray[2] = (int)this.myColumnCoordinates[index + 1];
            nArray[3] = (int)this.mySubTableHeight;
            this.myLines.add(nArray);
            ++index;
        }
        index = 0;
        while (index < this.myRowsFitsToFirstPage) {
            this.myRowCoordinates[index + 1] = this.myRowCoordinates[index] + (double)((int)this.myRowHeights[index]);
            int[] nArray = new int[4];
            nArray[1] = (int)this.myRowCoordinates[index + 1];
            nArray[2] = (int)this.myTableWidth;
            nArray[3] = (int)this.myRowCoordinates[index + 1];
            this.myLines.add(nArray);
            ++index;
        }
        if (this.myRowHeights.length > 0) {
            this.myHeaderLineBasis = this.myRowCoordinates[0] + this.myRowHeights[0] - 2.0;
        } else {
            this.myPaintHeaderLine = false;
        }
        int[] nArray = new int[4];
        nArray[2] = (int)this.myTableWidth;
        this.myLines.add(nArray);
        int[] nArray2 = new int[4];
        nArray2[3] = (int)this.mySubTableHeight;
        this.myLines.add(nArray2);
    }

    @Override
    protected void draw(Graphics graphics) {
        graphics.setFont(this.getFont());
        Graphics2D g2 = (Graphics2D)graphics;
        PTableCellPrinter cellPrinter = null;
        Object value = null;
        AffineTransform saveAT = g2.getTransform();
        Shape saveClip = graphics.getClip();
        AffineTransform transform = new AffineTransform();
        int cellWidth = 0;
        int cellHeight = 0;
        this.drawLines(graphics);
        int rowsToBePainted = this.myPaintHeader ? this.myRowsFitsToFirstPage + 1 : this.myRowsFitsToFirstPage;
        int column = 0;
        while (column < this.myColumnsCount) {
            int row = 0;
            while (row < rowsToBePainted && row < this.myRowHeights.length) {
                cellWidth = (int)this.myColumnWidths[column];
                cellHeight = (int)this.myRowHeights[row];
                value = this.isPaintHeaderGroups() ? this.drawWithHeaderGroups(column, row) : this.drawWithoutHeaderGroups(column, row);
                cellPrinter = this.getCellPrinter(value.getClass());
                if (cellPrinter != null) {
                    cellPrinter.setFont(this.getFont());
                    transform.setTransform(1.0, 0.0, 0.0, 1.0, this.myColumnCoordinates[column] + this.getStartPointX() + (double)this.myLeftMarginal, this.myRowCoordinates[row] + this.getStartPointY() + (double)this.myTopMarginal);
                    g2.transform(transform);
                    int widthExceptMarginal = cellWidth - this.myLeftMarginal - this.myRightMarginal > 0 ? cellWidth - this.myLeftMarginal - this.myRightMarginal : 1;
                    int heightExceptMarginal = cellHeight - this.myTopMarginal - this.myBottomMarginal > 0 ? cellHeight - this.myTopMarginal - this.myBottomMarginal : 1;
                    g2.setClip(0, 0, widthExceptMarginal, heightExceptMarginal);
                    cellPrinter.drawCell(g2, value);
                    g2.setTransform(saveAT);
                }
                ++row;
            }
            ++column;
        }
        g2.setTransform(saveAT);
        g2.setClip(saveClip);
        this.drawPageNumber(graphics);
    }

    private Object drawWithoutHeaderGroups(int column, int row) {
        Object value = this.myPaintHeader && row == 0 ? this.myTable.getColumnModel().getColumn(column).getHeaderValue() : (this.myPaintHeader ? this.myTable.getValueAt(row - 1, column) : this.myTable.getValueAt(row, column));
        if (value == null) {
            value = " ";
        }
        return value;
    }

    private Object drawWithHeaderGroups(int column, int row) {
        Object value = this.myPaintHeader && row == 0 ? this.myHeaderGroups.get(column) : (this.myPaintHeader && row == 1 ? this.myTable.getColumnModel().getColumn(column).getHeaderValue() : (this.myPaintHeader ? this.myTable.getValueAt(row - 2, column) : this.myTable.getValueAt(row, column)));
        if (value == null) {
            value = " ";
        }
        return value;
    }

    @Override
    protected PPrintableObject getExceedingPart() {
        PPrintTable printTable = null;
        if (this.mySubTable != null) {
            printTable = new PPrintTable(this.mySubTable.getModel(), this.myParent);
            printTable.setDrawTableLines(this.getDrawTableLines());
            printTable.setPaintTableHeader(this.getPaintTableHeader());
            printTable.setPaintHeaderLine(this.getPaintHeaderLine());
            printTable.setCellTopMarginal(this.getCellTopMarginal());
            printTable.setCellBottomMarginal(this.getCellBottomMarginal());
            printTable.setCellLeftMarginal(this.getCellLeftMarginal());
            printTable.setCellRightMarginal(this.getCellRightMarginal());
            printTable.setColumnMaxWidth(this.getColumnMaxWidth());
        }
        return printTable;
    }

    @Override
    protected void showHeaderPageNumber(boolean showPageNumber) {
        this.myShowPageNumber = showPageNumber;
    }

    @Override
    protected void setHeaderPageNumber(int pageNumber) {
        this.myPageNumber = String.valueOf(pageNumber);
    }

    @Override
    protected PPrintableArea getParent() {
        return this.myParent;
    }

    @Override
    protected PPrintableObject getObjectCopy() {
        PPrintTable copyObject = new PPrintTable(this.myTable.getModel(), this.getParent());
        copyObject.setPaintHeaderLine(this.getPaintHeaderLine());
        copyObject.setPaintTableHeader(this.getPaintTableHeader());
        copyObject.setDrawTableLines(this.getDrawTableLines());
        copyObject.setCellTopMarginal(this.getCellTopMarginal());
        copyObject.setCellBottomMarginal(this.getCellBottomMarginal());
        copyObject.setCellLeftMarginal(this.getCellLeftMarginal());
        copyObject.setCellRightMarginal(this.getCellRightMarginal());
        copyObject.setColumnMaxWidth(this.getColumnMaxWidth());
        copyObject.setFont(this.getFont());
        return copyObject;
    }

    @Override
    protected void setParent(PPrintableArea parent) {
        this.myParent = parent;
    }

    protected void calculateCellDimensions() {
        this.myColumnWidths = new double[this.myColumnsCount];
        this.myRowHeights = new double[this.myRowsCount];
        double tableHeight = 0.0;
        double tableWidth = 0.0;
        int row = 0;
        while (row < this.myRowsCount) {
            int column = 0;
            while (column < this.myColumnsCount) {
                if (this.isPaintHeaderGroups()) {
                    this.calculateCellDimensionsWithGroupHeader(row, column);
                } else {
                    this.calculateCellDimensionsWithoutGroupHeader(row, column);
                }
                ++column;
            }
            ++row;
        }
        int i = 0;
        while (i < this.myRowHeights.length) {
            tableHeight += this.myRowHeights[i];
            ++i;
        }
        this.myTableHeight = tableHeight;
        i = 0;
        while (i < this.myColumnWidths.length) {
            tableWidth += this.myColumnWidths[i];
            ++i;
        }
        this.myTableWidth = tableWidth;
    }

    private void calculateCellDimensionsWithoutGroupHeader(int row, int column) {
        if (this.myPaintHeader && row == 0) {
            Object value = this.myTable.getColumnModel().getColumn(column).getHeaderValue();
            this.checkCellDimension(value, row, column);
        } else if (this.myPaintHeader && this.myTable.getValueAt(row - 1, column) != null) {
            Object value = this.myTable.getValueAt(row - 1, column);
            this.checkCellDimension(value, row, column);
        } else if (!this.myPaintHeader && this.myTable.getValueAt(row, column) != null) {
            Object value = this.myTable.getValueAt(row, column);
            this.checkCellDimension(value, row, column);
        }
    }

    private void calculateCellDimensionsWithGroupHeader(int row, int column) {
        if (this.myPaintHeader) {
            if (row == 0) {
                Object value = this.myHeaderGroups.get(column);
                this.checkCellDimension(value, row, column);
            } else if (row == 1) {
                Object value = this.myTable.getColumnModel().getColumn(column).getHeaderValue();
                this.checkCellDimension(value, row, column);
            } else if (this.myTable.getValueAt(row - 2, column) != null) {
                Object value = this.myTable.getValueAt(row - 2, column);
                this.checkCellDimension(value, row, column);
            }
        } else if (this.myTable.getValueAt(row, column) != null) {
            Object value = this.myTable.getValueAt(row, column);
            this.checkCellDimension(value, row, column);
        }
    }

    protected boolean fitsToPage(PPrintableArea area) {
        int availableHeight = 0;
        double dimentionHeight = 0.0;
        if (area != null && area instanceof PPrintablePage) {
            availableHeight = ((PPrintablePage)area).getPageAvailableArea().height;
            dimentionHeight = ((PPrintablePage)area).getPageDimension().getHeight();
        } else if (area != null) {
            availableHeight = area.getArea().height;
            dimentionHeight = area.getArea().height;
        }
        if (this.myTableHeight > (double)availableHeight) {
            int heightOfRows = this.isPaintHeader() ? (int)this.myRowHeights[0] : 0;
            int index = 0;
            this.myRowsFitsToFirstPage = 0;
            while (index < this.myRowHeights.length && heightOfRows < availableHeight) {
                heightOfRows = (int)((double)heightOfRows + this.myRowHeights[index]);
                ++index;
            }
            this.calculateRowsFitsToFirstPage(index);
            if (this.getFirstRowWhichDoesNotFitToPage() < dimentionHeight) {
                this.mySubTableHeight = (double)heightOfRows - this.myRowHeights[this.myRowsFitsToFirstPage];
                this.divideTableToParts(this.myRowsFitsToFirstPage);
                return false;
            }
            if (this.myPaintHeader && this.myRowsCount > 2 || !this.myPaintHeader && this.myRowsCount > 1) {
                this.mySubTableHeight = heightOfRows;
                this.divideTableToParts(this.myRowsFitsToFirstPage);
                return false;
            }
            this.myRowsFitsToFirstPage = this.myPaintHeader ? 2 : 1;
        }
        return true;
    }

    private void calculateRowsFitsToFirstPage(int index) {
        int n = this.myRowsFitsToFirstPage = this.isPaintHeader() && index > 0 ? index - 1 : index;
        if (this.myRowsFitsToFirstPage == this.myRowHeights.length) {
            this.myRowsFitsToFirstPage = this.myRowHeights.length - 1;
        }
    }

    private double getFirstRowWhichDoesNotFitToPage() {
        if (this.myRowsFitsToFirstPage == 1 && this.isPaintHeader()) {
            return this.myRowHeights[0] + this.myRowHeights[1];
        }
        if (this.myRowHeights.length > this.myRowsFitsToFirstPage) {
            return this.myRowHeights[this.myRowsFitsToFirstPage];
        }
        return this.myRowHeights[0];
    }

    protected void checkCellDimension(Object value, int row, int column) {
        Object valueForCheck = value == null ? " " : value;
        Dimension cellDimension = null;
        PTableCellPrinter cellPrinter = this.getCellPrinter(valueForCheck.getClass());
        if (cellPrinter != null) {
            cellPrinter.setFont(this.getFont());
            cellDimension = cellPrinter.getPrintSize(valueForCheck, this, false);
            if (cellDimension.getWidth() > (double)this.getColumnContentMaxWidth() && this.getColumnContentMaxWidth() > 10) {
                cellDimension = cellPrinter.getPrintSize(valueForCheck, this, true);
                if (this.myPaintHeader && row == 0) {
                    this.myHeaderDivided = true;
                    this.myHeaderRows = this.isPaintHeaderGroups() ? 3 : 2;
                }
            }
            this.myRowHeights[row] = Math.max(cellDimension.getHeight() + (double)this.myTopMarginal + (double)this.myBottomMarginal, this.myRowHeights[row]);
            if (cellDimension.getWidth() + (double)this.myLeftMarginal + (double)this.myRightMarginal > this.myColumnWidths[column]) {
                this.myColumnWidths[column] = this.myColumnMaxWidth > 10 ? Math.min((double)this.myColumnMaxWidth, cellDimension.getWidth() + (double)this.myLeftMarginal + (double)this.myRightMarginal) : cellDimension.getWidth() + (double)this.myLeftMarginal + (double)this.myRightMarginal;
            }
        }
    }

    protected void divideTableToParts(int rowNumOfFirstTable) {
        int rowsOfFirstTable = rowNumOfFirstTable;
        Object value = null;
        int rowsToBeIterated = this.myPaintHeader ? this.myRowsCount - 1 : this.myRowsCount;
        Object[][] dataContent = new Object[rowsToBeIterated - rowNumOfFirstTable][this.myColumnsCount];
        Object[] columnNames = new Object[this.myColumnsCount];
        int i = 0;
        while (i < this.myColumnsCount) {
            columnNames[i] = this.myTable.getColumnModel().getColumn(i).getHeaderValue();
            ++i;
        }
        int initRow = 0;
        int column = 0;
        while (column < this.myColumnsCount) {
            initRow = 0;
            int row = rowsOfFirstTable;
            while (row < rowsToBeIterated) {
                value = !this.myPaintHeader ? this.myTable.getValueAt(row, column) : (this.isPaintHeaderGroups() ? (row == 0 ? this.myHeaderGroups.get(column) : (row == 1 ? this.myTable.getColumnModel().getColumn(column).getHeaderValue() : this.myTable.getValueAt(row - 2, column))) : (this.myTable.getRowCount() > row ? this.myTable.getValueAt(row, column) : this.myTable.getValueAt(row - 1, column)));
                if (value == null) {
                    value = " ";
                }
                dataContent[initRow][column] = value;
                ++initRow;
                ++row;
            }
            ++column;
        }
        this.mySubTable = new PTable(dataContent, columnNames);
        if (this.myHeaderGroups != null) {
            for (Integer startColumn : this.myHeaderGroups.keySet()) {
                this.mySubTable.addHeaderGroup(startColumn, this.myHeaderGroups.get(startColumn));
            }
        }
    }

    protected void drawLines(Graphics graphics) {
        if (this.myPaintHeaderLine && this.myRowsFitsToFirstPage > 0) {
            if (this.isPaintHeaderGroups()) {
                this.drawheaderLineWithGroupHeaders(graphics);
            } else {
                this.drawHeaderLine(graphics);
            }
        }
        if (this.myDrawLines) {
            for (int[] item : this.myLines) {
                graphics.drawLine((int)this.getStartPointX() + item[0], (int)(this.getStartPointY() + (double)item[1]), (int)this.getStartPointX() + item[2], (int)(this.getStartPointY() + (double)item[3]));
            }
        }
    }

    private void drawheaderLineWithGroupHeaders(Graphics graphics) {
        if (this.myRowHeights.length > 0) {
            double headerLineLocation = this.myRowCoordinates[1] + this.myRowHeights[1];
            graphics.drawLine((int)this.getStartPointX(), (int)(this.getStartPointY() + headerLineLocation), (int)(this.getStartPointX() + this.myTableWidth), (int)(this.getStartPointY() + headerLineLocation));
        }
    }

    protected void drawPageNumber(Graphics graphics) {
        if (this.myShowPageNumber) {
            double pageNumberX = this.getArea().width - graphics.getFontMetrics().stringWidth(this.myPageNumber);
            double tableHeightShift = 0.0;
            if (this.myTableWidth > pageNumberX) {
                tableHeightShift = this.myTableHeight;
            }
            graphics.drawString(this.myPageNumber, (int)pageNumberX, (int)(tableHeightShift + this.getStartPointY()));
        }
    }

    public boolean isPaintHeader() {
        return this.myPaintHeader;
    }

    public int getRowsInFirstPage() {
        return this.myRowsFitsToFirstPage;
    }

    @Override
    protected double getHighestPointLength() {
        return this.myTableHeight;
    }
}

