/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.print;

import com.nokia.em.poseidon.frameworks.print.PPrintableArea;
import com.nokia.em.poseidon.frameworks.print.PPrintableObject;
import com.nokia.em.poseidon.frameworks.print.PPrintablePage;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PPrintText
extends PPrintableObject {
    public static final int EMPTY_ROW_SPACE = 5;
    private String myText;
    private Font myFont;
    private final Map myAttributes = new HashMap();
    private List myTextLayouts = new ArrayList();
    private Map myTextLayoutLocations = new HashMap();
    private int myIndent;
    private boolean myShowPageNumber = false;
    private String myPageNumber = " ";
    private PPrintableArea myParent;
    private List myTexts = new ArrayList();
    private ALIGN myAlign;
    private String myLineSeparator;
    private PPrintText myOverflownText;

    public PPrintText(String text, PPrintableArea parentArea) {
        this.myParent = parentArea;
        this.myText = text;
        if (this.myText == null) {
            this.myText = " ";
        }
        this.myIndent = 0;
        this.setLineSeparator("\r\n");
    }

    public void setFont(Font font) {
        this.myFont = font;
    }

    @Override
    public Font getFont() {
        if (this.myFont == null) {
            this.myFont = this.getParent().getFont();
        }
        return this.myFont;
    }

    @Override
    public double getWidestPointLength() {
        double myWidth = 0.0;
        if (this.myTexts != null) {
            if (this.myTexts.size() > 0) {
                int x = 0;
                while (x < this.myTexts.size()) {
                    GlyphVector g = this.myFont.createGlyphVector(new FontRenderContext(this.getFont().getTransform(), true, true), (String)this.myTexts.get(x));
                    Rectangle2D r = g.getLogicalBounds();
                    double a = r.getWidth() + r.getX();
                    if (a > myWidth) {
                        myWidth = a;
                    }
                    ++x;
                }
            } else if (this.myText != null && this.myText.length() > 0) {
                myWidth = this.myFont.createGlyphVector(new FontRenderContext(this.getFont().getTransform(), true, true), this.myText).getLogicalBounds().getWidth();
            }
        }
        return myWidth;
    }

    @Override
    public double getHighestPointLength() {
        double myHeight = 0.0;
        if (this.myTexts != null) {
            if (this.myTexts.size() > 0) {
                GlyphVector g = this.myFont.createGlyphVector(new FontRenderContext(this.getFont().getTransform(), true, true), (String)this.myTexts.get(0));
                Rectangle2D r = g.getLogicalBounds();
                double a = r.getHeight() + r.getY();
                myHeight = a * (double)this.myTexts.size();
            } else if (this.myText != null && this.myText.length() > 0) {
                myHeight = this.myFont.createGlyphVector(new FontRenderContext(this.getFont().getTransform(), true, true), this.myText).getLogicalBounds().getHeight();
            }
        }
        return myHeight;
    }

    public void setText(String text) {
        this.myText = text;
    }

    public String getText() {
        return this.myText;
    }

    public void setIndent(int indent) {
        this.myIndent = indent;
    }

    public int getIndent() {
        return this.myIndent;
    }

    public void setAlignment(ALIGN align) {
        this.myAlign = align;
    }

    public ALIGN getAlignment() {
        return this.myAlign;
    }

    public void setAttribute(Object key, Object value) {
        this.myAttributes.put(key, value);
    }

    public void setLineSeparator(String lineSeparator) {
        this.myLineSeparator = lineSeparator;
    }

    @Override
    protected void showHeaderPageNumber(boolean showPageNumber) {
        this.myShowPageNumber = showPageNumber;
    }

    @Override
    protected void setHeaderPageNumber(int pageNumber) {
        this.myPageNumber = String.valueOf(pageNumber);
    }

    @Override
    public boolean calculatePrintableArea(PPrintableArea area) {
        this.divideTextToLines(area);
        return this.myOverflownText == null || "".equals(this.myOverflownText.getText().trim());
    }

    @Override
    public void clear() {
        super.clear();
        this.myTextLayouts.clear();
        this.myTextLayoutLocations.clear();
        this.myTexts.clear();
    }

    @Override
    protected void draw(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setFont(this.getFont());
        double tempStartPointInTextArea = this.getStartPointY();
        TextLayout layout2 = null;
        Point2D.Double pen = new Point2D.Double(0.0, 0.0);
        int index = 0;
        for (TextLayout layout2 : this.myTextLayouts) {
            pen = (Point2D.Double)this.myTextLayoutLocations.get(layout2);
            g2d.drawString((String)this.myTexts.get(index), (float)pen.x, (float)(pen.y + tempStartPointInTextArea));
            ++index;
        }
        if (this.myShowPageNumber) {
            double pageNumberX = this.getPageDimensions().width - g2d.getFontMetrics().stringWidth(this.myPageNumber);
            if (layout2.getBounds().getWidth() > pageNumberX) {
                pen.y = tempStartPointInTextArea + pen.y;
            }
            g2d.drawString(this.myPageNumber, (float)pageNumberX, (float)(pen.y + tempStartPointInTextArea));
        }
    }

    @Override
    protected PPrintableObject getExceedingPart() {
        return this.myOverflownText;
    }

    @Override
    protected PPrintableArea getParent() {
        return this.myParent;
    }

    @Override
    protected PPrintableObject getObjectCopy() {
        PPrintText copyObject = new PPrintText(this.myText, this.getParent());
        copyObject.setFont(this.getFont());
        copyObject.setAlignment(this.myAlign);
        return copyObject;
    }

    @Override
    protected void setParent(PPrintableArea parent) {
        this.myParent = parent;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Text: ");
        builder.append(this.myText);
        builder.append(super.toString());
        return builder.toString();
    }

    private void divideTextToLines(PPrintableArea area) {
        this.clear();
        Point2D.Double pen = new Point2D.Double(0.0, 0.0);
        this.myAttributes.put(TextAttribute.FONT, this.getFont());
        if (this.myText.length() == 0) {
            this.myText = " ";
        }
        int availableHeight = 0;
        if (area instanceof PPrintablePage) {
            availableHeight = ((PPrintablePage)area).getPageAvailableArea().height;
        } else if (area != null) {
            availableHeight = area.getArea().height;
        }
        AttributedString attributedText = new AttributedString(this.myText, this.myAttributes);
        LineBreakMeasurer lineBreaker = new LineBreakMeasurer(attributedText.getIterator(), new FontRenderContext(this.getFont().getTransform(), false, false));
        int startOffset = 0;
        int endOffset = 0;
        float wrappingWidth = this.getPageDimensions().width - 20;
        if (wrappingWidth < 1.0f) {
            wrappingWidth = 10.0f;
        }
        TextLayout layout = null;
        pen.x = (double)this.myIndent * 28.346456692913385;
        Point2D.Double tempPen = new Point2D.Double(0.0, 0.0);
        while (lineBreaker.getPosition() < this.myText.length()) {
            int lineSeparatorIndex = -1;
            if (this.myLineSeparator != null) {
                lineSeparatorIndex = this.myText.substring(startOffset, lineBreaker.nextOffset(wrappingWidth)).indexOf(this.myLineSeparator);
            }
            layout = lineSeparatorIndex != -1 ? lineBreaker.nextLayout(wrappingWidth, lineBreaker.getPosition() + lineSeparatorIndex + this.myLineSeparator.length(), false) : lineBreaker.nextLayout(wrappingWidth);
            tempPen.y = pen.y;
            tempPen.x = pen.x;
            endOffset = lineBreaker.getPosition();
            String line = this.myText.substring(startOffset, endOffset);
            if (this.myLineSeparator != null && lineSeparatorIndex != -1) {
                line = line.replace(this.myLineSeparator, "");
            }
            this.myTexts.add(line);
            startOffset = endOffset;
            this.myTextLayouts.add(layout);
            if (ALIGN.CENTER.equals((Object)this.myAlign)) {
                tempPen.x += ((double)wrappingWidth - this.myFont.createGlyphVector(new FontRenderContext(this.getFont().getTransform(), true, true), line).getLogicalBounds().getWidth() + (double)this.myFont.getSize()) / 2.0;
                this.myTextLayoutLocations.put(layout, tempPen.clone());
            } else if (ALIGN.RIGHT.equals((Object)this.myAlign)) {
                tempPen.x += (double)wrappingWidth - this.myFont.createGlyphVector(new FontRenderContext(this.getFont().getTransform(), true, true), line).getLogicalBounds().getWidth() + (double)this.myFont.getSize();
                this.myTextLayoutLocations.put(layout, tempPen.clone());
            } else {
                this.myTextLayoutLocations.put(layout, tempPen.clone());
            }
            pen.y += (double)(layout.getDescent() + layout.getLeading() + layout.getAscent());
            if (!(pen.y + (double)layout.getDescent() + (double)layout.getLeading() + (double)layout.getAscent() > (double)availableHeight)) continue;
            this.myOverflownText = (PPrintText)this.getObjectCopy();
            this.myOverflownText.setText(this.myText.substring(endOffset));
            break;
        }
        int row = 0;
        if (this.myShowPageNumber && layout != null) {
            double pageNumberX = this.getPageDimensions().width - 10;
            if (layout.getBounds().getWidth() > pageNumberX) {
                row = (int)(layout.getDescent() + layout.getLeading() + layout.getAscent());
            }
        }
        this.setArea(new Rectangle(this.getPageDimensions().width, (int)pen.y + row + 5));
    }

    public static enum ALIGN {
        LEFT,
        CENTER,
        RIGHT;

    }
}

