/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.print;

import com.nokia.em.poseidon.frameworks.print.PPrintableDoc;
import com.nokia.em.poseidon.frameworks.print.PPrintableObject;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PPrintableArea
extends PPrintableObject {
    protected List myPrintableObjects = new ArrayList();
    private PPrintableArea myParent;
    private Font myFont;

    PPrintableArea() {
        this.setArea(new Rectangle(0, 0));
        this.setStartPoint(0.0, 0.0);
    }

    public PPrintableArea(PPrintableArea parentArea) {
        this();
        this.myParent = parentArea;
    }

    public void add(PPrintableObject printableObject) {
        this.myPrintableObjects.add(printableObject);
    }

    public void remove(PPrintableObject printableObject) {
        this.myPrintableObjects.remove(printableObject);
    }

    public void insert(PPrintableObject addedObject, PPrintableObject indexObject) {
        this.myPrintableObjects.add(this.myPrintableObjects.indexOf(indexObject), addedObject);
    }

    public PPrintableObject getPrintableObject(int index) {
        if (index < this.myPrintableObjects.size() && index > -1) {
            return (PPrintableObject)this.myPrintableObjects.get(index);
        }
        return null;
    }

    public Iterator getIterator() {
        return this.myPrintableObjects.iterator();
    }

    protected int getObjectCount() {
        return this.myPrintableObjects.size();
    }

    @Override
    public void clear() {
        for (PPrintableObject item : this.myPrintableObjects) {
            item.clear();
        }
        super.clear();
    }

    @Override
    protected void draw(Graphics graphics) {
        for (PPrintableObject item : this.myPrintableObjects) {
            item.draw(graphics);
        }
    }

    @Override
    public boolean calculatePrintableArea(PPrintableArea area) {
        return true;
    }

    @Override
    public double getWidestPointLength() {
        double d = 0.0;
        for (PPrintableObject item : this.myPrintableObjects) {
            double dd = item.getWidestPointLength();
            if (!(dd > d)) continue;
            d = dd;
        }
        return d;
    }

    @Override
    public double getHighestPointLength() {
        double d = 0.0;
        for (PPrintableObject item : this.myPrintableObjects) {
            double dd = item.getHighestPointLength();
            if (!(dd > d)) continue;
            d = dd;
        }
        return d;
    }

    @Override
    protected PPrintableObject getExceedingPart() {
        return null;
    }

    @Override
    protected void showHeaderPageNumber(boolean showPageNumber) {
    }

    @Override
    protected void setHeaderPageNumber(int pageNumber) {
    }

    @Override
    protected PPrintableArea getParent() {
        return this.myParent;
    }

    @Override
    protected Font getFont() {
        if (this.myFont == null) {
            this.myFont = this.getParent() != null ? this.getParent().getFont() : new Font(PPrintableDoc.FONT_NAME, 0, 10);
        }
        return this.myFont;
    }

    @Override
    protected PPrintableObject getObjectCopy() {
        PPrintableArea copyAreaObject = new PPrintableArea();
        Iterator iter = this.getIterator();
        while (iter.hasNext()) {
            PPrintableObject copyObject = ((PPrintableObject)iter.next()).getObjectCopy();
            copyAreaObject.add(copyObject);
            copyObject.setParent(copyAreaObject);
        }
        return copyAreaObject;
    }

    @Override
    protected void setParent(PPrintableArea parent) {
        this.myParent = parent;
    }
}

