/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.print;

import com.nokia.em.poseidon.frameworks.print.PPrintImage;
import com.nokia.em.poseidon.frameworks.print.PPrintLine;
import com.nokia.em.poseidon.frameworks.print.PPrintText;
import com.nokia.em.poseidon.frameworks.print.PPrintableArea;
import com.nokia.em.poseidon.frameworks.print.PPrintableObject;
import com.nokia.em.poseidon.frameworks.print.PPrintablePage;
import com.nokia.laf.NetLookAndFeel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Iterator;

public abstract class PPrintableDoc
extends PPrintableArea
implements Printable {
    protected static final int DOTS_PER_INCH = 72;
    private static final int MAX_PAGE_COUNT = 999;
    protected static final String FONT_NAME = NetLookAndFeel.getUserTextFont().getName();
    protected static final int FONT_SIZE = 10;
    protected static final Font DEFAULT_FONT = new Font(FONT_NAME, 0, 10);
    private Font myDefaultFont;
    private int myPageCount = 1;
    private PPrintableArea myFooter = null;
    private PPrintableArea myHeader = null;
    private PPrintableArea myPaginatedArea = null;
    private PageFormat myPageFormat;
    private boolean myShowPageNumber = true;
    protected PPrintHeaderMode myHeaderMode = PPrintHeaderMode.PRINT_ALL_HEADERS_AND_FOOTERS;

    protected abstract void doPrinting();

    public void setDefaultFont(Font font) {
        this.myDefaultFont = font;
    }

    public Font getDefaultFont() {
        if (this.myDefaultFont == null) {
            this.myDefaultFont = DEFAULT_FONT;
        }
        return this.myDefaultFont;
    }

    public int getPrintablePageCount(PageFormat pageFormat) {
        if (this.myPageCount != 0 && pageFormat.equals(this.myPageFormat)) {
            return this.myPageCount;
        }
        this.myPageFormat = pageFormat;
        this.createPagingForAllPrintObjects();
        return this.myPageCount;
    }

    public void removeAllPrintableObjects() {
        super.clear();
        if (this.myHeader != null) {
            this.myHeader.clear();
        }
        if (this.myFooter != null) {
            this.myFooter.clear();
        }
        this.myPrintableObjects.clear();
    }

    protected PPrintableArea createPageHeader() {
        if (this.myHeader == null) {
            this.myHeader = new PPrintableArea(this);
            PPrintText pageNumber = new PPrintText(" ", this.myHeader);
            pageNumber.showHeaderPageNumber(true);
            PPrintLine line1 = new PPrintLine(0.0, 1.0, 0.0, 0.0, this.myHeader);
            PPrintLine line2 = new PPrintLine(0.0, 1.0, 0.0, 0.0, this.myHeader);
            this.myHeader.add(line1);
            this.myHeader.add(pageNumber);
            this.myHeader.add(line2);
        }
        return this.myHeader;
    }

    protected void setHeaderPageNumberVisible(boolean show) {
        this.myShowPageNumber = show;
    }

    protected void setPageHeader(PPrintableArea header) {
        this.myHeader = header;
    }

    protected void setPageFooter(PPrintableArea footer) {
        this.myFooter = footer;
    }

    protected void createPagingForAllPrintObjects() {
        this.createBaseToDoc();
        PPrintablePage currentPage = this.createNewPage();
        boolean isFirstObjAdded = false;
        if (this.isPageSpaceEnough(currentPage)) {
            this.myPaginatedArea.add(currentPage);
            PPrintableObject currentObject = null;
            Iterator iterator = this.getIterator();
            while (iterator.hasNext()) {
                if (!this.isPageLessThanMaxPageCount(currentPage)) break;
                currentObject = (PPrintableObject)iterator.next();
                if (currentObject == null) continue;
                if (isFirstObjAdded && currentObject instanceof PPrintImage) {
                    currentPage = this.createNewPage();
                    this.myPaginatedArea.add(currentPage);
                }
                currentPage = this.addObjectToPage(currentObject, currentPage);
                isFirstObjAdded = true;
            }
        }
    }

    private boolean isPageSpaceEnough(PPrintablePage currentPage) {
        return currentPage.getPageAvailableArea().getHeight() > 0.0 && currentPage.getPageAvailableArea().getWidth() > 0.0;
    }

    private boolean isPageLessThanMaxPageCount(PPrintablePage currentPage) {
        return currentPage.getPageNumber() < 999;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        this.myPageFormat = pageFormat;
        double x = this.myPageFormat.getImageableX();
        double y = this.myPageFormat.getImageableY();
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setColor(new Color(0, 0, 0));
        g2d.setFont(this.getDefaultFont());
        g2d.translate(x, y + (double)this.getFont().getSize());
        boolean isPage = this.printRequestedPage(pageIndex, g2d);
        if (isPage) {
            return 0;
        }
        return 1;
    }

    @Override
    protected Font getFont() {
        return this.getDefaultFont();
    }

    private PPrintablePage addObjectToPage(PPrintableObject currentObject, PPrintablePage currPage) {
        PPrintablePage currentPage = currPage;
        PPrintableObject dividedPart = null;
        dividedPart = currentPage.countPrintableObjectSize(currentObject, true);
        if (!this.isPageLessThanMaxPageCount(currentPage)) {
            return currentPage;
        }
        if (!this.fitsToPage(currentPage, currentObject) || dividedPart != null) {
            if (dividedPart != null) {
                currentPage.add(currentObject);
                currentObject.setParent(currentPage);
                currentPage.countPrintableAreaOnPage(currentObject);
            }
            if (currentPage.getPageAvailableArea().getHeight() != currentPage.getPageDimension().getHeight()) {
                currentPage = this.createNewPage();
                this.myPaginatedArea.add(currentPage);
            }
        }
        if (dividedPart == null) {
            currentPage.add(currentObject);
            currentObject.setParent(currentPage);
            currentPage.countPrintableAreaOnPage(currentObject);
        } else {
            currentPage = this.addObjectToPage(dividedPart, currentPage);
        }
        return currentPage;
    }

    private void createBaseToDoc() {
        if (this.myPaginatedArea == null) {
            this.myPaginatedArea = new PPrintableArea(this);
        } else {
            if (this.myHeader != null) {
                this.myHeader.clear();
            }
            if (this.myFooter != null) {
                this.myFooter.clear();
            }
            this.myPaginatedArea.clear();
            this.myPaginatedArea = null;
            this.myPaginatedArea = new PPrintableArea(this);
        }
        this.myPageCount = 0;
    }

    private boolean printRequestedPage(int pageNumber, Graphics graphics) {
        boolean isPage = false;
        PPrintableObject pageToPrinted = this.myPaginatedArea.getPrintableObject(pageNumber);
        if (pageToPrinted != null && pageToPrinted instanceof PPrintablePage) {
            ((PPrintablePage)pageToPrinted).setPageFormat(this.myPageFormat);
            pageToPrinted.draw(graphics);
            isPage = true;
        }
        return isPage;
    }

    private boolean fitsToPage(PPrintablePage page, PPrintableObject printObject) {
        if (page.getPageAvailableArea() == null || printObject.getArea() == null) {
            return false;
        }
        return page.getPageAvailableArea().getHeight() >= printObject.getArea().getHeight();
    }

    private PPrintablePage createNewPage() {
        ++this.myPageCount;
        PPrintablePage page = new PPrintablePage(this.myPageCount, this.myPageFormat, this);
        if (this.myHeader != null) {
            PPrintableArea copyHeader = (PPrintableArea)this.myHeader.getObjectCopy();
            copyHeader.setParent(page);
            page.setHeader(copyHeader, this.myShowPageNumber);
        }
        if (this.myFooter != null) {
            PPrintableArea copyFooter = (PPrintableArea)this.myFooter.getObjectCopy();
            copyFooter.setParent(page);
            page.setFooter(copyFooter);
        }
        page.setPageAvailableArea(page.calculatePageImageableArea());
        return page;
    }

    protected void setHeaderFooterPrintMode(PPrintHeaderMode mode) {
        if (mode == PPrintHeaderMode.PRINT_ALL_HEADERS_AND_FOOTERS || mode == PPrintHeaderMode.PRINT_FIRST_AND_LAST_FOOTER || mode == PPrintHeaderMode.PRINT_FIRST_HEADER_NO_FOOTERS || mode == PPrintHeaderMode.PRINT_LAST_FOOTER_NO_HEADERS || mode == PPrintHeaderMode.PRINT_NO_FOOTERS_OR_HEADERS) {
            this.myHeaderMode = mode;
        } else {
            System.err.println("Erroneous header/footer print mode");
            this.myHeaderMode = PPrintHeaderMode.PRINT_ALL_HEADERS_AND_FOOTERS;
        }
    }

    public PPrintHeaderMode getHeaderMode() {
        return this.myHeaderMode;
    }

    public static enum PPrintHeaderMode {
        PRINT_ALL_HEADERS_AND_FOOTERS,
        PRINT_FIRST_HEADER_NO_FOOTERS,
        PRINT_LAST_FOOTER_NO_HEADERS,
        PRINT_NO_FOOTERS_OR_HEADERS,
        PRINT_FIRST_AND_LAST_FOOTER;

    }
}

