/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.print;

import com.nokia.em.poseidon.frameworks.print.PPrintableArea;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class PPrintableObject {
    private static final int DEFAULT_PAGE_WIDTH = 495;
    private static final int DEFAULT_PAGE_HEIGHT = 742;
    private Rectangle myArea;
    private double myStartPointY;
    private double myStartPointX;
    private Dimension myPageDimensions = new Dimension(495, 742);
    private int myIndentation = 0;

    public Rectangle getArea() {
        return this.myArea;
    }

    public void setPageDimensions(int width, int height) {
        this.myPageDimensions.setSize(width, height);
    }

    public Dimension getPageDimensions() {
        return this.myPageDimensions;
    }

    public void setIndentation(int indent) {
        this.myIndentation = indent;
    }

    public int getIndentation() {
        return this.myIndentation;
    }

    protected void setArea(Rectangle area) {
        this.myArea = area;
    }

    protected void addPrintableArea(Rectangle area) {
        if (area != null && this.myArea != null) {
            this.myArea.setSize((int)this.myArea.getWidth(), (int)(this.myArea.getHeight() + area.getHeight()));
        }
    }

    protected void setStartPointY(double startPoint) {
        this.myStartPointY = startPoint;
    }

    protected void setStartPointX(double startPoint) {
        this.myStartPointX = startPoint;
    }

    protected void setStartPoint(double startPointX, double startPointY) {
        this.myStartPointX = startPointX;
        this.myStartPointY = startPointY;
    }

    protected double getStartPointX() {
        return this.myStartPointX + (double)this.myIndentation;
    }

    protected double getStartPointY() {
        return this.myStartPointY;
    }

    protected void clear() {
        this.setStartPoint(0.0, 0.0);
        this.setArea(new Rectangle(0, 0));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(" Size: ");
        builder.append(this.getArea());
        builder.append(" StartY: ");
        builder.append(this.getStartPointY());
        builder.append(" StartX: ");
        builder.append(this.getStartPointX());
        return builder.toString();
    }

    protected abstract PPrintableArea getParent();

    protected abstract void setParent(PPrintableArea var1);

    protected abstract Font getFont();

    protected abstract void setHeaderPageNumber(int var1);

    protected abstract void showHeaderPageNumber(boolean var1);

    protected abstract PPrintableObject getObjectCopy();

    protected abstract void draw(Graphics var1);

    protected abstract boolean calculatePrintableArea(PPrintableArea var1);

    protected abstract PPrintableObject getExceedingPart();

    protected abstract double getWidestPointLength();

    protected abstract double getHighestPointLength();
}

