/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.print;

import com.nokia.em.poseidon.frameworks.print.PPrintImage;
import com.nokia.em.poseidon.frameworks.print.PPrintLine;
import com.nokia.em.poseidon.frameworks.print.PPrintTable;
import com.nokia.em.poseidon.frameworks.print.PPrintText;
import com.nokia.em.poseidon.frameworks.print.PPrintableArea;
import com.nokia.em.poseidon.frameworks.print.PPrintableDoc;
import com.nokia.em.poseidon.frameworks.print.PPrintableObject;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.util.Iterator;

public class PPrintablePage
extends PPrintableArea {
    private Rectangle myAvailableArea;
    private Rectangle myInitialAvailableArea = new Rectangle(0, 0);
    private double myPageStartPointY = 0.0;
    private double myPageStartPointX;
    private int myPageNumber;
    private PPrintableArea myFooter;
    private PPrintableArea myHeader;
    private PageFormat myPageFormat;
    private Font myFont;
    private boolean myHeaderSetted = false;
    private boolean myFooterSetted = false;
    private Dimension myPageImageableArea;
    private PPrintableArea myParent;
    private boolean myIsWidthAlreadyScaled = false;
    private boolean myIsInitialAvailableAreaInitialzed = false;

    public PPrintablePage(int pageNumber, PageFormat pageFormat, PPrintableArea parent) {
        this.myAvailableArea = new Rectangle(0, 0);
        this.myPageNumber = pageNumber;
        this.myParent = parent;
        this.myPageFormat = pageFormat;
        this.myPageImageableArea = new Dimension((int)this.myPageFormat.getWidth() * 72, (int)this.myPageFormat.getHeight() * 72);
    }

    protected void setHeader(PPrintableArea header, boolean showPageNumber) {
        this.myHeader = header;
        if (showPageNumber) {
            this.setHeaderPageNumber();
        }
    }

    protected void setFooter(PPrintableArea footer) {
        this.myFooter = footer;
    }

    protected Rectangle getPageAvailableArea() {
        return this.myAvailableArea;
    }

    protected void setPageAvailableArea(Rectangle availableArea) {
        if (!this.myIsInitialAvailableAreaInitialzed) {
            this.myInitialAvailableArea = availableArea;
            this.myIsInitialAvailableAreaInitialzed = true;
        }
        this.myAvailableArea = availableArea;
    }

    protected Rectangle getInitialPageAvailableArea() {
        return this.myInitialAvailableArea;
    }

    protected double getPageStartPointX() {
        return this.myPageStartPointX;
    }

    protected double getPageStartPointY() {
        return this.myPageStartPointY;
    }

    protected Rectangle calculatePageImageableArea() {
        if (this.myFooter != null && !this.myFooterSetted) {
            this.countPrintableObjectSize(this.myFooter, false);
            this.setFooterLocation();
            this.myFooter.setStartPointY((int)(this.getArea().getHeight() - this.myFooter.getArea().getHeight()));
            this.myFooterSetted = true;
        }
        if (this.myHeader != null && !this.myHeaderSetted) {
            this.countPrintableObjectSize(this.myHeader, false);
            this.countPrintableAreaOnPage(this.myHeader);
            this.myHeaderSetted = true;
        }
        return this.reducePageHeaderAndFooterArea();
    }

    @Override
    protected void draw(Graphics graphics) {
        Iterator iter = this.myPrintableObjects.iterator();
        Graphics2D g2d = (Graphics2D)graphics;
        double intTotalWidth = this.getWidestPointLength();
        double availableWidth = this.myAvailableArea.getWidth();
        double availableHeight = this.getPageDimension().getHeight();
        double intTotalHeight = this.getPageDimension().getHeight() - this.myAvailableArea.getHeight();
        if (intTotalHeight == 0.0) {
            intTotalHeight = this.getHighestPointLength();
        }
        double scale = availableWidth / intTotalWidth;
        double heightScale = availableHeight / intTotalHeight;
        this.printHeadersAndFooters(graphics);
        if (availableWidth < intTotalWidth && !this.myIsWidthAlreadyScaled) {
            g2d.scale(scale, 1.0);
            this.myIsWidthAlreadyScaled = true;
        }
        while (iter.hasNext()) {
            PPrintableObject item = (PPrintableObject)iter.next();
            double startPointY = item.getStartPointY();
            boolean doScale = false;
            if (this.myAvailableArea.getHeight() < 0.0) {
                doScale = true;
                g2d.scale(1.0, heightScale);
                double headerHight = item.getStartPointY() / heightScale;
                item.setStartPointY(headerHight);
            }
            item.draw(graphics);
            if (!doScale) continue;
            item.setStartPointY(startPointY);
        }
    }

    protected void setPageFormat(PageFormat pageFormat) {
        this.myPageFormat = pageFormat;
    }

    private void printHeadersAndFooters(Graphics graphics) {
        if (this.myParent != null) {
            if (this.myParent instanceof PPrintableDoc) {
                PPrintableDoc.PPrintHeaderMode mode = ((PPrintableDoc)this.myParent).getHeaderMode();
                if (mode == PPrintableDoc.PPrintHeaderMode.PRINT_ALL_HEADERS_AND_FOOTERS) {
                    if (this.myHeader != null) {
                        this.myHeader.draw(graphics);
                    }
                    if (this.myFooter != null) {
                        this.myFooter.draw(graphics);
                    }
                } else if (mode == PPrintableDoc.PPrintHeaderMode.PRINT_FIRST_HEADER_NO_FOOTERS) {
                    if (this.myPageNumber == 1 && this.myHeader != null) {
                        this.myHeader.draw(graphics);
                    }
                } else if (mode == PPrintableDoc.PPrintHeaderMode.PRINT_LAST_FOOTER_NO_HEADERS) {
                    if (this.myPageNumber == ((PPrintableDoc)this.myParent).getPrintablePageCount(this.myPageFormat) && this.myFooter != null) {
                        this.myFooter.draw(graphics);
                    }
                } else if (mode == PPrintableDoc.PPrintHeaderMode.PRINT_FIRST_AND_LAST_FOOTER) {
                    if (this.myPageNumber == 1) {
                        if (this.myHeader != null) {
                            this.myHeader.draw(graphics);
                        }
                    } else if (this.myPageNumber == ((PPrintableDoc)this.myParent).getPrintablePageCount(this.myPageFormat) && this.myFooter != null) {
                        this.myFooter.draw(graphics);
                    }
                }
            } else {
                if (this.myHeader != null) {
                    this.myHeader.draw(graphics);
                }
                if (this.myFooter != null) {
                    this.myFooter.draw(graphics);
                }
            }
        } else {
            if (this.myHeader != null) {
                this.myHeader.draw(graphics);
            }
            if (this.myFooter != null) {
                this.myFooter.draw(graphics);
            }
        }
    }

    @Override
    protected Font getFont() {
        if (this.myFont == null) {
            this.myFont = this.getParent().getFont();
        }
        return this.myFont;
    }

    protected Dimension getPageDimension() {
        return this.myPageImageableArea;
    }

    @Override
    protected PPrintableArea getParent() {
        return this.myParent;
    }

    protected void countPrintableAreaOnPage(PPrintableObject printableObject) {
        printableObject.setStartPointY(this.getPageStartPointY());
        if (printableObject instanceof PPrintableArea) {
            PPrintableObject currentObject = null;
            Iterator iter = ((PPrintableArea)printableObject).getIterator();
            while (iter.hasNext()) {
                currentObject = (PPrintableObject)iter.next();
                double startPointY = printableObject.getStartPointY();
                if (currentObject instanceof PPrintLine && startPointY == 0.0) {
                    startPointY = ((PPrintLine)currentObject).getLineHeight() / 2;
                }
                currentObject.setStartPointY(startPointY);
                printableObject.setStartPointY(currentObject.getStartPointY() + currentObject.getArea().getHeight());
            }
        }
        this.updateAvailableAreaOnPage(printableObject);
    }

    protected PPrintableObject countPrintableObjectSize(PPrintableObject printableObject, boolean isAllowedToDivide) {
        boolean fitsToPage = true;
        PPrintableObject newObject = null;
        if (printableObject instanceof PPrintableArea) {
            PPrintableObject currentObject = null;
            Iterator iter = ((PPrintableArea)printableObject).getIterator();
            while (iter.hasNext()) {
                currentObject = (PPrintableObject)iter.next();
                if (currentObject == null) continue;
                this.countPrintableObjectSize(currentObject, false);
                printableObject.addPrintableArea(currentObject.getArea());
            }
        } else {
            printableObject.setPageDimensions((int)(this.myPageFormat.getImageableWidth() * 72.0), (int)(this.myPageFormat.getImageableHeight() * 72.0));
            fitsToPage = printableObject.calculatePrintableArea(this);
        }
        if (!fitsToPage && isAllowedToDivide) {
            newObject = printableObject.getExceedingPart();
        }
        return newObject;
    }

    protected int getPageNumber() {
        return this.myPageNumber;
    }

    private double updateAvailableAreaOnPage(PPrintableObject printObject) {
        Rectangle area = printObject.getArea();
        if (area != null) {
            this.myAvailableArea.setSize((int)this.myAvailableArea.getWidth(), (int)(this.myAvailableArea.getHeight() - area.getHeight()));
            this.myPageStartPointY += area.getHeight();
        }
        return this.myPageStartPointY;
    }

    private Rectangle reducePageHeaderAndFooterArea() {
        Rectangle pageArea = new Rectangle((int)this.myPageFormat.getImageableWidth() * 72, (int)this.myPageFormat.getImageableHeight() * 72);
        if (this.myFooter == null && this.myHeader == null) {
            return pageArea;
        }
        if (this.myFooter == null) {
            pageArea.setSize((int)this.myPageFormat.getImageableWidth() * 72, (int)(this.myPageFormat.getImageableHeight() * 72.0 - this.myHeader.getArea().getHeight()));
            this.setStartPointY(this.myHeader.getArea().getHeight());
        } else if (this.myHeader == null) {
            pageArea.setSize((int)this.myPageFormat.getImageableWidth() * 72, (int)(this.myPageFormat.getImageableHeight() * 72.0 - this.myFooter.getArea().getHeight()));
        } else {
            pageArea.setSize((int)this.myPageFormat.getImageableWidth() * 72, (int)(this.myPageFormat.getImageableHeight() * 72.0 - this.myFooter.getArea().getHeight() - this.myHeader.getArea().getHeight()));
            this.setStartPointY(this.myHeader.getArea().getHeight());
        }
        this.myPageImageableArea = new Dimension((int)pageArea.getWidth(), (int)pageArea.getHeight());
        return pageArea;
    }

    private void setHeaderPageNumber() {
        if (this.myHeader != null) {
            Iterator iter = this.myHeader.getIterator();
            while (iter.hasNext()) {
                PPrintableObject printableObject = (PPrintableObject)iter.next();
                if (!(printableObject instanceof PPrintText) && !(printableObject instanceof PPrintTable) && !(printableObject instanceof PPrintImage)) continue;
                printableObject.setHeaderPageNumber(this.myPageNumber);
                printableObject.showHeaderPageNumber(true);
                break;
            }
        }
    }

    private void setFooterLocation() {
        this.myFooter.setStartPointY(this.myPageFormat.getImageableHeight() * 72.0 - this.myFooter.getArea().getHeight());
        PPrintableObject currentObject = null;
        Iterator iter = this.myFooter.getIterator();
        while (iter.hasNext()) {
            currentObject = (PPrintableObject)iter.next();
            currentObject.setStartPointY(this.myFooter.getStartPointY());
            this.myFooter.setStartPointY(currentObject.getStartPointY() + currentObject.getArea().getHeight());
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Page: ");
        builder.append(this.myPageNumber);
        builder.append("  AvailableArea: ");
        builder.append(this.myAvailableArea);
        builder.append("  StartingPointY: ");
        builder.append(this.myPageStartPointY);
        builder.append("  StartingPointX: ");
        builder.append(this.myPageStartPointX);
        builder.append(super.toString());
        return builder.toString();
    }
}

