/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.print;

import com.nokia.em.poseidon.frameworks.print.PConfigurableCell;
import com.nokia.em.poseidon.frameworks.print.PPrintTable;
import com.nokia.em.poseidon.frameworks.print.PTableCellPrinter;
import com.nokia.laf.NetLookAndFeel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PTextCellPrinter
implements PTableCellPrinter {
    static final String FONT_NAME = NetLookAndFeel.getUserTextFont().getName();
    static final int FONT_SIZE = 10;
    static final Font DEFAULT_FONT = new Font(FONT_NAME, 0, 10);
    private List<TextLayout> myTextLayouts = new ArrayList<TextLayout>();
    private Map<TextLayout, Point2D.Double> myTextLayoutLocations = new HashMap<TextLayout, Point2D.Double>();
    private Font myFont;
    private List<String> myTexts = new ArrayList<String>();

    @Override
    public void drawCell(Graphics graphics, Object value) {
        this.clear();
        this.divideTextToLines(value, (int)graphics.getClipBounds().getWidth());
        Graphics2D g2d = (Graphics2D)graphics;
        Iterator<TextLayout> iter = this.myTextLayouts.iterator();
        TextLayout layout = null;
        while (iter.hasNext()) {
            layout = iter.next();
            Point2D.Double pen = this.myTextLayoutLocations.get(layout);
            layout.draw(g2d, (float)pen.x, (float)pen.y + (float)this.myFont.getSize());
        }
    }

    @Override
    public Dimension getPrintSize(Object inputValue, PPrintTable table, boolean divideToRows) {
        Object value = inputValue;
        double width = 0.0;
        if (divideToRows) {
            this.clear();
            int columnMaxWidth = table.getColumnContentMaxWidth();
            int scale = columnMaxWidth / 20 + 1;
            return this.divideTextToLines(value, columnMaxWidth - scale);
        }
        if (value instanceof String) {
            width = table.getFont().createGlyphVector(new FontRenderContext(this.getFont().getTransform(), true, true), (String)value).getLogicalBounds().getWidth() + (double)table.getFont().getSize();
        } else {
            try {
                value = value.toString();
            }
            catch (Exception e) {
                value = "value should be String";
            }
            width = table.getFont().createGlyphVector(new FontRenderContext(this.getFont().getTransform(), true, true), (String)value).getLogicalBounds().getWidth() + (double)table.getFont().getSize();
        }
        return new Dimension((int)width, table.getFont().getSize() + 2);
    }

    @Override
    public void setFont(Font font) {
        this.myFont = font;
    }

    @Override
    public Font getFont() {
        if (this.myFont == null) {
            return DEFAULT_FONT;
        }
        return this.myFont;
    }

    private Dimension divideTextToLines(Object value, int cellMaxWidth) {
        Point2D.Double pen = new Point2D.Double(0.0, 0.0);
        HashMap<TextAttribute, Font> attributes = new HashMap<TextAttribute, Font>();
        attributes.put(TextAttribute.FONT, this.getFont());
        String myText = null;
        if (value instanceof String) {
            myText = (String)value;
            if (myText == null || myText.length() == 0) {
                myText = " ";
            }
        } else {
            try {
                myText = value.toString();
            }
            catch (Exception e) {
                myText = "value should be String";
            }
        }
        if (myText.length() == 0) {
            myText = " ";
        }
        AttributedString attributedText = new AttributedString(myText, attributes);
        LineBreakMeasurer lineBreaker = new LineBreakMeasurer(attributedText.getIterator(), new FontRenderContext(this.getFont().getTransform(), true, true));
        float wrappingWidth = cellMaxWidth;
        int startOffset = 0;
        int endOffset = 0;
        TextLayout layout = null;
        while (lineBreaker.getPosition() < myText.length()) {
            int position = myText.substring(startOffset).indexOf(System.getProperty("line.separator"));
            if (position != -1) {
                int offLimit = position + startOffset + System.getProperty("line.separator").length();
                layout = lineBreaker.nextLayout(wrappingWidth, offLimit, false);
            } else {
                layout = lineBreaker.nextLayout(wrappingWidth);
            }
            endOffset = lineBreaker.getPosition();
            this.myTexts.add(myText.substring(startOffset, endOffset).trim());
            startOffset = endOffset;
            this.myTextLayouts.add(layout);
            Point2D.Double clone = (Point2D.Double)pen.clone();
            if (value instanceof PConfigurableCell && ((PConfigurableCell)value).getAlignment() == 4) {
                clone.x += (double)((float)cellMaxWidth - (layout.getVisibleAdvance() + 2.0f));
            }
            this.myTextLayoutLocations.put(layout, clone);
            pen.y += (double)(layout.getDescent() + layout.getLeading() + layout.getAscent());
        }
        if (layout == null) {
            return null;
        }
        return new Dimension(cellMaxWidth, (int)pen.y);
    }

    private void clear() {
        this.myTextLayoutLocations.clear();
        this.myTextLayouts.clear();
        this.myTexts.clear();
    }
}

