/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLFile;
import com.nokia.em.poseidon.frameworks.raml.RAMLHeader;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaDataFile;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaManagedObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RAMLCMData
extends RAMLObject {
    private static final long serialVersionUID = 4464796481638530068L;
    protected Map<String, RAMLManagedObject> myMOs;
    protected Map<String, List<RAMLManagedObject>> myMOsByClassName;
    private List<RAMLManagedObject> myMOsList;
    private RAMLHeader myHeader;
    private RAMLFile myOwnerFile;
    private RAMLMetaDataFile myMetaData;

    public RAMLCMData() {
        this(null);
    }

    protected RAMLCMData(RAMLFile owner) {
        this.createHeader();
        this.myMOs = new HashMap<String, RAMLManagedObject>();
        this.myMOsByClassName = new HashMap<String, List<RAMLManagedObject>>();
        this.myMOsList = new ArrayList<RAMLManagedObject>();
        this.myOwnerFile = owner;
        this.myMetaData = null;
    }

    public List<RAMLManagedObject> getMOs() {
        return new ArrayList<RAMLManagedObject>(this.myMOsList);
    }

    public List<RAMLManagedObject> getMOsList() {
        return this.myMOsList;
    }

    public void addMetaData(RAMLMetaDataFile metaData) {
        if (this.myOwnerFile != null) {
            this.myOwnerFile.addMetaData(metaData);
            return;
        }
        if (this.myMetaData != null) {
            for (RAMLMetaManagedObject mo : metaData.getMetaManagedObjects()) {
                this.myMetaData.addMetaManagedObject(mo.getClassName(), mo);
            }
        } else {
            this.myMetaData = metaData;
        }
    }

    public RAMLMetaDataFile getMetaData() {
        if (this.myMetaData == null && this.myOwnerFile != null) {
            return this.myOwnerFile.getMetaData();
        }
        return this.myMetaData;
    }

    public void clearMetaData() {
        this.myMetaData.destroy();
        this.myMetaData = null;
    }

    public List<RAMLManagedObject> getMOs(int level) {
        ArrayList<RAMLManagedObject> childMOs = new ArrayList<RAMLManagedObject>();
        for (RAMLManagedObject tempMO : this.getMOs()) {
            if (this.getHierarchyDepth(tempMO.getDistName()) >= level) continue;
            childMOs.add(tempMO);
        }
        return childMOs;
    }

    public void addMO(RAMLManagedObject obj) {
        if (obj != null && obj.getDistName().length() > 0 && obj.getMOClass().length() > 0) {
            String key = obj.getKey();
            if (!this.myMOsList.contains(obj)) {
                this.myMOsList.add(obj);
            }
            if (!this.myMOs.containsValue(obj)) {
                this.myMOs.put(key, obj);
            }
            if (this.myMOsByClassName.get(obj.getMOClass()) == null) {
                ArrayList<RAMLManagedObject> moList = new ArrayList<RAMLManagedObject>();
                moList.add(obj);
                this.myMOsByClassName.put(obj.getMOClass(), moList);
            } else if (!this.myMOsByClassName.get(obj.getMOClass()).contains(obj)) {
                this.myMOsByClassName.get(obj.getMOClass()).add(obj);
            }
            obj.setCMData(this);
            RAMLManagedObject parent = this.findParentMO(obj);
            obj.setParent(parent);
            if (parent != null) {
                parent.setChild(obj);
            } else {
                this.clearAncestorsCaches(obj);
            }
            List<RAMLManagedObject> childMOs = this.findChildMOs(obj);
            for (RAMLManagedObject mo : childMOs) {
                obj.setChild(mo);
            }
        }
    }

    private void clearAncestorsCaches(RAMLManagedObject mo) {
        String distName = mo.getDistName();
        while (distName.contains("/")) {
            distName = distName.substring(0, distName.lastIndexOf(47));
            List<RAMLManagedObject> mos = this.getMOsByDistName(distName);
            for (RAMLManagedObject parentMO : mos) {
                parentMO.clearAncestorsCachesHierarchially();
            }
        }
    }

    protected RAMLManagedObject findParentMO(RAMLManagedObject mo) {
        if (mo.getAssignedParentMO() != null) {
            return mo.getAssignedParentMO();
        }
        String distName = mo.getDistName();
        if (!distName.contains("/")) {
            return null;
        }
        String parentLocalMoid = distName.substring(0, distName.lastIndexOf(47));
        String create = String.valueOf(parentLocalMoid) + "|create";
        RAMLManagedObject parent = this.getMosInMap().get(create);
        if (parent == null) {
            String update = String.valueOf(parentLocalMoid) + "|update";
            parent = this.getMosInMap().get(update);
        }
        if (parent == null) {
            parent = this.getMosInMap().get(parentLocalMoid);
        }
        if (parent == null) {
            List<RAMLManagedObject> parentMOS = this.getMOsByClass(this.getParentMOClassName(parentLocalMoid));
            for (RAMLManagedObject ramlManagedObject : parentMOS) {
                if (!ramlManagedObject.getDistName().equals(parentLocalMoid)) continue;
                parent = ramlManagedObject;
                break;
            }
        }
        return parent;
    }

    private String getParentMOClassName(String parentLocalMoid) {
        int beginIndex = parentLocalMoid.lastIndexOf(47) + 1;
        int lastIndexOfDash = parentLocalMoid.lastIndexOf(45);
        return lastIndexOfDash == -1 ? parentLocalMoid.substring(beginIndex) : parentLocalMoid.substring(beginIndex, lastIndexOfDash);
    }

    protected List<RAMLManagedObject> findChildMOs(RAMLManagedObject mo) {
        ArrayList<RAMLManagedObject> childMOs = new ArrayList<RAMLManagedObject>();
        if ("".equals(mo.getId())) {
            return childMOs;
        }
        String distName = mo.getDistName().concat("/");
        this.getMOs().stream().forEach(tempMO -> {
            String tempDistName;
            String tempDist = tempMO.getDistName();
            if (tempDist.startsWith(distName) && this.getHierarchyDepth(tempDistName = tempDist.substring(distName.length())) < 1) {
                childMOs.add((RAMLManagedObject)tempMO);
            }
        });
        return childMOs;
    }

    public void addMOsRecursively(RAMLManagedObject obj) {
        if (obj != null && obj.getDistName().length() > 0 && obj.getMOClass().length() > 0) {
            List<RAMLManagedObject> children = obj.getChildMOs(1);
            for (RAMLManagedObject managedObject : children) {
                this.addMOsRecursively(managedObject);
            }
            this.addMO(obj);
            if (obj.getParentMO() == null) {
                Collections.reverse(this.myMOsList);
            }
        }
    }

    public void removeMO(String distName, String operation) {
        String key = null;
        key = operation != null ? String.valueOf(distName) + "|" + operation : distName;
        for (RAMLManagedObject tempMO : this.getMOs()) {
            if (!distName.equals(tempMO.getDistName()) || tempMO.getOperation() == null || !operation.equals(tempMO.getOperation())) continue;
            this.myMOs.remove(key);
            this.myMOsList.remove(tempMO);
            this.removeFromMosByClassMap(tempMO);
            tempMO.removeParentReferences();
        }
    }

    public void removeMO(RAMLManagedObject mo) {
        this.myMOs.remove(mo.getKey());
        this.myMOsList.remove(mo);
        this.removeFromMosByClassMap(mo);
        mo.removeParentReferences();
    }

    public void removeMOs(Collection<RAMLManagedObject> mos) {
        for (RAMLManagedObject tempMO : mos) {
            this.myMOsList.remove(tempMO);
            this.myMOs.remove(tempMO.getKey());
            this.removeFromMosByClassMap(tempMO);
            tempMO.removeParentReferences();
        }
    }

    public void removeMOs(String rootDistName) {
        String childDistName = rootDistName.concat("/");
        Set<String> keySet = this.myMOs.keySet();
        ArrayList<String> mosToBeRemoved = new ArrayList<String>();
        String rootKey = rootDistName;
        RAMLManagedObject tempRootMO = this.myMOs.get(rootDistName);
        for (String key : keySet) {
            if (tempRootMO == null && key.startsWith(rootDistName.concat("|"))) {
                tempRootMO = this.myMOs.get(key);
                rootKey = key;
            }
            if (!key.startsWith(childDistName)) continue;
            RAMLManagedObject tempMO = this.myMOs.get(key);
            this.myMOsList.remove(tempMO);
            this.removeFromMosByClassMap(tempMO);
            mosToBeRemoved.add(key);
            if (tempMO.getParentMO() == null) continue;
            tempMO.getParentMO().removeChildMO(tempMO);
            tempMO.setParent(null);
        }
        for (String mo : mosToBeRemoved) {
            this.myMOs.remove(mo);
        }
        this.myMOs.remove(rootKey);
        this.removeFromMosByClassMap(tempRootMO);
        this.myMOsList.remove(tempRootMO);
        tempRootMO.removeParentReferences();
    }

    public RAMLManagedObject getMO(String distName, String operation) {
        if (operation != null) {
            return this.myMOs.get(String.valueOf(distName) + "|" + operation);
        }
        return this.myMOs.get(distName);
    }

    public List<RAMLManagedObject> getMOs(String distName, String operation) {
        ArrayList<RAMLManagedObject> mos = new ArrayList<RAMLManagedObject>();
        for (RAMLManagedObject tempMO : this.getMOs()) {
            if (!distName.equals(tempMO.getDistName()) || tempMO.getOperation() == null || !operation.equals(tempMO.getOperation())) continue;
            mos.add(tempMO);
        }
        return mos;
    }

    public List<RAMLManagedObject> getMOsByDistName(String distName) {
        ArrayList<RAMLManagedObject> mos = new ArrayList<RAMLManagedObject>();
        for (RAMLManagedObject mo : this.getMOs()) {
            if (!mo.getDistName().equals(distName)) continue;
            mos.add(mo);
        }
        return mos;
    }

    public RAMLManagedObject getMOByClassAndId(String className, String id) {
        List<RAMLManagedObject> mosByClass = this.getMOsByClass(className);
        int i = 0;
        while (i < mosByClass.size()) {
            RAMLManagedObject mo = mosByClass.get(i);
            if (id.equals(mo.getId())) {
                return mo;
            }
            ++i;
        }
        return null;
    }

    public List<RAMLManagedObject> getMOsByClassAndId(String className, String id) {
        List<RAMLManagedObject> mosByClass = this.getMOsByClass(className);
        ArrayList<RAMLManagedObject> foundMOs = new ArrayList<RAMLManagedObject>();
        int i = 0;
        while (i < mosByClass.size()) {
            RAMLManagedObject mo = mosByClass.get(i);
            if (id.equals(mo.getId())) {
                foundMOs.add(mo);
            }
            ++i;
        }
        return foundMOs;
    }

    public List<RAMLManagedObject> getMOsByClass(String className) {
        ArrayList mosByClass = this.myMOsByClassName.get(className);
        return mosByClass != null ? mosByClass : new ArrayList();
    }

    public List<RAMLManagedObject> getMOsByClassAndOperation(String className, String operationName) {
        ArrayList<RAMLManagedObject> mosByClassAndOperation = new ArrayList<RAMLManagedObject>();
        List<RAMLManagedObject> mosByClass = this.getMOsByClass(className);
        for (RAMLManagedObject mo : mosByClass) {
            if (mo.getOperation() == null || !operationName.equals(mo.getOperation())) continue;
            mosByClassAndOperation.add(mo);
        }
        return mosByClassAndOperation;
    }

    public RAMLHeader getHeader() {
        return this.myHeader;
    }

    protected void createHeader() {
        this.myHeader = new RAMLHeader();
    }

    public void setHeader(RAMLHeader header) {
        this.myHeader = header;
    }

    public Map<String, RAMLManagedObject> getMosInMap() {
        return this.myMOs;
    }

    @Override
    public void destroy() {
        this.myHeader.destroy();
        List<RAMLManagedObject> MOs = this.getMOs();
        int i = 0;
        while (i < MOs.size()) {
            MOs.get(i).destroy();
            ++i;
        }
        this.myMOs.clear();
        this.myMOs = null;
        this.myMOsByClassName.clear();
        this.myMOsByClassName = null;
        this.myMOsList.clear();
        this.myMOsList = null;
        this.myHeader = null;
        super.destroy();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RAMLCMData: \n");
        builder.append(super.toString());
        builder.append(this.getHeader().toString());
        return builder.toString();
    }

    @Override
    public String toXmlString() {
        StringBuilder ramlObjectData = new StringBuilder();
        ramlObjectData.append("<cmData");
        ramlObjectData.append(super.toXmlString());
        ramlObjectData.append(">");
        ramlObjectData.append(this.getHeader().toXmlString());
        Iterator<RAMLManagedObject> it = this.getMOs().iterator();
        while (it.hasNext()) {
            ramlObjectData.append(it.next().toXmlString());
        }
        ramlObjectData.append("</cmData>");
        return ramlObjectData.toString();
    }

    public RAMLFile getRAMLFile() {
        return this.myOwnerFile;
    }

    public void setRAMLFile(RAMLFile ramlFile) {
        this.myOwnerFile = ramlFile;
    }

    public void validate(RAMLValidationContext validationContext) {
        if (this.getMetaData() == null) {
            validationContext.addResult(this.createMissingMetaDataResult());
            return;
        }
        List<RAMLManagedObject> tmpMOs = this.getMOs();
        boolean validationTargetFound = false;
        int i = 0;
        while (i < tmpMOs.size()) {
            RAMLManagedObject tmp = tmpMOs.get(i);
            if (tmp.getParentMO() == null) {
                tmp.validate(validationContext);
                validationTargetFound = true;
            }
            ++i;
        }
        if (!validationTargetFound) {
            validationContext.addResult(this.createMissingRootMOResult());
            return;
        }
    }

    private RAMLValidationResult createMissingMetaDataResult() {
        ResourceBundle bundle = I18n.getI18n().getBundle(this.getClass());
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
        result.setParameterName("");
        result.setDistName("cmData");
        result.setVersion(this.getAttribute("version"));
        result.setText(bundle.getString("RAMLValidation.Incomplete.Configuration"));
        result.setDetails(bundle.getString("RAMLValidation.Missing.Meta.Data"));
        Logger.getLogger(this.getClass()).error("[RAML Validation] " + result.getDetails());
        return result;
    }

    private RAMLValidationResult createMissingRootMOResult() {
        ResourceBundle bundle = I18n.getI18n().getBundle(this.getClass());
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
        result.setParameterName("");
        result.setDistName("cmData");
        result.setVersion(this.getAttribute("version"));
        result.setText(bundle.getString("RAMLValidation.Incomplete.Configuration"));
        result.setDetails(bundle.getString("RAMLValidation.Unknown.Root.ManagedObj"));
        Logger.getLogger(this.getClass()).error("[RAML Validation] " + result.getDetails());
        return result;
    }

    private void removeFromMosByClassMap(RAMLManagedObject mo) {
        if (mo == null) {
            return;
        }
        List<RAMLManagedObject> list = this.myMOsByClassName.get(mo.getMOClass());
        if (list == null) {
            return;
        }
        list.remove(mo);
        if (list.isEmpty()) {
            this.myMOsByClassName.remove(mo.getMOClass());
        }
    }

    @Override
    public void clear() {
        List<RAMLManagedObject> MOs = this.getMOs();
        int i = 0;
        while (i < MOs.size()) {
            MOs.get(i).destroy();
            ++i;
        }
        this.myMOs.clear();
        this.myMOsByClassName.clear();
        this.myMOsList.clear();
        super.clear();
    }
}

