/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.util.xml.XmlUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RAMLExtension
implements Serializable {
    private static final long serialVersionUID = 8164144828081843749L;
    private String myName = "";
    private Map<String, RAMLList<?>> myItemLists = new HashMap();
    private Map<String, RAMLParameter> myParameters = new HashMap<String, RAMLParameter>();
    private ArrayList<RAMLList<?>> myItemListsCollection = new ArrayList();
    private ArrayList<RAMLParameter> myParametersCollection = new ArrayList();

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        if (name != null) {
            this.myName = name;
        }
    }

    public RAMLList<?> getList(String name) {
        return this.myItemLists.get(name);
    }

    public RAMLParameter getParameter(String name) {
        return this.myParameters.get(name);
    }

    public void addList(RAMLList<?> list) {
        if (list != null && list.getName().length() > 0) {
            if (this.myItemLists.containsKey(list.getName())) {
                int i = 0;
                while (i < this.myItemListsCollection.size()) {
                    if (this.myItemListsCollection.get(i).getName().equals(list.getName())) {
                        this.myItemListsCollection.set(i, list);
                    }
                    ++i;
                }
            } else {
                this.myItemListsCollection.add(list);
            }
            this.myItemLists.put(list.getName(), list);
        }
    }

    public void removeList(String name) {
        this.myItemListsCollection.remove(this.myItemLists.get(name));
        this.myItemLists.remove(name);
    }

    public void setParameter(RAMLParameter param) {
        if (param != null) {
            if (this.myParameters.containsKey(param.getName())) {
                int i = 0;
                while (i < this.myParametersCollection.size()) {
                    if (this.myParametersCollection.get(i).getName().equals(param.getName())) {
                        this.myParametersCollection.set(i, param);
                    }
                    ++i;
                }
            } else {
                this.myParametersCollection.add(param);
            }
            param.setParent(this);
            this.myParameters.put(param.getName(), param);
        }
    }

    public List<RAMLList<?>> getLists() {
        return (ArrayList)this.myItemListsCollection.clone();
    }

    public List<RAMLParameter> getParameters() {
        return (ArrayList)this.myParametersCollection.clone();
    }

    public void removeParameter(String name) {
        this.myParametersCollection.remove(this.myParameters.get(name));
        this.myParameters.remove(name);
    }

    protected void destroy() {
        int i = 0;
        while (i < this.myItemListsCollection.size()) {
            this.myItemListsCollection.get(i).destroy();
            ++i;
        }
        this.myItemLists.clear();
        this.myItemLists = null;
        this.myParameters.clear();
        this.myParameters = null;
        this.myItemListsCollection.clear();
        this.myItemListsCollection = null;
        this.myParametersCollection.clear();
        this.myParametersCollection = null;
        this.myName = null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RAMLExtension: " + this.getName());
        builder.append("Parameters:");
        Iterator<RAMLParameter> iter = this.getParameters().iterator();
        while (iter.hasNext()) {
            builder.append("  " + iter.next().toString() + "\n");
        }
        builder.append("Lists:");
        Iterator<RAMLList<?>> itera = this.getLists().iterator();
        while (itera.hasNext()) {
            builder.append("  " + itera.next().toString() + "\n");
        }
        return builder.toString();
    }

    public String toXmlString() {
        StringBuilder ramlObjectData = new StringBuilder();
        ramlObjectData.append("<extension name=\"");
        ramlObjectData.append(XmlUtils.encode(this.getName()));
        ramlObjectData.append("\">");
        Iterator<RAMLParameter> iter = this.getParameters().iterator();
        while (iter.hasNext()) {
            ramlObjectData.append(iter.next().toXmlString());
        }
        Iterator<RAMLList<?>> itera = this.getLists().iterator();
        while (itera.hasNext()) {
            ramlObjectData.append(itera.next().toXmlString());
        }
        ramlObjectData.append("</extension>");
        return ramlObjectData.toString();
    }
}

