/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import com.nokia.em.poseidon.frameworks.raml.RAMLCMData;
import com.nokia.em.poseidon.frameworks.raml.RAMLExtension;
import com.nokia.em.poseidon.frameworks.raml.RAMLFileBase;
import com.nokia.em.poseidon.frameworks.raml.RAMLHeader;
import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLItemList;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLLogEntry;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.frameworks.raml.RAMLPrevalidationDeltaWatcher;
import com.nokia.em.poseidon.frameworks.raml.RAMLSaxHandler;
import com.nokia.em.poseidon.frameworks.raml.RAMLSaxParserLock;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaDataFile;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaManagedObject;
import com.nokia.em.poseidon.util.file.IOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class RAMLFile
extends RAMLFileBase {
    private static final long serialVersionUID = 8023331666913775452L;
    private static String COLON_STRING = ":";
    private boolean myIgnoreMoClassPrefix = false;
    private SortedSet<String> mySitesToBeParsed = new TreeSet<String>();
    private List<RAMLCMData> myCMData;
    protected transient Document myDOMDocument;
    private double myVersion = 2.1;
    private RAMLMetaDataFile myMetaData;

    public RAMLFile() {
        this.init();
    }

    public RAMLFile(String fileName) throws Exception, SAXException, IOException {
        this.init();
        this.readFrom(fileName);
    }

    public RAMLFile(Document doc) throws Exception, SAXException, IOException {
        this.init();
        this.readFrom(doc);
    }

    public RAMLFile(InputStream is) throws Exception, SAXException, IOException {
        this.init();
        this.readFrom(is);
    }

    public RAMLFile(File file) throws Exception, SAXException, IOException {
        this.init();
        this.readFrom(file);
    }

    public RAMLFile(RAMLMetaDataFile metaData) {
        this();
        this.myMetaData = metaData;
    }

    public RAMLFile(String fileName, RAMLMetaDataFile metaData) throws Exception, SAXException, IOException {
        this(fileName);
        this.myMetaData = metaData;
    }

    public RAMLFile(InputStream is, RAMLMetaDataFile metaData) throws Exception, SAXException, IOException {
        this(is);
        this.myMetaData = metaData;
    }

    public RAMLFile(File file, RAMLMetaDataFile metaData) throws Exception, SAXException, IOException {
        this(file);
        this.myMetaData = metaData;
    }

    public void setIgnoreMoClassPrefix(boolean ignoreMoClassPrefix) {
        this.myIgnoreMoClassPrefix = ignoreMoClassPrefix;
    }

    public void init() {
        this.myCMData = new ArrayList<RAMLCMData>();
        this.myMetaData = null;
    }

    public void writeTo(String fileName) throws Exception {
        this.createEmptyDOM();
        this.addRAMLModelToDOM();
        this.saveDOMToFile(fileName);
    }

    public void writeTo(OutputStream os) throws Exception {
        this.createEmptyDOM();
        this.addRAMLModelToDOM();
        this.saveDOMToFile(os);
    }

    public RAMLCMData createCMData() {
        RAMLCMData cmData = new RAMLCMData(this);
        this.myCMData.add(cmData);
        return cmData;
    }

    public void addCMData(RAMLCMData cmData) {
        this.myCMData.add(cmData);
        cmData.setRAMLFile(this);
    }

    @Override
    public void destroy() {
        this.clear();
        this.myCMData = null;
        this.myDOMDocument = null;
        super.destroy();
    }

    public List<RAMLCMData> getCMData() {
        return this.myCMData;
    }

    @Override
    protected void clear() {
        int i = 0;
        while (i < this.myCMData.size()) {
            this.myCMData.get(i).destroy();
            ++i;
        }
        this.myCMData.clear();
    }

    public void setVersion(double version) {
        this.myVersion = version;
    }

    public double getVersion() {
        return this.myVersion;
    }

    protected void saveDOMToFile(String fileName) throws TransformerException, IllegalArgumentException {
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            this.saveDOMToFile(os);
            IOUtils.closeQuietly(os);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Given file name (" + fileName + ") is invalid.", e);
        }
    }

    protected void saveDOMToFile(OutputStream os) throws TransformerException, IllegalArgumentException {
        TransformerFactory transFact = TransformerFactory.newInstance();
        Transformer transformer = transFact.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.transform(new DOMSource(this.myDOMDocument), new StreamResult(os));
    }

    @Override
    public void buildModel(Document doc) {
        Node ramlNode = doc.getElementsByTagName("raml").item(0);
        Node ramlChildNode = null;
        NodeList ramlChildNodes = null;
        Attr versionElement = ((Element)ramlNode).getAttributeNode("version");
        Double version = new Double("2.1");
        if (versionElement != null) {
            version = new Double(versionElement.getValue());
        }
        if (ramlNode.getNodeName().equals("raml") && version >= 2.0) {
            this.myVersion = version;
            this.setAttribute("version", version.toString());
            ramlChildNodes = ramlNode.getChildNodes();
            int i = 0;
            int size = ramlChildNodes.getLength();
            while (i < size) {
                ramlChildNode = ramlChildNodes.item(i);
                if (ramlChildNode.getNodeName().equals("cmData")) {
                    this.createRAMLCMData(ramlChildNode);
                }
                ++i;
            }
        }
    }

    private void createRAMLCMData(Node ramlChildNode) {
        Node tempChildNode;
        int size;
        RAMLCMData cmData = this.createCMData();
        if (ramlChildNode.hasAttributes()) {
            NamedNodeMap nodeAttributes = ramlChildNode.getAttributes();
            int i = 0;
            size = nodeAttributes.getLength();
            while (i < size) {
                tempChildNode = nodeAttributes.item(i);
                cmData.setAttribute(tempChildNode.getNodeName(), tempChildNode.getNodeValue());
                ++i;
            }
        }
        NodeList cmDataChildNodes = ramlChildNode.getChildNodes();
        int j = 0;
        size = cmDataChildNodes.getLength();
        while (j < size) {
            tempChildNode = cmDataChildNodes.item(j);
            if (tempChildNode.getNodeName().equals("managedObject")) {
                this.createRAMLManagedObject(tempChildNode, cmData);
            } else if (tempChildNode.getNodeName().equals("header")) {
                this.createRAMLHeader(tempChildNode, cmData);
            }
            ++j;
        }
    }

    private void createRAMLHeader(Node headerNode, RAMLCMData cmData) {
        cmData.createHeader();
        if (headerNode.hasChildNodes()) {
            NodeList allLogNodes = headerNode.getChildNodes();
            RAMLHeader header = cmData.getHeader();
            RAMLLogEntry logEntry = null;
            int i = 0;
            while (i < allLogNodes.getLength()) {
                if (allLogNodes.item(i).getNodeName().equals("log")) {
                    logEntry = new RAMLLogEntry();
                    Node logNode = allLogNodes.item(i);
                    NamedNodeMap logAttributes = logNode.getAttributes();
                    int j = 0;
                    while (j < logAttributes.getLength()) {
                        Node attributeNode = logAttributes.item(j);
                        String nodeName = attributeNode.getNodeName();
                        if (nodeName.equals("action")) {
                            logEntry.setAction(attributeNode.getNodeValue());
                        } else if (nodeName.equals("appInfo")) {
                            logEntry.setAppInfo(attributeNode.getNodeValue());
                        } else if (nodeName.equals("dateTime")) {
                            logEntry.setDateTime(attributeNode.getNodeValue());
                        } else if (nodeName.equals("user")) {
                            logEntry.setUser(attributeNode.getNodeValue());
                        } else if (nodeName.equals("adaptationVersionMinor")) {
                            logEntry.setAdaptationVersionMinor(attributeNode.getNodeValue());
                        } else if (nodeName.equals("appVersion")) {
                            logEntry.setAppVersion(attributeNode.getNodeValue());
                        }
                        ++j;
                    }
                    if (logNode.hasChildNodes()) {
                        Node textNode = logNode.getFirstChild();
                        logEntry.setContent(textNode.getNodeValue());
                    }
                    header.addLog(logEntry);
                }
                ++i;
            }
        }
    }

    private void createRAMLManagedObject(Node managedObjectNode, RAMLCMData cmData) {
        NamedNodeMap moAttributes = managedObjectNode.getAttributes();
        RAMLManagedObject managedObject = moAttributes.getNamedItem("operation") != null ? new RAMLManagedObject(moAttributes.getNamedItem("distName").getNodeValue(), moAttributes.getNamedItem("class").getNodeValue(), moAttributes.getNamedItem("operation").getNodeValue(), cmData) : new RAMLManagedObject(moAttributes.getNamedItem("distName").getNodeValue(), moAttributes.getNamedItem("class").getNodeValue(), cmData);
        int i = 0;
        while (i < moAttributes.getLength()) {
            Node attribute = moAttributes.item(i);
            managedObject.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
            ++i;
        }
        if (managedObjectNode.hasChildNodes()) {
            NodeList childNodes = managedObjectNode.getChildNodes();
            int j = 0;
            while (j < childNodes.getLength()) {
                Node childNode = childNodes.item(j);
                if (childNode.getNodeName().equals("p")) {
                    RAMLParameter parameter = this.createRAMLParameter(childNode);
                    managedObject.setParameter(parameter);
                } else if (childNode.getNodeName().equals("list")) {
                    this.createRAMLList(childNode, managedObject);
                } else if (childNode.getNodeName().equals("extension")) {
                    this.createExtension(childNode, managedObject);
                }
                ++j;
            }
        }
    }

    private RAMLParameter createRAMLParameter(Node parameterNode) {
        if (parameterNode.hasChildNodes()) {
            Node childTextNode = parameterNode.getFirstChild();
            RAMLParameter parameter = ((Element)parameterNode).getAttributeNode("name") != null ? new RAMLParameter(((Element)parameterNode).getAttributeNode("name").getNodeValue(), childTextNode.getNodeValue()) : new RAMLParameter(childTextNode.getNodeValue());
            return parameter;
        }
        RAMLParameter parameter = ((Element)parameterNode).getAttributeNode("name") != null ? new RAMLParameter(((Element)parameterNode).getAttributeNode("name").getNodeValue(), "") : new RAMLParameter("", "");
        return parameter;
    }

    private void createRAMLList(Node listNode, RAMLManagedObject managedObject) {
        if (listNode.hasChildNodes()) {
            Node firstNode = listNode.getFirstChild();
            if (firstNode.getNextSibling() != null) {
                firstNode = firstNode.getNextSibling();
            }
            if (firstNode.getNodeName().equals("p")) {
                this.createRAMLParaList(listNode, managedObject);
            } else if (firstNode.getNodeName().equals("item")) {
                this.createRAMLItemList(listNode, managedObject);
            } else {
                this.createEmptyRAMLItemList(listNode, managedObject);
            }
        } else {
            this.createEmptyRAMLItemList(listNode, managedObject);
        }
    }

    private void createEmptyRAMLItemList(Node listNode, RAMLManagedObject managedObject) {
        RAMLItemList emptyList = new RAMLItemList();
        emptyList.setName(((Element)listNode).getAttributeNode("name").getNodeValue());
        managedObject.addList(emptyList);
    }

    private void createRAMLListForExtension(Node listNode, RAMLExtension extension) {
        if (listNode.hasChildNodes()) {
            Node firstNode = listNode.getFirstChild();
            if (firstNode.getNextSibling() != null) {
                firstNode = firstNode.getNextSibling();
            }
            if (firstNode.getNodeName().equals("p")) {
                this.createRAMLParaListForExtension(listNode, extension);
            } else if (firstNode.getNodeName().equals("item")) {
                this.createRAMLItemListForExtension(listNode, extension);
            }
        } else {
            RAMLItemList emptyList = new RAMLItemList();
            emptyList.setName(((Element)listNode).getAttributeNode("name").getNodeValue());
            extension.addList(emptyList);
        }
    }

    private void createExtension(Node extensionNode, RAMLManagedObject managedObject) {
        if (extensionNode.hasChildNodes()) {
            RAMLExtension extension = new RAMLExtension();
            extension.setName(((Element)extensionNode).getAttributeNode("name").getNodeValue());
            NodeList childNodes = extensionNode.getChildNodes();
            int j = 0;
            while (j < childNodes.getLength()) {
                Node childNode = childNodes.item(j);
                if (childNode.getNodeName().equals("p")) {
                    RAMLParameter parameter = this.createRAMLParameter(childNode);
                    extension.setParameter(parameter);
                } else if (childNode.getNodeName().equals("list")) {
                    this.createRAMLListForExtension(childNode, extension);
                }
                ++j;
            }
            managedObject.addExtension(extension);
        } else {
            RAMLExtension extension = new RAMLExtension();
            extension.setName(((Element)extensionNode).getAttributeNode("name").getNodeValue());
            managedObject.addExtension(extension);
        }
    }

    private void createRAMLParaList(Node listNode, RAMLManagedObject managedObject) {
        RAMLParameterList parameterList = new RAMLParameterList();
        parameterList.setName(((Element)listNode).getAttributeNode("name").getNodeValue());
        NodeList parameterNodes = listNode.getChildNodes();
        int i = 0;
        while (i < parameterNodes.getLength()) {
            if (parameterNodes.item(i).getNodeName().equals("p")) {
                RAMLParameter parameter = this.createRAMLParameter(parameterNodes.item(i));
                parameter.setRAMLManagedObject(managedObject);
                parameter.setParent(parameterList);
                parameterList.add(parameter);
            }
            ++i;
        }
        managedObject.addList(parameterList);
    }

    private void createRAMLParaListForExtension(Node listNode, RAMLExtension extension) {
        RAMLParameterList parameterList = new RAMLParameterList();
        parameterList.setName(((Element)listNode).getAttributeNode("name").getNodeValue());
        NodeList parameterNodes = listNode.getChildNodes();
        int i = 0;
        while (i < parameterNodes.getLength()) {
            if (parameterNodes.item(i).getNodeName().equals("p")) {
                RAMLParameter parameter = this.createRAMLParameter(parameterNodes.item(i));
                parameter.setParent(parameterList);
                parameterList.add(parameter);
            }
            ++i;
        }
        extension.addList(parameterList);
    }

    private void createRAMLItemList(Node listNode, RAMLManagedObject managedObject) {
        RAMLItemList itemList = new RAMLItemList();
        itemList.setName(((Element)listNode).getAttributeNode("name").getNodeValue());
        NodeList itemNodes = listNode.getChildNodes();
        int j = 0;
        while (j < itemNodes.getLength()) {
            if (itemNodes.item(j).getNodeName().equals("item")) {
                RAMLItem item = new RAMLItem();
                Node itemNode = itemNodes.item(j);
                NamedNodeMap itemAttributes = itemNode.getAttributes();
                int i = 0;
                while (i < itemAttributes.getLength()) {
                    Node attribute = itemAttributes.item(i);
                    item.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
                    ++i;
                }
                if (itemNode.hasChildNodes()) {
                    NodeList itemListNodes = itemNode.getChildNodes();
                    int k = 0;
                    while (k < itemListNodes.getLength()) {
                        Node tempNode = itemListNodes.item(k);
                        if (tempNode.getNodeName().equals("p")) {
                            RAMLParameter itemParameter = this.createRAMLParameter(tempNode);
                            itemParameter.setRAMLManagedObject(managedObject);
                            item.addParameter(itemParameter);
                        }
                        ++k;
                    }
                }
                itemList.add(item);
            }
            ++j;
        }
        managedObject.addList(itemList);
    }

    private void createRAMLItemListForExtension(Node listNode, RAMLExtension extension) {
        RAMLItemList itemList = new RAMLItemList();
        itemList.setName(((Element)listNode).getAttributeNode("name").getNodeValue());
        NodeList itemNodes = listNode.getChildNodes();
        int j = 0;
        while (j < itemNodes.getLength()) {
            if (itemNodes.item(j).getNodeName().equals("item")) {
                RAMLItem item = new RAMLItem();
                Node itemNode = itemNodes.item(j);
                if (itemNode.hasChildNodes()) {
                    NodeList itemListNodes = itemNode.getChildNodes();
                    int k = 0;
                    while (k < itemListNodes.getLength()) {
                        Node tempNode = itemListNodes.item(k);
                        if (tempNode.getNodeName().equals("p")) {
                            RAMLParameter itemParameter = this.createRAMLParameter(tempNode);
                            item.addParameter(itemParameter);
                        }
                        ++k;
                    }
                }
                itemList.add(item);
            }
            ++j;
        }
        extension.addList(itemList);
    }

    private void createEmptyDOM() throws FactoryConfigurationError, ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        this.myDOMDocument = docBuilder.newDocument();
    }

    private void addRAMLModelToDOM() {
        Element typeElement = this.myDOMDocument.createElement("raml");
        typeElement.setAttribute("version", Double.toString(this.myVersion));
        typeElement.setAttribute("xmlns", "raml" + this.getRamlVersionWithoutDot() + ".xsd");
        this.myDOMDocument.appendChild(typeElement);
        int i = 0;
        while (i < this.myCMData.size()) {
            RAMLCMData cmData = this.myCMData.get(i);
            List<RAMLManagedObject> ramlMOs = cmData.getMOs();
            Element cmDataElement = this.myDOMDocument.createElement("cmData");
            this.setAttributes(cmDataElement, cmData);
            typeElement.appendChild(cmDataElement);
            cmDataElement.appendChild(this.ramlHeaderToDOM(cmData));
            Iterator<RAMLManagedObject> ite = ramlMOs.iterator();
            while (ite.hasNext()) {
                cmDataElement.appendChild(this.ramlMOToDOM(ite.next()));
            }
            ++i;
        }
    }

    private String getRamlVersionWithoutDot() {
        StringBuffer versionBuffer = new StringBuffer(Double.toString(this.myVersion));
        versionBuffer.deleteCharAt(1);
        return versionBuffer.toString();
    }

    private Element ramlHeaderToDOM(RAMLCMData cmData) {
        RAMLHeader header = cmData.getHeader();
        Element headerElement = this.myDOMDocument.createElement("header");
        List<RAMLLogEntry> logs = header.getLogs();
        for (RAMLLogEntry log : logs) {
            Element logElement = this.myDOMDocument.createElement("log");
            logElement.setAttribute("dateTime", log.getDateTime());
            logElement.setAttribute("action", log.getAction());
            logElement.setAttribute("user", log.getUser());
            logElement.setAttribute("appInfo", log.getAppInfo());
            logElement.setAttribute("appVersion", log.getAppVersion());
            if (!"".equals(log.getContent())) {
                Text contentText = this.myDOMDocument.createTextNode(log.getContent());
                logElement.appendChild(contentText);
            }
            headerElement.appendChild(logElement);
        }
        return headerElement;
    }

    private void setAttributes(Element element, RAMLObject object) {
        List<String> attributeKeySet = object.getAttributeKeys();
        for (String tempKey : attributeKeySet) {
            element.setAttribute(tempKey, object.getAttribute(tempKey));
        }
    }

    private void setMOAttributes(Element element, RAMLManagedObject object) {
        List<String> attributeKeySet = object.getAttributeKeys();
        for (String tempKey : attributeKeySet) {
            String attributeValue = object.getAttribute(tempKey);
            attributeValue = this.updateMOAttribute(object, tempKey, attributeValue);
            element.setAttribute(tempKey, attributeValue);
        }
    }

    private String updateMOAttribute(RAMLManagedObject object, String attributeKey, String attributeValue) {
        if (attributeKey.equals("class")) {
            if (this.myIgnoreMoClassPrefix) {
                return object.getMOClass();
            }
            String moClassPrefix = object.getMOClassPrefix();
            if (!moClassPrefix.isEmpty() && !attributeValue.contains(COLON_STRING)) {
                return String.valueOf(moClassPrefix) + COLON_STRING + attributeValue;
            }
        }
        return attributeValue;
    }

    private Element ramlMOToDOM(RAMLManagedObject managedObject) {
        Element moElement = this.myDOMDocument.createElement("managedObject");
        this.setMOAttributes(moElement, managedObject);
        List<RAMLExtension> ramlExtensions = managedObject.getExtensions();
        Iterator<RAMLExtension> extIte = ramlExtensions.iterator();
        while (extIte.hasNext()) {
            moElement.appendChild(this.ramlExtensionToDOM(extIte.next()));
        }
        List<RAMLParameter> ramlParaList = managedObject.getParameters();
        Iterator<RAMLParameter> paraIte = ramlParaList.iterator();
        while (paraIte.hasNext()) {
            moElement.appendChild(this.ramlParameterToDOM(paraIte.next()));
        }
        List<RAMLList<?>> ramlItemList = managedObject.getLists();
        for (RAMLList<?> list : ramlItemList) {
            Element listElement = this.myDOMDocument.createElement("list");
            listElement.setAttribute("name", list.getName());
            if (list instanceof RAMLItemList) {
                List<RAMLItem> itemList = ((RAMLItemList)list).getItems();
                Iterator<RAMLItem> ite = itemList.iterator();
                while (ite.hasNext()) {
                    listElement.appendChild(this.ramlItemToDOM(ite.next()));
                }
                moElement.appendChild(listElement);
                continue;
            }
            if (!(list instanceof RAMLParameterList)) continue;
            List<RAMLParameter> paramList = ((RAMLParameterList)list).getParameters();
            Iterator<RAMLParameter> iter = paramList.iterator();
            while (iter.hasNext()) {
                listElement.appendChild(this.ramlParameterListParameterToDOM(iter.next()));
            }
            moElement.appendChild(listElement);
        }
        return moElement;
    }

    private Element ramlExtensionToDOM(RAMLExtension extension) {
        Element extensionElement = this.myDOMDocument.createElement("extension");
        extensionElement.setAttribute("name", extension.getName());
        List<RAMLParameter> ramlParaList = extension.getParameters();
        Iterator<RAMLParameter> paraIte = ramlParaList.iterator();
        while (paraIte.hasNext()) {
            extensionElement.appendChild(this.ramlParameterToDOM(paraIte.next()));
        }
        List<RAMLList<?>> ramlItemList = extension.getLists();
        for (RAMLList<?> list : ramlItemList) {
            Element listElement = this.myDOMDocument.createElement("list");
            listElement.setAttribute("name", list.getName());
            if (list instanceof RAMLItemList) {
                List<RAMLItem> itemList = ((RAMLItemList)list).getItems();
                Iterator<RAMLItem> ite = itemList.iterator();
                while (ite.hasNext()) {
                    listElement.appendChild(this.ramlItemToDOM(ite.next()));
                }
                extensionElement.appendChild(listElement);
                continue;
            }
            if (!(list instanceof RAMLParameterList)) continue;
            List<RAMLParameter> paramList = ((RAMLParameterList)list).getParameters();
            Iterator<RAMLParameter> iter = paramList.iterator();
            while (iter.hasNext()) {
                listElement.appendChild(this.ramlParameterListParameterToDOM(iter.next()));
            }
            extensionElement.appendChild(listElement);
        }
        return extensionElement;
    }

    private Element ramlParameterToDOM(RAMLParameter parameter) {
        Element paraElement = this.myDOMDocument.createElement("p");
        paraElement.setAttribute("name", parameter.getName());
        if (!"".equals(parameter.getValue())) {
            Text paraValue = this.myDOMDocument.createTextNode(parameter.getValue());
            paraElement.appendChild(paraValue);
        }
        return paraElement;
    }

    private Element ramlParameterListParameterToDOM(RAMLParameter parameter) {
        Element paraElement = this.myDOMDocument.createElement("p");
        if (!"".equals(parameter.getValue())) {
            Text paraValue = this.myDOMDocument.createTextNode(parameter.getValue());
            paraElement.appendChild(paraValue);
        }
        return paraElement;
    }

    private Element ramlItemToDOM(RAMLItem item) {
        Element itemElement = this.myDOMDocument.createElement("item");
        this.setAttributes(itemElement, item);
        List<RAMLParameter> itemParameters = item.getParameters();
        Iterator<RAMLParameter> ite = itemParameters.iterator();
        while (ite.hasNext()) {
            itemElement.appendChild(this.ramlParameterToDOM(ite.next()));
        }
        return itemElement;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RAMLFile Content: \n");
        builder.append("Attributes: \n");
        builder.append(super.toString());
        Iterator<RAMLCMData> iter = this.getCMData().iterator();
        while (iter.hasNext()) {
            builder.append(String.valueOf(iter.next().toString()) + "\n");
        }
        return builder.toString();
    }

    @Override
    public String toXmlString() {
        BufferedInputStream f = null;
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tempRAML", ".xml");
            this.writeTo(tempFile.getAbsolutePath());
            byte[] buffer = new byte[(int)tempFile.length()];
            f = new BufferedInputStream(new FileInputStream(tempFile));
            f.read(buffer);
            if (!tempFile.delete()) {
                tempFile.deleteOnExit();
            }
            f.close();
            return new String(buffer);
        }
        catch (Exception e) {
            if (tempFile != null && !tempFile.delete()) {
                tempFile.deleteOnExit();
            }
            return null;
        }
    }

    public RAMLMetaDataFile getMetaData() {
        return this.myMetaData;
    }

    public void addMetaData(RAMLMetaDataFile metaData) {
        if (this.myMetaData != null) {
            for (RAMLMetaManagedObject metaMO : metaData.getMetaManagedObjects()) {
                this.myMetaData.addMetaManagedObject(metaMO.getClassName(), metaMO);
            }
        } else {
            this.myMetaData = metaData;
        }
    }

    public void clearMetaData() {
        this.myMetaData = null;
    }

    public void validate(RAMLValidationContext validationContext) {
        int i = 0;
        while (i < this.myCMData.size()) {
            RAMLCMData tmp = this.myCMData.get(i);
            tmp.validate(validationContext);
            ++i;
        }
    }

    public void parseSiteWithSax(TreeSet<String> sites, InputStream is, boolean planInOptimisedOrder, RAMLPrevalidationDeltaWatcher changeFinder) throws SAXException, IOException {
        this.mySitesToBeParsed.addAll(sites);
        this.parseSiteWithSax(is, planInOptimisedOrder, null, changeFinder);
    }

    public void parseSiteWithSax(TreeSet<String> sites, InputStream is, boolean planInOptimisedOrder) throws SAXException, IOException {
        this.parseSiteWithSax(sites, is, planInOptimisedOrder, null);
    }

    public void parseSiteWithSax(InputStream is, boolean planInOptimisedOrder, RAMLSaxParserLock parserLock, RAMLPrevalidationDeltaWatcher changeFinder) throws SAXException, IOException {
        String siteClass = null;
        siteClass = parserLock != null ? parserLock.getSitesToBeParsed().first() : this.mySitesToBeParsed.first();
        siteClass = siteClass.substring(siteClass.lastIndexOf(47) + 1, siteClass.lastIndexOf(45));
        if (this.myCMData.size() == 0) {
            this.createCMData();
        }
        XMLReader parser = XMLReaderFactory.createXMLReader();
        parser.setEntityResolver(this.getEntityResolver());
        if (parserLock != null) {
            parser.setContentHandler(new RAMLSaxHandler(planInOptimisedOrder, siteClass, this.myCMData.get(0), parserLock, changeFinder));
        } else {
            parser.setContentHandler(new RAMLSaxHandler(planInOptimisedOrder, siteClass, this.mySitesToBeParsed, this.myCMData.get(0), changeFinder));
        }
        try {
            parser.parse(new InputSource(is));
        }
        catch (SAXException e) {
            Logger.getLogger(this.getClass()).debug("Stopping RAML model parsing ", e);
        }
        Logger.getLogger(this.getClass()).debug("RAML model parsed. ");
        if (is != null) {
            is.close();
        }
        if (parserLock != null) {
            parserLock.notifyParsingReady();
        }
    }
}

