/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import com.nokia.em.poseidon.frameworks.raml.RAMLObject;
import com.nokia.em.poseidon.util.file.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class RAMLFileBase
extends RAMLObject {
    private static final long serialVersionUID = -6184684963223646800L;
    public static final String XML_START_ELEMENT = "<?xml version='1.0' encoding='UTF-8'?>";
    public static final String RAML_20_DTD = "raml20.dtd";
    public static final String RAML_21_DTD = "raml21.dtd";

    public void readFrom(String fileName) throws Exception, SAXException, IOException {
        this.clear();
        DocumentBuilder builder = this.createDocumentBuilder();
        Document doc = null;
        try {
            doc = builder.parse(fileName);
        }
        catch (MalformedURLException e) {
            doc = builder.parse(new File(fileName).toURI().toString());
        }
        catch (FileNotFoundException ex) {
            FileInputStream is = new FileInputStream(fileName);
            doc = builder.parse(is);
            IOUtils.closeQuietly(is);
        }
        this.buildModel(doc);
    }

    public void readFrom(Document doc) throws Exception {
        this.clear();
        this.buildModel(doc);
    }

    public void readFrom(InputStream is) throws Exception, SAXException, IOException {
        this.clear();
        DocumentBuilder builder = this.createDocumentBuilder();
        Document doc = builder.parse(is);
        this.buildModel(doc);
    }

    public void readFrom(File file) throws Exception, SAXException, IOException {
        this.clear();
        DocumentBuilder builder = this.createDocumentBuilder();
        Document doc = null;
        try {
            doc = builder.parse(file);
        }
        catch (FileNotFoundException ex) {
            FileInputStream is = new FileInputStream(file);
            doc = builder.parse(is);
            IOUtils.closeQuietly(is);
        }
        this.buildModel(doc);
    }

    protected DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(this.getEntityResolver());
        return builder;
    }

    protected EntityResolver getEntityResolver() {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                if (systemId.indexOf(RAMLFileBase.RAML_20_DTD) > -1 || systemId.indexOf(RAMLFileBase.RAML_21_DTD) > -1) {
                    return new InputSource(new ByteArrayInputStream(RAMLFileBase.XML_START_ELEMENT.getBytes()));
                }
                return null;
            }
        };
    }

    public abstract void buildModel(Document var1);

    @Override
    protected abstract void clear();
}

