/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import com.nokia.em.poseidon.frameworks.raml.RAMLFile;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLSaxHandler;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLChildManagedObject;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaDataFile;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaManagedObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class RAMLHelpper {
    private static Map<String, Object> myGlobalProperties = new HashMap<String, Object>();

    private RAMLHelpper() {
    }

    public static void setPropertyForThisAndChildrenMOs(RAMLManagedObject mo, String key, Object value) {
        mo.setProperty(key, value);
        for (RAMLManagedObject managedObject : mo.getChildMOs()) {
            managedObject.setProperty(key, value);
        }
    }

    public static void setPropertyForThisAndChildrenMetaMOs(RAMLMetaManagedObject metaMO, String key, Object value) {
        metaMO.setProperty(key, value);
        for (RAMLChildManagedObject childMO : metaMO.getChildManagedObjects()) {
            RAMLHelpper.setPropertyForThisAndChildrenMetaMOs(metaMO.getMetaDataFile().getMetaManagedObject(childMO.getClassName()), key, value);
        }
    }

    public static void setPropertyForThisAndChildrenMetaMOs(RAMLMetaDataFile metaFile, String className, String key, Object value) {
        RAMLHelpper.setPropertyForThisAndChildrenMetaMOs(metaFile.getMetaManagedObject(className), key, value);
    }

    public static void skipThisMOAndChildrenValidation(RAMLMetaDataFile metaFile, String distName) {
        metaFile.setProperty("Do not validate this distName", distName);
    }

    public static boolean skipThisMOValidation(RAMLMetaDataFile metaFile, RAMLManagedObject mo) {
        if (metaFile != null && metaFile.getProperty("Do not validate this distName") != null && mo.getDistName() != null) {
            return mo.getDistName().contains((String)metaFile.getProperty("Do not validate this distName"));
        }
        return false;
    }

    public static RAMLFile parseRAMLFileWithSAX(InputStream is) throws SAXException, IOException {
        RAMLFile ramlFile = new RAMLFile();
        XMLReader parser = XMLReaderFactory.createXMLReader();
        parser.setEntityResolver(ramlFile.getEntityResolver());
        parser.setContentHandler(new RAMLSaxHandler(ramlFile));
        parser.parse(new InputSource(is));
        return ramlFile;
    }

    public static InputStream resolveInputStreamForSAXParser(File file) throws FileNotFoundException, IOException {
        if (file.getName().endsWith("gz")) {
            return new GZIPInputStream(new FileInputStream(file));
        }
        if (file.getName().endsWith("zip")) {
            ZipInputStream is = new ZipInputStream(new FileInputStream(file));
            is.getNextEntry();
            return is;
        }
        return new FileInputStream(file);
    }

    public static void setGlobalProperty(String key, Object value) {
        myGlobalProperties.put(key, value);
    }

    public static Object getGlobalProperty(String key) {
        return myGlobalProperties.get(key);
    }

    public static List<String> getParameterValues(RAMLManagedObject mObject, String className, String listName, String parameterName, RAMLScope scope) {
        List<RAMLParameter> parameters = RAMLHelpper.getParameters(mObject, className, listName, parameterName, scope);
        ArrayList<String> values = new ArrayList<String>();
        if (parameters != null) {
            for (RAMLParameter parameter : parameters) {
                values.add(parameter.getValue());
            }
        }
        return values;
    }

    public static List<RAMLParameter> getParameters(RAMLManagedObject mObject, String className, String listName, String parameterName, RAMLScope scope) {
        return mObject.getParameters(className, listName, parameterName, scope);
    }

    public static List<RAMLManagedObject> getMOsByScope(RAMLManagedObject mObject, String className, RAMLScope scope) {
        return mObject.getMOsByScope(className, scope);
    }

    public static List<RAMLList> getLists(RAMLManagedObject mObject, String className, String listName, RAMLScope scope) {
        ArrayList<RAMLList> ramlLists = new ArrayList<RAMLList>();
        List<RAMLManagedObject> managedObjects = RAMLHelpper.getMOsByScope(mObject, className, scope);
        for (RAMLManagedObject managedObject : managedObjects) {
            RAMLList<?> list = managedObject.getList(listName);
            if (list == null || list.size() <= 0) continue;
            ramlLists.add(list);
        }
        return ramlLists;
    }

    public static RAMLManagedObject getParentMOByName(RAMLManagedObject mo, String parentName) {
        if (mo == null || mo.getParentMO() == null) {
            return null;
        }
        if (mo.getMOClass().equals(parentName)) {
            return mo;
        }
        if (mo.getParentMO().getMOClass().equals(parentName)) {
            return mo.getParentMO();
        }
        return RAMLHelpper.getParentMOByName(mo.getParentMO(), parentName);
    }

    public static String getSimpleOperationFormat(String operationValue) {
        if ("ADD".equals(operationValue)) {
            return "+";
        }
        if ("SUBTRACT".equals(operationValue)) {
            return "-";
        }
        if ("MULTIPLY".equals(operationValue)) {
            return "*";
        }
        if ("DIVIDE".equals(operationValue)) {
            return "/";
        }
        if ("MODULO".equals(operationValue)) {
            return "%";
        }
        if ("POWER".equals(operationValue)) {
            return "^";
        }
        if ("BIGGER_OR_EQUAL".equals(operationValue)) {
            return "\u2265";
        }
        if ("BIGGER".equals(operationValue)) {
            return ">";
        }
        if ("SMALLER_OR_EQUAL".equals(operationValue)) {
            return "\u2264";
        }
        if ("SMALLER".equals(operationValue)) {
            return "<";
        }
        if ("EQUAL".equals(operationValue)) {
            return "=";
        }
        return operationValue;
    }

    public static enum RAMLScope {
        WHOLE_RAML,
        SINGLE_MO,
        CURRENT_MO;

    }
}

