/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import com.nokia.em.poseidon.frameworks.raml.RAMLItemList;
import com.nokia.em.poseidon.frameworks.raml.RAMLObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RAMLItem
extends RAMLObject {
    private static final long serialVersionUID = -9159593329695274558L;
    private Map<String, RAMLParameter> myParameters = new HashMap<String, RAMLParameter>();
    private ArrayList<RAMLParameter> myParametersCollection = new ArrayList();
    private RAMLItemList myParentList;

    public List<RAMLParameter> getParameters() {
        return (ArrayList)this.myParametersCollection.clone();
    }

    public void addParameter(RAMLParameter param) {
        if (param != null) {
            if (this.myParameters.containsKey(param.getName())) {
                int i = 0;
                while (i < this.myParametersCollection.size()) {
                    if (this.myParametersCollection.get(i).getName().equals(param.getName())) {
                        this.myParametersCollection.set(i, param);
                    }
                    ++i;
                }
            } else {
                this.myParametersCollection.add(param);
            }
            param.setParent(this);
            this.myParameters.put(param.getName(), param);
        }
    }

    public void setOperation(String operation) {
        if (operation != null) {
            this.setAttribute("operation", operation);
        }
    }

    public String getOperation() {
        return this.getAttribute("operation");
    }

    public void removeParameter(String name) {
        this.myParametersCollection.remove(this.myParameters.get(name));
        this.myParameters.remove(name);
    }

    public RAMLParameter getParameter(String name) {
        return this.myParameters.get(name);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.myParameters.clear();
        this.myParameters = null;
        this.myParametersCollection.clear();
        this.myParametersCollection = null;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RAMLItem \n");
        builder.append(super.toString());
        Iterator<RAMLParameter> iter = this.getParameters().iterator();
        while (iter.hasNext()) {
            builder.append("  " + iter.next().toString() + "\n");
        }
        return builder.toString();
    }

    @Override
    public String toXmlString() {
        StringBuilder ramlObjectData = new StringBuilder();
        ramlObjectData.append("<item");
        ramlObjectData.append(super.toXmlString());
        ramlObjectData.append(">");
        Iterator<RAMLParameter> iter = this.getParameters().iterator();
        while (iter.hasNext()) {
            ramlObjectData.append(iter.next().toXmlString());
        }
        ramlObjectData.append("</item>");
        return ramlObjectData.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myParametersCollection == null ? 0 : this.myParametersCollection.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RAMLItem other = (RAMLItem)obj;
        if (this.myParametersCollection == null) {
            if (other.myParametersCollection != null) {
                return false;
            }
        } else {
            if (other.myParametersCollection == null) {
                return false;
            }
            for (RAMLParameter item : this.myParametersCollection) {
                if (other.getParameters().contains(item)) continue;
                return false;
            }
            for (RAMLParameter item : other.getParameters()) {
                if (this.myParametersCollection.contains(item)) continue;
                return false;
            }
        }
        return true;
    }

    public RAMLItemList getParentList() {
        return this.myParentList;
    }

    public void setParentList(RAMLItemList parentList) {
        this.myParentList = parentList;
    }
}

