/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaManagedObject;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.util.xml.XmlUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RAMLList<T>
implements Comparable<RAMLList<T>>,
Serializable {
    private static final long serialVersionUID = 7420934149016832622L;
    private RAMLManagedObject myOwnerMO;
    protected ArrayList<T> myItems;
    private String myName;

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        if (name != null) {
            this.myName = name;
        }
    }

    public void add(T obj) {
        this.myItems.add(obj);
        this.clearParentMOCache(obj);
    }

    public void remove(T obj) {
        int indexOfItemToBeRemoved = -1;
        int i = 0;
        while (i < this.myItems.size()) {
            if (this.myItems.get(i) == obj) {
                indexOfItemToBeRemoved = i;
                break;
            }
            ++i;
        }
        if (indexOfItemToBeRemoved == -1) {
            this.myItems.remove(obj);
        } else {
            this.myItems.remove(indexOfItemToBeRemoved);
        }
        this.clearParentMOCache(obj);
    }

    public int size() {
        return this.myItems.size();
    }

    public List<T> getListObjects() {
        return this.myItems;
    }

    public void setRAMLManagedObject(RAMLManagedObject mo) {
        this.myOwnerMO = mo;
    }

    public RAMLManagedObject getManagedObject() {
        return this.myOwnerMO;
    }

    public RAMLMetaParameter getMetaData() {
        RAMLMetaManagedObject metaMO = this.myOwnerMO.getMetaData();
        return metaMO == null ? null : metaMO.getMetaParameter(this.myName);
    }

    void destroy() {
        int i = 0;
        while (i < this.myItems.size()) {
            if (this.myItems.get(i) instanceof RAMLItem) {
                ((RAMLItem)this.myItems.get(i)).destroy();
            }
            ++i;
        }
        this.myItems.clear();
        this.myItems = null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RAMLList: " + this.getName() + "\n");
        Iterator<T> iter = this.myItems.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next().toString());
        }
        return builder.toString();
    }

    public String toXmlString() {
        StringBuilder ramlObjectData = new StringBuilder();
        ramlObjectData.append("<list name=\"");
        ramlObjectData.append(XmlUtils.encode(this.getName()));
        ramlObjectData.append("\">");
        if (this.myItems != null) {
            for (T item : this.myItems) {
                if (item instanceof RAMLItem) {
                    ramlObjectData.append(((RAMLItem)item).toXmlString());
                    continue;
                }
                if (!(item instanceof RAMLParameter)) continue;
                ramlObjectData.append(((RAMLParameter)item).toXmlString());
            }
        } else {
            ramlObjectData.append("</list>");
        }
        return ramlObjectData.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myItems == null ? 0 : this.myItems.hashCode());
        result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
        result = 31 * result + (this.myOwnerMO == null ? 0 : this.myOwnerMO.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RAMLList other = (RAMLList)obj;
        if (this.myName == null && other.myName != null) {
            return false;
        }
        if (this.myName != null && !this.myName.equals(other.getName())) {
            return false;
        }
        if (this.getManagedObject() == null && other.getManagedObject() != null || this.getManagedObject() != null && other.getManagedObject() == null) {
            return false;
        }
        if (this.getManagedObject() != null && other.getManagedObject() != null && !this.getManagedObject().getDistName().equals(other.getManagedObject().getDistName())) {
            return false;
        }
        if (this.myItems == null && other.myItems != null) {
            return false;
        }
        if (other.myItems == null) {
            return false;
        }
        if (this.myItems.size() != other.myItems.size()) {
            return false;
        }
        for (T item : this.myItems) {
            if (other.myItems.contains(item)) continue;
            return false;
        }
        for (T item : other.myItems) {
            if (this.myItems.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(RAMLList<T> o) {
        return this.getName().compareTo(o.getName());
    }

    private void clearParentMOCache(T obj) {
        if (this.myOwnerMO == null) {
            return;
        }
        if (obj instanceof RAMLItem) {
            List<RAMLParameter> params = ((RAMLItem)obj).getParameters();
            for (RAMLParameter p : params) {
                this.myOwnerMO.removeFromParameterCache(this.getName(), p.getName());
            }
        } else if (obj instanceof RAMLParameter) {
            this.myOwnerMO.removeFromParameterCache(this.getName(), ((RAMLParameter)obj).getName());
        }
    }
}

