/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLCMData;
import com.nokia.em.poseidon.frameworks.raml.RAMLExtension;
import com.nokia.em.poseidon.frameworks.raml.RAMLHelpper;
import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLItemList;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaDataFile;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaManagedObject;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.util.xml.XmlUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;

public class RAMLManagedObject
extends RAMLObject
implements Comparable<RAMLManagedObject>,
Serializable {
    private static final long serialVersionUID = 6949303487902149025L;
    private static String COLON_STRING = ":";
    private Map<String, RAMLList<?>> myItemLists;
    private Map<String, RAMLExtension> myExtensions;
    private Map<String, RAMLParameter> myParameters;
    private ArrayList<RAMLList<?>> myItemListsCollection;
    private ArrayList<RAMLExtension> myExtensionsCollection;
    private ArrayList<RAMLParameter> myParametersCollection;
    private List<RAMLManagedObject> myChildManagedObjects;
    private Map<String, List<RAMLManagedObject>> myChildByClassCache;
    private RAMLManagedObject myParent;
    private RAMLCMData myCMData;
    private String myId;
    private transient ResourceBundle myResourceBundle;
    private String myDistName;
    private RAMLMetaManagedObject myMetaData;
    private String myMOClass;
    private String myPrefix = "";
    private Map<String, List<RAMLParameter>> myParameterCache;
    private boolean myUseOptimization;

    private RAMLManagedObject() {
        this.init();
    }

    private void init() {
        this.myId = "";
        this.myItemLists = new HashMap();
        this.myParameters = new HashMap<String, RAMLParameter>();
        this.myItemListsCollection = new ArrayList();
        this.myParametersCollection = new ArrayList();
        this.myExtensions = new HashMap<String, RAMLExtension>();
        this.myExtensionsCollection = new ArrayList();
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.myChildManagedObjects = new ArrayList<RAMLManagedObject>();
        this.myChildByClassCache = new HashMap<String, List<RAMLManagedObject>>();
        Object useOptimization = RAMLHelpper.getGlobalProperty("useOptimization");
        if (useOptimization instanceof Boolean) {
            this.myUseOptimization = (Boolean)useOptimization;
        }
        this.myParameterCache = this.myUseOptimization ? new HashMap<String, List<RAMLParameter>>() : Collections.emptyMap();
    }

    public RAMLManagedObject(String distName, String moClass, RAMLCMData cmData) {
        this();
        this.setMOClass(moClass);
        this.setDistName(distName);
        this.myCMData = cmData;
        if (this.myCMData != null) {
            this.myCMData.addMO(this);
        }
    }

    public RAMLManagedObject(String distName, String moClass, String operation, RAMLCMData cmData) {
        this.init(distName, moClass, operation, cmData);
    }

    private void init(String distName, String moClass, String operation, RAMLCMData cmData) {
        this.init();
        this.setMOClass(moClass);
        this.setDistName(distName);
        this.setOperation(operation);
        this.myCMData = cmData;
        if (this.myCMData != null) {
            this.myCMData.addMO(this);
        }
    }

    public RAMLManagedObject(String moClass, String distName, String operation, String version, RAMLCMData cmData) {
        this.init(moClass, distName, operation, version, cmData);
    }

    private void init(String moClass, String distName, String operation, String version, RAMLCMData cmData) {
        this.setVersion(version);
        this.init(distName, moClass, operation, cmData);
    }

    public RAMLManagedObject(String className, String distName, String operation, String version, RAMLCMData cmData, RAMLManagedObject parentMO) {
        this.myParent = parentMO;
        this.init(className, distName, operation, version, cmData);
    }

    public static String createId(String distName, String className) {
        if (distName.indexOf("/") == -1) {
            return distName.replaceFirst(String.valueOf(className) + "-", "");
        }
        String idSection = distName.substring(distName.lastIndexOf("/"));
        return idSection.replaceFirst("/" + className + "-", "");
    }

    void setCMData(RAMLCMData cmData) {
        this.myCMData = cmData;
    }

    public RAMLList<?> getList(String name) {
        return this.myItemLists.get(name);
    }

    public RAMLExtension getExtension(String name) {
        return this.myExtensions.get(name);
    }

    public RAMLParameter getParameter(String name) {
        return this.myParameters.get(name);
    }

    public Optional<RAMLParameter> getNullableParameter(String name) {
        return Optional.ofNullable(this.myParameters.get(name));
    }

    public Optional<RAMLList<?>> getNullableList(String name) {
        return Optional.ofNullable(this.getList(name));
    }

    public Optional<RAMLParameter> getNullableParameterFromFirstChildMO(String moName, String paramName) {
        Optional<RAMLManagedObject> childMO = this.getFirstChildMOByClass(moName);
        return childMO.flatMap(mo -> mo.getNullableParameter(paramName));
    }

    public Optional<RAMLParameter> getNullableParameterFromDescendantMO(String paramName, String firstDescendantClassName, String ... descendantOrderClassName) {
        Optional<RAMLManagedObject> descendantMO = this.getFirstDescendantMOByClass(firstDescendantClassName, descendantOrderClassName);
        return descendantMO.flatMap(mo -> mo.getNullableParameter(paramName));
    }

    public Optional<RAMLList<?>> getNullableListFromFirstChildMO(String moName, String listName) {
        Optional<RAMLManagedObject> childMO = this.getFirstChildMOByClass(moName);
        return childMO.flatMap(mo -> mo.getNullableList(listName));
    }

    public Optional<RAMLList<?>> getNullableListFromDescendantMO(String listName, String firstDescendantClassName, String ... descendantOrderClassName) {
        Optional<RAMLManagedObject> descendantMO = this.getFirstDescendantMOByClass(firstDescendantClassName, descendantOrderClassName);
        return descendantMO.flatMap(mo -> mo.getNullableList(listName));
    }

    public void addList(RAMLList<?> list) {
        if (list != null && list.getName().length() > 0) {
            list.setRAMLManagedObject(this);
            if (this.myItemLists.containsKey(list.getName())) {
                int i = 0;
                while (i < this.myItemListsCollection.size()) {
                    if (this.myItemListsCollection.get(i).getName().equals(list.getName())) {
                        this.myItemListsCollection.set(i, list);
                    }
                    ++i;
                }
            } else {
                this.myItemListsCollection.add(list);
            }
            this.myItemLists.put(list.getName(), list);
        }
        this.myParameterCache.clear();
    }

    public void addExtension(RAMLExtension extension) {
        if (extension != null && extension.getName().length() > 0) {
            if (this.myExtensions.containsKey(extension.getName())) {
                int i = 0;
                while (i < this.myExtensionsCollection.size()) {
                    if (this.myExtensionsCollection.get(i).getName().equals(extension.getName())) {
                        this.myExtensionsCollection.set(i, extension);
                    }
                    ++i;
                }
            } else {
                this.myExtensionsCollection.add(extension);
            }
            this.myExtensions.put(extension.getName(), extension);
        }
    }

    public void removeList(String name) {
        this.myItemListsCollection.remove(this.myItemLists.get(name));
        this.myItemLists.remove(name);
        this.myParameterCache.clear();
    }

    public void removeExtension(String name) {
        this.myExtensionsCollection.remove(this.myExtensions.get(name));
        this.myExtensions.remove(name);
    }

    public void setParameter(RAMLParameter param) {
        if (param != null) {
            param.setRAMLManagedObject(this);
            if (this.myParameters.containsKey(param.getName())) {
                int i = 0;
                while (i < this.myParametersCollection.size()) {
                    if (this.myParametersCollection.get(i).getName().equals(param.getName())) {
                        this.myParametersCollection.set(i, param);
                    }
                    ++i;
                }
            } else {
                this.myParametersCollection.add(param);
            }
            param.setParent(this);
            this.myParameters.put(param.getName(), param);
            this.myParameterCache.clear();
        }
    }

    public void removeParameter(String name) {
        this.myParametersCollection.remove(this.myParameters.get(name));
        this.myParameters.remove(name);
        this.myParameterCache.clear();
    }

    public void clearParameters() {
        this.myParametersCollection.clear();
        this.myParameters.clear();
        this.myParameterCache.clear();
    }

    public void clearLists() {
        this.myItemListsCollection.clear();
        this.myItemLists.clear();
        this.myParameterCache.clear();
    }

    public List<RAMLManagedObject> getChildMOsByClass(String className) {
        if (this.myCMData == null) {
            return null;
        }
        List<RAMLManagedObject> fromCache = this.myChildByClassCache.get(className);
        if (fromCache != null) {
            return fromCache;
        }
        ArrayList<RAMLManagedObject> childMOsByClass = new ArrayList<RAMLManagedObject>();
        String childDistName = this.getDistName().concat("/");
        List<RAMLManagedObject> allMOsByClass = this.myCMData.getMOsByClass(className);
        for (RAMLManagedObject tempMO : allMOsByClass) {
            RAMLManagedObject tempParentMo = tempMO.getParentMO();
            boolean checkDistName = tempParentMo == null;
            while (tempParentMo != null) {
                if (this.equals(tempParentMo)) {
                    childMOsByClass.add(tempMO);
                    break;
                }
                tempParentMo = tempParentMo.getParentMO();
            }
            if (!checkDistName || !tempMO.getDistName().startsWith(childDistName)) continue;
            childMOsByClass.add(tempMO);
        }
        this.myChildByClassCache.put(className, childMOsByClass);
        return childMOsByClass;
    }

    public Optional<RAMLManagedObject> getFirstChildMOByClass(String className) {
        List<RAMLManagedObject> childMOs = this.getChildMOsByClass(className);
        if (childMOs == null || childMOs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(childMOs.get(0));
    }

    public Optional<RAMLManagedObject> getFirstDescendantMOByClass(String firstDescendantClassName, String ... descendantOrderClassName) {
        Optional<RAMLManagedObject> optionalFirstChild = this.getFirstChildMOByClass(firstDescendantClassName);
        if (descendantOrderClassName.length == 0) {
            return optionalFirstChild;
        }
        Optional<RAMLManagedObject> optionalCurrentChild = optionalFirstChild;
        String[] stringArray = descendantOrderClassName;
        int n = descendantOrderClassName.length;
        int n2 = 0;
        while (n2 < n) {
            String currentClassName = stringArray[n2];
            if (!(optionalCurrentChild = optionalCurrentChild.flatMap(childMO -> childMO.getFirstChildMOByClass(currentClassName))).isPresent()) break;
            ++n2;
        }
        return optionalCurrentChild;
    }

    public void setChild(RAMLManagedObject childMO) {
        if (!this.myChildManagedObjects.contains(childMO)) {
            this.myChildManagedObjects.add(childMO);
        }
        this.clearAncestorsCachesHierarchially();
        if (this.myChildByClassCache != null) {
            this.myChildByClassCache.clear();
        }
        this.myParameterCache.clear();
    }

    public void addChild(RAMLManagedObject obj) {
        if (this.myCMData == null) {
            return;
        }
        this.clearAncestorsCachesHierarchially();
        if (this.myChildManagedObjects.contains(obj)) {
            return;
        }
        if (!"".equals(obj.getDistName()) && !"".equals(obj.getMOClass())) {
            boolean isGrandChild = obj.getDistName().contains("/");
            obj.setDistName(this.getDistName().concat("/").concat(obj.getDistName()));
            if (!isGrandChild) {
                this.myChildManagedObjects.add(obj);
            }
            this.myCMData.addMO(obj);
        }
        this.myParameterCache.clear();
    }

    public RAMLManagedObject getMOByClassAndId(String className, String id) {
        if (this.myCMData != null) {
            return this.myCMData.getMOByClassAndId(className, id);
        }
        return null;
    }

    public List<RAMLManagedObject> getMOsByClassAndId(String className, String id) {
        if (this.myCMData != null) {
            return this.myCMData.getMOsByClassAndId(className, id);
        }
        return null;
    }

    public List<RAMLManagedObject> getMOByClass(String className) {
        if (this.myCMData != null) {
            List<RAMLManagedObject> tmp = this.myCMData.getMOsByClass(className);
            ArrayList<RAMLManagedObject> actual = new ArrayList<RAMLManagedObject>(tmp.size());
            int i = 0;
            while (i < tmp.size()) {
                actual.add(tmp.get(i));
                ++i;
            }
            return actual;
        }
        return new ArrayList<RAMLManagedObject>(0);
    }

    public List<RAMLManagedObject> getChildMOs() {
        if (this.myCMData == null) {
            return null;
        }
        ArrayList<RAMLManagedObject> childMos = new ArrayList<RAMLManagedObject>();
        for (RAMLManagedObject mo : this.myChildManagedObjects) {
            childMos.addAll(mo.getChildMOs());
        }
        childMos.addAll(this.myChildManagedObjects);
        return childMos;
    }

    public List<RAMLManagedObject> getAllChildMOsIncludingHangingMOs() {
        if (this.myCMData == null) {
            return null;
        }
        ArrayList<RAMLManagedObject> childMOs = new ArrayList<RAMLManagedObject>();
        String distName = this.getDistName().concat("/");
        List<RAMLManagedObject> allMOs = this.myCMData.getMOs();
        for (RAMLManagedObject tempMO : allMOs) {
            if (!tempMO.getDistName().startsWith(distName)) continue;
            childMOs.add(tempMO);
        }
        return childMOs;
    }

    public List<RAMLManagedObject> getChildMOs(int level) {
        if (this.myCMData == null) {
            return null;
        }
        ArrayList<RAMLManagedObject> childMOs = new ArrayList<RAMLManagedObject>();
        childMOs.addAll(this.myChildManagedObjects);
        if (level > 1) {
            for (RAMLManagedObject mo : this.myChildManagedObjects) {
                childMOs.addAll(mo.getChildMOs(level - 1));
            }
        }
        return childMOs;
    }

    public RAMLCMData getCMData() {
        return this.myCMData;
    }

    public RAMLManagedObject getParentMO() {
        if (this.myCMData == null) {
            return null;
        }
        if (this.myParent != null) {
            return this.getAssignedParentMO();
        }
        this.myParent = this.myCMData.findParentMO(this);
        return this.getAssignedParentMO();
    }

    public RAMLManagedObject getAssignedParentMO() {
        return this.myParent;
    }

    public void removeChildMOs() {
        if (this.myCMData == null) {
            return;
        }
        this.myCMData.removeMOs(this.getChildMOs());
        this.myChildManagedObjects.clear();
        this.clearAncestorsCachesHierarchially();
        this.myParameterCache.clear();
    }

    public List<RAMLList<?>> getLists() {
        return (ArrayList)this.myItemListsCollection.clone();
    }

    public List<RAMLList<?>> getListsCollection() {
        return this.myItemListsCollection;
    }

    public List<RAMLExtension> getExtensions() {
        return (ArrayList)this.myExtensionsCollection.clone();
    }

    public List<RAMLParameter> getParameters() {
        return (ArrayList)this.myParametersCollection.clone();
    }

    public List<RAMLParameter> getParametersCollection() {
        return this.myParametersCollection;
    }

    public List<RAMLParameter> getSortedParameters() {
        List<RAMLParameter> params = this.getParameters();
        Collections.sort(params);
        return params;
    }

    public List<RAMLList<?>> getSortedLists() {
        List<RAMLList<?>> lists = this.getLists();
        Collections.sort(lists);
        return lists;
    }

    @Override
    public void destroy() {
        int i = 0;
        while (i < this.myItemListsCollection.size()) {
            this.myItemListsCollection.get(i).destroy();
            ++i;
        }
        int j = 0;
        while (j < this.myExtensionsCollection.size()) {
            this.myExtensionsCollection.get(j).destroy();
            ++j;
        }
        this.myItemLists.clear();
        this.myItemLists = null;
        this.myExtensions.clear();
        this.myExtensions = null;
        this.myParameters.clear();
        this.myParameters = null;
        this.myItemListsCollection.clear();
        this.myItemListsCollection = null;
        this.myParametersCollection.clear();
        this.myParametersCollection = null;
        this.myExtensionsCollection.clear();
        this.myExtensionsCollection = null;
        this.myChildManagedObjects.clear();
        this.clearAncestorsCachesHierarchially();
        super.destroy();
    }

    public String getDistName() {
        return this.myDistName;
    }

    public String getOperation() {
        return this.getAttribute("operation");
    }

    public String getMOClass() {
        if (this.myMOClass == null) {
            this.myMOClass = this.getAttribute("class");
        }
        return this.myMOClass;
    }

    public String getMOClassPrefix() {
        String moClassPrefix = "";
        moClassPrefix = !this.myPrefix.isEmpty() ? this.myPrefix : (this.getMetaData() != null ? this.getMetaData().getPrefix() : "");
        return moClassPrefix;
    }

    public String getKey() {
        String key = null;
        key = this.getOperation() != null ? String.valueOf(this.getDistName()) + "|" + this.getOperation() : this.getDistName();
        return key;
    }

    public String getVersion() {
        return this.getAttribute("version");
    }

    public void setDistName(String distName) {
        if (distName != null) {
            RAMLMetaParameter instanceP;
            boolean removed = false;
            if (this.myCMData != null && this.myCMData.getMosInMap().containsKey(this.getKey())) {
                this.myCMData.getMosInMap().remove(this.getKey());
                removed = true;
            }
            this.setAttribute("distName", distName);
            this.myId = RAMLManagedObject.createId(distName, this.getMOClass());
            RAMLMetaManagedObject metaData = this.getMetaData();
            if (metaData != null && (instanceP = metaData.getInstanceParameter()) != null) {
                this.removeFromParameterCache(null, instanceP.getName());
            }
            if (removed) {
                this.myCMData.getMosInMap().put(this.getKey(), this);
            }
        }
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("distName".equals(name)) {
            this.myDistName = value;
        }
        super.setAttribute(name, value);
    }

    public String getId() {
        return this.myId;
    }

    public void setOperation(String operation) {
        if (operation != null && !operation.equals(this.getAttribute("operation"))) {
            boolean removed = false;
            if (this.myCMData != null && this.myCMData.getMosInMap().containsKey(this.getKey())) {
                this.myCMData.getMosInMap().remove(this.getKey());
                removed = true;
            }
            this.setAttribute("operation", operation);
            if (removed) {
                this.myCMData.getMosInMap().put(this.getKey(), this);
            }
        }
    }

    public void setMOClass(String moClass) {
        String className = moClass;
        if (className != null) {
            int colonIndex = className.indexOf(COLON_STRING);
            if (colonIndex >= 0) {
                this.myPrefix = className.substring(0, colonIndex);
                className = className.substring(colonIndex + 1);
            }
            this.setAttribute("class", className);
            this.myMOClass = className;
        }
    }

    public void setMOClassWithouCheck(String moClass) {
        this.setAttribute("class", moClass);
        this.myMOClass = moClass;
    }

    public void setVersion(String version) {
        if (version != null) {
            this.setAttribute("version", version);
        }
    }

    public RAMLMetaManagedObject getMetaData() {
        if (this.myMetaData == null) {
            this.myMetaData = this.getMetaData(this.getMOClass());
        }
        return this.myMetaData;
    }

    public RAMLMetaManagedObject getMetaData(String className) {
        if (this.myCMData == null) {
            return null;
        }
        RAMLMetaDataFile metaData = this.myCMData.getMetaData();
        if (metaData == null) {
            return null;
        }
        return metaData.getMetaManagedObject(className);
    }

    public boolean addMetaData(RAMLMetaDataFile metaData) {
        if (this.myCMData != null) {
            this.myCMData.addMetaData(metaData);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RAMLManagedObject \n");
        builder.append("Attributes: \n");
        builder.append(super.toString());
        builder.append("Parameters: \n");
        Iterator<RAMLParameter> iter = this.getParameters().iterator();
        while (iter.hasNext()) {
            builder.append("  " + iter.next().toString() + "\n");
        }
        builder.append("Lists: \n");
        Iterator<RAMLList<?>> itera = this.getLists().iterator();
        while (itera.hasNext()) {
            builder.append(String.valueOf(itera.next().toString()) + "\n");
        }
        return builder.toString();
    }

    @Override
    public String toXmlString() {
        StringBuilder ramlObjectData = new StringBuilder();
        ramlObjectData.append("<managedObject");
        ramlObjectData.append(super.toXmlString());
        ramlObjectData.append(">");
        for (RAMLParameter param : this.getParameters()) {
            ramlObjectData.append(param.toXmlString());
        }
        Iterator<RAMLList<?>> iter2 = this.getLists().iterator();
        while (iter2.hasNext()) {
            ramlObjectData.append(iter2.next().toXmlString());
        }
        Iterator<RAMLExtension> iter3 = this.getExtensions().iterator();
        while (iter3.hasNext()) {
            ramlObjectData.append(iter3.next().toXmlString());
        }
        ramlObjectData.append("</managedObject>");
        return ramlObjectData.toString();
    }

    @Override
    protected String appendAttributeValue(String key) {
        String moClassPrefix;
        String attributeValue = this.getAttribute(key);
        if ("class".equals(key) && !(moClassPrefix = this.getMOClassPrefix()).isEmpty() && !attributeValue.contains(COLON_STRING)) {
            return XmlUtils.encode(String.valueOf(moClassPrefix) + COLON_STRING + attributeValue);
        }
        return XmlUtils.encode(attributeValue);
    }

    public void validate(RAMLValidationContext validationContext) {
        RAMLMetaManagedObject metaMO = this.getMetaData();
        if (metaMO == null) {
            return;
        }
        validationContext.setValidatedObject(this);
        metaMO.validate(validationContext, this);
        validationContext.setValidatedObject(null);
        ArrayList<String> distnames = new ArrayList<String>();
        List<RAMLManagedObject> childList = this.getChildMOs(1);
        for (RAMLManagedObject child : childList) {
            child.validate(validationContext);
            if (!child.getId().isEmpty() && distnames.contains(child.getDistName())) {
                RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
                result.setParameterName(child.getMetaData().getInstanceParameter().getName());
                result.setDistName(child.getDistName());
                result.setVersion(child.getVersion());
                result.setText(this.myResourceBundle.getString("RAMLValidation.Incomplete.Configuration"));
                result.setDetails(this.myResourceBundle.getString("RAMLValidation.Dubplicate.Distname"));
                result.setSource(child);
                validationContext.getResults().add(result);
                continue;
            }
            distnames.add(child.getDistName());
        }
    }

    @Override
    public int compareTo(RAMLManagedObject o) {
        if (this.getMOClass().equals(o.getMOClass())) {
            try {
                Integer id1 = "".equals(this.getId()) ? Integer.MAX_VALUE : Integer.parseInt(this.getId());
                Integer id2 = "".equals(o.getId()) ? Integer.MAX_VALUE : Integer.parseInt(o.getId());
                return id1.compareTo(id2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getMOClass().compareTo(o.getMOClass());
    }

    public void setParent(RAMLManagedObject parentMO) {
        this.myParent = parentMO;
        if (this.myParent != null) {
            this.myParent.setChild(this);
            this.myParameterCache.clear();
        }
    }

    public void addChildrenMOs(List<RAMLManagedObject> childMOs) {
        for (RAMLManagedObject mo : childMOs) {
            this.addChild(mo);
        }
        this.clearAncestorsCachesHierarchially();
        this.myParameterCache.clear();
    }

    public void removeChildMO(RAMLManagedObject mo) {
        this.myChildManagedObjects.remove(mo);
        this.clearAncestorsCachesHierarchially();
    }

    protected void removeParentReferences() {
        if (this.getParentMO() != null) {
            this.clearAncestorsCachesHierarchially();
            this.getParentMO().removeChildMO(this);
            this.setParent(null);
        }
        this.myParameterCache.clear();
    }

    protected void clearAncestorsCachesHierarchially() {
        if (this.getParentMO() != null) {
            this.getParentMO().clearAncestorsCachesHierarchially();
        }
        this.myChildByClassCache.clear();
    }

    public List<RAMLManagedObject> getMOsByScope(String className, RAMLHelpper.RAMLScope scope) {
        if (RAMLHelpper.RAMLScope.WHOLE_RAML.equals((Object)scope)) {
            return this.getMOByClass(className);
        }
        if (RAMLHelpper.RAMLScope.SINGLE_MO.equals((Object)scope)) {
            if (this.getMetaData().getClassName().equals(className)) {
                ArrayList<RAMLManagedObject> managedObjects = new ArrayList<RAMLManagedObject>(1);
                managedObjects.add(this);
                return managedObjects;
            }
            return this.getChildMOsByClass(className);
        }
        if (RAMLHelpper.RAMLScope.CURRENT_MO.equals((Object)scope)) {
            ArrayList<RAMLManagedObject> managedObjects = new ArrayList<RAMLManagedObject>(1);
            managedObjects.add(this);
            return managedObjects;
        }
        return new ArrayList<RAMLManagedObject>(0);
    }

    public List<RAMLParameter> getParameters(String className, String listName, String parameterName, RAMLHelpper.RAMLScope scope) {
        List<RAMLParameter> fromCache;
        String key = String.valueOf(className) + "_" + listName + "_" + parameterName + "_" + (Object)((Object)scope);
        if (this.myUseOptimization && (fromCache = this.myParameterCache.get(key)) != null) {
            return fromCache;
        }
        ArrayList<RAMLParameter> result = new ArrayList<RAMLParameter>();
        try {
            List<RAMLManagedObject> managedObjects = this.getMOsByScope(className, scope);
            for (RAMLManagedObject managedObject : managedObjects) {
                if (listName != null && !"".equals(listName.trim())) {
                    RAMLList<?> list = managedObject.getList(listName);
                    if (list == null) continue;
                    if (list instanceof RAMLParameterList) {
                        List<RAMLParameter> parameters = ((RAMLParameterList)list).getParameters();
                        for (RAMLParameter rAMLParameter : parameters) {
                            if (!rAMLParameter.getName().equals(parameterName)) continue;
                            result.add(rAMLParameter);
                        }
                        continue;
                    }
                    if (!(list instanceof RAMLItemList)) continue;
                    List<?> list2 = list.getListObjects();
                    for (RAMLItem item : list2) {
                        RAMLParameter parameter = item.getParameter(parameterName);
                        if (parameter == null) continue;
                        result.add(parameter);
                    }
                    continue;
                }
                RAMLParameter parameter = managedObject.getParameter(parameterName);
                if (parameter != null) {
                    result.add(parameter);
                    continue;
                }
                if (managedObject.getMetaData().getInstanceParameter().getName().equals(parameterName)) {
                    RAMLParameter instanceParam = new RAMLParameter(parameterName, managedObject.getId(), (Object)managedObject);
                    instanceParam.setRAMLManagedObject(managedObject);
                    result.add(instanceParam);
                    continue;
                }
                List<RAMLList<?>> lists = managedObject.getLists();
                for (RAMLList rAMLList : lists) {
                    if (rAMLList instanceof RAMLItemList) {
                        List items = rAMLList.getListObjects();
                        for (RAMLItem item : items) {
                            List<RAMLParameter> parametersInItem = item.getParameters();
                            for (RAMLParameter parameterInItem : parametersInItem) {
                                if (!parameterInItem.getName().equals(parameterName)) continue;
                                result.add(parameterInItem);
                            }
                        }
                        continue;
                    }
                    if (!(rAMLList instanceof RAMLParameterList) || !rAMLList.getName().equals(parameterName)) continue;
                    RAMLParameterList parameterList = (RAMLParameterList)rAMLList;
                    List<RAMLParameter> pList = parameterList.getParameters();
                    for (RAMLParameter parameterInList : pList) {
                        result.add(parameterInList);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error("An exception occurred", e);
        }
        if (this.myUseOptimization) {
            this.myParameterCache.put(key, result);
        }
        return result;
    }

    public void removeFromParameterCache(String listName, String parameterName) {
        String moClass = this.getMOClass();
        RAMLHelpper.RAMLScope[] rAMLScopeArray = RAMLHelpper.RAMLScope.values();
        int n = rAMLScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RAMLHelpper.RAMLScope scope = rAMLScopeArray[n2];
            String key = String.valueOf(moClass) + "_" + listName + "_" + parameterName + "_" + (Object)((Object)scope);
            this.myParameterCache.remove(key);
            ++n2;
        }
    }

    public Map<String, RAMLList<?>> getItemListsMap() {
        return this.myItemLists;
    }

    public Map<String, RAMLParameter> getParametersMap() {
        return this.myParameters;
    }
}

