/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import com.nokia.em.poseidon.util.xml.XmlUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RAMLObject
implements Serializable {
    private static final long serialVersionUID = 1821830406426679924L;
    private Map<String, String> myAttributes = new HashMap<String, String>();
    private ArrayList<String> myAttributeKeys = new ArrayList();
    private Map<String, Object> myProperties = new HashMap<String, Object>();

    protected RAMLObject() {
    }

    public String getAttribute(String name) {
        return this.myAttributes.get(name);
    }

    public void setAttribute(String name, String value) {
        if (name != null && !"".equals(name)) {
            if (!this.myAttributes.containsKey(name)) {
                this.myAttributeKeys.add(name);
            }
            this.myAttributes.put(name, value);
        }
    }

    public void destroy() {
        this.myAttributes.clear();
        this.myAttributes = null;
        this.myAttributeKeys.clear();
        this.myAttributeKeys = null;
    }

    protected void clear() {
        this.myAttributes.clear();
        this.myAttributeKeys.clear();
    }

    public List<String> getAttributeKeys() {
        return (ArrayList)this.myAttributeKeys.clone();
    }

    public void removeAttribute(String name) {
        this.myAttributes.remove(name);
        this.myAttributeKeys.remove(name);
    }

    public void setProperty(String key, Object value) {
        this.myProperties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.myProperties.get(key);
    }

    protected int getHierarchyDepth(String distName) {
        int depth = 0;
        int dividerIndex = 0;
        if (distName.contains("/")) {
            ++depth;
            dividerIndex = distName.indexOf("/");
            return depth += this.getHierarchyDepth(distName.substring(dividerIndex + 1));
        }
        return depth;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String key : this.getAttributeKeys()) {
            builder.append("  Attribute: " + key + " Value: " + this.getAttribute(key) + "\n");
        }
        return builder.toString();
    }

    public String toXmlString() {
        StringBuilder ramlObjectData = new StringBuilder();
        for (String key : this.getAttributeKeys()) {
            ramlObjectData.append(" " + XmlUtils.encode(key) + "=\"" + this.appendAttributeValue(key) + "\"");
        }
        return ramlObjectData.toString();
    }

    protected String appendAttributeValue(String key) {
        return XmlUtils.encode(this.getAttribute(key));
    }
}

