/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLItemList;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaManagedObject;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.em.poseidon.util.xml.XmlUtils;
import java.io.Serializable;
import java.util.List;

public class RAMLParameter
implements Comparable<RAMLParameter>,
Serializable {
    private static final long serialVersionUID = 6584818435506140293L;
    private RAMLManagedObject myOwnerMO;
    private Object myParent;
    private String myName;
    private String myValue;
    private RAMLManagedObject myValueRef;
    private String myValueAsInt;
    private RAMLMetaParameter myMetaParameter;

    public RAMLParameter(String name, String value, Object parent) {
        this(name, value);
        this.setParent(parent);
    }

    public RAMLParameter(String name, int value, Object parent) {
        this(name, value);
        this.setParent(parent);
    }

    public RAMLParameter(String name, RAMLManagedObject valueRef, Object parent) {
        this(name, valueRef);
        this.setParent(parent);
    }

    public RAMLParameter(String name, String value) {
        this(value);
        this.setName(name);
    }

    public RAMLParameter(String name, int value) {
        this(value);
        this.setName(name);
    }

    public RAMLParameter(String name, RAMLManagedObject valueRef) {
        this(valueRef);
        this.setName(name);
    }

    public RAMLParameter(String value) {
        this.setValue(value);
    }

    public RAMLParameter(int value) {
        this.setValue(value);
    }

    public RAMLParameter(RAMLManagedObject valueRef) {
        this.setValue(valueRef);
    }

    public String getName() {
        return this.myName;
    }

    public String getValue() {
        return this.myValueRef == null ? this.myValue : this.myValueRef.getDistName();
    }

    public int getValueAsInt() throws NumberFormatException {
        return new Double(this.myValue).intValue();
    }

    public long getValueAsLong() throws NumberFormatException {
        return new Double(this.myValue).longValue();
    }

    public String getIntegerValueAsString() throws NumberFormatException {
        if (this.myValueAsInt == null) {
            this.myValueAsInt = this.calculateIntegerValueAsString();
        }
        return this.myValueAsInt;
    }

    private String calculateIntegerValueAsString() throws NumberFormatException {
        return String.valueOf(this.getValueAsLong());
    }

    public boolean isNumeric() {
        return TextUtils.isNumeric(this.myValue);
    }

    public boolean isInteger() {
        return TextUtils.isInteger(this.myValue);
    }

    public boolean isRefValue() {
        return this.myValueRef != null;
    }

    public void setRAMLManagedObject(RAMLManagedObject mo) {
        this.myOwnerMO = mo;
    }

    public RAMLMetaParameter getMetaData() {
        if (this.myMetaParameter == null) {
            this.myMetaParameter = this.findMetaData();
        }
        return this.myMetaParameter;
    }

    private RAMLMetaParameter findMetaData() {
        if (this.myOwnerMO == null) {
            return null;
        }
        RAMLMetaManagedObject metaMO = this.myOwnerMO.getMetaData();
        if (metaMO == null) {
            return null;
        }
        if (metaMO.getMetaParameter(this.myName) != null) {
            return metaMO.getMetaParameter(this.myName);
        }
        for (RAMLList<?> list : this.myOwnerMO.getLists()) {
            RAMLMetaParameter metadataFromList;
            if (!(list instanceof RAMLItemList) || !this.isParentList((RAMLItemList)list) || (metadataFromList = metaMO.getMetaParameterFromList(((RAMLItemList)list).getName(), this.myName)) == null) continue;
            return metadataFromList;
        }
        return null;
    }

    public RAMLManagedObject getManagedObject() {
        return this.myOwnerMO;
    }

    public Object getParent() {
        return this.myParent;
    }

    public void setParent(Object parent) {
        this.myParent = parent;
    }

    public void setName(String name) {
        if (name != null && name.length() > 0) {
            this.myName = name;
        }
    }

    public void setValue(String value) {
        this.myValue = value == null ? "" : value;
        this.myValueAsInt = null;
        if (this.myOwnerMO != null) {
            this.removeFromMOCache();
        }
    }

    public void setValue(int value) {
        this.myValue = String.valueOf(value);
        this.myValueAsInt = null;
        if (this.myOwnerMO != null) {
            this.removeFromMOCache();
        }
    }

    public void setValue(RAMLManagedObject valueRef) {
        this.myValue = null;
        this.myValueAsInt = null;
        this.myValueRef = valueRef;
        if (this.myOwnerMO != null) {
            this.removeFromMOCache();
        }
    }

    private void removeFromMOCache() {
        String listName = null;
        if (this.myParent instanceof RAMLItem) {
            RAMLItemList parent = ((RAMLItem)this.myParent).getParentList();
            listName = parent != null ? parent.getName() : null;
        } else if (this.myParent instanceof RAMLParameterList) {
            listName = ((RAMLParameterList)this.myParent).getName();
        }
        this.myOwnerMO.removeFromParameterCache(listName, this.getName());
    }

    public String toString() {
        return "Name: " + this.myName + " Value: " + this.myValue;
    }

    public String toXmlString() {
        StringBuilder ramlObjectData = new StringBuilder();
        ramlObjectData.append("<p name=\"");
        ramlObjectData.append(XmlUtils.encode(this.getName()));
        ramlObjectData.append("\">");
        ramlObjectData.append(XmlUtils.encode(this.getValue()));
        ramlObjectData.append("</p>");
        return ramlObjectData.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RAMLParameter other = (RAMLParameter)obj;
        if (this.myName == null ? other.myName != null : !this.myName.equals(other.myName)) {
            return false;
        }
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }

    @Override
    public int compareTo(RAMLParameter o) {
        return this.getName().compareTo(o.getName());
    }

    private boolean isParentList(RAMLItemList list) {
        if (this.myParent instanceof RAMLItem) {
            List<RAMLItem> items = list.getItems();
            for (RAMLItem item : items) {
                for (RAMLParameter p : item.getParameters()) {
                    if (p != this) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

