/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import com.nokia.em.poseidon.frameworks.raml.RAMLCMData;
import com.nokia.em.poseidon.frameworks.raml.RAMLExtension;
import com.nokia.em.poseidon.frameworks.raml.RAMLFile;
import com.nokia.em.poseidon.frameworks.raml.RAMLHeader;
import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLItemList;
import com.nokia.em.poseidon.frameworks.raml.RAMLLogEntry;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.frameworks.raml.RAMLPrevalidationDeltaWatcher;
import com.nokia.em.poseidon.frameworks.raml.RAMLSaxParserLock;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class RAMLSaxHandler
implements ContentHandler,
Serializable {
    private static final long serialVersionUID = -6722343360633787551L;
    private RAMLManagedObject myCurrentMoObject;
    private RAMLHeader myCurrentHeader;
    private RAMLExtension myExtension;
    private String myCurrentListName;
    private String myCurrentParameterName;
    private RAMLParameterList myParameterList;
    private RAMLItemList myItemList;
    private RAMLItem myItem;
    private boolean mySiteFound = false;
    private boolean myParsingPlanInParts = false;
    private RAMLSaxParserLock myParserLock;
    private Set<String> mySitesToBeParsed = new TreeSet<String>();
    private String mySiteClass;
    private RAMLCMData myCMData;
    private RAMLFile myRAMLFile;
    private boolean myPlanInOptimisedOrder = false;
    private StringBuilder myTempCharacterString = new StringBuilder();
    private String myCurrentSite;
    private Map<String, Integer> myNumMOsSkipped = new HashMap<String, Integer>();
    RAMLLogEntry myLogEntry;
    private RAMLPrevalidationDeltaWatcher myChangeFinder;
    private transient Logger myLogger = Logger.getLogger(this.getClass());

    public RAMLSaxHandler(RAMLFile ramlFile) {
        this.myRAMLFile = ramlFile;
    }

    public RAMLSaxHandler(boolean planOptimized, String siteClass, SortedSet<String> sitesToBeParsed, RAMLCMData cmData, RAMLPrevalidationDeltaWatcher changeFinder) {
        this(planOptimized, siteClass, cmData, null, changeFinder);
        this.mySitesToBeParsed = sitesToBeParsed;
    }

    public RAMLSaxHandler(boolean planOptimized, String siteClass, RAMLCMData cmData, RAMLSaxParserLock parserLock, RAMLPrevalidationDeltaWatcher changeFinder) {
        this.myPlanInOptimisedOrder = planOptimized;
        this.mySiteClass = siteClass;
        if (parserLock != null) {
            this.mySitesToBeParsed = parserLock.getSitesToBeParsed();
        }
        this.myCMData = cmData;
        this.myParsingPlanInParts = true;
        this.myParserLock = parserLock;
        this.myChangeFinder = changeFinder;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
        this.myTempCharacterString.delete(0, this.myTempCharacterString.length());
        if (localName.equals("managedObject")) {
            String distName = atts.getValue("distName");
            String siteId = this.getSiteId(distName);
            if (this.myParsingPlanInParts && this.mySiteFound && !this.mySitesToBeParsed.contains(siteId) && this.myPlanInOptimisedOrder) {
                if (this.myParserLock != null) {
                    this.myLogger.debug("myParserLock.notifyParsingReady()");
                    this.myParserLock.notifyParsingReady();
                    this.myLogger.debug("myParserLock.setParserThreadToWait()");
                    this.myParserLock.setParserThreadToWait();
                    this.myLogger.debug("myParserLock.setParserThreadToWait() ---- RELEASED");
                    this.myCMData.clear();
                    this.mySitesToBeParsed = this.myParserLock.getSitesToBeParsed();
                    this.mySiteFound = false;
                } else {
                    throw new SAXException("Given sites are now parsed. Stop parsing in optimised case.");
                }
            }
            if (!this.myParsingPlanInParts || distName != null && this.mySitesToBeParsed.contains(siteId)) {
                this.mySiteFound = true;
                this.refreshMyCurrentSiteId(siteId);
                if (!this.myParsingPlanInParts || this.myParserLock != null || distName != null && this.mySitesToBeParsed.contains(this.getSiteId(distName))) {
                    String moClass = atts.getValue("class");
                    if (!(moClass == null || this.myChangeFinder != null && this.myChangeFinder.isSkipManagedObject(this.myCurrentSite, moClass))) {
                        this.myCurrentMoObject = new RAMLManagedObject(moClass, distName, atts.getValue("operation"), atts.getValue("version"), this.myCMData);
                    } else {
                        this.debugSkipMO(distName);
                    }
                }
            }
        } else if (localName.equals("header")) {
            this.myCurrentHeader = new RAMLHeader();
            this.myCMData.setHeader(this.myCurrentHeader);
        } else if (localName.equals("cmData")) {
            if (this.myCMData == null) {
                this.myCMData = new RAMLCMData();
            }
            if (this.myRAMLFile != null) {
                this.myRAMLFile.addCMData(this.myCMData);
            }
            if (atts.getValue("id") != null) {
                this.myCMData.setAttribute("id", atts.getValue("id"));
            }
            if (atts.getValue("name") != null) {
                this.myCMData.setAttribute("name", atts.getValue("name"));
            }
            if (atts.getValue("type") != null) {
                this.myCMData.setAttribute("type", atts.getValue("type"));
            }
        }
        if (this.myCurrentMoObject != null) {
            String name = atts.getValue("name");
            if (localName.equals("list")) {
                if (name != null) {
                    this.myCurrentListName = name;
                }
            } else if (localName.equals("item")) {
                if (this.myCurrentListName != null) {
                    RAMLItemList itemList = new RAMLItemList();
                    itemList.setName(this.myCurrentListName);
                    if (this.myExtension != null) {
                        this.myExtension.addList(itemList);
                    } else {
                        this.myCurrentMoObject.addList(itemList);
                    }
                    this.myItemList = itemList;
                    this.myCurrentListName = null;
                }
                this.myItem = new RAMLItem();
                this.myItemList.add(this.myItem);
            } else if (localName.equals("p")) {
                if (this.myCurrentListName != null) {
                    RAMLParameterList paraList = new RAMLParameterList();
                    paraList.setName(this.myCurrentListName);
                    if (this.myExtension != null) {
                        this.myExtension.addList(paraList);
                    } else {
                        this.myCurrentMoObject.addList(paraList);
                    }
                    this.myParameterList = paraList;
                    this.myCurrentListName = null;
                }
                this.myCurrentParameterName = name != null ? name : "SCALARLIST_PARAMETER";
            } else if (localName.equals("extension")) {
                this.myExtension = new RAMLExtension();
                this.myExtension.setName(name);
                this.myCurrentMoObject.addExtension(this.myExtension);
            }
        } else if (this.myCurrentHeader != null && localName.equals("log")) {
            this.myCurrentHeader.addLog(this.createLogEntry(atts));
        }
    }

    private void refreshMyCurrentSiteId(String siteId) {
        if (!siteId.equals(this.myCurrentSite)) {
            this.myCurrentSite = siteId;
        }
    }

    private void debugSkipMO(String distName) {
        Integer numSkip = this.myNumMOsSkipped.get(this.myCurrentSite);
        this.myNumMOsSkipped.put(this.myCurrentSite, numSkip == null ? 1 : numSkip + 1);
        this.myLogger.trace("Skipped " + distName);
    }

    private RAMLLogEntry createLogEntry(Attributes atts) {
        this.myLogEntry = new RAMLLogEntry();
        this.myLogEntry.setDateTime(atts.getValue("dateTime"));
        this.myLogEntry.setAction(atts.getValue("action"));
        this.myLogEntry.setUser(atts.getValue("user"));
        this.myLogEntry.setAppInfo(atts.getValue("appInfo"));
        this.myLogEntry.setAppVersion(atts.getValue("appVersion"));
        this.myLogEntry.setAdaptationVersionMinor(atts.getValue("adaptationVersionMinor"));
        return this.myLogEntry;
    }

    private String getSiteId(String distName) {
        if (this.mySiteClass == null || !distName.contains(this.mySiteClass)) {
            return distName;
        }
        int indexForSiteEndDistName = distName.indexOf(47, distName.indexOf(this.mySiteClass));
        String siteId = indexForSiteEndDistName != -1 ? distName.substring(0, indexForSiteEndDistName) : distName;
        return siteId;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (this.myCurrentParameterName != null) {
            if (this.myItem != null) {
                RAMLParameter itemParameter = new RAMLParameter(this.myCurrentParameterName, this.myTempCharacterString.toString());
                itemParameter.setRAMLManagedObject(this.myCurrentMoObject);
                this.myItem.addParameter(itemParameter);
            } else if (this.myParameterList != null) {
                RAMLParameter ramlParameter = new RAMLParameter(this.myTempCharacterString.toString());
                ramlParameter.setRAMLManagedObject(this.myCurrentMoObject);
                ramlParameter.setParent(this.myParameterList);
                this.myParameterList.add(ramlParameter);
            } else if (this.myExtension != null) {
                this.myExtension.setParameter(new RAMLParameter(this.myCurrentParameterName, this.myTempCharacterString.toString()));
            } else if (this.myCurrentMoObject != null) {
                this.myCurrentMoObject.setParameter(new RAMLParameter(this.myCurrentParameterName, this.myTempCharacterString.toString()));
            }
        }
        if (localName.equals("p")) {
            if (this.isProcessingMoParameter() && this.myCurrentMoObject != null && this.myCurrentMoObject.getParameter(this.myCurrentParameterName) == null) {
                this.myCurrentMoObject.setParameter(new RAMLParameter(this.myCurrentParameterName, null));
            }
            this.myCurrentParameterName = null;
        } else if (localName.equals("item")) {
            this.myItem = null;
        } else if (localName.equals("list")) {
            if (this.myCurrentListName != null && this.myCurrentMoObject != null && this.myItemList == null && this.myParameterList == null) {
                this.createEmptyItemList(this.myCurrentListName, this.myCurrentMoObject);
            }
            this.myParameterList = null;
            this.myItemList = null;
            this.myCurrentListName = null;
        } else if (localName.equals("managedObject")) {
            this.myCurrentMoObject = null;
        } else if (localName.equals("extension")) {
            this.myExtension = null;
        } else if (localName.equals("header")) {
            this.myCurrentHeader = null;
        } else if (localName.equals("cmData")) {
            this.myCMData = null;
        } else if (localName.equals("log")) {
            this.myLogEntry.setContent(this.myTempCharacterString.toString());
        }
    }

    @Override
    public void characters(char[] t, int s, int l) {
        this.myTempCharacterString.append(t, s, l);
    }

    private boolean isProcessingMoParameter() {
        return this.myItemList == null && this.myParameterList == null && this.myExtension == null;
    }

    private void createEmptyItemList(String listName, RAMLManagedObject managedObject) {
        RAMLItemList emptyList = new RAMLItemList();
        emptyList.setName(listName);
        managedObject.addList(emptyList);
    }

    @Override
    public void setDocumentLocator(Locator l) {
    }

    @Override
    public void startPrefixMapping(String p, String u) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String p) throws SAXException {
    }

    @Override
    public void skippedEntity(String n) throws SAXException {
    }

    @Override
    public void processingInstruction(String t, String d) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] t, int s, int l) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.myChangeFinder == null) {
            this.myLogger.debug("RAMLPrevalidationDeltaWatcher is not enabled");
        } else {
            this.myLogger.debug("RAMLPrevalidationDeltaWatcher is enabled. Implementing class is " + this.myChangeFinder.getClass().getName());
        }
    }

    @Override
    public void endDocument() throws SAXException {
        Set<String> sites = this.myNumMOsSkipped.keySet();
        this.myLogger.error("Number of sites with skipped MOs: " + sites.size());
        for (String siteId : sites) {
            this.myLogger.error("Number of skipped MOs for " + siteId + ": " + this.myNumMOsSkipped.get(siteId));
        }
    }
}

