/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class RAMLSaxHelperToFindSites
implements Serializable {
    private static final long serialVersionUID = 4163764540206446610L;
    private static final String XML_START_ELEMENT = "<?xml version='1.0' encoding='UTF-8'?>";
    private static final String RAML_21_DTD = "raml21.dtd";
    private List<String> mySiteClasses = new ArrayList<String>();
    private Set<String> myDistNameValues = new TreeSet<String>();
    private Set<String> myDuplicatedDistNameValues = new TreeSet<String>();
    private String mySiteRootClass = null;
    private List<String> mySiteRootObjectsInList = new ArrayList<String>();
    private boolean mySiteOrderInPlanIsOptimised = true;
    private String myCurrentSiteUnderParsing = null;
    private int myCmDataCount = 0;
    private boolean myIsRamlFile = false;

    public boolean isMySiteOrderInPlanIsOptimised() {
        return this.mySiteOrderInPlanIsOptimised;
    }

    public List<String> getMySiteRootObjectsInList() {
        return this.mySiteRootObjectsInList;
    }

    public int getCmDataCount() {
        return this.myCmDataCount;
    }

    public boolean isRamlFile() {
        return this.myIsRamlFile;
    }

    public Set<String> getDuplicatedDistNameValues() {
        return this.myDuplicatedDistNameValues;
    }

    public Set<String> getMyDistNameValues() {
        return this.myDistNameValues;
    }

    public void clearMyDistNameValues() {
        this.myDistNameValues.clear();
    }

    public void setSiteClass(String siteClass) {
        this.mySiteClasses.add(siteClass);
    }

    public void parse(InputStream is, String siteClass) {
        XMLReader parser;
        this.mySiteRootClass = siteClass;
        this.mySiteRootObjectsInList.clear();
        this.mySiteOrderInPlanIsOptimised = true;
        this.myCurrentSiteUnderParsing = null;
        this.myDistNameValues.clear();
        this.myDuplicatedDistNameValues.clear();
        this.myCmDataCount = 0;
        try {
            parser = XMLReaderFactory.createXMLReader();
            parser.setEntityResolver(this.getEntityResolver());
        }
        catch (SAXException e) {
            return;
        }
        parser.setContentHandler(new ManagedObjectHandler());
        try {
            try {
                parser.parse(new InputSource(is));
            }
            catch (Exception exception) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected EntityResolver getEntityResolver() {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                if (systemId.indexOf(RAMLSaxHelperToFindSites.RAML_21_DTD) > -1) {
                    return new InputSource(new ByteArrayInputStream(RAMLSaxHelperToFindSites.XML_START_ELEMENT.getBytes()));
                }
                return null;
            }
        };
    }

    private class ManagedObjectHandler
    implements ContentHandler {
        private ManagedObjectHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
            if (localName.equals("raml")) {
                RAMLSaxHelperToFindSites.this.myIsRamlFile = true;
            }
            if (localName.equals("cmData")) {
                RAMLSaxHelperToFindSites rAMLSaxHelperToFindSites = RAMLSaxHelperToFindSites.this;
                rAMLSaxHelperToFindSites.myCmDataCount = rAMLSaxHelperToFindSites.myCmDataCount + 1;
                if (RAMLSaxHelperToFindSites.this.myCmDataCount > 1) {
                    throw new SAXException("Plan contains multiple cmData elements. Only single cmData is supported.");
                }
            }
            if (localName.equals("managedObject")) {
                String distNameAttribute = atts.getValue("distName");
                if (distNameAttribute != null) {
                    if (RAMLSaxHelperToFindSites.this.myDistNameValues.contains(distNameAttribute)) {
                        RAMLSaxHelperToFindSites.this.myDuplicatedDistNameValues.add(distNameAttribute);
                    }
                    RAMLSaxHelperToFindSites.this.myDistNameValues.add(distNameAttribute);
                }
                this.checkDistName(distNameAttribute);
            }
        }

        private void checkDistName(String distNameAttribute) {
            String siteId;
            boolean found = false;
            for (String siteClass : RAMLSaxHelperToFindSites.this.mySiteClasses) {
                if (!distNameAttribute.contains(siteClass)) continue;
                siteId = this.parseSiteIdFromDistnameAttribute(distNameAttribute, siteClass);
                this.checkSiteOrderInPlan(siteId);
                this.updateSiteList(siteId);
                found = true;
                break;
            }
            if (!found && RAMLSaxHelperToFindSites.this.mySiteRootClass != null && RAMLSaxHelperToFindSites.this.mySiteRootClass.length() != 0 && distNameAttribute.contains(RAMLSaxHelperToFindSites.this.mySiteRootClass)) {
                siteId = this.parseSiteIdFromDistnameAttribute(distNameAttribute, RAMLSaxHelperToFindSites.this.mySiteRootClass);
                this.checkSiteOrderInPlan(siteId);
                this.updateSiteList(siteId);
            }
        }

        private void updateSiteList(String siteId) {
            if (!this.siteListContains(siteId)) {
                RAMLSaxHelperToFindSites.this.mySiteRootObjectsInList.add(this.cutDistNameToFirstRoot(siteId));
            }
        }

        private String cutDistNameToFirstRoot(String siteId) {
            String tempSiteName = siteId;
            for (String siteClass : RAMLSaxHelperToFindSites.this.mySiteClasses) {
                if (!siteId.contains(siteClass)) continue;
                int endIndex = siteId.indexOf("/", siteId.indexOf(siteClass));
                tempSiteName = siteId.substring(0, endIndex != -1 ? endIndex : siteId.length());
            }
            return tempSiteName;
        }

        private boolean siteListContains(String siteId) {
            String compareableSiteId = String.valueOf(siteId) + "/";
            String compareableExistingId = "";
            for (String existingSiteId : RAMLSaxHelperToFindSites.this.mySiteRootObjectsInList) {
                compareableExistingId = String.valueOf(existingSiteId) + "/";
                if (!compareableExistingId.startsWith(compareableSiteId) && !compareableSiteId.startsWith(compareableExistingId)) continue;
                return true;
            }
            return false;
        }

        private String parseSiteIdFromDistnameAttribute(String distNameAttribute, String siteClass) {
            String distName = distNameAttribute;
            int indexForSiteEndDistName = distName.indexOf(47, distName.indexOf(siteClass));
            String siteId = indexForSiteEndDistName != -1 ? distName.substring(0, indexForSiteEndDistName) : distName;
            return siteId;
        }

        private void checkSiteOrderInPlan(String siteId) {
            if (RAMLSaxHelperToFindSites.this.myCurrentSiteUnderParsing == null) {
                RAMLSaxHelperToFindSites.this.myCurrentSiteUnderParsing = siteId;
            }
            if (!RAMLSaxHelperToFindSites.this.myCurrentSiteUnderParsing.startsWith(siteId) && !siteId.startsWith(RAMLSaxHelperToFindSites.this.myCurrentSiteUnderParsing) && this.siteListContains(siteId)) {
                RAMLSaxHelperToFindSites.this.mySiteOrderInPlanIsOptimised = false;
            }
            RAMLSaxHelperToFindSites.this.myCurrentSiteUnderParsing = siteId;
        }

        @Override
        public void setDocumentLocator(Locator l) {
        }

        @Override
        public void startPrefixMapping(String p, String u) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String p) throws SAXException {
        }

        @Override
        public void skippedEntity(String n) throws SAXException {
        }

        @Override
        public void processingInstruction(String t, String d) throws SAXException {
        }

        @Override
        public void characters(char[] t, int s, int l) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] t, int s, int l) throws SAXException {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }
    }
}

