/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLItemList;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class RAMLValidationContext
implements Serializable {
    private static final long serialVersionUID = 681435775950060028L;
    private final String myValidationSource;
    private final List<RAMLValidationResult> myResults;
    private Object myCurrentObject;
    private int myIndex = -1;
    private boolean relationshipIdEnabled = false;

    public RAMLValidationContext(String source) {
        this.myValidationSource = source;
        this.myResults = new ArrayList<RAMLValidationResult>();
    }

    public RAMLValidationContext(String source, String xmlSource) {
        this.myValidationSource = source;
        this.myResults = new ArrayList<RAMLValidationResult>();
        this.readResultsFromString(xmlSource);
    }

    public void clearResults() {
        this.myResults.clear();
    }

    public void setValidatedObject(Object validatedObject) {
        if (this.myCurrentObject instanceof RAMLItem && validatedObject != null && !(validatedObject instanceof RAMLItem)) {
            return;
        }
        this.myCurrentObject = validatedObject;
    }

    public void setValidatedObjectIndex(int idx) {
        this.myIndex = idx;
    }

    public void addResult(RAMLValidationResult result) {
        if (this.myCurrentObject instanceof RAMLItemList) {
            result.setSource(((RAMLItemList)this.myCurrentObject).getManagedObject());
        } else {
            result.setSource(this.myCurrentObject);
            result.setSourceIndex(this.myIndex);
        }
        this.myResults.add(result);
    }

    public String getValidationSource() {
        return this.myValidationSource;
    }

    public List<RAMLValidationResult> getResults() {
        return this.myResults;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getValidationSource());
        builder.append(" validation results:");
        builder.append(System.getProperty("line.separator"));
        if (this.getResults().size() == 0) {
            builder.append("...everything ok!");
        } else {
            for (RAMLValidationResult res : this.getResults()) {
                builder.append(res.toString());
                builder.append(System.getProperty("line.separator"));
            }
        }
        return builder.toString();
    }

    public void writeToStream(StreamResult result) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document domDocument = docBuilder.newDocument();
        this.addResultsToDOM(domDocument);
        TransformerFactory transFact = TransformerFactory.newInstance();
        Transformer transformer = transFact.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.transform(new DOMSource(domDocument), result);
    }

    public void writeToFile(File file) throws IOException, Exception {
        FileOutputStream output = new FileOutputStream(file);
        StreamResult stream = new StreamResult(output);
        this.writeToStream(stream);
        output.close();
    }

    private void readResultsFromString(String xmlSource) {
        Document doc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new InputSource(new StringReader(xmlSource)));
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error("Failed to create context from given xml source.", e);
            return;
        }
        Node root = doc.getElementsByTagName("msgml").item(0);
        if (root == null) {
            return;
        }
        NodeList messages = root.getChildNodes();
        int i = 0;
        while (i < messages.getLength()) {
            Node message = messages.item(i);
            if ("message".equals(message.getNodeName())) {
                this.addResult(this.parseResult(message));
            }
            ++i;
        }
    }

    private RAMLValidationResult parseResult(Node message) {
        NodeList messageDetails = message.getChildNodes();
        String version = "";
        String dn = "";
        String text = "";
        String status = "";
        String details = "";
        String relationshipId = "";
        int i = 0;
        while (i < messageDetails.getLength()) {
            Node p = messageDetails.item(i);
            if ("p".equals(p.getNodeName())) {
                Node firstChild;
                Node namedItem = p.getAttributes().getNamedItem("name");
                if ("version".equals(namedItem.getNodeValue())) {
                    firstChild = p.getFirstChild();
                    if (firstChild != null) {
                        version = firstChild.getNodeValue();
                    }
                } else if ("dn".equals(namedItem.getNodeValue())) {
                    firstChild = p.getFirstChild();
                    if (firstChild != null) {
                        dn = firstChild.getNodeValue();
                    }
                } else if ("text".equals(namedItem.getNodeValue())) {
                    firstChild = p.getFirstChild();
                    if (firstChild != null) {
                        text = firstChild.getNodeValue();
                    }
                } else if ("status".equals(namedItem.getNodeValue())) {
                    firstChild = p.getFirstChild();
                    if (firstChild != null) {
                        status = firstChild.getNodeValue();
                    }
                } else if ("details".equals(namedItem.getNodeValue())) {
                    firstChild = p.getFirstChild();
                    if (firstChild != null) {
                        details = firstChild.getNodeValue();
                    }
                } else if ("rId".equals(namedItem.getNodeValue()) && (firstChild = p.getFirstChild()) != null) {
                    relationshipId = firstChild.getNodeValue();
                }
            }
            ++i;
        }
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.valueOf(status.toUpperCase()), details, dn, version, text);
        result.setRelationshipId(relationshipId);
        return result;
    }

    private void addResultsToDOM(Document domDocument) {
        Element typeElement = domDocument.createElement("msgml");
        typeElement.setAttribute("source", this.myValidationSource);
        typeElement.setAttribute("action", "Validate");
        typeElement.setAttribute("dateTime", RAMLValidationContext.getTimeStamp());
        domDocument.appendChild(typeElement);
        int i = 0;
        while (i < this.myResults.size()) {
            String relationshipId;
            RAMLValidationResult result = this.myResults.get(i);
            Element message = domDocument.createElement("message");
            typeElement.appendChild(message);
            if (result.isLast()) {
                Element lastMsgElement = domDocument.createElement("p");
                lastMsgElement.setAttribute("name", "lastFeedback");
                Text lastMsgValue = domDocument.createTextNode("Yes");
                lastMsgElement.appendChild(lastMsgValue);
                message.appendChild(lastMsgElement);
            }
            Element versionElement = domDocument.createElement("p");
            versionElement.setAttribute("name", "version");
            Text versionValue = result.getVersion() == null ? domDocument.createTextNode("") : domDocument.createTextNode(result.getVersion());
            versionElement.appendChild(versionValue);
            message.appendChild(versionElement);
            Element dnElement = domDocument.createElement("p");
            dnElement.setAttribute("name", "dn");
            Text dnValue = domDocument.createTextNode(result.getDistName());
            dnElement.appendChild(dnValue);
            message.appendChild(dnElement);
            Element textElement = domDocument.createElement("p");
            textElement.setAttribute("name", "text");
            Text textValue = domDocument.createTextNode(String.valueOf(result.getText()) + result.getAdditionalText());
            textElement.appendChild(textValue);
            message.appendChild(textElement);
            Element statusElement = domDocument.createElement("p");
            statusElement.setAttribute("name", "status");
            Text statusValue = domDocument.createTextNode(result.getState().toString());
            statusElement.appendChild(statusValue);
            message.appendChild(statusElement);
            if (this.isRelationshipIdEnabled() && (relationshipId = result.getRelationshipId()) != null && !relationshipId.isEmpty()) {
                Element rIdElement = domDocument.createElement("p");
                rIdElement.setAttribute("name", "rId");
                Text rIdValue = domDocument.createTextNode(relationshipId);
                rIdElement.appendChild(rIdValue);
                message.appendChild(rIdElement);
            }
            Element detailsElement = domDocument.createElement("p");
            detailsElement.setAttribute("name", "details");
            Text detailsValue = domDocument.createTextNode(result.getDetails());
            detailsElement.appendChild(detailsValue);
            message.appendChild(detailsElement);
            ++i;
        }
    }

    public static final String getTimeStamp() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(Calendar.getInstance().getTime());
    }

    public boolean isRelationshipIdEnabled() {
        return this.relationshipIdEnabled;
    }

    public void setRelationshipIdEnabled(boolean relationshipIdEnabled) {
        this.relationshipIdEnabled = relationshipIdEnabled;
    }
}

