/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLHelpper;
import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLItemList;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.frameworks.raml.metadata.ConditionBase;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLCondition;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaManagedObject;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLOperation;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLPreCondition;
import com.nokia.em.poseidon.frameworks.raml.metadata.RamlConditionRelatedParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLLogicalValidatorBase;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLRelatedParameterOccursValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLRelatedParameterRangeValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLValue;
import com.nokia.em.poseidon.util.GeneralUtils;
import com.nokia.em.poseidon.util.TextUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public final class RAMLValidationErrorMessageFactory {
    private static Map<String, String> myResourceBundleCache = new HashMap<String, String>();
    private static final String SPACE = " ";
    private static final String COMMA = ",";
    private static final String PERIOD = ".";
    private static ResourceBundle resourceBundle;
    private static String BECAUSE;

    static {
        RAMLValidationErrorMessageFactory.loadResourceBundle();
    }

    private static void addReasonBasedOnUIValue(RamlConditionRelatedParameter ramlConditionRelatedParameter, StringBuilder reason, String value, String valueOperation, RAMLManagedObject myManagedObject) {
        String myUIValue = null;
        if (myManagedObject != null) {
            List<RAMLParameter> params = ramlConditionRelatedParameter.getRelatedParameters();
            int i = 0;
            while (params != null && i < params.size()) {
                RAMLParameter param = params.get(i);
                String myParamName = ramlConditionRelatedParameter.getParamName();
                String myClassName = ramlConditionRelatedParameter.getClassName();
                if (param != null && param.getName() != null && param.getManagedObject() != null && param.getManagedObject().getMOClass() != null && param.getName().equals(myParamName) && param.getManagedObject().getMOClass().equals(myClassName)) {
                    myUIValue = RAMLLogicalValidatorBase.getUIValue(param, value);
                    break;
                }
                ++i;
            }
        } else if (myUIValue == null) {
            myUIValue = value;
        }
        if (valueOperation == null) {
            reason.append(String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Equal.To")) + SPACE + myUIValue);
        } else {
            if (valueOperation.toUpperCase().contains("EQUAL")) {
                reason.append(valueOperation.toLowerCase().replace("_", SPACE));
                reason.append(SPACE + RAMLValidationErrorMessageFactory.getString("RAMLValidation.To") + SPACE);
            } else {
                reason.append(valueOperation.toLowerCase());
                reason.append(SPACE + RAMLValidationErrorMessageFactory.getString("RAMLValidation.Than") + SPACE);
            }
            reason.append(myUIValue);
        }
    }

    private static String getString(String key) {
        String valueString = myResourceBundleCache.get(key);
        if (valueString == null) {
            valueString = resourceBundle.getString(key);
            myResourceBundleCache.put(key, valueString);
        }
        return valueString;
    }

    public static String concatenateReasons(Iterable<String> reasons) {
        return RAMLValidationErrorMessageFactory.getCombinedStringWithDelimiter(reasons, ", ");
    }

    private static StringBuilder constructErrorMessage(String resourceBundleString, Object[] texts) {
        StringBuilder errorMessage = new StringBuilder(MessageFormat.format(RAMLValidationErrorMessageFactory.getString(resourceBundleString), texts));
        return errorMessage;
    }

    public static String createCalculationErrorMessage(RAMLCondition condition, RAMLOperation operation) {
        String details = RAMLValidationErrorMessageFactory.generatedCalculationClauseStart(condition.getMetaParameter(), condition.getParameterToBeValidated(), "EQUAL", condition.getValue());
        details = String.valueOf(details) + SPACE + BECAUSE + SPACE + RAMLValidationErrorMessageFactory.concatenateReasons(operation.getReasons()) + PERIOD;
        return details;
    }

    public static String createCompareValidationErrorMessage(RAMLCondition condition, RamlConditionRelatedParameter relatedP) {
        StringBuilder errorMessage;
        Object[] texts;
        String compType = condition.getValue();
        RAMLParameter p = condition.getParameterToBeValidated();
        RAMLMetaParameter metaP = condition.getMetaParameter();
        RAMLValue valueType = (RAMLValue)metaP.getValueType();
        String relatedPListName = relatedP.getListName();
        String relatedPClassName = relatedP.getClassName();
        String relatedParameterName = relatedP.getParamName();
        String listName = null;
        String relatedPListFullName = null;
        String relatedParameterFullName = null;
        RAMLMetaManagedObject relatedMetaManagedObject = metaP.getMetaManagedObject().getMetaDataFile().getMetaManagedObject(relatedPClassName);
        if (relatedMetaManagedObject != null) {
            RAMLMetaManagedObject metaManagedObject = relatedMetaManagedObject;
            RAMLMetaParameter relatedMetaParameterList = metaManagedObject.getMetaParameter(relatedPListName);
            RAMLMetaParameter relatedMetaParameterFromList = metaManagedObject.getMetaParameterFromList(relatedPListName, relatedParameterName);
            if (relatedPListName != null && relatedMetaParameterList != null && relatedMetaParameterFromList != null) {
                relatedPListFullName = relatedMetaParameterList.getFullName();
                relatedParameterFullName = relatedMetaParameterFromList.getFullName();
            } else {
                RAMLMetaParameter relatedMetaParameterFromMo = metaManagedObject.getMetaParameter(relatedParameterName);
                if (relatedParameterName != null && relatedMetaParameterFromMo != null) {
                    relatedParameterFullName = relatedMetaParameterFromMo.getFullName();
                }
            }
        } else {
            relatedParameterFullName = relatedP.getParamName();
        }
        if (valueType instanceof RAMLSimpleType) {
            listName = ((RAMLSimpleType)valueType).getProperty("listName");
        }
        String compareStr = RAMLValidationErrorMessageFactory.getComparisonString(compType);
        String displayValue = RAMLLogicalValidatorBase.getUIValue(p);
        if (listName == null && relatedPListName == null) {
            texts = new Object[]{p.getName(), metaP.getFullName(), displayValue, compareStr, relatedParameterName, relatedParameterFullName, relatedPClassName};
            errorMessage = RAMLValidationErrorMessageFactory.constructErrorMessage("RAMLValidation.Compare.Details.NotList_NotList", texts);
        } else if (listName != null && relatedPListName == null) {
            texts = new Object[]{p.getName(), metaP.getFullName(), listName, displayValue, compareStr, relatedParameterName, relatedParameterFullName, relatedPClassName};
            errorMessage = RAMLValidationErrorMessageFactory.constructErrorMessage("RAMLValidation.Compare.Details.IsList_NotList", texts);
        } else if (listName == null && relatedPListName != null) {
            texts = new Object[]{p.getName(), metaP.getFullName(), displayValue, compareStr, relatedParameterName, relatedParameterFullName, relatedPListName, relatedPListFullName, relatedPClassName};
            errorMessage = RAMLValidationErrorMessageFactory.constructErrorMessage("RAMLValidation.Compare.Details.NotList_IsList", texts);
        } else {
            texts = new Object[]{p.getName(), metaP.getFullName(), listName, displayValue, compareStr, relatedParameterName, relatedParameterFullName, relatedPListName, relatedPListFullName, relatedPClassName};
            errorMessage = RAMLValidationErrorMessageFactory.constructErrorMessage("RAMLValidation.Compare.Details.IsList_IsList", texts);
        }
        errorMessage.append(RAMLValidationErrorMessageFactory.generateBecauseClause(condition));
        return errorMessage.toString();
    }

    public static String createHWValidationComparisonReason(String operation, String hwProperty, String hwPropertyValue) {
        if (operation == null || hwProperty == null || hwPropertyValue == null) {
            throw new IllegalArgumentException("Argument can't be null");
        }
        String compareStr = RAMLValidationErrorMessageFactory.getComparisonString(operation);
        Object[] details = new Object[]{compareStr, hwProperty, hwPropertyValue};
        return RAMLValidationErrorMessageFactory.constructErrorMessage("RAMLValidation.HW.Property.Restriction", details).toString();
    }

    public static String createOutOfRangeErrorMessage(RAMLParameter param, RAMLMetaParameter metaP, String rangeText, String value) {
        Object parent = param.getParent();
        String errorMessage = "";
        if (parent instanceof RAMLItem) {
            parent = ((RAMLItem)parent).getParentList();
            Object[] values = new Object[]{param.getName(), metaP.getFullName(), value, ((RAMLList)parent).getName(), ((RAMLList)parent).getMetaData().getFullName(), rangeText};
            errorMessage = MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.List.Simple.Value.Out.Of.Range"), values);
        } else if (parent instanceof RAMLParameterList) {
            Object[] values = new Object[]{value, ((RAMLParameterList)parent).getName(), ((RAMLParameterList)parent).getMetaData().getFullName(), rangeText};
            errorMessage = MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.List.Value.Out.Of.Range"), values);
        } else if (parent instanceof RAMLManagedObject) {
            Object[] values = new Object[]{param.getName(), metaP.getFullName(), value, rangeText};
            errorMessage = MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Value.Out.Of.Range"), values);
        }
        return errorMessage;
    }

    public static String createEmptyOrNotEmptyErrorMessage(RAMLCondition ramlCondition) {
        return String.valueOf(RAMLValidationErrorMessageFactory.generateEmptyOrNotEmptyErrorMessageStart(ramlCondition)) + RAMLValidationErrorMessageFactory.generateBecauseClause(ramlCondition);
    }

    public static String createEmptyOrNotEmptyErrorMessage(RAMLCondition ramlCondition, RAMLOperation operation) {
        StringBuilder error = new StringBuilder(RAMLValidationErrorMessageFactory.generateEmptyOrNotEmptyErrorMessageStart(ramlCondition));
        error.append(SPACE);
        error.append(BECAUSE);
        error.append(SPACE);
        error.append(RAMLValidationErrorMessageFactory.concatenateReasons(operation.getReasons()));
        error.append(PERIOD);
        return error.toString();
    }

    public static String createInvalidValueErrorMessage(RAMLCondition ramlCondition, RamlConditionRelatedParameter relatedParameter, String targetValue) {
        RAMLMetaParameter metaParameter = ramlCondition.getMetaParameter();
        StringBuilder details = new StringBuilder();
        details.append(RAMLValidationErrorMessageFactory.generatedCalculationClauseStart(metaParameter, ramlCondition.getParameterToBeValidated(), ramlCondition.getValue(), targetValue));
        String relatedParamText = RAMLValidationErrorMessageFactory.generateRelatedParamText(relatedParameter);
        if (!GeneralUtils.isEmptyString(relatedParamText)) {
            details.append(SPACE);
            details.append(relatedParamText);
        } else if (relatedParameter.isErrorReasonVisible()) {
            details.append(SPACE);
            details.append(BECAUSE);
            details.append(SPACE);
            details.append(relatedParameter.getReason());
        }
        details.append(PERIOD);
        return details.toString();
    }

    public static String createInvalidValueErrorMessage(RAMLMetaParameter metaP, RAMLParameter param) {
        Object[] values;
        String pattern;
        String paramValue = param.getValue();
        Object parent = param.getParent();
        if (parent instanceof RAMLItem) {
            String name = param.getName();
            String fullName = metaP.getFullName();
            RAMLItemList parentList = ((RAMLItem)parent).getParentList();
            RAMLMetaParameter parentMetaParameter = parentList.getMetaData();
            String parentName = parentMetaParameter.getName();
            String parentFullName = parentMetaParameter.getFullName();
            pattern = RAMLValidationErrorMessageFactory.getString("RAMLValidation.Incorrect.List.Parameter.Value");
            values = new Object[]{name, fullName, parentName, parentFullName, paramValue};
        } else {
            String fullName;
            String name;
            if (parent instanceof RAMLParameterList) {
                name = ((RAMLParameterList)parent).getName();
                fullName = ((RAMLParameterList)parent).getMetaData().getFullName();
                pattern = RAMLValidationErrorMessageFactory.getString("RAMLValidation.Incorrect.List.Simple.Parameter.Value");
            } else {
                name = param.getName();
                fullName = metaP.getFullName();
                pattern = RAMLValidationErrorMessageFactory.getString("RAMLValidation.Incorrect.Parameter.Value");
            }
            values = new Object[]{name, fullName, paramValue};
        }
        return MessageFormat.format(pattern, values);
    }

    public static String createMandatoryErrorMessageForRAMLItemList(RAMLItemList itemList, RAMLMetaParameter metaParameter, String reasonClause) {
        boolean hasReason = !GeneralUtils.isEmptyString(reasonClause);
        String details = hasReason ? String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Because")) + SPACE + reasonClause : "";
        String itemListFullName = itemList.getMetaData() != null && itemList.getMetaData().getFullName() != null ? itemList.getMetaData().getFullName() : itemList.getName();
        Object[] values = new Object[]{metaParameter.getName(), metaParameter.getFullName(), itemList.getName(), itemListFullName, details};
        details = hasReason ? MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Missing.Mandatory.List.Parameter.WithReason"), values) : MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Missing.Mandatory.List.Parameter"), values);
        return details;
    }

    public static String createMandatoryErrorMessageForRAMLManagedObject(RAMLManagedObject moToBeValidated, RAMLMetaParameter metaP, RAMLList<?> list, String reasonClause) {
        boolean hasReason = !GeneralUtils.isEmptyString(reasonClause);
        String details = hasReason ? String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Because")) + SPACE + reasonClause : "";
        Object[] values = new Object[]{metaP.getName(), metaP.getFullName(), details};
        details = metaP.isSimpleType() && metaP.getMaxOccurs() == 1 || RAMLValidationErrorMessageFactory.isMandatoryEmptyList(metaP, list) ? (hasReason ? MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Missing.Mandatory.Parameter.WithReason"), values) : MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Missing.Mandatory.Parameter"), values)) : (hasReason ? MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Missing.Mandatory.List.WithReason"), values) : MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Missing.Mandatory.List"), values));
        return details;
    }

    public static String createMultiplicityErrorMessage(RAMLMetaParameter metaP, RAMLParameter p, RamlConditionRelatedParameter relatedParameter, String value) {
        String error;
        Object[] texts;
        RAMLValue valueType = (RAMLValue)metaP.getValueType();
        String list = null;
        if (valueType instanceof RAMLSimpleType) {
            list = ((RAMLSimpleType)valueType).getProperty("listName");
        }
        if (list == null) {
            texts = new Object[]{p.getName(), metaP.getFullName(), value};
            error = MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Multiplicity.Details_SimpleText"), texts);
        } else {
            texts = new Object[]{p.getName(), metaP.getFullName(), list, value};
            error = MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Multiplicity.Details_Text"), texts);
        }
        String relatedParamText = RAMLValidationErrorMessageFactory.generateRelatedParamText(relatedParameter);
        if (GeneralUtils.isEmptyString(relatedParamText)) {
            return String.valueOf(error) + PERIOD;
        }
        return String.valueOf(error) + SPACE + relatedParamText + PERIOD;
    }

    public static String createParameterOccurrenceErrorMessage(RAMLRelatedParameterOccursValidator validator, RAMLMetaParameter metaP, Object object, String errorType) {
        RamlConditionRelatedParameter myParentParameter = validator.getMetaParameter();
        String detailReason = "";
        if (myParentParameter != null && myParentParameter.getParentCondition() != null) {
            detailReason = RAMLValidationErrorMessageFactory.generateBecauseClause(myParentParameter.getParentCondition());
        }
        if (detailReason.isEmpty()) {
            detailReason = PERIOD;
        }
        RAMLValue valueType = (RAMLValue)metaP.getValueType();
        String list = null;
        String name = "";
        int occurrence = 0;
        boolean isList = false;
        if (myParentParameter != null) {
            if (object instanceof RAMLParameter) {
                RAMLParameter ramlParameter = (RAMLParameter)object;
                name = ramlParameter.getName();
                occurrence = myParentParameter.getTargetParameterValues().size();
            } else if (object instanceof RAMLList) {
                RAMLList ramlList = (RAMLList)object;
                name = ramlList.getName();
                occurrence = ramlList.size();
                isList = true;
            }
        }
        if (valueType instanceof RAMLSimpleType) {
            list = ((RAMLSimpleType)valueType).getProperty("listName");
        }
        String str = null;
        str = errorType.equals("exactOccurs") ? String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Equal.To")) + SPACE + validator.getExactOccurs() : (errorType.equals("minOccurs") ? String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Bigger.Than.Or.Equal.To")) + SPACE + validator.getMinOccurs() : String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Smaller.Than.Or.Equal.To")) + SPACE + validator.getMaxOccurs());
        if (list == null) {
            Object[] texts = new Object[]{name, metaP.getFullName(), occurrence, str};
            if (isList) {
                return String.valueOf(MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Occur.Details.For.List_Text"), texts)) + detailReason;
            }
            return String.valueOf(MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Occur.Details_SimpleText"), texts)) + detailReason;
        }
        Object[] texts = new Object[]{name, metaP.getFullName(), list, occurrence, str};
        return String.valueOf(MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Occur.Details_Text"), texts)) + detailReason;
    }

    public static String createRangeErrorMessage(RAMLRelatedParameterRangeValidator validator, RAMLMetaParameter metaP, RAMLParameter p, String disValue, String errorType) {
        String detailedReason = "";
        RamlConditionRelatedParameter myParentParameter = validator.getMetaParameter();
        if (myParentParameter != null && myParentParameter.getParentCondition() != null) {
            detailedReason = RAMLValidationErrorMessageFactory.generateBecauseClause(myParentParameter.getParentCondition());
        }
        String displayValue = RAMLLogicalValidatorBase.getUIValue(p);
        String reason = detailedReason.trim();
        String errorStr = null;
        String validationPattern = null;
        if (errorType.equals("minIncl")) {
            errorStr = String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.MinIncl.Details_Text")) + SPACE + validator.getMinIncl();
        } else if (errorType.equals("maxIncl")) {
            errorStr = String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.MaxIncl.Details_Text")) + SPACE + validator.getMaxIncl();
        } else if (errorType.equals("step")) {
            errorStr = String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Step.Details_Text")) + validator.getStep();
        }
        if (reason.endsWith(PERIOD)) {
            reason = reason.substring(0, reason.length() - 1);
        }
        if (GeneralUtils.isEmptyString(displayValue) && "mandatory".equals(errorType)) {
            Object[] texts;
            if (reason.isEmpty()) {
                validationPattern = RAMLValidationErrorMessageFactory.getString("RAMLValidation.Missing.Mandatory.Parameter");
                texts = new Object[]{p.getName(), metaP.getFullName()};
            } else {
                validationPattern = RAMLValidationErrorMessageFactory.getString("RAMLValidation.Missing.Mandatory.Parameter.WithReason");
                texts = new Object[]{p.getName(), metaP.getFullName(), reason};
            }
            return MessageFormat.format(validationPattern, texts);
        }
        reason = reason.isEmpty() ? PERIOD : SPACE + reason + PERIOD;
        Object parent = p.getParent();
        if (parent instanceof RAMLItem) {
            RAMLItemList parentList = ((RAMLItem)parent).getParentList();
            RAMLMetaParameter metaPList = parentList.getMetaData();
            String listNameCombination = String.valueOf(metaPList.getName()) + " (" + metaPList.getFullName() + ")";
            Object[] texts = new Object[]{p.getName(), metaP.getFullName(), displayValue, listNameCombination, errorStr};
            return String.valueOf(MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Range.Details_Text"), texts)) + reason;
        }
        Object[] texts = new Object[]{p.getName(), metaP.getFullName(), displayValue, errorStr};
        return String.valueOf(MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Range.Details_SimpleText"), texts)) + reason;
    }

    public static String createUniqueValidationErrorMessage(RAMLCondition condition, List<String> parameters, String definedScope) {
        Object[] texts;
        RAMLMetaParameter metaP = condition.getMetaParameter();
        RAMLValue valueType = (RAMLValue)metaP.getValueType();
        String list = null;
        if (valueType instanceof RAMLSimpleType) {
            list = ((RAMLSimpleType)valueType).getProperty("listName");
        }
        String reason = RAMLValidationErrorMessageFactory.generateBecauseClause(condition);
        StringBuilder builder = new StringBuilder();
        for (String parameterName : parameters) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(parameterName);
        }
        String paramsStr = builder.toString();
        if (list == null && parameters.size() > 1) {
            texts = new Object[]{paramsStr, definedScope};
            return String.valueOf(MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Unique.Parameters.Details_SimpleText"), texts)) + reason;
        }
        if (list != null && parameters.size() > 1) {
            texts = new Object[]{paramsStr, list, definedScope};
            return String.valueOf(MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Unique.Parameters.Details_Text"), texts)) + reason;
        }
        if (list == null && parameters.size() == 1) {
            texts = new Object[]{paramsStr, definedScope};
            return String.valueOf(MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Unique.Parameter.Details_SimpleText"), texts)) + reason;
        }
        texts = new Object[]{paramsStr, list, definedScope};
        return String.valueOf(MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Unique.Parameter.Details_Text"), texts)) + reason;
    }

    private static void generateAdditionalReasonBasedOnValue(RamlConditionRelatedParameter ramlConditionRelatedParameter, StringBuilder reason, String value, String valueOperation, String maxIncl, String minIncl) {
        if (value == null) {
            if (maxIncl != null && minIncl != null) {
                reason.append(String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Within.The.Range")) + SPACE + minIncl + SPACE + RAMLValidationErrorMessageFactory.getString("RAMLValidation.To") + SPACE + maxIncl);
            } else if (maxIncl != null) {
                reason.append(String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Smaller.Than")) + SPACE + maxIncl);
            } else if (minIncl != null) {
                reason.append(String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Bigger.Than")) + SPACE + minIncl);
            }
        } else {
            RAMLManagedObject myManagedObject = ramlConditionRelatedParameter.getManagedObject();
            RAMLValidationErrorMessageFactory.addReasonBasedOnUIValue(ramlConditionRelatedParameter, reason, value, valueOperation, myManagedObject);
        }
    }

    public static String generateBecauseClause(RAMLCondition condition) {
        TreeSet<String> reasons = new TreeSet<String>();
        RAMLPreCondition preCondition = condition.getPrecondition();
        if (preCondition != null && preCondition.isPreConditionTrue() && preCondition.getReason().size() > 0) {
            reasons.addAll(preCondition.getReason());
        }
        reasons.addAll(condition.getIfElseReasons());
        for (RamlConditionRelatedParameter relatedParam : condition.getAllRelatedParameters()) {
            if (!relatedParam.isPreCondition() || !relatedParam.isValidationMatched() || !relatedParam.isErrorReasonVisible() || relatedParam.getReason().isEmpty()) continue;
            reasons.add(relatedParam.getReason());
        }
        StringBuilder detailedReason = new StringBuilder();
        if (!reasons.isEmpty()) {
            detailedReason.append(SPACE + BECAUSE + SPACE);
            detailedReason.append(RAMLValidationErrorMessageFactory.getCombinedStringWithDelimiter(reasons, ", "));
        }
        detailedReason.append(PERIOD);
        return detailedReason.toString();
    }

    public static String generatedCalculationClauseStart(RAMLMetaParameter metaP, RAMLParameter p, String compType, String result) {
        String compareType = compType;
        RAMLValue valueType = (RAMLValue)metaP.getValueType();
        String str = null;
        str = compareType.equals("BIGGER") || compareType.equals("SMALLER") ? RAMLValidationErrorMessageFactory.getString("RAMLValidation.Than") : RAMLValidationErrorMessageFactory.getString("RAMLValidation.To");
        String list = null;
        if (valueType instanceof RAMLSimpleType) {
            list = ((RAMLSimpleType)valueType).getProperty("listName");
        }
        if (compareType.equals("BIGGER_OR_EQUAL")) {
            compareType = "BIGGER_THAN_OR_EQUAL";
        } else if (compareType.equals("SMALLER_OR_EQUAL")) {
            compareType = "SMALLER_THAN_OR_EQUAL";
        }
        compareType = compareType.replace("_", SPACE).toLowerCase();
        if (list == null) {
            Object[] texts = new Object[]{p.getName(), metaP.getFullName(), RAMLLogicalValidatorBase.getUIValue(p), compareType, str, RAMLLogicalValidatorBase.getUIValue(p, result)};
            return MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Calculation.Details_SimpleText"), texts);
        }
        Object[] texts = new Object[]{p.getName(), metaP.getFullName(), list, RAMLLogicalValidatorBase.getUIValue(p), compareType, str, RAMLLogicalValidatorBase.getUIValue(p, result)};
        return MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Calculation.Details_Text"), texts);
    }

    private static String generateEmptyOrNotEmptyErrorMessageStart(RAMLCondition ramlCondition) {
        StringBuilder error;
        RAMLValue valueType = (RAMLValue)ramlCondition.getMetaParameter().getValueType();
        String empty = ramlCondition.getValue().toLowerCase().replaceAll("_", SPACE);
        String list = null;
        RAMLParameter p = ramlCondition.getParameterToBeValidated();
        if (valueType instanceof RAMLSimpleType) {
            list = ((RAMLSimpleType)valueType).getProperty("listName");
        }
        RAMLMetaParameter metaP = ramlCondition.getMetaParameter();
        if (list == null) {
            Object[] texts = new Object[]{p.getName(), metaP.getFullName(), empty};
            error = new StringBuilder(MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Empty.Details_SimpleText"), texts));
        } else {
            Object[] texts = new Object[]{p.getName(), metaP.getFullName(), list, empty};
            error = new StringBuilder(MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Empty.Details_Text"), texts));
        }
        return error.toString();
    }

    public static String generateFormsOfCalculationClause(ConditionBase condition, boolean inOperation) {
        String conditionValue = condition.getValue();
        List<RamlConditionRelatedParameter> relatedParameters = condition.getRelatedParameters();
        List<RAMLOperation> myOperations = condition.getOperations();
        StringBuffer formsOfCalculation = new StringBuffer();
        String operationSymbol = RAMLHelpper.getSimpleOperationFormat(conditionValue);
        StringBuffer prefix = new StringBuffer(String.valueOf(condition.getParameterToBeValidated().getName()) + SPACE + operationSymbol + SPACE + "(");
        if (relatedParameters.size() == 1 && myOperations.size() > 0) {
            formsOfCalculation.append(relatedParameters.get(0).getFormsOfCalculation());
            for (RAMLOperation operation : myOperations) {
                String operationValue = RAMLHelpper.getSimpleOperationFormat(operation.getOperationValue());
                formsOfCalculation.append(SPACE).append(operationValue).append(SPACE).append(operation.getFormsOfOperation());
            }
        } else if (myOperations.size() == 0 && relatedParameters.size() > 0) {
            if (relatedParameters.get(0).getValueOperation() != null) {
                formsOfCalculation.append(relatedParameters.get(0).getFormsOfCalculation());
            }
            int i = 1;
            while (i < relatedParameters.size()) {
                if (relatedParameters.get(0).getValueOperation() != null) {
                    formsOfCalculation.append(SPACE).append(relatedParameters.get(i).getFormsOfCalculation());
                }
                ++i;
            }
        } else if (myOperations.size() == 1 && relatedParameters.size() == 0) {
            List<RamlConditionRelatedParameter> parameters = myOperations.get(0).getAllRelatedParameters();
            formsOfCalculation.append(String.valueOf(RAMLHelpper.getSimpleOperationFormat(myOperations.get(0).getOperationValue().toLowerCase())) + "(");
            int i = 0;
            while (i < parameters.size() - 1) {
                formsOfCalculation.append(String.valueOf(parameters.get(i).getFormsOfCalculation()) + COMMA + SPACE);
                ++i;
            }
            formsOfCalculation.append(parameters.get(parameters.size() - 1).getFormsOfCalculation());
            formsOfCalculation.append(")");
        }
        if (formsOfCalculation.length() == 0 || formsOfCalculation.indexOf("null") != -1) {
            return "";
        }
        if (!inOperation) {
            formsOfCalculation = prefix.append(formsOfCalculation);
            formsOfCalculation = new StringBuffer(" given that").append(SPACE).append(formsOfCalculation.append(")"));
        } else {
            formsOfCalculation.insert(0, "(");
            formsOfCalculation.append(")");
        }
        return formsOfCalculation.toString();
    }

    public static String generateFormsOfCalculationClause(RamlConditionRelatedParameter ramlConditionRelatedParameter) {
        StringBuffer formsOfCalculation = new StringBuffer();
        String paramName = ramlConditionRelatedParameter.getParamName();
        String value = ramlConditionRelatedParameter.getValue();
        String valueOperation = ramlConditionRelatedParameter.getValueOperation();
        String fullName = ramlConditionRelatedParameter.getFullParamName();
        if (paramName != null) {
            if (valueOperation != null && value != null && RAMLLogicalValidatorBase.isCalculativeOperation(valueOperation)) {
                formsOfCalculation.append(paramName).append(SPACE).append("(").append(fullName).append(")").append(SPACE);
                formsOfCalculation.append(RAMLHelpper.getSimpleOperationFormat(valueOperation));
                formsOfCalculation.append(SPACE).append(value);
                return formsOfCalculation.toString();
            }
            return String.valueOf(paramName) + SPACE + "(" + fullName + ")";
        }
        if (value != null && valueOperation == null) {
            return value;
        }
        return null;
    }

    private static String generateOccursReasonClause(RamlConditionRelatedParameter ramlConditionRelatedParameter) {
        StringBuilder reason = new StringBuilder();
        String maxOccurs = ramlConditionRelatedParameter.getMaxOccurs();
        String minOccurs = ramlConditionRelatedParameter.getMinOccurs();
        String exactOccurs = ramlConditionRelatedParameter.getExactOccurs();
        RAMLList<?> ramlList = ramlConditionRelatedParameter.getRAMLList();
        reason.append(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Has"));
        reason.append(SPACE);
        if (maxOccurs != null) {
            reason.append(String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Less.Than.Or.Equal.To")) + SPACE + maxOccurs);
        }
        if (minOccurs != null) {
            reason.append(String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.More.Than.Or.Equal.To")) + SPACE + minOccurs);
        }
        if (exactOccurs != null) {
            reason.append(exactOccurs);
        }
        reason.append(SPACE);
        if (ramlList != null) {
            reason.append(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Items"));
        } else {
            reason.append(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Instances"));
        }
        return reason.toString();
    }

    public static String generateParameterLocation(RamlConditionRelatedParameter ramlConditionRelatedParameter) {
        StringBuilder location = new StringBuilder();
        String paramName = ramlConditionRelatedParameter.getParamName();
        String listName = ramlConditionRelatedParameter.getListName();
        String className = ramlConditionRelatedParameter.getClassName();
        if (paramName != null) {
            location.append(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Parameter"));
            location.append(SPACE + paramName + SPACE);
            String fullParamName = ramlConditionRelatedParameter.getFullParamName();
            if (fullParamName != null) {
                location.append("(" + fullParamName + ")" + SPACE);
            }
            if (listName != null) {
                String fullnameWithParenthesis = RAMLValidationErrorMessageFactory.getFullListNameWithParenthesis(ramlConditionRelatedParameter.getListMetaParameter());
                location.append(String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.In.List")) + SPACE + listName + SPACE);
                if (!GeneralUtils.isEmptyString(fullnameWithParenthesis)) {
                    location.append(String.valueOf(fullnameWithParenthesis) + SPACE);
                }
            }
            if (className != null) {
                location.append(String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.In.Object")) + SPACE + className);
            }
        } else if (listName != null) {
            String fullnameWithParenthesis = RAMLValidationErrorMessageFactory.getFullListNameWithParenthesis(ramlConditionRelatedParameter.getListMetaParameter());
            location.append(String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.List")) + SPACE + listName + SPACE);
            if (!GeneralUtils.isEmptyString(fullnameWithParenthesis)) {
                location.append(String.valueOf(fullnameWithParenthesis) + SPACE);
            }
            if (className != null) {
                location.append(String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.In.Object")) + SPACE + className);
            }
        }
        return location.toString();
    }

    public static String generateReasonClause(RamlConditionRelatedParameter ramlConditionRelatedParameter) {
        if (RAMLValidationErrorMessageFactory.isRamlConditionRelatedParameterInvalid(ramlConditionRelatedParameter)) {
            return "";
        }
        StringBuilder reason = new StringBuilder();
        reason.append(String.valueOf(RAMLValidationErrorMessageFactory.generateParameterLocation(ramlConditionRelatedParameter)) + SPACE);
        reason.append(RAMLValidationErrorMessageFactory.generateReasonString(ramlConditionRelatedParameter));
        return reason.toString();
    }

    private static boolean isRamlConditionRelatedParameterInvalid(RamlConditionRelatedParameter ramlConditionRelatedParameter) {
        return ramlConditionRelatedParameter.getValue() == null && ramlConditionRelatedParameter.getMaxOccurs() == null && ramlConditionRelatedParameter.getMinOccurs() == null && ramlConditionRelatedParameter.getExactOccurs() == null && ramlConditionRelatedParameter.getMaxIncl() == null && ramlConditionRelatedParameter.getMinIncl() == null && ramlConditionRelatedParameter.getValueOperation() == null;
    }

    private static String generateReasonString(RamlConditionRelatedParameter ramlConditionRelatedParameter) {
        String value = ramlConditionRelatedParameter.getValue();
        String maxOccurs = ramlConditionRelatedParameter.getMaxOccurs();
        String minOccurs = ramlConditionRelatedParameter.getMinOccurs();
        String valueOperation = ramlConditionRelatedParameter.getValueOperation();
        String exactOccurs = ramlConditionRelatedParameter.getExactOccurs();
        String maxIncl = ramlConditionRelatedParameter.getMaxIncl();
        String minIncl = ramlConditionRelatedParameter.getMinIncl();
        StringBuilder reason = new StringBuilder();
        if (maxOccurs != null || minOccurs != null || exactOccurs != null) {
            String occursReason = RAMLValidationErrorMessageFactory.generateOccursReasonClause(ramlConditionRelatedParameter);
            reason.append(occursReason);
        } else if ("EMPTY".equals(valueOperation) || "NOT_EMPTY".equals(valueOperation)) {
            reason.append(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Is"));
            reason.append(SPACE);
            reason.append(valueOperation.toLowerCase().replace("_", SPACE));
        } else if ("MATCHES".equals(valueOperation) || "NOT_MATCHES".equals(valueOperation)) {
            String strBundleItem = "MATCHES".equals(valueOperation) ? "RAMLValidation.Matches" : "RAMLValidation.Not.Matches";
            reason.append(String.valueOf(RAMLValidationErrorMessageFactory.getString(strBundleItem)) + SPACE + value);
        } else {
            reason.append(String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Has.The.Value.Equal.To")) + SPACE);
            RAMLValidationErrorMessageFactory.generateAdditionalReasonBasedOnValue(ramlConditionRelatedParameter, reason, value, valueOperation, maxIncl, minIncl);
        }
        return reason.toString();
    }

    public static String generateReasonClause(RAMLOperation ramlOperation) {
        List<RamlConditionRelatedParameter> parameters = ramlOperation.getAllRelatedParameters();
        String operationValue = ramlOperation.getOperationValue();
        StringBuilder reason = new StringBuilder(RAMLValidationErrorMessageFactory.generateParameterLocation(parameters.get(0)));
        reason.append(SPACE);
        reason.append(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Is"));
        reason.append(SPACE);
        reason.append(operationValue.toLowerCase().replaceAll("_", SPACE));
        reason.append(SPACE);
        reason.append(RAMLValidationErrorMessageFactory.getString("RAMLValidation.To"));
        reason.append(SPACE);
        reason.append(parameters.get(1).getParameterLocation());
        return reason.toString();
    }

    public static String generateRelatedParamText(RamlConditionRelatedParameter p) {
        if (p.getClassName() == null && p.getParamName() == null || p.getMaxOccurs() != null || p.getMinOccurs() != null || p.getExactOccurs() != null) {
            return "";
        }
        Object[] text = new Object[]{p.getParamName(), p.getClassName(), p.getListName() == null ? "" : SPACE + RAMLValidationErrorMessageFactory.getString("RAMLValidation.List") + SPACE + p.getListName(), p.getResultValue()};
        return String.valueOf(RAMLValidationErrorMessageFactory.getString("RAMLValidation.Because")) + SPACE + TextUtils.removeExtraSpaces(MessageFormat.format(RAMLValidationErrorMessageFactory.getString("RAMLValidation.RelatedParameter.Value.Details_Text"), text));
    }

    private static String getCombinedStringWithDelimiter(Iterable<String> collection, String delimiter) {
        StringBuilder combiner = new StringBuilder();
        for (String nextString : collection) {
            if (combiner.length() > 0 && !GeneralUtils.isEmptyString(nextString)) {
                combiner.append(delimiter);
            }
            if (GeneralUtils.isEmptyString(nextString)) continue;
            combiner.append(nextString);
        }
        return combiner.toString();
    }

    private static String getComparisonString(String compType) {
        String compareType = compType;
        String compareStr = compareType.equals("BIGGER") || compareType.equals("SMALLER") ? RAMLValidationErrorMessageFactory.getString("RAMLValidation.Than") : RAMLValidationErrorMessageFactory.getString("RAMLValidation.To");
        compareStr = String.valueOf(compareType) + SPACE + compareStr;
        compareStr = compareType.equals("BIGGER") || compareType.equals("SMALLER") ? RAMLValidationErrorMessageFactory.getString("RAMLValidation.Than") : RAMLValidationErrorMessageFactory.getString("RAMLValidation.To");
        if (compareType.equals("BIGGER_OR_EQUAL")) {
            compareType = "BIGGER_THAN_OR_EQUAL";
        } else if (compareType.equals("SMALLER_OR_EQUAL")) {
            compareType = "SMALLER_THAN_OR_EQUAL";
        }
        compareStr = String.valueOf(compareType) + SPACE + compareStr;
        compareStr = compareStr.replace("_", SPACE).toLowerCase();
        return compareStr;
    }

    private static String getFullListNameWithParenthesis(RAMLMetaParameter metaP) {
        if (metaP == null || metaP.getFullName() == null || metaP.getFullName().length() == 0) {
            return "";
        }
        return "(" + metaP.getFullName() + ")";
    }

    private static boolean isMandatoryEmptyList(RAMLMetaParameter metaP, RAMLList<?> list) {
        return metaP.isMandatory() && list == null && metaP.getMaxOccurs() > 1;
    }

    protected static void loadResourceBundle() {
        resourceBundle = I18n.getI18n().getBundle(RAMLValidationErrorMessageFactory.class);
        BECAUSE = RAMLValidationErrorMessageFactory.getString("RAMLValidation.Because");
    }

    private RAMLValidationErrorMessageFactory() {
    }
}

