/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RAMLValidationResult
implements Serializable {
    private static final long serialVersionUID = -6296687237794490494L;
    private String myDistName;
    private String myParamName;
    private List<String> myAllInvalidParamNames = new ArrayList<String>();
    private String myDetails;
    private String myText;
    private State myStatus;
    private String myVersion;
    private boolean myLastFeedback;
    private boolean myRangeCheckIssue;
    private boolean myInvalidValueCheckIssue;
    private Object mySource;
    private int mySourceIndex = -1;
    private String myRelationshipId = null;

    public RAMLValidationResult(State state) {
        this.myStatus = state;
        this.myDetails = "";
        this.myDistName = "";
        this.myParamName = "";
        this.myVersion = "";
        this.myText = "";
        this.myLastFeedback = false;
    }

    public RAMLValidationResult(State state, String details, String distName, String version, String text) {
        this.myStatus = state;
        this.myDetails = details;
        this.myDistName = distName;
        this.myParamName = "";
        this.myVersion = version;
        this.myText = text;
        this.myLastFeedback = false;
    }

    public RAMLValidationResult(State state, String details, String distName, String paramName, String version, String text) {
        this.myStatus = state;
        this.myDetails = details;
        this.myDistName = distName;
        this.myParamName = paramName;
        this.myVersion = version;
        this.myText = text;
        this.myLastFeedback = false;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(String version) {
        this.myVersion = version;
    }

    public boolean isOk() {
        return State.OK.equals((Object)this.myStatus);
    }

    public boolean isLast() {
        return this.myLastFeedback;
    }

    public void setLast(boolean last) {
        this.myLastFeedback = last;
    }

    public static RAMLValidationResult createOkResult() {
        return new RAMLValidationResult(State.OK);
    }

    public static RAMLValidationResult createErrorResult() {
        return new RAMLValidationResult(State.ERROR);
    }

    public static RAMLValidationResult createWarningResult() {
        return new RAMLValidationResult(State.WARNING);
    }

    public String getDistName() {
        return this.myDistName != null ? this.myDistName : "";
    }

    public String getAdditionalText() {
        return this.myParamName == null || "".equals(this.myParamName) ? "" : ": " + this.myParamName;
    }

    public void setDistName(String distName) {
        this.myDistName = distName;
    }

    public String getParameterName() {
        return this.myParamName;
    }

    public void setParameterName(String paramName) {
        this.myParamName = paramName;
    }

    public List<String> getAllInvalidParamNames() {
        return this.myAllInvalidParamNames;
    }

    public void addAllInvalidParamNames(List<String> invalidParamNames) {
        this.myAllInvalidParamNames.addAll(invalidParamNames);
    }

    public String getDetails() {
        return this.myDetails;
    }

    public void setDetails(String details) {
        this.myDetails = details;
    }

    public State getState() {
        return this.myStatus;
    }

    public void setState(State state) {
        this.myStatus = state;
    }

    public String toString() {
        return "DistName: " + this.myDistName + " Details: " + this.myDetails + " Status: " + (Object)((Object)this.myStatus) + " Param: " + this.myParamName + " SourceIndex: " + this.mySourceIndex + " RID: " + this.myRelationshipId;
    }

    public String getText() {
        return this.myText;
    }

    public void setText(String text) {
        this.myText = text;
    }

    public Object getSource() {
        return this.mySource;
    }

    public void setSource(Object source) {
        this.mySource = source;
    }

    public int getSourceIndex() {
        return this.mySourceIndex;
    }

    public void setSourceIndex(int sourceIndex) {
        this.mySourceIndex = sourceIndex;
    }

    public String getRelationshipId() {
        return this.myRelationshipId;
    }

    public void setRelationshipId(String relationshipId) {
        this.myRelationshipId = relationshipId;
    }

    public boolean hasRangeCheckIssue() {
        return this.myRangeCheckIssue;
    }

    public final boolean hasRangeCheckIssueAndInvalidValueCheckIssue() {
        return this.myRangeCheckIssue || this.myInvalidValueCheckIssue;
    }

    public void setRangeCheckIssue(boolean rangeCheckIssue) {
        this.myRangeCheckIssue = rangeCheckIssue;
    }

    public boolean hasInvalidValueCheckIssue() {
        return this.myInvalidValueCheckIssue;
    }

    public void setInvalidValueCheckIssue(boolean invalidCheckIssue) {
        this.myInvalidValueCheckIssue = invalidCheckIssue;
    }

    public static enum State {
        OK("Ok"),
        WARNING("Warning"),
        ERROR("Error");

        protected String myDescription;

        private State(String desc) {
            this.myDescription = desc;
        }

        public String toString() {
            return this.myDescription;
        }
    }
}

