/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLOperation;
import com.nokia.em.poseidon.frameworks.raml.metadata.RamlConditionRelatedParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLLogicalValidatorBase;
import com.nokia.em.poseidon.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ConditionBase
implements Serializable {
    private static final long serialVersionUID = -4282577650594652886L;
    private String myConditionValue;
    private List<RAMLOperation> myOperations = new ArrayList<RAMLOperation>();
    private List<RamlConditionRelatedParameter> myParameters = new ArrayList<RamlConditionRelatedParameter>();
    private RAMLList myListToBeValidated;
    private RAMLParameter myParameterToBeValidated;

    public ConditionBase(Node conditionNode) {
        this.readAttributes(conditionNode);
    }

    private void readAttributes(Node referenceNode) {
        NamedNodeMap attributes = referenceNode.getAttributes();
        this.myConditionValue = this.readAttribute(attributes, "value");
    }

    protected String readAttribute(NamedNodeMap attributes, String name) {
        Node attr = attributes.getNamedItem(name);
        return attr == null ? null : attr.getNodeValue();
    }

    public String getValue() {
        return this.myConditionValue;
    }

    public List<RamlConditionRelatedParameter> getRelatedParameters() {
        return this.myParameters;
    }

    public List<RAMLOperation> getOperations() {
        return this.myOperations;
    }

    public RAMLParameter getParameterToBeValidated() {
        return this.myParameterToBeValidated;
    }

    protected RAMLList getListToBeValidated() {
        return this.myListToBeValidated;
    }

    public void setRAMLParameter(RAMLParameter ramlparameter) {
        for (RamlConditionRelatedParameter parameter : this.myParameters) {
            parameter.setRAMLParameter(ramlparameter);
            parameter.createParameterLocation();
            parameter.createReason();
        }
        for (RAMLOperation operation : this.myOperations) {
            operation.setRAMLParameter(ramlparameter);
        }
        this.myParameterToBeValidated = ramlparameter;
    }

    public void setRAMLList(RAMLList ramlList) {
        for (RamlConditionRelatedParameter parameter : this.myParameters) {
            parameter.setRAMLList(ramlList);
            parameter.createParameterLocation();
            parameter.createReason();
        }
        for (RAMLOperation operation : this.myOperations) {
            operation.setRAMLList(ramlList);
        }
        this.myListToBeValidated = ramlList;
    }

    public void setParentRAMLItem(RAMLItem ramlItem) {
        for (RamlConditionRelatedParameter parameter : this.myParameters) {
            parameter.setParentRAMLItem(ramlItem);
        }
    }

    public void setManagedObject(RAMLManagedObject managedObject) {
        for (RamlConditionRelatedParameter parameter : this.myParameters) {
            parameter.setManagedObject(managedObject);
            parameter.createParameterLocation();
            parameter.createReason();
        }
        for (RAMLOperation operation : this.myOperations) {
            operation.setManagedObject(managedObject);
        }
    }

    public void setMetaParameter(RAMLMetaParameter metaParameter) {
        for (RamlConditionRelatedParameter parameter : this.myParameters) {
            parameter.setMetaParameter(metaParameter);
            parameter.createParameterLocation();
            parameter.createReason();
        }
        for (RAMLOperation operation : this.myOperations) {
            operation.setMetaParameter(metaParameter);
        }
    }

    public void setRAMLParameter(RAMLMetaParameter metaParameter, RAMLParameter ramlParameter) {
        for (RamlConditionRelatedParameter parameter : this.myParameters) {
            parameter.setMetaParameter(metaParameter);
            parameter.setRAMLParameter(ramlParameter);
            parameter.createParameterLocation();
            parameter.createReason();
        }
        for (RAMLOperation operation : this.myOperations) {
            operation.setMetaParameter(metaParameter);
            operation.setRAMLParameter(ramlParameter);
        }
        this.myParameterToBeValidated = ramlParameter;
    }

    public void setRAMLList(RAMLMetaParameter metaParameter, RAMLList ramlList) {
        for (RamlConditionRelatedParameter parameter : this.myParameters) {
            parameter.setMetaParameter(metaParameter);
            parameter.setRAMLList(ramlList);
            parameter.createParameterLocation();
            parameter.createReason();
        }
        for (RAMLOperation operation : this.myOperations) {
            operation.setMetaParameter(metaParameter);
        }
        this.myListToBeValidated = ramlList;
    }

    public void setManagedObject(RAMLMetaParameter metaParameter, RAMLManagedObject managedObject) {
        for (RamlConditionRelatedParameter parameter : this.myParameters) {
            parameter.setMetaParameter(metaParameter);
            parameter.setManagedObject(managedObject);
            parameter.createParameterLocation();
            parameter.createReason();
        }
        for (RAMLOperation operation : this.myOperations) {
            operation.setManagedObject(managedObject);
        }
    }

    public void addOperation(RAMLOperation operation) {
        this.myOperations.add(operation);
    }

    public void addRelatedParameter(RamlConditionRelatedParameter relatedParameter) {
        this.myParameters.add(relatedParameter);
    }

    protected boolean isReadyForCalculation() {
        if (this.getOperations().size() == 0) {
            if (this.getRelatedParameters().size() > 0) {
                return RAMLLogicalValidatorBase.shouldRelatedParamCal(this.getRelatedParameters());
            }
        } else {
            if (this.getOperations().size() == 1 && this.getRelatedParameters().size() == 0) {
                return this.getOperations().get(0).isMinMaxOperation();
            }
            if (this.getRelatedParameters().size() == 1) {
                for (RAMLOperation operation : this.getOperations()) {
                    if (operation.isCalculativeOperation()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String getCalculationValue() {
        if (this.myParameters.size() == 1 && this.myOperations.size() > 0) {
            String value = this.myParameters.get(0).getConditionRelatedParameterValue();
            if (TextUtils.isNumeric(value)) {
                double parameter = Double.parseDouble(value);
                return RAMLLogicalValidatorBase.doCalculation(this.myOperations, parameter);
            }
        } else {
            if (this.myOperations.size() == 0 && this.myParameters.size() > 0) {
                return RAMLLogicalValidatorBase.doRelatedParamCal(this.myParameters);
            }
            if (this.myOperations.size() == 1 && this.myParameters.size() == 0) {
                return RAMLLogicalValidatorBase.doCalculation(this.myOperations.get(0));
            }
        }
        return null;
    }

    public String getFormsOfCalculation(boolean inOperation) {
        return RAMLValidationErrorMessageFactory.generateFormsOfCalculationClause(this, inOperation);
    }

    protected List<RAMLParameter> getRelatedParametersWithoutCurrentOne(RamlConditionRelatedParameter parameter) {
        ArrayList<RAMLParameter> result = new ArrayList<RAMLParameter>();
        for (RAMLParameter ramlP : parameter.getRelatedParameters()) {
            if (ramlP == this.myParameterToBeValidated) continue;
            result.add(ramlP);
        }
        return result;
    }

    protected List<String> getRelatedParameterValuesWithoutCurrentOne(RamlConditionRelatedParameter parameter) {
        List<RAMLParameter> parameters = this.getRelatedParametersWithoutCurrentOne(parameter);
        ArrayList<String> result = new ArrayList<String>();
        for (RAMLParameter ramlP : parameters) {
            result.add(ramlP.getValue());
        }
        return result;
    }
}

