/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLSimpleTypeCreator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBitList;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBoolean;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDecimal;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLEnum;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLInteger;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLString;
import java.io.Serializable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultRAMLSimpleTypeCreator
implements RAMLSimpleTypeCreator,
Serializable {
    private static final long serialVersionUID = 5331113043991030524L;

    @Override
    public RAMLSimpleType createSimpleTypeValue(RAMLMetaParameter param, Node simpleTypeNode, Node paramNode) {
        NamedNodeMap attributes = simpleTypeNode.getAttributes();
        String base = attributes.getNamedItem("base").getNodeValue();
        if (base.equals("integer")) {
            NodeList childNodes = simpleTypeNode.getChildNodes();
            Node childNode = null;
            int i = 0;
            while (i < childNodes.getLength()) {
                childNode = childNodes.item(i);
                if (childNode.getNodeName().equals("enumeration")) {
                    return new RAMLEnum(simpleTypeNode, "enumeration", param);
                }
                if (childNode.getNodeName().equals("bit")) {
                    return new RAMLBitList(simpleTypeNode, "bit", param);
                }
                ++i;
            }
            return new RAMLInteger(simpleTypeNode, "integer", param);
        }
        if (base.equals("decimal")) {
            return new RAMLDecimal(simpleTypeNode, "decimal", param);
        }
        if (base.equals("string")) {
            return new RAMLString(simpleTypeNode, "string", param);
        }
        if (base.equals("boolean")) {
            return new RAMLBoolean(simpleTypeNode, "boolean", param);
        }
        return null;
    }
}

