/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.util.GeneralUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RAMLChildManagedObject
implements Serializable {
    private static final long serialVersionUID = -7830151290908512482L;
    private Map<String, String> myAttributes = new HashMap<String, String>();
    private String myClass = "";
    private String myPrefix = "";

    public RAMLChildManagedObject(Node childManagedObject) {
        this.readProperties(childManagedObject);
        this.readClassNameAndPrefix(this.myAttributes.get("class"));
    }

    private void readProperties(Node childManagedObject) {
        NamedNodeMap attributes = childManagedObject.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            this.myAttributes.put(attribute.getNodeName(), attribute.getNodeValue());
            ++i;
        }
    }

    private void readClassNameAndPrefix(String className) {
        int colonIndex = className.indexOf(":");
        if (colonIndex >= 0) {
            this.myClass = className.substring(colonIndex + 1);
            this.myPrefix = className.substring(0, colonIndex);
        } else {
            this.myClass = className;
        }
    }

    public String getClassName() {
        return this.myClass;
    }

    public String getPrefix() {
        return this.myPrefix;
    }

    public int getMaxOccurs() {
        String maxOccurs = this.myAttributes.get("maxOccurs");
        return maxOccurs == null ? -1 : Integer.parseInt(maxOccurs);
    }

    public String getAttribute(String key) {
        return this.myAttributes.get(key);
    }

    public void setAttribute(String key, String value) {
        this.myAttributes.put(key, value);
    }

    public boolean hasMaxOccurance() {
        return this.getMaxOccurs() != -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Child managed object class: ");
        sb.append(this.getClassName());
        sb.append(" max occurs:");
        sb.append(this.getMaxOccurs());
        return sb.toString();
    }

    public String toXmlString() {
        StringBuilder tagData = new StringBuilder();
        tagData.append("<childManagedObject");
        tagData.append(" class=\"");
        if (!GeneralUtils.isEmptyString(this.myPrefix)) {
            tagData.append(this.myPrefix);
            tagData.append(":");
        }
        tagData.append(this.getClassName());
        tagData.append("\" maxOccurs=\"");
        tagData.append(this.getMaxOccurs());
        tagData.append("\"");
        tagData.append("/>");
        return tagData.toString();
    }
}

