/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLHelpper;
import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLItemList;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.ConditionBase;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLElseBlock;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLElseIfBlock;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLIfBlock;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLOperation;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLPreCondition;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.RamlConditionRelatedParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLLogicalValidatorBase;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBoolean;
import com.nokia.em.poseidon.util.GeneralUtils;
import com.nokia.em.poseidon.util.TextUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RAMLCondition
extends ConditionBase
implements RAMLValidator {
    private static final long serialVersionUID = -1762104871780978217L;
    private String myRelationshipId = null;
    private RAMLPreCondition myPreCondition;
    private RAMLMetaParameter myMetaParameter;
    private RAMLValidationContext myValidationContext;
    protected transient ResourceBundle myRB;
    private SortedSet<String> myReason = new TreeSet<String>();
    private RAMLIfBlock myIfBlock;
    private List<RAMLElseIfBlock> myElseIfBLocks = new ArrayList<RAMLElseIfBlock>(0);
    private RAMLElseBlock myElseBlock;
    private Set<String> myIfElseReasons = new HashSet<String>(0);

    public RAMLCondition(Node conditionNode) {
        super(conditionNode);
        this.setRelationshipId(this.readAttribute(conditionNode.getAttributes(), "rId"));
        this.myPreCondition = null;
        this.readElement(conditionNode);
        this.myRB = I18n.getI18n().getBundle(this.getClass());
    }

    public void readElement(Node conditionNode) {
        NodeList childNodes = conditionNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            if ("operation".equals(nodeName)) {
                this.addOperation(new RAMLOperation(childNode, this));
            } else if ("pRef".equals(nodeName)) {
                this.addRelatedParameter(new RamlConditionRelatedParameter(childNode, this));
            } else if ("preCondition".equals(nodeName)) {
                this.myPreCondition = new RAMLPreCondition(childNode);
            } else if ("if".equals(nodeName)) {
                this.myIfBlock = new RAMLIfBlock(childNode);
            } else if ("elseif".equals(nodeName)) {
                this.myElseIfBLocks.add(new RAMLElseIfBlock(childNode));
            } else if ("else".equals(nodeName)) {
                this.myElseBlock = new RAMLElseBlock(childNode);
            }
            ++i;
        }
    }

    public List<RamlConditionRelatedParameter> getAllRelatedParameters() {
        ArrayList<RamlConditionRelatedParameter> parameters = new ArrayList<RamlConditionRelatedParameter>();
        parameters.addAll(this.getRelatedParameters());
        if (this.myPreCondition != null) {
            parameters.addAll(this.myPreCondition.getRelatedParameters());
        }
        for (RAMLOperation operation : this.getOperations()) {
            parameters.addAll(operation.getAllRelatedParameters());
        }
        return parameters;
    }

    public boolean areAllRequirementsTrue() {
        ArrayList<String> reasons = new ArrayList<String>();
        for (RAMLOperation operation : this.getOperations()) {
            if (!operation.areAllRequirementsTrue()) {
                return false;
            }
            reasons.addAll(operation.getReasons());
        }
        for (RamlConditionRelatedParameter parameter : this.getRelatedParameters()) {
            if (!parameter.isValidationMatched()) {
                return false;
            }
            if (!parameter.isErrorReasonVisible()) continue;
            reasons.add(parameter.getReason());
        }
        this.myReason.addAll(reasons);
        return true;
    }

    public SortedSet<String> getReasons() {
        return this.myReason;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RAMLCondition: ");
        sb.append(this.getValue());
        sb.append(" operations: ");
        sb.append(this.getOperations());
        return sb.toString();
    }

    public String toXmlString() {
        StringBuilder tagData = new StringBuilder();
        tagData.append("<condition");
        tagData.append("\n");
        if (this.myMetaParameter != null) {
            tagData.append(this.myMetaParameter.toXmlString());
        }
        tagData.append("</condition>");
        tagData.append("\n");
        return tagData.toString();
    }

    public boolean hasMinOccursCheck(RAMLManagedObject moToBeValidated) {
        if (this.myPreCondition != null && !this.myPreCondition.isPreConditionTrue()) {
            return false;
        }
        for (RamlConditionRelatedParameter parameter : this.getRelatedParameters()) {
            if (!parameter.hasMinOccursCheck(moToBeValidated)) continue;
            return true;
        }
        for (RAMLOperation operation : this.getOperations()) {
            if (!operation.hasMinOccursCheck(moToBeValidated)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMandatoryCheck(RAMLManagedObject moToBeValidated) {
        this.myReason.clear();
        ArrayList<String> reasons = new ArrayList<String>();
        if (this.myPreCondition != null) {
            boolean isPreConditionTrue = this.myPreCondition.isPreConditionTrue();
            if (isPreConditionTrue) {
                reasons.addAll(this.myPreCondition.getReason());
            } else {
                return false;
            }
        }
        for (RamlConditionRelatedParameter parameter : this.getRelatedParameters()) {
            if (!parameter.hasMandatoryCheck(moToBeValidated)) continue;
            if (parameter.isErrorReasonVisible()) {
                reasons.add(parameter.getReason());
            }
            this.myReason.addAll(reasons);
            return true;
        }
        for (RAMLOperation operation : this.getOperations()) {
            if (!operation.hasMandatoryCheck(moToBeValidated)) continue;
            reasons.addAll(operation.getReasons());
            this.myReason.addAll(reasons);
            return true;
        }
        if (!reasons.isEmpty()) {
            this.myReason.addAll(reasons);
        }
        return false;
    }

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        this.clearIfElseReasons();
        this.myMetaParameter = (RAMLMetaParameter)metaData;
        this.myValidationContext = validationContext;
        if (objectToBeValidated instanceof RAMLList) {
            this.setRAMLList(this.myMetaParameter, (RAMLList)objectToBeValidated);
        } else if (objectToBeValidated instanceof RAMLParameter) {
            this.setRAMLParameter(this.myMetaParameter, (RAMLParameter)objectToBeValidated);
        }
        if (this.myPreCondition != null && !this.myPreCondition.isPreConditionTrue()) {
            return;
        }
        if (this.myIfBlock != null) {
            this.validateIfBlock(validationContext, metaData, objectToBeValidated);
            return;
        }
        if (objectToBeValidated instanceof RAMLList) {
            this.validateList(this.myValidationContext, this.myMetaParameter, this.getListToBeValidated());
        } else if (objectToBeValidated instanceof RAMLParameter) {
            this.validateParameter(this.myValidationContext, this.myMetaParameter, this.getParameterToBeValidated());
        }
    }

    private void validateIfBlock(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        if (this.myIfBlock.isPreconditionTrue()) {
            this.myIfElseReasons.addAll(this.myIfBlock.getPrecondition().getReason());
            this.myIfBlock.setIfElseReasons(this.myIfElseReasons);
            this.myIfBlock.validate(validationContext, metaData, objectToBeValidated);
        } else {
            for (RAMLElseIfBlock elseIfBlock : this.myElseIfBLocks) {
                if (!elseIfBlock.isPreconditionTrue()) continue;
                this.myIfElseReasons.addAll(elseIfBlock.getPrecondition().getReason());
                elseIfBlock.setIfElseReasons(this.myIfElseReasons);
                elseIfBlock.validate(validationContext, metaData, objectToBeValidated);
                return;
            }
            if (this.myElseBlock != null) {
                this.myElseBlock.setIfElseReasons(this.myIfElseReasons);
                this.myElseBlock.validate(validationContext, metaData, objectToBeValidated);
            }
        }
    }

    public RAMLPreCondition getPrecondition() {
        return this.myPreCondition;
    }

    protected void setIfElseReasons(Set<String> reasons) {
        this.myIfElseReasons.clear();
        this.myIfElseReasons.addAll(reasons);
    }

    public Set<String> getIfElseReasons() {
        return this.myIfElseReasons;
    }

    protected void clearIfElseReasons() {
        this.myIfElseReasons.clear();
    }

    private void validateParameter(RAMLValidationContext validationContext, RAMLMetaParameter metaData, RAMLParameter objectToBeValidated) {
        if (this.getValue() == null) {
            if (this.isReadyForCalculation()) {
                this.validateCalculation("EQUAL");
            } else {
                this.validateRelatedParameters(validationContext, metaData, objectToBeValidated);
                this.validateOperations(validationContext, metaData, objectToBeValidated);
            }
        } else if (this.hasSpecialValue()) {
            RAMLOperation operation;
            if (this.getValue().equals("OR")) {
                this.validateRelatedParameters(validationContext, metaData, objectToBeValidated);
                this.validateOperations(validationContext, metaData, objectToBeValidated);
            } else if (this.getValue().equals("UNIQUE")) {
                this.validateUniqueForParameter();
            } else if (this.isReadyForCalculation()) {
                this.validateCalculation(this.getValue());
            } else if (this.getRelatedParameters().size() > 0) {
                RamlConditionRelatedParameter parameter = this.getRelatedParameters().get(0);
                if (parameter.isValidationMatched()) {
                    if (RAMLLogicalValidatorBase.shouldRelatedParamCal(this.getRelatedParameters()) || parameter.getParamName() == null && parameter.getListName() == null && parameter.getValue() != null) {
                        String targetValue = parameter.getResultValue();
                        if (!RAMLLogicalValidatorBase.isValueValid(this.getValue(), targetValue, this.getParameterToBeValidated().getValue())) {
                            String details = RAMLValidationErrorMessageFactory.createInvalidValueErrorMessage(this, parameter, targetValue);
                            RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationError(this.myMetaParameter, this.getParameterToBeValidated(), details);
                            result.setRelationshipId(this.getRelationshipId());
                            validationContext.addResult(result);
                        }
                    } else {
                        String details = "";
                        List<String> targetValues = this.getValidRelatedParameterValuesWithoutCurrentOne(parameter);
                        if (this.getValue().equals("EMPTY") || this.getValue().equals("NOT_EMPTY")) {
                            if (!RAMLLogicalValidatorBase.isValueValid(this.getValue(), "", this.getParameterToBeValidated().getValue())) {
                                details = RAMLValidationErrorMessageFactory.createEmptyOrNotEmptyErrorMessage(this);
                                RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationError(this.myMetaParameter, this.getParameterToBeValidated(), details);
                                result.setRelationshipId(this.getRelationshipId());
                                validationContext.addResult(result);
                            }
                        } else if (targetValues.size() != 0 && !RAMLLogicalValidatorBase.isValueValid(metaData, this.getValue(), targetValues, this.getParameterToBeValidated().getValue(), parameter.getOperationScope())) {
                            details = RAMLValidationErrorMessageFactory.createCompareValidationErrorMessage(this, parameter);
                            RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationError(this.myMetaParameter, this.getParameterToBeValidated(), details);
                            result.setRelationshipId(this.getRelationshipId());
                            validationContext.addResult(result);
                        }
                    }
                }
            } else if ((this.getValue().equals("EMPTY") || this.getValue().equals("NOT_EMPTY")) && this.getOperations().size() > 0 && (operation = this.getOperations().get(0)).areAllRequirementsTrue() && !RAMLLogicalValidatorBase.isValueValid(this.getValue(), "", this.getParameterToBeValidated().getValue())) {
                String details = RAMLValidationErrorMessageFactory.createEmptyOrNotEmptyErrorMessage(this, operation);
                RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationError(this.myMetaParameter, this.getParameterToBeValidated(), details);
                result.setRelationshipId(this.getRelationshipId());
                validationContext.addResult(result);
            }
        } else if (this.hasOccurrenceValue()) {
            this.validateRelatedParameters(validationContext, metaData, objectToBeValidated);
            this.validateOperations(validationContext, metaData, objectToBeValidated);
        } else if (this.getOperations().size() == 0) {
            if ((this.getRelatedParameters().size() != 0 && this.getRelatedParameters().get(0).isValidationMatched() || this.getRelatedParameters().size() == 0 && this.myPreCondition != null) && this.isNotFillCondition()) {
                this.addCompareErrorMessage(validationContext);
            }
        } else {
            RAMLOperation operation = this.getOperations().get(0);
            if (operation.areAllRequirementsTrue() && this.isNotFillCondition()) {
                this.addCalculationErrorMessage(validationContext, operation);
            }
        }
    }

    private boolean isNotFillCondition() {
        if (TextUtils.isNumeric(this.getValue()) && this.getParameterToBeValidated().isNumeric()) {
            return Integer.parseInt(this.getValue()) != this.getParameterToBeValidated().getValueAsInt();
        }
        if (this.getParameterToBeValidated().getValue() != null && this.getMetaParameter().getValueType() instanceof RAMLBoolean) {
            return !this.getValue().equalsIgnoreCase(this.getParameterToBeValidated().getValue());
        }
        return !this.getValue().equals(this.getParameterToBeValidated().getValue());
    }

    private void addCompareErrorMessage(RAMLValidationContext validationContext) {
        String details = String.valueOf(RAMLValidationErrorMessageFactory.generatedCalculationClauseStart(this.myMetaParameter, this.getParameterToBeValidated(), "EQUAL", this.getValue())) + RAMLValidationErrorMessageFactory.generateBecauseClause(this);
        RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationError(this.myMetaParameter, this.getParameterToBeValidated(), details);
        result.setRelationshipId(this.getRelationshipId());
        validationContext.addResult(result);
    }

    private void addCalculationErrorMessage(RAMLValidationContext validationContext, RAMLOperation operation) {
        String details = RAMLValidationErrorMessageFactory.createCalculationErrorMessage(this, operation);
        validationContext.addResult(RAMLLogicalValidatorBase.generateValidationError(this.myMetaParameter, this.getParameterToBeValidated(), details));
    }

    protected List<String> getValidRelatedParameterValuesWithoutCurrentOne(RamlConditionRelatedParameter parameter) {
        ArrayList<String> result = new ArrayList<String>();
        RAMLParameter parameterToBeValidated = this.getParameterToBeValidated();
        for (RAMLParameter ramlP : parameter.getRelatedParameters()) {
            if (ramlP == parameterToBeValidated || GeneralUtils.isEmptyString(ramlP.getValue()) || !ramlP.getMetaData().validate(ramlP)) continue;
            result.add(ramlP.getValue());
        }
        return result;
    }

    private void validateOperations(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        if (this.getOperations().size() != 0) {
            for (RAMLOperation operation : this.getOperations()) {
                operation.validate(validationContext, metaData, objectToBeValidated);
            }
        }
    }

    private void validateRelatedParameters(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        if (this.getRelatedParameters().size() != 0) {
            for (RamlConditionRelatedParameter parameter : this.getRelatedParameters()) {
                if (!parameter.isValidationMatched()) continue;
                parameter.setRelationshipId(this.getRelationshipId());
                parameter.validate(validationContext, metaData, objectToBeValidated);
            }
        }
    }

    private boolean hasSpecialValue() {
        return this.getValue().equals("SMALLER") || this.getValue().equals("SMALLER_OR_EQUAL") || this.getValue().equals("BIGGER") || this.getValue().equals("BIGGER_OR_EQUAL") || this.getValue().equals("EMPTY") || this.getValue().equals("NOT_EMPTY") || this.getValue().equals("EQUAL") || this.getValue().equals("NOT_EQUAL") || this.getValue().equals("UNIQUE") || this.getValue().equals("OR") || this.getValue().equals("AND");
    }

    private boolean hasOccurrenceValue() {
        return this.getValue().equals("MIN_OCCURS") || this.getValue().equals("MAX_OCCURS");
    }

    @Override
    public void setRAMLParameter(RAMLParameter ramlParameter) {
        super.setRAMLParameter(ramlParameter);
        if (this.myPreCondition != null) {
            this.myPreCondition.setRAMLParameter(ramlParameter);
        }
        if (this.myIfBlock != null) {
            this.myIfBlock.setRAMLParameter(ramlParameter);
        }
        if (this.myElseBlock != null) {
            this.myElseBlock.setRAMLParameter(ramlParameter);
        }
        for (RAMLElseIfBlock elseIfBlock : this.myElseIfBLocks) {
            elseIfBlock.setRAMLParameter(ramlParameter);
        }
    }

    @Override
    public void setRAMLParameter(RAMLMetaParameter metaParameter, RAMLParameter ramlParameter) {
        super.setRAMLParameter(metaParameter, ramlParameter);
        if (this.myPreCondition != null) {
            this.myPreCondition.setRAMLParameter(metaParameter, ramlParameter);
        }
        if (this.myIfBlock != null) {
            this.myIfBlock.setRAMLParameter(metaParameter, ramlParameter);
        }
        if (this.myElseBlock != null) {
            this.myElseBlock.setRAMLParameter(metaParameter, ramlParameter);
        }
        for (RAMLElseIfBlock elseIfBlock : this.myElseIfBLocks) {
            elseIfBlock.setRAMLParameter(metaParameter, ramlParameter);
        }
    }

    @Override
    public void setParentRAMLItem(RAMLItem ramlItem) {
        super.setParentRAMLItem(ramlItem);
        if (this.myPreCondition != null) {
            this.myPreCondition.setParentRAMLItem(ramlItem);
        }
        if (this.myIfBlock != null) {
            this.myIfBlock.setParentRAMLItem(ramlItem);
        }
        if (this.myElseBlock != null) {
            this.myElseBlock.setParentRAMLItem(ramlItem);
        }
        for (RAMLElseIfBlock elseIfBlock : this.myElseIfBLocks) {
            elseIfBlock.setParentRAMLItem(ramlItem);
        }
    }

    @Override
    public void setRAMLList(RAMLList ramlList) {
        super.setRAMLList(ramlList);
        if (this.myPreCondition != null) {
            this.myPreCondition.setRAMLList(ramlList);
        }
        if (this.myIfBlock != null) {
            this.myIfBlock.setRAMLList(ramlList);
        }
        if (this.myElseBlock != null) {
            this.myElseBlock.setRAMLList(ramlList);
        }
        for (RAMLElseIfBlock elseIfBlock : this.myElseIfBLocks) {
            elseIfBlock.setRAMLList(ramlList);
        }
    }

    @Override
    public void setRAMLList(RAMLMetaParameter metaParameter, RAMLList ramlList) {
        super.setRAMLList(metaParameter, ramlList);
        if (this.myPreCondition != null) {
            this.myPreCondition.setRAMLList(ramlList);
            this.myPreCondition.setMetaParameter(metaParameter);
        }
        if (this.myIfBlock != null) {
            this.myIfBlock.setRAMLList(ramlList);
        }
        if (this.myElseBlock != null) {
            this.myElseBlock.setRAMLList(ramlList);
        }
        for (RAMLElseIfBlock elseIfBlock : this.myElseIfBLocks) {
            elseIfBlock.setRAMLList(ramlList);
        }
    }

    @Override
    public void setManagedObject(RAMLManagedObject managedObject) {
        super.setManagedObject(managedObject);
        if (this.myPreCondition != null) {
            this.myPreCondition.setManagedObject(managedObject);
        }
        if (this.myIfBlock != null) {
            this.myIfBlock.setManagedObject(managedObject);
        }
        if (this.myElseBlock != null) {
            this.myElseBlock.setManagedObject(managedObject);
        }
        for (RAMLElseIfBlock elseIfBlock : this.myElseIfBLocks) {
            elseIfBlock.setManagedObject(managedObject);
        }
    }

    @Override
    public void setManagedObject(RAMLMetaParameter metaParameter, RAMLManagedObject managedObject) {
        super.setManagedObject(metaParameter, managedObject);
        if (this.myPreCondition != null) {
            this.myPreCondition.setManagedObject(managedObject);
            this.myPreCondition.setMetaParameter(metaParameter);
        }
        if (this.myIfBlock != null) {
            this.myIfBlock.setManagedObject(managedObject);
        }
        if (this.myElseBlock != null) {
            this.myElseBlock.setManagedObject(managedObject);
        }
        for (RAMLElseIfBlock elseIfBlock : this.myElseIfBLocks) {
            elseIfBlock.setManagedObject(managedObject);
        }
    }

    @Override
    public void setMetaParameter(RAMLMetaParameter metaParameter) {
        super.setMetaParameter(metaParameter);
        if (this.myPreCondition != null) {
            this.myPreCondition.setMetaParameter(metaParameter);
        }
    }

    private void validateUniqueForParameter() {
        if (this.areAllRequirementsTrue()) {
            String scope = "";
            String parentMOName = "";
            String currentMOName = "";
            RAMLParameter currentParameter = this.getParameterToBeValidated();
            currentMOName = currentParameter.getManagedObject().getMOClass();
            ArrayList<String> invalidParametersWithFullNames = new ArrayList<String>();
            if (this.getOperations() != null && this.getOperations().size() != 0) {
                ArrayList<String> invalidParametersWithAbbreviatedNames = new ArrayList<String>();
                for (RAMLOperation operation : this.getOperations()) {
                    if (!operation.getOperationValue().trim().equals("CONCATENATE")) continue;
                    invalidParametersWithFullNames.add(String.valueOf(operation.getAllRelatedParameters().get(0).getParamName()) + " (" + operation.getAllRelatedParameters().get(0).getFullParamName() + ")");
                    invalidParametersWithAbbreviatedNames.add(operation.getAllRelatedParameters().get(0).getParamName());
                }
                if (!this.isParameterUnique(this.getParameterToBeValidated(), this.getOperations())) {
                    RamlConditionRelatedParameter relatedParameter = this.getOperations().get(0).getAllRelatedParameters().get(0);
                    parentMOName = relatedParameter.getParentClass();
                    scope = relatedParameter.getScope();
                    String details = RAMLValidationErrorMessageFactory.createUniqueValidationErrorMessage(this, invalidParametersWithFullNames, this.getDefinedScope(currentMOName, scope, parentMOName));
                    RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationErrorWithoutParameterName(this.myMetaParameter, this.getParameterToBeValidated(), details);
                    result.addAllInvalidParamNames(invalidParametersWithAbbreviatedNames);
                    result.setText(this.getString("RAMLValidation.Incomplete.Configuration"));
                    result.setParameterName(this.myMetaParameter.getName());
                    result.setRelationshipId(this.getRelationshipId());
                    this.myValidationContext.addResult(result);
                }
            } else if (!this.isParameterUnique(this.getParameterToBeValidated())) {
                RamlConditionRelatedParameter relatedParameter = this.getRelatedParameters().get(0);
                parentMOName = relatedParameter.getParentClass();
                scope = relatedParameter.hasScope() ? relatedParameter.getScope() : "";
                invalidParametersWithFullNames.add(String.valueOf(this.getParameterToBeValidated().getName()) + " (" + this.getParameterToBeValidated().getMetaData().getFullName() + ")");
                String details = RAMLValidationErrorMessageFactory.createUniqueValidationErrorMessage(this, invalidParametersWithFullNames, this.getDefinedScope(currentMOName, scope, parentMOName));
                RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationError(this.myMetaParameter, this.getParameterToBeValidated(), details);
                result.setText(this.getString("RAMLValidation.Incorrect.Parameter"));
                result.setRelationshipId(this.getRelationshipId());
                this.myValidationContext.addResult(result);
            }
        }
    }

    private String getDefinedScope(String className, String scopeValue, String parentClassName) {
        String scope = scopeValue;
        String template = "";
        if (className.equals(parentClassName)) {
            scope = "";
        }
        template = "ALL".equals(scope) ? "RAMLValidation.Unique.Parameter.ScopeAll_Text" : ("SINGLE".equals(scope) ? "RAMLValidation.Unique.Parameter.ScopeSingle_Text" : "RAMLValidation.Unique.Parameter.ScopeCurrent_Text");
        return MessageFormat.format(this.getString(template), className, parentClassName);
    }

    private boolean isParameterUnique(RAMLParameter ramlParameter) {
        if (this.getRelatedParameters().size() == 1) {
            RamlConditionRelatedParameter relatedParameter = this.getRelatedParameters().get(0);
            if (relatedParameter.getListName() != null && !relatedParameter.hasScope()) {
                return this.isParameterUniqueInList(ramlParameter, relatedParameter);
            }
            if (relatedParameter.hasScope()) {
                List<RAMLParameter> parameters = relatedParameter.getTargetParameters();
                String ramlParameterValue = ramlParameter.isInteger() ? ramlParameter.getIntegerValueAsString() : ramlParameter.getValue();
                for (RAMLParameter parameter : parameters) {
                    if (parameter != ramlParameter && parameter.isInteger() && ramlParameterValue.equals(parameter.getIntegerValueAsString())) {
                        return false;
                    }
                    if (parameter == ramlParameter || parameter.getValue() == null || !parameter.getValue().equals(ramlParameterValue)) continue;
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private boolean isParameterUniqueInList(RAMLParameter ramlParameter, RamlConditionRelatedParameter relatedParameter) {
        block5: {
            RAMLList<?> list;
            block4: {
                if (relatedParameter.getParamName() == null || ramlParameter.getName() == null || !ramlParameter.getName().equals(relatedParameter.getParamName())) break block4;
                RAMLList<?> list2 = ramlParameter.getManagedObject().getList(relatedParameter.getListName());
                if (!(list2 instanceof RAMLItemList)) break block5;
                RAMLItemList ramlList = (RAMLItemList)list2;
                boolean excludeItself = false;
                for (RAMLItem item : ramlList.getItems()) {
                    String paraWithSameNameValue;
                    RAMLParameter paraWithSameName = item.getParameter(ramlParameter.getName());
                    if (paraWithSameName == null) continue;
                    String ramlParameterValue = ramlParameter.isInteger() ? ramlParameter.getIntegerValueAsString() : ramlParameter.getValue();
                    String string = paraWithSameNameValue = paraWithSameName.isInteger() ? paraWithSameName.getIntegerValueAsString() : paraWithSameName.getValue();
                    if (!paraWithSameNameValue.equals(ramlParameterValue)) continue;
                    if (!excludeItself) {
                        excludeItself = true;
                        continue;
                    }
                    return false;
                }
                break block5;
            }
            if (ramlParameter.getName() == null && relatedParameter.getParamName() == null && relatedParameter.getListName() != null && !relatedParameter.hasScope() && (list = ramlParameter.getManagedObject().getList(relatedParameter.getListName())) instanceof RAMLParameterList) {
                RAMLParameterList ramlList = (RAMLParameterList)list;
                for (RAMLParameter parameter : ramlList.getParameters()) {
                    if (!ramlParameter.getValue().equals(parameter.getValue()) || ramlParameter == parameter) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isParameterUnique(RAMLParameter parameter, List<RAMLOperation> operations) {
        StringBuilder builder = new StringBuilder();
        for (RAMLOperation operation : operations) {
            String parameterValue = RAMLLogicalValidatorBase.getParameterValue(parameter.getManagedObject(), operation.getAllRelatedParameters().get(0).getListName(), operation.getAllRelatedParameters().get(0).getParamName(), parameter);
            if (parameterValue == null) continue;
            builder.append(parameterValue);
            builder.append("+");
        }
        String valueToBeValidated = builder.toString();
        if (operations.get(0).getAllRelatedParameters().get(0).hasScope()) {
            String parentClasss = operations.get(0).getAllRelatedParameters().get(0).getParentClass();
            String scope = operations.get(0).getAllRelatedParameters().get(0).getScope();
            RAMLManagedObject parentMO = null;
            parentMO = parameter.getManagedObject().getMOClass().equals(parentClasss) ? parameter.getManagedObject() : RAMLHelpper.getParentMOByName(parameter.getManagedObject(), parentClasss);
            if (scope.equals("ALL")) {
                parentMO = parentMO.getParentMO();
            }
            List<RAMLManagedObject> managedObjects = RAMLHelpper.getMOsByScope(parentMO, parameter.getManagedObject().getMOClass(), RAMLHelpper.RAMLScope.SINGLE_MO);
            for (RAMLManagedObject managedObject : managedObjects) {
                if (managedObject == parameter.getManagedObject()) continue;
                StringBuffer targetValue = new StringBuffer();
                for (RAMLOperation operation : operations) {
                    String parameterValue = RAMLLogicalValidatorBase.getParameterValue(managedObject, operation.getAllRelatedParameters().get(0).getListName(), operation.getAllRelatedParameters().get(0).getParamName(), null);
                    if (parameterValue == null) continue;
                    targetValue.append(String.valueOf(parameterValue) + "+");
                }
                if (!targetValue.toString().equals(valueToBeValidated)) continue;
                return false;
            }
        }
        return true;
    }

    private void validateCalculation(String conditionValue) {
        String targetValue = this.getCalculationValue();
        String ValueToBeValidated = this.getParameterToBeValidated().getValue();
        if (targetValue != null && !RAMLLogicalValidatorBase.isValueValid(conditionValue, targetValue, ValueToBeValidated)) {
            String details = String.valueOf(RAMLValidationErrorMessageFactory.generatedCalculationClauseStart(this.myMetaParameter, this.getParameterToBeValidated(), conditionValue, targetValue)) + this.getFormsOfCalculation(false) + RAMLValidationErrorMessageFactory.generateBecauseClause(this);
            RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationError(this.myMetaParameter, this.getParameterToBeValidated(), details);
            result.setText(this.getString("RAMLValidation.Incorrect.Parameter"));
            result.setRelationshipId(this.getRelationshipId());
            this.myValidationContext.addResult(result);
        }
    }

    private void validateList(RAMLValidationContext validationContext, RAMLMetaParameter metaData, RAMLList objectToBeValidated) {
        if (this.getValue() == null) {
            RamlConditionRelatedParameter parameter = this.getRelatedParameters().get(0);
            if (parameter.isValidationMatched()) {
                parameter.setRelationshipId(this.getRelationshipId());
                parameter.validate(validationContext, metaData, objectToBeValidated);
            }
        } else if (this.getValue().equals("UNIQUE")) {
            String scope = "";
            String parentMOName = "";
            String currentMOName = "";
            RAMLParameter currentParameter = this.getParameterToBeValidated();
            currentMOName = currentParameter == null ? this.getListToBeValidated().getManagedObject().getMOClass() : currentParameter.getManagedObject().getMOClass();
            if (this.getRelatedParameters().size() > 0) {
                RamlConditionRelatedParameter relatedParameter = this.getRelatedParameters().get(0);
                parentMOName = relatedParameter.getParentClass();
                scope = relatedParameter.hasScope() ? relatedParameter.getScope() : "";
                RamlConditionRelatedParameter parameter = this.getRelatedParameters().get(0);
                List<RAMLList> ramlLists = parameter.getTargetLists();
                if (this.hasSameList(ramlLists)) {
                    Object[] texts = new Object[]{objectToBeValidated.getName(), this.getDefinedScope(currentMOName, scope, parentMOName), RAMLValidationErrorMessageFactory.generateBecauseClause(this)};
                    RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationError(this.myMetaParameter, this.getListToBeValidated(), MessageFormat.format(this.getString("RAMLValidation.Unique.List.Details_Text"), texts));
                    result.setRelationshipId(this.getRelationshipId());
                    this.myValidationContext.addResult(result);
                }
            }
            if (this.getOperations() != null && this.getOperations().size() != 0) {
                ArrayList<String> concatenateParameters = new ArrayList<String>();
                for (RAMLOperation operation : this.getOperations()) {
                    RamlConditionRelatedParameter relatedParam = this.getOperations().get(0).getAllRelatedParameters().get(0);
                    parentMOName = relatedParam.getParentClass();
                    scope = relatedParam.getScope();
                    if (!operation.getOperationValue().trim().equals("CONCATENATE")) continue;
                    concatenateParameters.add(operation.getAllRelatedParameters().get(0).getParamName());
                }
                if (!this.isParameterConcatenateUniqueInList(objectToBeValidated, concatenateParameters)) {
                    String details = RAMLValidationErrorMessageFactory.createUniqueValidationErrorMessage(this, concatenateParameters, this.getDefinedScope(currentMOName, scope, parentMOName));
                    RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationError(this.myMetaParameter, this.getListToBeValidated(), details);
                    result.setRelationshipId(this.getRelationshipId());
                    this.myValidationContext.addResult(result);
                }
            }
        }
    }

    private boolean isParameterConcatenateUniqueInList(RAMLList objectToBeValidated, List<String> concatenateParameters) {
        ArrayList<String> concatenateList = new ArrayList<String>();
        for (Object obj : objectToBeValidated.getListObjects()) {
            if (!(obj instanceof RAMLItem)) continue;
            RAMLItem item = (RAMLItem)obj;
            StringBuilder builder = new StringBuilder();
            for (String parameter : concatenateParameters) {
                for (RAMLParameter p : item.getParameters()) {
                    if (!parameter.equals(p.getName())) continue;
                    if (p.isInteger()) {
                        builder.append(p.getValueAsInt());
                    } else {
                        builder.append(p.getValue());
                    }
                    builder.append("+");
                }
            }
            String valueToBeValidated = builder.toString();
            if ("".equals(valueToBeValidated)) continue;
            if (concatenateList.contains(valueToBeValidated)) {
                this.myValidationContext.setValidatedObject(item);
                return false;
            }
            concatenateList.add(valueToBeValidated);
        }
        return true;
    }

    private <T> boolean hasSameList(List<T> list) {
        if (this.isWithDuplicteItems(list)) {
            return true;
        }
        if (list.size() == 1 && list.get(0) instanceof RAMLList) {
            RAMLList ramlList = (RAMLList)list.get(0);
            List listObjects = ramlList.getListObjects();
            if (listObjects.size() == 1) {
                return false;
            }
            if (this.isWithDuplicteItems(listObjects)) {
                return true;
            }
        }
        return false;
    }

    private boolean isWithDuplicteItems(List listObjects) {
        int size = listObjects.size();
        int i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                if (listObjects.get(i).equals(listObjects.get(j))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private String getString(String key) {
        return this.myRB.getString(key);
    }

    public String getRelationshipId() {
        return this.myRelationshipId;
    }

    public void setRelationshipId(String relationshipId) {
        this.myRelationshipId = relationshipId;
    }

    public RAMLMetaParameter getMetaParameter() {
        return this.myMetaParameter;
    }
}

