/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RAMLDescription
implements Serializable {
    private static final long serialVersionUID = -8685195681429831398L;
    private List<String> myDescriptionParagraphs = new ArrayList<String>();

    public RAMLDescription(String description) {
        this.myDescriptionParagraphs.add(description);
    }

    public RAMLDescription(Node descriptionNode) {
        this.readDescription(descriptionNode);
    }

    public void readDescription(Node descriptionNode) {
        NodeList childNodes = descriptionNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("para")) {
                Node node = childNode.getFirstChild();
                if (node != null) {
                    this.myDescriptionParagraphs.add(node.getNodeValue());
                } else {
                    this.myDescriptionParagraphs.add("");
                }
            }
            ++i;
        }
    }

    public List<String> getDescriptionParagraphs() {
        return this.myDescriptionParagraphs;
    }

    public String getDescription() {
        return this.getDescription(" ");
    }

    public String getDescription(String separator) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.myDescriptionParagraphs.size()) {
            sb.append(this.myDescriptionParagraphs.get(i));
            if (i < this.myDescriptionParagraphs.size() - 1) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        return "Description: " + this.getDescription();
    }

    public String toXmlString() {
        StringBuilder tagData = new StringBuilder();
        tagData.append("<description>");
        tagData.append("\n");
        for (String para : this.myDescriptionParagraphs) {
            tagData.append("<para>");
            tagData.append(para);
            tagData.append("</para>");
            tagData.append("\n");
        }
        tagData.append("</description>");
        tagData.append("\n");
        return tagData.toString();
    }
}

