/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import java.io.Serializable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RAMLFeature
implements Serializable {
    private static final long serialVersionUID = 1808818885925669499L;
    private String myName;
    private String myType;

    public RAMLFeature(Node featureNode) {
        this.readAttributes(featureNode);
    }

    private void readAttributes(Node featureNode) {
        NamedNodeMap attributes = featureNode.getAttributes();
        this.myName = attributes.getNamedItem("name").getNodeValue();
        this.myType = attributes.getNamedItem("type").getNodeValue();
    }

    public boolean isStandard() {
        return this.myType.equals("standard");
    }

    public String getType() {
        return this.myType;
    }

    public String getName() {
        return this.myName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Feature name: ");
        sb.append(this.myName);
        sb.append(" type: ");
        sb.append(this.myType);
        return sb.toString();
    }

    public String toXmlString() {
        StringBuilder tagData = new StringBuilder();
        tagData.append("<feature");
        tagData.append(" type=\"");
        tagData.append(this.myType);
        tagData.append("\" name=\"");
        tagData.append(this.myName);
        tagData.append("\"");
        tagData.append("/>");
        tagData.append("\n");
        return tagData.toString();
    }
}

