/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLHWPropertySupplier;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLHWPropertyValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLLogicalValidatorBase;
import java.util.Optional;
import java.util.function.Supplier;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RAMLHWPropertyDefaultValidator
implements RAMLHWPropertyValidator {
    private Optional<String> myProperty = Optional.empty();
    private Optional<String> myValue = Optional.empty();
    private Optional<String> myValueOperation = Optional.empty();
    private Supplier<RAMLHWPropertySupplier> myPropertySupplier;

    public RAMLHWPropertyDefaultValidator(Supplier<RAMLHWPropertySupplier> propertySupplier, Node hwNode) {
        if (propertySupplier == null || hwNode == null) {
            throw new IllegalArgumentException();
        }
        this.myPropertySupplier = propertySupplier;
        Optional.ofNullable(hwNode.getAttributes()).ifPresent(attributes -> {
            this.myProperty = this.getNodeValue((NamedNodeMap)attributes, "property", () -> null);
            this.myValue = this.getNodeValue((NamedNodeMap)attributes, "value", () -> null);
            this.myValueOperation = this.getNodeValue((NamedNodeMap)attributes, "valueOperation", () -> "EQUAL");
        });
    }

    @Override
    public boolean validate() {
        return Optional.ofNullable(this.myPropertySupplier.get()).map(this::validate).orElse(false);
    }

    @Override
    public String getReason() {
        return this.myValueOperation.filter(RAMLLogicalValidatorBase::isComparativeOperation).map(this::getReason).orElse("");
    }

    private Optional<String> getNodeValue(NamedNodeMap namedNodeMap, String attribute, Supplier<String> defaultValue) {
        return Optional.ofNullable(namedNodeMap.getNamedItem(attribute)).map(item -> Optional.ofNullable(item.getNodeValue())).orElse(Optional.ofNullable(defaultValue.get()));
    }

    private Boolean validate(RAMLHWPropertySupplier propertySupplier) {
        return this.myProperty.map(property -> this.validate(propertySupplier, (String)property)).orElse(false);
    }

    private Boolean validate(RAMLHWPropertySupplier propertySupplier, String property) {
        String actualValue = propertySupplier.getValue(property);
        return RAMLLogicalValidatorBase.isValueValid(this.myValueOperation.get(), this.myValue.orElse(null), actualValue);
    }

    private String getReason(String operation) {
        return this.myProperty.map(property -> this.getReason(operation, (String)property)).orElse("");
    }

    private String getReason(String operation, String property) {
        return Optional.ofNullable(this.myPropertySupplier.get()).map(supplier -> supplier.getDisplayName(property)).map(name -> this.getValidationReason(operation, (String)name)).orElse("");
    }

    private String getValidationReason(String operation, String name) {
        return this.myValue.map(value -> RAMLValidationErrorMessageFactory.createHWValidationComparisonReason(operation, name, value)).orElse("");
    }
}

