/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import java.io.Serializable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RAMLInterface
implements Serializable {
    private static final long serialVersionUID = 7770990017302497600L;
    private String mySource;
    private String myTarget;
    private boolean myIsBidirectional;

    public RAMLInterface(Node interfaceNode) {
        this.readAttributes(interfaceNode);
    }

    private void readAttributes(Node interfaceNode) {
        NamedNodeMap attributes = interfaceNode.getAttributes();
        this.mySource = attributes.getNamedItem("source").getNodeValue();
        this.myTarget = attributes.getNamedItem("target").getNodeValue();
        Node bidirect = attributes.getNamedItem("bidirectional");
        this.myIsBidirectional = bidirect == null ? true : Boolean.parseBoolean(bidirect.getNodeValue());
    }

    public String getSource() {
        return this.mySource;
    }

    public String getTarget() {
        return this.myTarget;
    }

    public boolean isBidirectional() {
        return this.myIsBidirectional;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Interface source: ");
        sb.append(this.mySource);
        sb.append(" target: ");
        sb.append(this.myTarget);
        sb.append(" is bidirectional:");
        sb.append(this.myIsBidirectional);
        return sb.toString();
    }

    public String toXmlString() {
        StringBuilder tagData = new StringBuilder();
        tagData.append("<interface");
        tagData.append(" source=\"");
        tagData.append(this.mySource);
        tagData.append("\" target=\"");
        tagData.append(this.myTarget);
        tagData.append("\" bidirectional=\"");
        tagData.append(this.myIsBidirectional ? "yes" : "no");
        tagData.append("\"");
        tagData.append("/>");
        tagData.append("\n");
        return tagData.toString();
    }
}

