/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLInterface;
import java.io.Serializable;

public class RAMLInterfaceFilter
implements Serializable {
    private static final long serialVersionUID = 779569353287110051L;
    private String mySource;
    private String myTarget;
    private Field myFilteredFields;

    private RAMLInterfaceFilter(String source, String target) {
        this.mySource = source;
        this.myTarget = target;
        this.determineFilteredFields();
    }

    public static RAMLInterfaceFilter createFilterForSource(String source) {
        return new RAMLInterfaceFilter(source, "");
    }

    public static RAMLInterfaceFilter createFilterForTarget(String target) {
        return new RAMLInterfaceFilter("", target);
    }

    public static RAMLInterfaceFilter createFilter(String source, String target) {
        return new RAMLInterfaceFilter(source, target);
    }

    public boolean isMatch(RAMLInterface ramlInterface) {
        switch (this.myFilteredFields) {
            case SOURCE: {
                return this.mySource.equals(ramlInterface.getSource());
            }
            case TARGET: {
                return this.myTarget.equals(ramlInterface.getTarget());
            }
            case BOTH: {
                return this.mySource.equals(ramlInterface.getSource()) && this.myTarget.equals(ramlInterface.getTarget());
            }
        }
        return true;
    }

    private void determineFilteredFields() {
        this.myFilteredFields = "".equals(this.mySource) ? Field.SOURCE : ("".equals(this.myTarget) ? Field.TARGET : Field.BOTH);
    }

    public String getSource() {
        return this.mySource;
    }

    public String getTarget() {
        return this.myTarget;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Interface filter source: ");
        sb.append(this.mySource);
        sb.append(" target: ");
        sb.append(this.myTarget);
        return sb.toString();
    }

    private static enum Field {
        SOURCE,
        TARGET,
        BOTH;

    }
}

