/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.frameworks.raml.RAMLFileBase;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLChildManagedObject;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLInterfaceFilter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaHeader;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaManagedObject;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBitValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBooleanValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDecimalValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLEnumValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLIntegerValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLStringValidator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RAMLMetaDataFile
extends RAMLFileBase {
    private static final long serialVersionUID = 1779697591181485545L;
    private static final RAMLStringValidator VALIDATOR_STRING = new RAMLStringValidator();
    private static final RAMLEnumValidator VALIDATOR_ENUM = new RAMLEnumValidator();
    private static final RAMLBitValidator VALIDATOR_BIT = new RAMLBitValidator();
    private static final RAMLDecimalValidator VALIDATOR_DECIMAL = new RAMLDecimalValidator();
    private static final RAMLIntegerValidator VALIDATOR_INTEGER = new RAMLIntegerValidator();
    private static final RAMLBooleanValidator VALIDATOR_BOOLEAN = new RAMLBooleanValidator();
    private Map<String, RAMLMetaManagedObject> myMetaManagedObjects;
    private Map<String, RAMLMetaParameter> myMetaParameters;
    private RAMLMetaHeader myHeader;
    private Map<String, RAMLValidator> myValidators;
    private List<RAMLInterfaceFilter> myInterfaceFilters;
    private boolean myReadDeletedParameters = false;

    public RAMLMetaDataFile(String fileName) throws Exception, SAXException, IOException {
        this.init();
        this.readFrom(fileName);
    }

    public RAMLMetaDataFile(InputStream is) throws Exception, SAXException, IOException {
        this.init();
        this.readFrom(is);
    }

    public RAMLMetaDataFile(File file) throws Exception, SAXException, IOException {
        this.init();
        this.readFrom(file);
    }

    public RAMLMetaDataFile(File file, boolean readDeletedObjects) throws Exception, SAXException, IOException {
        this.myReadDeletedParameters = readDeletedObjects;
        this.init();
        this.readFrom(file);
    }

    public RAMLMetaDataFile(String fileName, Map<String, RAMLValidator> customValidators) throws Exception, SAXException, IOException {
        this.init();
        this.insertCustomValidators(customValidators);
        this.readFrom(fileName);
    }

    public RAMLMetaDataFile(InputStream is, Map<String, RAMLValidator> customValidators) throws Exception, SAXException, IOException {
        this.init();
        this.insertCustomValidators(customValidators);
        this.readFrom(is);
    }

    public RAMLMetaDataFile(File file, Map<String, RAMLValidator> customValidators, boolean readDeletedObjects) throws Exception, SAXException, IOException {
        this.myReadDeletedParameters = readDeletedObjects;
        this.init();
        this.insertCustomValidators(customValidators);
        this.readFrom(file);
    }

    public RAMLMetaDataFile(File file, Map<String, RAMLValidator> customValidators) throws Exception, SAXException, IOException {
        this.init();
        this.insertCustomValidators(customValidators);
        this.readFrom(file);
    }

    public void init() {
        this.myMetaManagedObjects = new HashMap<String, RAMLMetaManagedObject>();
        this.myMetaParameters = new HashMap<String, RAMLMetaParameter>();
        this.myValidators = new HashMap<String, RAMLValidator>();
        this.myInterfaceFilters = new ArrayList<RAMLInterfaceFilter>();
        this.initDefaultValidators();
    }

    private void initDefaultValidators() {
        this.myValidators.put("string", VALIDATOR_STRING);
        this.myValidators.put("integer", VALIDATOR_INTEGER);
        this.myValidators.put("bit", VALIDATOR_BIT);
        this.myValidators.put("boolean", VALIDATOR_BOOLEAN);
        this.myValidators.put("decimal", VALIDATOR_DECIMAL);
        this.myValidators.put("enumeration", VALIDATOR_ENUM);
    }

    public void setInterfaceFilters(RAMLInterfaceFilter ... filters) {
        this.myInterfaceFilters.clear();
        if (filters != null) {
            RAMLInterfaceFilter[] rAMLInterfaceFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                RAMLInterfaceFilter filter = rAMLInterfaceFilterArray[n2];
                this.myInterfaceFilters.add(filter);
                ++n2;
            }
        }
        for (RAMLMetaManagedObject metaM : this.getMetaManagedObjects()) {
            metaM.setInterfaceFilters(filters);
        }
    }

    public RAMLMetaManagedObject getMetaManagedObject(String className) {
        return this.myMetaManagedObjects.get(className);
    }

    public RAMLMetaManagedObject getRootMetaManagedObject() {
        List<RAMLMetaManagedObject> tmp = this.getMetaManagedObjects();
        for (RAMLMetaManagedObject mo : this.getMetaManagedObjects()) {
            boolean isRoot = true;
            for (RAMLMetaManagedObject comp : tmp) {
                for (RAMLChildManagedObject ch : comp.getChildManagedObjects()) {
                    if (!ch.getClassName().equals(mo.getClassName())) continue;
                    isRoot = false;
                }
            }
            if (!isRoot) continue;
            return mo;
        }
        return null;
    }

    public RAMLMetaParameter getMetaParameter(String pName) {
        return this.myMetaParameters.get(pName);
    }

    public RAMLMetaParameter getMetaParameter(String className, String pName) {
        RAMLMetaManagedObject tmp = this.getMetaManagedObject(className);
        return tmp != null ? tmp.getMetaParameter(pName) : null;
    }

    public List<RAMLMetaParameter> getMetaParameters() {
        ArrayList<RAMLMetaParameter> tmp = new ArrayList<RAMLMetaParameter>(this.myMetaParameters.size());
        tmp.addAll(this.myMetaParameters.values());
        return tmp;
    }

    public List<RAMLMetaManagedObject> getMetaManagedObjects() {
        ArrayList<RAMLMetaManagedObject> tmp = new ArrayList<RAMLMetaManagedObject>(this.myMetaManagedObjects.size());
        tmp.addAll(this.myMetaManagedObjects.values());
        return tmp;
    }

    public void addMetaManagedObject(String className, RAMLMetaManagedObject object) {
        if (!object.getMetaParameters().isEmpty()) {
            this.myMetaManagedObjects.put(className, object);
        }
    }

    public RAMLValidator getValidator(String validatorType) {
        return this.myValidators.get(validatorType);
    }

    public void setValidator(String key, RAMLValidator validator) {
        this.myValidators.put(key, validator);
    }

    public RAMLMetaHeader getHeader() {
        return this.myHeader;
    }

    private void insertCustomValidators(Map<String, RAMLValidator> customValidators) {
        this.myValidators.putAll(customValidators);
    }

    private void createMetaManagedObject(Node managedObject) {
        NamedNodeMap moAttributes = managedObject.getAttributes();
        RAMLMetaManagedObject mo = new RAMLMetaManagedObject(moAttributes, this);
        mo.readManagedObject(managedObject, this.myReadDeletedParameters);
        this.addMetaManagedObject(mo.getClassName(), mo);
    }

    private void createHeader(Node header) {
        this.myHeader = new RAMLMetaHeader(header);
    }

    @Override
    public void buildModel(Document doc) {
        Node ramlNode = doc.getElementsByTagName("pdmeta").item(0);
        Node ramlChildNode = null;
        NodeList ramlChildNodes = ramlNode.getChildNodes();
        int i = 0;
        while (i < ramlChildNodes.getLength()) {
            ramlChildNode = ramlChildNodes.item(i);
            if (ramlChildNode.getNodeName().equals("managedObject")) {
                this.createMetaManagedObject(ramlChildNode);
            } else if (ramlChildNode.getNodeName().equals("header")) {
                this.createHeader(ramlChildNode);
            }
            ++i;
        }
    }

    @Override
    public void destroy() {
        this.clear();
        super.destroy();
    }

    @Override
    protected void clear() {
        this.myMetaManagedObjects.clear();
        this.myMetaParameters.clear();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Metadata file content:\n");
        sb.append(this.myHeader);
        sb.append("\n");
        for (RAMLMetaManagedObject mo : this.getMetaManagedObjects()) {
            sb.append(mo.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBuilder tagData = new StringBuilder();
        tagData.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        tagData.append("\n");
        tagData.append("<pdmeta version=\"2.2\">");
        tagData.append("\n");
        tagData.append(this.myHeader.toXmlString());
        for (RAMLMetaManagedObject metaMO : this.myMetaManagedObjects.values()) {
            tagData.append(metaMO.toXmlString());
        }
        tagData.append("</pdmeta>");
        return tagData.toString();
    }
}

