/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLDescription;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaRelease;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RAMLMetaHeader
implements Serializable {
    private static final long serialVersionUID = -2387776097153038765L;
    private String myDomain;
    private String myProduct;
    private String myRelease;
    private String myVersion;
    private RAMLDescription myDescription;
    private RAMLMetaRelease myApplicationRelease;
    private List<RAMLMetaRelease> myPlatformReleases = new ArrayList<RAMLMetaRelease>();

    public RAMLMetaHeader(Node headerNode) {
        this.readHeader(headerNode);
    }

    public void readHeader(Node headerNode) {
        NamedNodeMap attributes = headerNode.getAttributes();
        this.myDomain = attributes.getNamedItem("domain").getNodeValue();
        this.myProduct = attributes.getNamedItem("product").getNodeValue();
        this.myRelease = attributes.getNamedItem("release").getNodeValue();
        this.myVersion = attributes.getNamedItem("version").getNodeValue();
        NodeList childNodes = headerNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            if ("description".equals(nodeName)) {
                this.myDescription = new RAMLDescription(childNode);
            } else if ("applicationRelease".equals(nodeName)) {
                this.myApplicationRelease = new RAMLMetaRelease(childNode);
            } else if ("platformReleases".equals(nodeName)) {
                this.readPlatformReleases(childNode);
            }
            ++i;
        }
    }

    private void readPlatformReleases(Node platformReleases) {
        NodeList childNodes = platformReleases.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            if ("platformRelease".equals(nodeName)) {
                this.myPlatformReleases.add(new RAMLMetaRelease(childNode));
            }
            ++i;
        }
    }

    public String getDomain() {
        return this.myDomain;
    }

    public String getProduct() {
        return this.myProduct;
    }

    public String getRelease() {
        return this.myRelease;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public RAMLDescription getDescription() {
        return this.myDescription;
    }

    public Optional<RAMLMetaRelease> getApplicationRelease() {
        return Optional.ofNullable(this.myApplicationRelease);
    }

    public List<RAMLMetaRelease> getPlaformReleases() {
        return Collections.unmodifiableList(this.myPlatformReleases);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Header domain: ");
        sb.append(this.myDomain);
        sb.append(" product: ");
        sb.append(this.myProduct);
        sb.append(" release: ");
        sb.append(this.myRelease);
        sb.append(" version: ");
        sb.append(this.myVersion);
        sb.append(" ");
        sb.append(this.myDescription);
        return sb.toString();
    }

    public String toXmlString() {
        StringBuilder tagData = new StringBuilder();
        tagData.append("<header");
        tagData.append(" domain=\"");
        tagData.append(this.getDomain());
        tagData.append("\" product=\"");
        tagData.append(this.getProduct());
        tagData.append("\" release=\"");
        tagData.append(this.getRelease());
        tagData.append("\" version=\"");
        tagData.append(this.getVersion());
        tagData.append("\"");
        tagData.append(">");
        tagData.append("\n");
        if (this.myApplicationRelease != null) {
            tagData.append(this.myApplicationRelease.toXmlString());
            tagData.append("\n");
        }
        if (!this.myPlatformReleases.isEmpty()) {
            tagData.append("<platformReleases>\n");
            this.myPlatformReleases.stream().forEach(myPlatformRelease -> {
                tagData.append(myPlatformRelease.toXmlString());
                tagData.append("\n");
            });
            tagData.append("</platformReleases>\n");
        }
        if (this.myDescription != null) {
            tagData.append(this.myDescription.toXmlString());
        }
        tagData.append("</header>");
        return tagData.toString();
    }
}

