/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLHelpper;
import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLItemList;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLChildManagedObject;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLDescription;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLInterface;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLInterfaceFilter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaDataFile;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLProductData;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLLogicalValidatorBase;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLComplexType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.util.GeneralUtils;
import com.nokia.em.poseidon.util.TextUtils;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.log4j.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RAMLMetaManagedObject
implements Serializable {
    private static final long serialVersionUID = -3532020074588790177L;
    private static final String SPACE = " ";
    private String myClass;
    private String myFullName;
    private String myVersion;
    private List<RAMLChildManagedObject> myChildManagedObjects;
    private RAMLDescription myDescription;
    private Map<String, RAMLMetaParameter> myMetaParameters;
    private RAMLMetaParameter myInstanceParameter;
    private RAMLMetaDataFile myMetaFile;
    private transient Logger myLogger;
    private List<RAMLInterfaceFilter> myInterfaceFilters;
    private List<RAMLInterface> myInterfaces;
    private transient ResourceBundle myResourceBundle;
    private Map myProperties;
    private String myPrefix = "";
    private String myRelease = "";

    public RAMLMetaManagedObject(String className, RAMLMetaDataFile metaFile) {
        this.readClassNameAndPrefix(className);
        this.myMetaFile = metaFile;
        this.myLogger = Logger.getLogger(this.getClass());
        this.myInterfaces = new ArrayList<RAMLInterface>();
        this.myInterfaceFilters = new ArrayList<RAMLInterfaceFilter>();
        this.myChildManagedObjects = new ArrayList<RAMLChildManagedObject>();
        this.myMetaParameters = new HashMap<String, RAMLMetaParameter>();
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.myProperties = new HashMap();
    }

    public RAMLMetaManagedObject(NamedNodeMap moAttributes, RAMLMetaDataFile metaFile) {
        this(moAttributes.getNamedItem("class").getNodeValue(), metaFile);
        this.myFullName = moAttributes.getNamedItem("fullName").getNodeValue() == null ? "" : moAttributes.getNamedItem("fullName").getNodeValue();
    }

    private void readClassNameAndPrefix(String className) {
        int colonIndex = className.indexOf(":");
        if (colonIndex >= 0) {
            this.myClass = className.substring(colonIndex + 1);
            this.myPrefix = className.substring(0, colonIndex);
        } else {
            this.myClass = className;
        }
    }

    public String getFullName() {
        return this.myFullName;
    }

    public void setInterfaceFilters(RAMLInterfaceFilter ... filters) {
        this.myInterfaceFilters.clear();
        if (filters != null) {
            RAMLInterfaceFilter[] rAMLInterfaceFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                RAMLInterfaceFilter filter = rAMLInterfaceFilterArray[n2];
                this.myInterfaceFilters.add(filter);
                ++n2;
            }
        }
    }

    public RAMLMetaParameter getMetaParameter(String pName) {
        return this.myMetaParameters.get(pName);
    }

    public RAMLMetaParameter getInstanceParameter() {
        return this.myInstanceParameter;
    }

    public RAMLMetaParameter getMetaParameterFromList(String listName, String pName) {
        RAMLMetaParameter p = this.myMetaParameters.get(listName);
        if (p != null && !p.isSimpleType()) {
            RAMLComplexType complexType = (RAMLComplexType)p.getValueType();
            return complexType.getParameter(pName);
        }
        return null;
    }

    public String getClassName() {
        return this.myClass;
    }

    public List<RAMLMetaParameter> getMetaParameters() {
        return new ArrayList<RAMLMetaParameter>(this.myMetaParameters.values());
    }

    public void readManagedObject(Node metaManagedObject, boolean readDeletedObjects) {
        NamedNodeMap moAttributes = metaManagedObject.getAttributes();
        Node version = moAttributes.getNamedItem("version");
        this.myVersion = version == null ? "" : version.getNodeValue();
        Node release = moAttributes.getNamedItem("release");
        this.myRelease = release == null ? "" : release.getNodeValue();
        int i = 0;
        while (i < moAttributes.getLength()) {
            Node attribute = moAttributes.item(i);
            if (attribute != null) {
                this.setProperty(attribute.getNodeName(), attribute.getNodeValue());
            }
            ++i;
        }
        NodeList childNodes = metaManagedObject.getChildNodes();
        Node childNode = null;
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            childNode = childNodes.item(i2);
            if (childNode.getNodeName().equals("description")) {
                this.createDescription(childNode);
            } else if (childNode.getNodeName().equals("p")) {
                this.createParameter(childNode, readDeletedObjects);
            } else if (childNode.getNodeName().equals("interfaces")) {
                this.createInterFaces(childNode);
            } else if (childNode.getNodeName().equals("childManagedObject")) {
                this.createChildManagedObject(childNode);
            }
            ++i2;
        }
    }

    public void readManagedObject(Node metaManagedObject) {
        this.readManagedObject(metaManagedObject, true);
    }

    public void setProperty(String key, Object value) {
        this.myProperties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.myProperties.get(key);
    }

    private void createInterFaces(Node interfacesNode) {
        NodeList childNodes = interfacesNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("interface")) {
                this.myInterfaces.add(new RAMLInterface(childNode));
            }
            ++i;
        }
    }

    private void createDescription(Node descNode) {
        this.myDescription = new RAMLDescription(descNode);
    }

    private void createParameter(Node pNode, boolean readDeletedObjects) {
        RAMLMetaParameter p = new RAMLMetaParameter(pNode, this);
        if (!readDeletedObjects && p.isDeleted()) {
            return;
        }
        if (p.isInstanceParameter() && !p.isDeleted()) {
            this.myInstanceParameter = p;
        }
        this.myMetaParameters.put(p.getName(), p);
    }

    private void createChildManagedObject(Node childMO) {
        this.myChildManagedObjects.add(new RAMLChildManagedObject(childMO));
    }

    public String getVersion() {
        return this.myVersion;
    }

    public List<RAMLInterface> getInterfaces() {
        return this.myInterfaces;
    }

    public List<RAMLChildManagedObject> getChildManagedObjects() {
        return this.myChildManagedObjects;
    }

    public RAMLDescription getDescription() {
        return this.myDescription;
    }

    public RAMLValidator getValidator(String validatorKey) {
        return this.myMetaFile.getValidator(validatorKey);
    }

    public RAMLMetaDataFile getMetaDataFile() {
        return this.myMetaFile;
    }

    public synchronized void validate(RAMLValidationContext validationContext, RAMLManagedObject moToBeValidated) {
        if (Boolean.TRUE.equals(moToBeValidated.getProperty("Do not validate this object")) || Boolean.TRUE.equals(this.getProperty("Do not validate this object")) || RAMLHelpper.skipThisMOValidation(this.getMetaDataFile(), moToBeValidated)) {
            this.myLogger.debug(String.valueOf(this.getClassName()) + " validation skipped because DO_NOT_VALIDATE flag");
            return;
        }
        this.validateMetaDataRules(validationContext, moToBeValidated);
        this.validateExtraRAMLFields(validationContext, moToBeValidated);
    }

    private boolean hasValidInterface(List<RAMLInterface> interfaces) {
        if (this.myInterfaceFilters.size() == 0) {
            return true;
        }
        for (RAMLInterfaceFilter filter : this.myInterfaceFilters) {
            for (RAMLInterface rInterface : interfaces) {
                if (!filter.isMatch(rInterface)) continue;
                return true;
            }
        }
        return false;
    }

    private void validateMetaDataRules(RAMLValidationContext validationContext, RAMLManagedObject moToBeValidated) {
        for (RAMLMetaParameter metaP : this.getMetaParameters()) {
            boolean isValidatedForMandatory;
            boolean isValueEmpty;
            if (metaP.isDeleted() || metaP.isHidden() || metaP.isInstanceParameter() || !this.hasValidInterface(metaP.getInterfaces()) || metaP.isSetByTheSystem() || metaP.isUnChangeable()) continue;
            metaP.clearCache();
            RAMLParameter parameter = moToBeValidated.getParameter(metaP.getName());
            RAMLList<?> list = moToBeValidated.getList(metaP.getName());
            boolean hasMandatoryCheck = metaP.hasMandatoryCheck(moToBeValidated);
            boolean isMandatory = metaP.isMandatory() || hasMandatoryCheck;
            boolean bl = isValueEmpty = parameter != null && "".equals(parameter.getValue().trim());
            if (!isMandatory && isValueEmpty) continue;
            boolean isValidatedForMinOccurs = metaP.hasMinOccursCheck(moToBeValidated) && parameter == null && list == null;
            boolean bl2 = isValidatedForMandatory = isMandatory && (isValueEmpty || parameter == null && list == null) && metaP.isCommissionable();
            if (isValidatedForMinOccurs || isValidatedForMandatory) {
                List<SortedSet<String>> reasons = metaP.getReasons();
                List<String> relationshipIds = metaP.getRelationshipIds();
                if (metaP.isMandatory() || reasons.isEmpty()) {
                    this.createMandatoryErrors(validationContext, moToBeValidated, metaP, list, "", null);
                    continue;
                }
                int index = 0;
                while (index < reasons.size()) {
                    this.createMandatoryErrors(validationContext, moToBeValidated, metaP, list, reasons.get(index), relationshipIds.get(index));
                    ++index;
                }
                continue;
            }
            if (parameter != null) {
                metaP.validate(validationContext, parameter);
                continue;
            }
            if (list == null) continue;
            if (metaP.isSimpleType() && list instanceof RAMLParameterList) {
                validationContext.setValidatedObject(list);
                RAMLParameterList pList = (RAMLParameterList)list;
                List<RAMLParameter> pListParameters = pList.getParameters();
                metaP.validateRelatedConditions(validationContext, list);
                if (pListParameters.size() > metaP.getMaxOccurs()) {
                    Object[] values = new Object[]{pList.getName(), pListParameters.size(), metaP.getMaxOccurs()};
                    RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationError(pList.getMetaData(), pList, MessageFormat.format(this.myResourceBundle.getString("RAMLValidation.Too.Many.Parameters"), values));
                    result.setText(this.myResourceBundle.getString("RAMLValidation.Incorrect.Parameter"));
                    validationContext.addResult(result);
                } else if (!metaP.isMandatory()) {
                    this.checkIfTheListContainsAtLeastOneItem(metaP, pList, validationContext);
                }
                RAMLSimpleType simpleType = (RAMLSimpleType)metaP.getValueType();
                int i = 0;
                while (i < pListParameters.size()) {
                    validationContext.setValidatedObjectIndex(i);
                    RAMLParameter tmp = pListParameters.get(i);
                    String listParamName = MessageFormat.format(this.myResourceBundle.getString("RAMLValidation.List.Parameter.Name.Index"), pList.getName(), Integer.toString(i + 1));
                    simpleType.putProperty("listName", listParamName);
                    if (metaP.isMandatory() && "".equals(tmp.getValue().trim())) {
                        Object[] values = new Object[]{metaP.getName(), metaP.getFullName()};
                        RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationError(metaP, tmp, MessageFormat.format(this.myResourceBundle.getString("RAMLValidation.Missing.Mandatory.Parameter"), values));
                        validationContext.addResult(result);
                    } else {
                        try {
                            simpleType.validate(validationContext, metaP, tmp);
                        }
                        catch (Exception e) {
                            Object[] values = new Object[]{metaP.getName(), metaP.getFullName()};
                            RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationError(metaP, tmp, MessageFormat.format(this.myResourceBundle.getString("RAMLValidation.Cannot.Validate"), values));
                            validationContext.addResult(result);
                        }
                    }
                    ++i;
                }
                continue;
            }
            if (list.getListObjects() == null || list.getListObjects().size() <= 0) continue;
            metaP.validate(validationContext, list);
        }
    }

    private void checkIfTheListContainsAtLeastOneItem(RAMLMetaParameter metaP, RAMLParameterList pList, RAMLValidationContext validationContext) {
        boolean isInvalid;
        List<RAMLParameter> pListParameters = pList.getParameters();
        boolean bl = isInvalid = pListParameters.isEmpty() || !pListParameters.stream().anyMatch(param -> !TextUtils.isNullOrEmpty(param.getValue()));
        if (isInvalid) {
            Object[] values = new Object[]{metaP.getName(), metaP.getFullName(), metaP.getMetaManagedObject().getClassName()};
            RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationError(metaP, pList, MessageFormat.format(this.myResourceBundle.getString("RAMLValidation.List.AtLeastOneConfigured"), values));
            result.setText(this.myResourceBundle.getString("RAMLValidation.Incorrect.Parameter"));
            validationContext.addResult(result);
        }
    }

    private void createMandatoryErrors(RAMLValidationContext validationContext, RAMLManagedObject moToBeValidated, RAMLMetaParameter metaP, RAMLList<?> list, SortedSet<String> reasons, String relationshipId) {
        String reason = RAMLValidationErrorMessageFactory.concatenateReasons(reasons);
        this.createMandatoryErrors(validationContext, moToBeValidated, metaP, list, reason, relationshipId);
    }

    private void createMandatoryErrors(RAMLValidationContext validationContext, RAMLManagedObject moToBeValidated, RAMLMetaParameter metaP, RAMLList<?> list, String reason, String relationshipId) {
        String details = RAMLValidationErrorMessageFactory.createMandatoryErrorMessageForRAMLManagedObject(moToBeValidated, metaP, list, reason);
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
        result.setParameterName(metaP.getName());
        result.setDistName(moToBeValidated.getDistName());
        result.setVersion(moToBeValidated.getVersion());
        result.setText(this.myResourceBundle.getString("RAMLValidation.Incomplete.Configuration"));
        result.setRelationshipId(relationshipId);
        result.setDetails(details);
        validationContext.addResult(result);
        result.setSource(moToBeValidated);
    }

    private void validateExtraRAMLFields(RAMLValidationContext validationContext, RAMLManagedObject moToBeValidated) {
        Comparable<RAMLParameter> tmp;
        List<RAMLParameter> moParams = moToBeValidated.getParameters();
        List<RAMLList<?>> moList = moToBeValidated.getLists();
        int i = 0;
        while (i < moParams.size()) {
            tmp = moParams.get(i);
            if (this.getMetaParameter(((RAMLParameter)tmp).getName()) == null) {
                this.createMissingMetaDataError(validationContext, moToBeValidated, ((RAMLParameter)tmp).getName(), null);
            }
            ++i;
        }
        i = 0;
        while (i < moList.size()) {
            tmp = moList.get(i);
            if (tmp instanceof RAMLParameterList) {
                if (this.getMetaParameter(((RAMLList)tmp).getName()) == null) {
                    this.createMissingMetaDataError(validationContext, moToBeValidated, ((RAMLList)tmp).getName(), null);
                }
            } else {
                this.validateItemListParameters((RAMLItemList)tmp, validationContext, moToBeValidated);
            }
            ++i;
        }
    }

    private void createMissingMetaDataError(RAMLValidationContext validationContext, RAMLManagedObject moToBeValidated, String parameterName, String listName) {
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.WARNING);
        result.setParameterName(parameterName);
        result.setDistName(moToBeValidated.getDistName());
        result.setVersion(moToBeValidated.getVersion());
        result.setText(this.myResourceBundle.getString("RAMLValidation.Incomplete.Configuration"));
        if (listName == null) {
            Object[] values = new Object[]{parameterName};
            result.setDetails(MessageFormat.format(this.myResourceBundle.getString("RAMLValidation.Unknown.Parameter"), values));
        } else {
            Object[] values = new Object[]{parameterName, listName};
            result.setDetails(MessageFormat.format(this.myResourceBundle.getString("RAMLValidation.Unknown.List.Parameter"), values));
        }
        validationContext.addResult(result);
    }

    private void validateItemListParameters(RAMLItemList ramlItemList, RAMLValidationContext validationContext, RAMLManagedObject moToBeValidated) {
        RAMLItemList itemList = ramlItemList;
        List<RAMLItem> items = itemList.getItems();
        int i = 0;
        while (i < items.size()) {
            RAMLItem tmpItem = items.get(i);
            validationContext.setValidatedObject(tmpItem);
            List<RAMLParameter> params = tmpItem.getParameters();
            int j = 0;
            while (j < params.size()) {
                RAMLParameter tmpParameter = params.get(j);
                if (this.getMetaParameterFromList(itemList.getName(), tmpParameter.getName()) == null) {
                    this.createMissingMetaDataError(validationContext, moToBeValidated, tmpParameter.getName(), itemList.getName());
                }
                ++j;
            }
            ++i;
        }
        validationContext.setValidatedObject(null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Managed object ");
        sb.append(this.myClass);
        sb.append(" content:\n");
        sb.append(" child MOs: ");
        sb.append(this.myChildManagedObjects);
        sb.append(" version ");
        sb.append(this.myVersion);
        for (RAMLMetaParameter p : this.getMetaParameters()) {
            sb.append(p.toString());
            sb.append("\n");
        }
        sb.append(SPACE);
        return sb.toString();
    }

    public String toXmlString() {
        String id;
        StringBuilder tagData = new StringBuilder();
        tagData.append("<managedObject");
        tagData.append(" class=\"");
        if (!GeneralUtils.isEmptyString(this.myPrefix)) {
            tagData.append(this.myPrefix);
            tagData.append(":");
        }
        tagData.append(this.myClass);
        tagData.append("\"");
        if (this.myVersion != null) {
            tagData.append(" version=\"");
            tagData.append(this.myVersion);
            tagData.append("\"");
        }
        if ((id = (String)this.getProperty("id")) != null) {
            tagData.append(" id=\"");
            tagData.append((String)this.getProperty("id"));
            tagData.append("\"");
        }
        tagData.append(">");
        tagData.append("\n");
        if (this.myDescription != null) {
            tagData.append(this.myDescription.toXmlString());
        }
        for (RAMLChildManagedObject child : this.myChildManagedObjects) {
            tagData.append(child.toXmlString());
        }
        for (RAMLMetaParameter p : this.myMetaParameters.values()) {
            tagData.append(p.toXmlString());
        }
        tagData.append("</managedObject>");
        return tagData.toString();
    }

    public int getMinOccurs() {
        RAMLMetaParameter instanceP = this.getInstanceParameter();
        int minOccurs = 0;
        if (instanceP != null) {
            List<RAMLProductData> pDataList = instanceP.getProductData();
            for (RAMLProductData pData : pDataList) {
                String strMinOccurs = pData.getProperties().get("MO MinOccurs");
                if (strMinOccurs == null) continue;
                return Integer.valueOf(strMinOccurs);
            }
        }
        return minOccurs;
    }

    public int getMaxOccurs() {
        RAMLMetaParameter instanceP = this.getInstanceParameter();
        int maxOccurs = -1;
        if (instanceP != null) {
            List<RAMLProductData> pDataList = instanceP.getProductData();
            for (RAMLProductData pData : pDataList) {
                String strMaxOccurs = pData.getProperties().get("MO MaxOccurs");
                if (strMaxOccurs == null) continue;
                return Integer.valueOf(strMaxOccurs);
            }
        }
        return maxOccurs;
    }

    public String[] getMOLTEHW(String hwDataName) {
        List<RAMLProductData> productDatas;
        RAMLMetaParameter instanceParameter = this.getInstanceParameter();
        if (instanceParameter != null && (productDatas = instanceParameter.getProductData()) != null) {
            for (RAMLProductData data : productDatas) {
                String hwType = data.getProperties().get(hwDataName);
                if (hwType == null) continue;
                return hwType.split(",");
            }
        }
        return null;
    }

    public String getTotalAmount() {
        RAMLMetaParameter instanceP = this.getInstanceParameter();
        String retVal = null;
        if (instanceP != null) {
            List<RAMLProductData> pDataList = instanceP.getProductData();
            for (RAMLProductData pData : pDataList) {
                retVal = pData.getProperties().get("MO TotalAmount");
                if (retVal == null) continue;
                return retVal;
            }
        }
        return retVal;
    }

    public String getPrefix() {
        return this.myPrefix;
    }

    public String getRelease() {
        return this.myRelease;
    }
}

