/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLDefaultParameterFilter;
import com.nokia.em.poseidon.frameworks.raml.RAMLHelpper;
import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.DefaultRAMLSimpleTypeCreator;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLDescription;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLFeature;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLInterface;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaManagedObject;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLParameterFilter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLProductData;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLReference;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLRelatedConditions;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLRelatedFunctions;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLRelatedParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLRelatedParams;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLSimpleTypeCreator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLComplexType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDecimal;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RAMLMetaParameter
implements Comparable<RAMLMetaParameter>,
Serializable {
    private static final long serialVersionUID = 4304039843114863558L;
    private String myName;
    private String myFullName;
    private String myGroup;
    private int myMaxOccurs;
    private boolean myLocked;
    private String myValidationRule;
    private String myValidationPattern;
    private String myRegularExpression;
    private Pattern myCompiledRegularExpressionPattern;
    private String myStatus;
    private boolean myHiddenState;
    private String my3GPPName;
    private RAMLDescription myDescription;
    private RAMLDescription myShortDescription;
    private RAMLRelatedFunctions myRelatedFunctions;
    private List<RAMLInterface> myInterfaces;
    private List<RAMLFeature> myFeatures;
    private List<RAMLReference> myReferences;
    private List<RAMLProductData> myProductData;
    private RAMLRelatedParams myRelatedParams;
    private RAMLRelatedConditions myRelatedConditions;
    private String myCreationType;
    private String myModificationType;
    private List<String> myParameterCategories;
    private RAMLValue myValueType;
    private RAMLMetaManagedObject myMetaMO;
    private RAMLSimpleTypeCreator mySimpleTypeCreator;
    private transient ResourceBundle myResourceBundle;
    private String myParentParamName = null;
    private boolean myInstanceParameter = false;
    private boolean myDefaultNoGuiSupport;
    private String myRelationshipIdForMandatoryCheck = null;
    private Map<Object, Boolean> myBasicCheckCache = new HashMap<Object, Boolean>();
    private transient RAMLParameterFilter myRamlParameterFilter;

    public RAMLMetaParameter(Node paramNode, RAMLMetaManagedObject metaMO) {
        this.myMetaMO = metaMO;
        this.myLocked = false;
        this.myInterfaces = new ArrayList<RAMLInterface>();
        this.myReferences = new ArrayList<RAMLReference>();
        this.myFeatures = new ArrayList<RAMLFeature>();
        this.myParameterCategories = new ArrayList<String>();
        this.myProductData = new ArrayList<RAMLProductData>();
        this.myRelatedParams = new RAMLRelatedParams();
        this.myRelatedFunctions = new RAMLRelatedFunctions();
        this.myRelatedConditions = new RAMLRelatedConditions();
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.mySimpleTypeCreator = RAMLHelpper.getGlobalProperty("simpleDataCreator") == null ? new DefaultRAMLSimpleTypeCreator() : (RAMLSimpleTypeCreator)RAMLHelpper.getGlobalProperty("simpleDataCreator");
        this.readParameter(paramNode);
        this.myInstanceParameter = this.calculateInstanceParameter();
        this.myDefaultNoGuiSupport = this.hasNoGuiSupportParameter();
        this.myBasicCheckCache = new HashMap<Object, Boolean>();
        this.myRamlParameterFilter = this.getParameterFilter();
    }

    private RAMLParameterFilter getParameterFilter() {
        RAMLParameterFilter filter = PoseidonRuntime.getRuntime().getObject(RAMLParameterFilter.class);
        if (filter == null) {
            return RAMLDefaultParameterFilter.getInstance();
        }
        return filter;
    }

    private void readParameter(Node paramNode) {
        Node parentNode = paramNode.getParentNode();
        if ("complexType".equals(parentNode.getNodeName())) {
            this.myParentParamName = parentNode.getParentNode().getAttributes().getNamedItem("name").getNodeValue();
        }
        this.readAttributes(paramNode);
        this.readChildNodes(paramNode);
    }

    private void readAttributes(Node paramNode) {
        NamedNodeMap attributes = paramNode.getAttributes();
        this.myName = attributes.getNamedItem("name").getNodeValue();
        this.myFullName = attributes.getNamedItem("fullName").getNodeValue();
        this.myMaxOccurs = Integer.parseInt(attributes.getNamedItem("maxOccurs").getNodeValue());
        this.myStatus = attributes.getNamedItem("status").getNodeValue();
        Node hidden = attributes.getNamedItem("hidden");
        this.myHiddenState = hidden == null ? false : Boolean.parseBoolean(hidden.getNodeValue());
        Node tgppName = attributes.getNamedItem("tgppName");
        this.my3GPPName = tgppName == null ? "" : tgppName.getNodeValue();
        Node group = attributes.getNamedItem("group");
        this.myGroup = group == null ? "" : group.getNodeValue();
    }

    private void readChildNodes(Node paramNode) {
        NodeList childNodes = paramNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("description") || nodeName.equals("shortDesc")) {
                this.createDescription(childNode);
            } else if (nodeName.equals("interfaces")) {
                this.createInterFaces(childNode);
            } else if (nodeName.equals("features")) {
                this.createFeatures(childNode);
            } else if (nodeName.equals("creation")) {
                this.createCreationType(childNode);
            } else if (nodeName.equals("modification")) {
                this.createModificationType(childNode);
            } else if (nodeName.equals("parameterCategories")) {
                this.createParameterCategory(childNode);
            } else if (nodeName.equals("simpleType")) {
                this.myValueType = this.mySimpleTypeCreator.createSimpleTypeValue(this, childNode, paramNode);
            } else if (nodeName.equals("complexType")) {
                this.myValueType = this.createComplexTypeValue(childNode);
            } else if (nodeName.equals("references")) {
                this.createReferences(childNode);
            } else if (nodeName.equals("relatedParameters")) {
                this.myRelatedParams.readRelatedParameters(childNode);
            } else if (nodeName.equals("productData")) {
                this.myProductData.add(new RAMLProductData(childNode));
            } else if (nodeName.equals("relatedFunctions")) {
                this.myRelatedFunctions.readRelatedFunctions(childNode);
            } else if (nodeName.equals("relatedConditions")) {
                this.myRelatedConditions.readChildNodes(childNode);
            } else if (nodeName.equals("validationRule")) {
                this.myValidationRule = childNode.getTextContent();
            } else if (nodeName.equals("validationPattern")) {
                this.myValidationPattern = childNode.getTextContent();
            } else if (nodeName.equals("regularExpression")) {
                this.myRegularExpression = childNode.getTextContent();
            }
            ++i;
        }
    }

    private void createFeatures(Node featuresNode) {
        NodeList childNodes = featuresNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("feature")) {
                this.myFeatures.add(new RAMLFeature(childNode));
            }
            ++i;
        }
    }

    private void createReferences(Node referenceNode) {
        NodeList childNodes = referenceNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("reference")) {
                this.myReferences.add(new RAMLReference(childNode));
            }
            ++i;
        }
    }

    private void createParameterCategory(Node parameterCategories) {
        NodeList childNodes = parameterCategories.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            NamedNodeMap attributes;
            Node func;
            childNode = childNodes.item(i);
            if ("parameterCategory".equals(childNode.getNodeName()) && (func = (attributes = childNode.getAttributes()).getNamedItem("name")) != null) {
                this.myParameterCategories.add(func.getNodeValue());
            }
            ++i;
        }
    }

    public RAMLMetaManagedObject getMetaManagedObject() {
        return this.myMetaMO;
    }

    private RAMLComplexType createComplexTypeValue(Node complexTypeNode) {
        return new RAMLComplexType(complexTypeNode, this.myMetaMO);
    }

    private void createModificationType(Node modificationNode) {
        NamedNodeMap attributes = modificationNode.getAttributes();
        this.myModificationType = attributes.getNamedItem("type").getNodeValue();
    }

    private void createCreationType(Node creationNode) {
        NamedNodeMap attributes = creationNode.getAttributes();
        this.myCreationType = attributes.getNamedItem("priority").getNodeValue();
    }

    private void createInterFaces(Node interfacesNode) {
        NodeList childNodes = interfacesNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("interface")) {
                this.myInterfaces.add(new RAMLInterface(childNode));
            }
            ++i;
        }
    }

    public boolean isUniDirectional(String src, String target) {
        for (RAMLInterface intf : this.getInterfaces()) {
            if (intf.isBidirectional() || !src.equals(intf.getSource()) || !target.equals(intf.getTarget())) continue;
            return true;
        }
        return false;
    }

    public boolean isUnChangeable() {
        return this.myRamlParameterFilter.isUnchangeable(this);
    }

    public boolean isCommissionable() {
        return this.myRamlParameterFilter.isCommissionable(this);
    }

    private void createDescription(Node childNode) {
        RAMLDescription desc = new RAMLDescription(childNode);
        if (childNode.getNodeName().equals("description")) {
            this.myDescription = desc;
        } else {
            this.myShortDescription = desc;
        }
    }

    private boolean hasNoGuiSupportParameter() {
        for (RAMLProductData data : this.myProductData) {
            if (!Boolean.parseBoolean(data.getValueWithKeyPhrase("addDefaultNoGuiSupport"))) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.myName;
    }

    public String getGroup() {
        return this.myGroup;
    }

    public boolean isVendorSpecific() {
        for (RAMLProductData p : this.myProductData) {
            if (!p.isVendorSpecific()) continue;
            return true;
        }
        return false;
    }

    public boolean isPrintableString() {
        for (RAMLProductData p : this.myProductData) {
            if (!p.isPrintableString()) continue;
            return true;
        }
        return false;
    }

    public String getFullName() {
        return this.myFullName;
    }

    public int getMaxOccurs() {
        return this.myMaxOccurs;
    }

    public String getStatus() {
        return this.myStatus;
    }

    public boolean isSimpleType() {
        return RAMLValue.Type.SIMPLE.equals((Object)this.myValueType.getType());
    }

    public boolean isComplexType() {
        return RAMLValue.Type.COMPLEX.equals((Object)this.myValueType.getType());
    }

    public boolean isIPv4Address() {
        for (RAMLProductData data : this.getProductData()) {
            if (!data.getProperties().containsKey("isIPv4Address")) continue;
            return true;
        }
        return false;
    }

    public boolean isIPv6Address() {
        for (RAMLProductData data : this.getProductData()) {
            if (!data.getProperties().containsKey("isIPv6Address")) continue;
            return true;
        }
        return false;
    }

    public boolean hasDefaultNoGuiSupport() {
        return this.myDefaultNoGuiSupport;
    }

    public boolean isVisibleInGUI() {
        if (this.hasDefaultNoGuiSupport()) {
            return this.isMandatoryWithoutDefaultValue();
        }
        Object valueType = this.getValueType();
        if (valueType instanceof RAMLComplexType) {
            return this.hasChildParamsVisibleOnGUI(valueType);
        }
        return true;
    }

    private boolean isMandatoryWithoutDefaultValue() {
        Object valueType = this.getValueType();
        return valueType instanceof RAMLComplexType ? this.isMandatory() && this.hasChildParamsMandatoryWithoutDefaultValue(valueType) : this.isMandatory() && !this.hasDefaultValue();
    }

    private boolean hasChildParamsMandatoryWithoutDefaultValue(Object valueType) {
        for (RAMLMetaParameter ramlParameter : ((RAMLComplexType)valueType).getParameters()) {
            if (!ramlParameter.isMandatory() || ramlParameter.hasDefaultValue()) continue;
            return true;
        }
        return false;
    }

    private boolean hasChildParamsVisibleOnGUI(Object valueType) {
        for (RAMLMetaParameter ramlParameter : ((RAMLComplexType)valueType).getParameters()) {
            if (!ramlParameter.isVisibleInGUI()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDMSProperty(String value) {
        for (RAMLProductData data : this.getProductData()) {
            if (!Boolean.parseBoolean(data.getValueWithKeyPhrase(value))) continue;
            return true;
        }
        return false;
    }

    public boolean isHidden() {
        return this.myHiddenState;
    }

    public boolean isLocked() {
        return this.myLocked;
    }

    public void setLocked() {
        this.myLocked = true;
    }

    public void setUnlocked() {
        this.myLocked = false;
    }

    public boolean isMandatory() {
        if (this.myCreationType == null) {
            Logger.getLogger(this.getClass()).error("Missing creation info from: " + this.getName());
        }
        return "mandatory".equals(this.myCreationType);
    }

    public boolean isOptional() {
        if (this.myCreationType == null) {
            Logger.getLogger(this.getClass()).error("Missing creation info from: " + this.getName());
        }
        return "optional".equals(this.myCreationType);
    }

    public boolean hasDefaultValue() {
        if (this.isSimpleType()) {
            return ((RAMLSimpleType)this.myValueType).hasDefaultValue();
        }
        return false;
    }

    public boolean hasMinOccursCheck(RAMLManagedObject moToBeValidated) {
        Boolean value = this.myBasicCheckCache.get(moToBeValidated);
        if (value != null) {
            return value;
        }
        this.setRelatedInfo(moToBeValidated);
        boolean result = this.myRelatedConditions.hasMinOccursCheck(moToBeValidated);
        this.myBasicCheckCache.put(moToBeValidated, result);
        return result;
    }

    private void setRelatedInfo(RAMLManagedObject moToBeValidated) {
        this.myRelatedConditions.setParameter(this, moToBeValidated);
    }

    private void setRelatedInfo(RAMLItem itemToBeValidated, RAMLManagedObject moToBeValidated) {
        RAMLParameter parameter = itemToBeValidated.getParameter(this.getName());
        if (parameter != null) {
            this.myRelatedConditions.setRAMLParameter(this, parameter);
        } else {
            this.myRelatedConditions.setParentRAMLItem(this, itemToBeValidated);
            this.myRelatedConditions.setManagedObject(this, moToBeValidated);
        }
    }

    public void clearCache() {
        this.myBasicCheckCache.clear();
    }

    public boolean hasMandatoryCheck(RAMLManagedObject moToBeValidated) {
        Boolean value = this.myBasicCheckCache.get(moToBeValidated);
        if (value != null) {
            return value;
        }
        this.setRelatedInfo(moToBeValidated);
        boolean result = this.myRelatedConditions.hasMandatoryCheck(moToBeValidated);
        this.myBasicCheckCache.put(moToBeValidated, result);
        return result;
    }

    public boolean hasMandatoryCheck(RAMLItem itemToBeValidated, RAMLManagedObject moToBeValidated) {
        this.setRelatedInfo(itemToBeValidated, moToBeValidated);
        return this.myRelatedConditions.hasMandatoryCheck(moToBeValidated);
    }

    public String getReason() {
        return this.myRelatedConditions.getReason();
    }

    public List<SortedSet<String>> getReasons() {
        return this.myRelatedConditions.getReasons();
    }

    public List<String> getRelationshipIds() {
        return this.myRelatedConditions.getRelationshipIds();
    }

    public boolean isSetByTheSystem() {
        if (this.myCreationType == null) {
            Logger.getLogger(this.getClass()).error("Missing creation info from: " + this.getName());
        }
        return "Value set by the system".equals(this.myCreationType);
    }

    public boolean isDeleted() {
        return "deleted".equals(this.getStatus());
    }

    public boolean isUnModifiable() {
        if (this.myModificationType == null) {
            Logger.getLogger(this.getClass()).error("[RAML Validation] " + this.getName() + " missing modification type");
        }
        return "unmodifiable".equals(this.myModificationType);
    }

    public String getMy3GPPName() {
        return this.my3GPPName;
    }

    public RAMLDescription getDescription() {
        return this.myDescription;
    }

    public RAMLDescription getShortDescription() {
        return this.myShortDescription;
    }

    public List<RAMLInterface> getInterfaces() {
        return this.myInterfaces;
    }

    public List<RAMLFeature> getFeatures() {
        return this.myFeatures;
    }

    public List<RAMLReference> getReferences() {
        return this.myReferences;
    }

    public String getCreationType() {
        return this.myCreationType;
    }

    public void setModificationType(String modificationType) {
        this.myModificationType = modificationType;
    }

    public void setCreationType(String creationType) {
        this.myCreationType = creationType;
    }

    public String getModificationType() {
        return this.myModificationType;
    }

    public RAMLRelatedParams getRelatedParameters() {
        return this.myRelatedParams;
    }

    public List<String> getParameterCategories() {
        return this.myParameterCategories;
    }

    public List<RAMLProductData> getProductData() {
        return this.myProductData;
    }

    public RAMLRelatedFunctions getRelatedFunctions() {
        return this.myRelatedFunctions;
    }

    public <T> T getValueType() {
        return (T)this.myValueType;
    }

    public boolean isInstanceParameter() {
        return this.myInstanceParameter;
    }

    private boolean calculateInstanceParameter() {
        for (RAMLProductData p : this.myProductData) {
            if (!p.isInstance()) continue;
            return true;
        }
        return false;
    }

    public RAMLRelatedConditions getRelatedConditions() {
        return this.myRelatedConditions;
    }

    public boolean isCopyTargetParameter() {
        for (RAMLProductData p : this.myProductData) {
            if (!p.isCopyTarget()) continue;
            return true;
        }
        return false;
    }

    public RAMLRelatedParameter getCopySourceParameter() {
        for (RAMLProductData p : this.myProductData) {
            if (!p.isCopyTarget()) continue;
            return new RAMLRelatedParameter(p.getValueWithKeyPhrase("Copy"));
        }
        return null;
    }

    public Optional<RAMLMetaParameter> getRAMLParentMetadata() {
        return Optional.ofNullable(this.myMetaMO.getMetaParameter(this.myParentParamName));
    }

    public synchronized boolean validate(RAMLValidationContext validationContext, Object objectToBeValidated) {
        int resultSize = validationContext.getResults().size();
        try {
            RAMLValue value = (RAMLValue)this.getValueType();
            Object source = null;
            if (objectToBeValidated instanceof RAMLParameter) {
                source = ((RAMLParameter)objectToBeValidated).getManagedObject();
            } else if (objectToBeValidated instanceof RAMLParameterList) {
                source = objectToBeValidated;
            }
            validationContext.setValidatedObject(source);
            value.validate(validationContext, this, objectToBeValidated);
            boolean hasRangeCheckOrInvalidValueIssue = false;
            List<RAMLValidationResult> validationResults = validationContext.getResults();
            if (validationResults != null && !validationResults.isEmpty()) {
                int i = 0;
                int size = validationResults.size();
                while (i < size) {
                    RAMLValidationResult ramlValidationResult = validationResults.get(i);
                    if (ramlValidationResult.hasRangeCheckIssueAndInvalidValueCheckIssue() && this.myName.equals(ramlValidationResult.getParameterName())) {
                        hasRangeCheckOrInvalidValueIssue = true;
                    }
                    ++i;
                }
            }
            if (!hasRangeCheckOrInvalidValueIssue) {
                this.validateRelatedConditions(validationContext, objectToBeValidated);
            }
        }
        catch (Exception e) {
            if (objectToBeValidated instanceof RAMLParameter) {
                ((RAMLParameter)objectToBeValidated).getValue();
                validationContext.setValidatedObject(((RAMLParameter)objectToBeValidated).getManagedObject());
            } else if (objectToBeValidated instanceof RAMLList) {
                ((RAMLList)objectToBeValidated).toString();
            }
            RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
            result.setParameterName(this.getName());
            if (objectToBeValidated != null && objectToBeValidated instanceof RAMLParameter) {
                RAMLParameter p = (RAMLParameter)objectToBeValidated;
                result.setDistName(p.getManagedObject() == null ? this.myMetaMO.getClassName() : p.getManagedObject().getDistName());
            } else {
                result.setDistName(this.myMetaMO.getClassName());
            }
            result.setVersion(this.myMetaMO.getVersion());
            result.setText(this.myResourceBundle.getString("RAMLValidation.Incomplete.Configuration"));
            Object[] values = new Object[]{this.getName(), this.getFullName()};
            result.setDetails(MessageFormat.format(this.myResourceBundle.getString("RAMLValidation.Cannot.Validate"), values));
            validationContext.addResult(result);
            Logger.getLogger(this.getClass()).error("[RAML Validation] " + result.getDetails());
            Logger.getLogger(this.getClass()).error(e);
        }
        return resultSize == validationContext.getResults().size();
    }

    public boolean validate(Object objectToBeValidated) {
        RAMLValidationContext validationContext = new RAMLValidationContext("");
        try {
            RAMLValue value = (RAMLValue)this.getValueType();
            value.validate(validationContext, this, objectToBeValidated);
        }
        catch (Exception e) {
            return false;
        }
        return validationContext.getResults().size() == 0;
    }

    public void validateRelatedConditions(RAMLValidationContext validationContext, Object objectToBeValidated) {
        RAMLRelatedConditions rc = this.getRelatedConditions();
        if (objectToBeValidated instanceof RAMLList || rc != null && !rc.isEmpty()) {
            rc.validate(validationContext, this, objectToBeValidated);
        }
    }

    public String getValidationRule() {
        return this.myValidationRule;
    }

    public String getValidationPattern() {
        return this.myValidationPattern;
    }

    public String getRegularExpression() {
        return this.myRegularExpression;
    }

    public boolean isValueValid(String value) {
        if (this.myRegularExpression != null && this.myRegularExpression.trim().length() > 0) {
            if (this.myCompiledRegularExpressionPattern == null) {
                this.myCompiledRegularExpressionPattern = Pattern.compile(this.myRegularExpression);
            }
            Matcher matcher = this.myCompiledRegularExpressionPattern.matcher(value);
            return matcher.matches();
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  Meta parameter ");
        sb.append(this.getName());
        sb.append("\n");
        sb.append("  fullName: ");
        sb.append(this.myFullName);
        sb.append("\n");
        sb.append("  maxOccurs: ");
        sb.append(this.myMaxOccurs);
        sb.append("\n");
        sb.append("  status: ");
        sb.append(this.myStatus);
        sb.append("\n");
        sb.append("  is hidden: ");
        sb.append(this.myHiddenState);
        sb.append("\n");
        sb.append("  3GPPName: ");
        sb.append(this.my3GPPName);
        sb.append("\n");
        sb.append("  creationType: ");
        sb.append(this.myCreationType);
        sb.append("\n");
        sb.append("  modificationType: ");
        sb.append(this.myModificationType);
        sb.append("\n");
        sb.append("  ");
        sb.append(this.myDescription);
        sb.append("\n");
        sb.append("  Short ");
        sb.append(this.myShortDescription);
        sb.append("\n");
        sb.append("  interfaces: ");
        sb.append(this.myInterfaces);
        sb.append("\n");
        sb.append("  features: ");
        sb.append(this.myFeatures);
        sb.append("\n");
        sb.append("  references: ");
        sb.append(this.myReferences);
        sb.append("\n");
        sb.append("  ");
        sb.append(this.myRelatedParams);
        sb.append("\n");
        sb.append("  Group ");
        sb.append(this.myGroup);
        sb.append("\n");
        sb.append("  ");
        sb.append(this.myRelatedFunctions);
        sb.append("\n");
        sb.append("  value: ");
        sb.append(this.myValueType);
        sb.append("\n");
        if (this.myValidationRule != null) {
            sb.append(" validationRule");
            sb.append(this.myValidationRule);
            sb.append("\n");
        }
        if (this.myValidationPattern != null) {
            sb.append(" validationPattern");
            sb.append(this.myValidationPattern);
            sb.append("\n");
        }
        if (this.myRegularExpression != null) {
            sb.append(" regularExpression");
            sb.append(this.myRegularExpression);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toXmlString() {
        StringBuilder tagData = new StringBuilder();
        tagData.append("<p");
        tagData.append(" name=\"");
        tagData.append(this.myName);
        tagData.append("\" fullName=\"");
        tagData.append(this.myFullName);
        tagData.append("\" maxOccurs=\"");
        tagData.append(this.myMaxOccurs);
        tagData.append("\" status=\"");
        tagData.append(this.myStatus);
        tagData.append("\" group=\"");
        tagData.append(this.myGroup);
        tagData.append("\" hidden=\"");
        tagData.append(this.myHiddenState ? "true" : "false");
        tagData.append("\" tgppName=\"");
        tagData.append(this.my3GPPName);
        tagData.append("\"");
        tagData.append(">");
        tagData.append("\n");
        tagData.append(this.myDescription.toXmlString());
        tagData.append("<creation priority=\"");
        tagData.append(this.myCreationType);
        tagData.append("\"/>");
        tagData.append("\n");
        tagData.append("<modification type=\"");
        tagData.append(this.myModificationType);
        tagData.append("\"/>");
        tagData.append("\n");
        tagData.append(this.myRelatedParams.toXmlString());
        tagData.append(this.myRelatedFunctions.toXmlString());
        tagData.append("<features>");
        tagData.append("\n");
        for (RAMLFeature feature : this.myFeatures) {
            tagData.append(feature.toXmlString());
        }
        tagData.append("</features>");
        tagData.append("\n");
        tagData.append("<interfaces>");
        tagData.append("\n");
        for (RAMLInterface inter : this.myInterfaces) {
            tagData.append(inter.toXmlString());
        }
        tagData.append("</interfaces>");
        tagData.append("\n");
        tagData.append("<references>");
        tagData.append("\n");
        for (RAMLReference ref : this.myReferences) {
            tagData.append(ref.toXmlString());
        }
        tagData.append("</references>");
        tagData.append("\n");
        for (RAMLProductData pData : this.myProductData) {
            tagData.append(pData.toXmlString());
        }
        if (this.myValidationRule != null) {
            tagData.append("<validationRule>");
            tagData.append(this.myValidationRule);
            tagData.append("</validationRule>");
            tagData.append("\n");
        }
        if (this.myValidationPattern != null) {
            tagData.append("<validationPattern>");
            tagData.append(this.myValidationPattern);
            tagData.append("</validationPattern>");
            tagData.append("\n");
        }
        if (this.myRegularExpression != null) {
            tagData.append("<regularExpression>");
            tagData.append(this.myRegularExpression);
            tagData.append("</regularExpression>");
            tagData.append("\n");
        }
        tagData.append("</p>");
        tagData.append("\n");
        return tagData.toString();
    }

    @Override
    public int compareTo(RAMLMetaParameter o) {
        RAMLMetaParameter compared = o;
        if (this.isInstanceParameter()) {
            return -1;
        }
        if (compared.isInstanceParameter()) {
            return 1;
        }
        return this.getFullName().compareToIgnoreCase(compared.getFullName());
    }

    public String getParentParamName() {
        return this.myParentParamName;
    }

    public String getRelationshipIdForMandatoryCheck() {
        return this.myRelationshipIdForMandatoryCheck;
    }

    public void setRelationshipIdForMandatoryCheck(String newRelationshipIdForMandatoryCheck) {
        this.myRelationshipIdForMandatoryCheck = newRelationshipIdForMandatoryCheck;
    }

    public boolean isMinValueEqualMaxValue() {
        if (this.getValueType() instanceof RAMLDecimal) {
            RAMLDecimal valueType = (RAMLDecimal)this.getValueType();
            Double max = (Double)valueType.getMaxValue();
            Double min = (Double)valueType.getMinValue();
            return BigDecimal.valueOf(max).compareTo(BigDecimal.valueOf(min)) == 0;
        }
        return false;
    }

    public Double getMinValue() {
        if (this.getValueType() instanceof RAMLDecimal) {
            RAMLDecimal valueType = (RAMLDecimal)this.getValueType();
            return (Double)valueType.getMinValue();
        }
        return null;
    }

    public Double getMaxValue() {
        if (this.getValueType() instanceof RAMLDecimal) {
            RAMLDecimal valueType = (RAMLDecimal)this.getValueType();
            return (Double)valueType.getMaxValue();
        }
        return null;
    }
}

