/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import java.io.Serializable;
import java.util.Optional;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RAMLMetaRelease
implements Serializable {
    private static final long serialVersionUID = 2806707370284714621L;
    private String myDomain;
    private String myProduct;
    private String myRelease;
    private String myVersion;
    private String myNodeName;

    RAMLMetaRelease(String domain, String product, String release, String version, String nodeName) {
        this.myDomain = domain;
        this.myProduct = product;
        this.myRelease = release;
        this.myVersion = version;
        this.myNodeName = nodeName;
    }

    public RAMLMetaRelease(Node node) {
        this.myNodeName = node.getNodeName();
        NamedNodeMap attributes = node.getAttributes();
        this.myDomain = this.getAttribute(attributes, "domain");
        this.myProduct = this.getAttribute(attributes, "product");
        this.myRelease = this.getAttribute(attributes, "release");
        this.myVersion = this.getAttribute(attributes, "version");
    }

    private String getAttribute(NamedNodeMap attributes, String attributeName) {
        return Optional.ofNullable(attributes.getNamedItem(attributeName).getNodeValue()).orElse("");
    }

    public String getDomain() {
        return this.myDomain;
    }

    public String getProduct() {
        return this.myProduct;
    }

    public String getRelease() {
        return this.myRelease;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RAMLMetaRelease [myDomain=");
        builder.append(this.myDomain);
        builder.append(", myProduct=");
        builder.append(this.myProduct);
        builder.append(", myRelease=");
        builder.append(this.myRelease);
        builder.append(", myVersion=");
        builder.append(this.myVersion);
        builder.append("]");
        return builder.toString();
    }

    public String toXmlString() {
        StringBuilder tagData = new StringBuilder("<");
        tagData.append(this.myNodeName);
        tagData.append(" domain=");
        tagData.append("\"" + this.myDomain + "\"");
        tagData.append(" product=");
        tagData.append("\"" + this.myProduct + "\"");
        tagData.append(" release=");
        tagData.append("\"" + this.myRelease + "\"");
        tagData.append(" version=");
        tagData.append("\"" + this.myVersion + "\"");
        tagData.append("/>");
        return tagData.toString();
    }
}

