/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLCondition;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.RamlConditionRelatedParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLLogicalValidatorBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RAMLOperation
implements RAMLValidator,
Serializable {
    private static final long serialVersionUID = 5754259470746619241L;
    private RAMLCondition myParentCondition;
    private String myOperationValue;
    private List<RAMLCondition> myConditions;
    private List<RamlConditionRelatedParameter> myParameters;
    private SortedSet<String> myReason = new TreeSet<String>();

    public RAMLOperation(Node referenceNode, RAMLCondition parent) {
        this(referenceNode);
        this.setParentCondition(parent);
    }

    public RAMLOperation(Node referenceNode) {
        this.myConditions = new ArrayList<RAMLCondition>();
        this.myParameters = new ArrayList<RamlConditionRelatedParameter>();
        this.readAttributes(referenceNode);
        this.readElement(referenceNode);
    }

    private void readAttributes(Node referenceNode) {
        NamedNodeMap attributes = referenceNode.getAttributes();
        this.myOperationValue = this.readAttribute(attributes, "value");
    }

    private String readAttribute(NamedNodeMap attributes, String name) {
        Node attr = attributes.getNamedItem(name);
        return attr == null ? null : attr.getNodeValue();
    }

    public void readElement(Node conditionNode) {
        NodeList childNodes = conditionNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("pRef")) {
                this.myParameters.add(new RamlConditionRelatedParameter(childNode));
            }
            if (childNode.getNodeName().equals("condition")) {
                this.myConditions.add(new RAMLCondition(childNode));
            }
            ++i;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RAMLOperation: ");
        sb.append(this.myOperationValue);
        sb.append(" related params: ");
        for (RamlConditionRelatedParameter parameter : this.myParameters) {
            sb.append(parameter.toString());
        }
        sb.append("related condition:");
        for (RAMLCondition condition : this.myConditions) {
            sb.append(condition.toString());
        }
        return sb.toString();
    }

    public String toXmlString() {
        StringBuilder tagData = new StringBuilder();
        tagData.append("<operation");
        tagData.append(" value=\"");
        tagData.append(this.myOperationValue);
        tagData.append("\"");
        tagData.append(">");
        tagData.append("\n");
        for (RAMLCondition condition : this.myConditions) {
            tagData.append(condition.toXmlString());
        }
        tagData.append("</operation>");
        tagData.append("\n");
        return tagData.toString();
    }

    public String getOperationValue() {
        return this.myOperationValue;
    }

    public List<RamlConditionRelatedParameter> getAllRelatedParameters() {
        ArrayList<RamlConditionRelatedParameter> parameters = new ArrayList<RamlConditionRelatedParameter>();
        parameters.addAll(this.myParameters);
        for (RAMLCondition condition : this.myConditions) {
            parameters.addAll(condition.getAllRelatedParameters());
        }
        return parameters;
    }

    public double getParameterValue() {
        if (this.myConditions.size() + this.myParameters.size() == 1) {
            if (this.myConditions.size() == 1) {
                return RAMLLogicalValidatorBase.parseDouble(this.myConditions.get(0).getCalculationValue());
            }
            if (this.myParameters.size() == 1) {
                return RAMLLogicalValidatorBase.parseDouble(this.myParameters.get(0).getResultValue());
            }
        }
        return -1.0;
    }

    public String getFormsOfOperation() {
        if (this.myConditions.size() + this.myParameters.size() == 1 && this.myConditions.size() == 1) {
            return this.myConditions.get(0).getFormsOfCalculation(true);
        }
        return this.myParameters.get(0).getFormsOfCalculation();
    }

    public boolean hasMinOccursCheck(RAMLManagedObject moToBeValidated) {
        block5: {
            block4: {
                if (this.myOperationValue != null && !this.myOperationValue.equals("OR")) break block4;
                for (RamlConditionRelatedParameter parameter : this.myParameters) {
                    if (!parameter.hasMinOccursCheck(moToBeValidated)) continue;
                    return true;
                }
                for (RAMLCondition condition : this.myConditions) {
                    if (!condition.hasMinOccursCheck(moToBeValidated)) continue;
                    return true;
                }
                break block5;
            }
            if (!this.myOperationValue.equals("AND") || !this.areAllRequirementsTrue()) break block5;
            for (RamlConditionRelatedParameter parameter : this.myParameters) {
                if (!parameter.hasMinOccursCheck(moToBeValidated)) continue;
                return true;
            }
            for (RAMLCondition condition : this.myConditions) {
                if (!condition.hasMinOccursCheck(moToBeValidated)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMandatoryCheck(RAMLManagedObject moToBeValidated) {
        block5: {
            block4: {
                if (this.myOperationValue != null && !this.myOperationValue.equals("OR")) break block4;
                for (RamlConditionRelatedParameter parameter : this.myParameters) {
                    if (!parameter.hasMandatoryCheck(moToBeValidated)) continue;
                    return true;
                }
                for (RAMLCondition condition : this.myConditions) {
                    if (!condition.hasMandatoryCheck(moToBeValidated)) continue;
                    return true;
                }
                break block5;
            }
            if (!this.myOperationValue.equals("AND") || !this.areAllRequirementsTrue()) break block5;
            for (RamlConditionRelatedParameter parameter : this.myParameters) {
                if (!parameter.hasMandatoryCheck(moToBeValidated)) continue;
                return true;
            }
            for (RAMLCondition condition : this.myConditions) {
                if (!condition.hasMandatoryCheck(moToBeValidated)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        RAMLParameter parameterToBeValidated = (RAMLParameter)objectToBeValidated;
        RAMLMetaParameter metaParameter = (RAMLMetaParameter)metaData;
        this.setRAMLParameter(parameterToBeValidated);
        if (this.myOperationValue.equals("AND")) {
            if (RAMLLogicalValidatorBase.shouldRelatedParamCal(this.myParameters)) {
                String result = RAMLLogicalValidatorBase.doRelatedParamCal(this.myParameters);
                if (!result.equals(parameterToBeValidated.getValue())) {
                    String details = RAMLValidationErrorMessageFactory.generatedCalculationClauseStart(metaParameter, parameterToBeValidated, "EQUAL", result);
                    validationContext.addResult(RAMLLogicalValidatorBase.generateValidationError(metaParameter, parameterToBeValidated, details));
                }
            } else if (this.areAllRequirementsTrue()) {
                this.validateConditions(validationContext, metaData, objectToBeValidated);
                this.validateParameters(validationContext, metaData, objectToBeValidated);
            }
        }
        if (this.myOperationValue.equals("OR")) {
            this.validateConditions(validationContext, metaData, objectToBeValidated);
            this.validateParameters(validationContext, metaData, objectToBeValidated);
        }
    }

    private void validateConditions(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        if (this.myConditions.size() != 0) {
            for (RAMLCondition condition : this.myConditions) {
                condition.validate(validationContext, metaData, objectToBeValidated);
            }
        }
    }

    private void validateParameters(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        if (this.myParameters.size() != 0) {
            for (RamlConditionRelatedParameter parameter : this.myParameters) {
                if (!parameter.isValidationMatched()) continue;
                parameter.validate(validationContext, metaData, objectToBeValidated);
            }
        }
    }

    public boolean areAllRequirementsTrue() {
        this.myReason.clear();
        if ("OR".equals(this.myOperationValue)) {
            for (RAMLCondition condition : this.myConditions) {
                if (!condition.areAllRequirementsTrue()) continue;
                this.myReason.addAll(condition.getReasons());
                return true;
            }
            for (RamlConditionRelatedParameter parameter : this.myParameters) {
                if (!parameter.isValidationMatched()) continue;
                if (parameter.isErrorReasonVisible()) {
                    this.myReason.add(parameter.getReason());
                }
                return true;
            }
            return false;
        }
        if ("EQUAL".equals(this.myOperationValue) || "NOT_EQUAL".equals(this.myOperationValue)) {
            if (this.myParameters.size() != 2) {
                return true;
            }
            boolean isSame = this.myParameters.get(0).hasSameValue(this.myParameters.get(1));
            if (isSame && "EQUAL".equals(this.myOperationValue) || !isSame && "NOT_EQUAL".equals(this.myOperationValue)) {
                this.myReason.add(RAMLValidationErrorMessageFactory.generateReasonClause(this));
                return true;
            }
            return false;
        }
        ArrayList<String> reasons = new ArrayList<String>();
        for (RAMLCondition condition : this.myConditions) {
            if (!condition.areAllRequirementsTrue()) {
                return false;
            }
            reasons.addAll(condition.getReasons());
        }
        for (RamlConditionRelatedParameter parameter : this.myParameters) {
            if (!parameter.isValidationMatched()) {
                return false;
            }
            if (!parameter.isErrorReasonVisible()) continue;
            reasons.add(parameter.getReason());
        }
        this.myReason.addAll(reasons);
        return true;
    }

    public SortedSet<String> getReasons() {
        return this.myReason;
    }

    public void setRAMLParameter(RAMLParameter ramlparameter) {
        for (RamlConditionRelatedParameter parameter : this.myParameters) {
            parameter.setRAMLParameter(ramlparameter);
            parameter.createParameterLocation();
            parameter.createReason();
        }
        for (RAMLCondition condition : this.myConditions) {
            condition.setRAMLParameter(ramlparameter);
        }
    }

    public void setRAMLList(RAMLList ramlList) {
        for (RamlConditionRelatedParameter parameter : this.myParameters) {
            parameter.setRAMLList(ramlList);
            parameter.createParameterLocation();
            parameter.createReason();
        }
        for (RAMLCondition condition : this.myConditions) {
            condition.setRAMLList(ramlList);
        }
    }

    public void setManagedObject(RAMLManagedObject managedObject) {
        for (RamlConditionRelatedParameter parameter : this.myParameters) {
            parameter.setManagedObject(managedObject);
        }
        for (RAMLCondition condition : this.myConditions) {
            condition.setManagedObject(managedObject);
        }
    }

    public void setMetaParameter(RAMLMetaParameter metaParameter) {
        for (RamlConditionRelatedParameter parameter : this.myParameters) {
            parameter.setMetaParameter(metaParameter);
            parameter.createParameterLocation();
            parameter.createReason();
        }
        for (RAMLCondition condition : this.myConditions) {
            condition.setMetaParameter(metaParameter);
        }
    }

    public boolean isCalculativeOperation() {
        return RAMLLogicalValidatorBase.isCalculativeOperation(this.myOperationValue);
    }

    public boolean isMinMaxOperation() {
        if (this.myOperationValue == null) {
            return false;
        }
        String oper = this.myOperationValue.toUpperCase();
        return "MIN".equals(oper) || "MAX".equals(oper);
    }

    public RAMLCondition getParentCondition() {
        return this.myParentCondition;
    }

    public void setParentCondition(RAMLCondition parentCondition) {
        this.myParentCondition = parentCondition;
    }

    public String getRelationshipId() {
        return this.myParentCondition.getRelationshipId();
    }
}

