/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.raml.metadata.ConditionBase;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLHWPropertyDefaultValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLHWPropertySupplier;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLHWPropertyValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLOperation;
import com.nokia.em.poseidon.frameworks.raml.metadata.RamlConditionRelatedParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLLogicalValidatorBase;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RAMLPreCondition
extends ConditionBase {
    private static final long serialVersionUID = 6887543779912591003L;
    private SortedSet<String> myReason = new TreeSet<String>();
    private List<RAMLHWPropertyValidator> myHWProperties;
    private Supplier<RAMLHWPropertySupplier> myHWPropertySupplier;

    public RAMLPreCondition(Node conditionNode) {
        this(() -> PoseidonRuntime.getRuntime().getObject(RAMLHWPropertySupplier.class), conditionNode);
    }

    public RAMLPreCondition(Supplier<RAMLHWPropertySupplier> hwPropertySupplier, Node conditionNode) {
        super(conditionNode);
        this.myHWPropertySupplier = hwPropertySupplier;
        this.myHWProperties = new ArrayList<RAMLHWPropertyValidator>();
        this.readElement(conditionNode);
    }

    public void readElement(Node conditionNode) {
        NodeList childNodes = conditionNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("operation")) {
                this.addOperation(new RAMLOperation(childNode));
            } else if (childNode.getNodeName().equals("pRef")) {
                this.addRelatedParameter(new RamlConditionRelatedParameter(childNode));
            } else if (childNode.getNodeName().equals("hw")) {
                this.myHWProperties.add(new RAMLHWPropertyDefaultValidator(this.myHWPropertySupplier, childNode));
            }
            ++i;
        }
    }

    public boolean isPreConditionTrue() {
        this.myReason.clear();
        if (this.getValue() == null) {
            if (this.getOperations().size() == 1) {
                RAMLOperation operation = this.getOperations().get(0);
                this.myReason.addAll(operation.getReasons());
                return operation.areAllRequirementsTrue();
            }
            if (this.getRelatedParameters().size() == 1) {
                RamlConditionRelatedParameter relatedParameter = this.getRelatedParameters().get(0);
                if (relatedParameter.isErrorReasonVisible()) {
                    this.myReason.add(relatedParameter.getReason());
                }
                return relatedParameter.isValidationMatched();
            }
            if (this.myHWProperties.size() == 1 && this.myHWProperties.get(0).validate()) {
                this.myReason.add(this.myHWProperties.get(0).getReason());
                return true;
            }
            return false;
        }
        if (this.getValue().equals("AND")) {
            ArrayList<String> reasons = new ArrayList<String>();
            for (RAMLOperation operation : this.getOperations()) {
                if (!operation.areAllRequirementsTrue()) {
                    return false;
                }
                if (operation.getReasons().size() <= 0) continue;
                reasons.addAll(operation.getReasons());
            }
            for (RamlConditionRelatedParameter parameter : this.getRelatedParameters()) {
                if (!parameter.isValidationMatched()) {
                    return false;
                }
                if (!parameter.isErrorReasonVisible()) continue;
                reasons.add(parameter.getReason());
            }
            for (RAMLHWPropertyValidator propertyValidator : this.myHWProperties) {
                if (!propertyValidator.validate()) {
                    return false;
                }
                reasons.add(propertyValidator.getReason());
            }
            this.myReason.addAll(reasons);
            return true;
        }
        if (this.getValue().equals("OR")) {
            for (RAMLOperation operation : this.getOperations()) {
                if (!operation.areAllRequirementsTrue()) continue;
                this.myReason.addAll(operation.getReasons());
                return true;
            }
            for (RamlConditionRelatedParameter parameter : this.getRelatedParameters()) {
                if (!parameter.isValidationMatched()) continue;
                if (parameter.isErrorReasonVisible()) {
                    this.myReason.add(parameter.getReason());
                }
                return true;
            }
            for (RAMLHWPropertyValidator propertyValidator : this.myHWProperties) {
                if (!propertyValidator.validate()) continue;
                this.myReason.add(propertyValidator.getReason());
                return true;
            }
            return false;
        }
        if (this.hasSpecialValue()) {
            RAMLOperation operation;
            if (this.isReadyForCalculation()) {
                return this.isCalculationTrue(this.getValue());
            }
            if (this.getRelatedParameters().size() > 0) {
                RamlConditionRelatedParameter parameter = this.getRelatedParameters().get(0);
                if (parameter.isValidationMatched()) {
                    if (RAMLLogicalValidatorBase.shouldRelatedParamCal(this.getRelatedParameters()) || parameter.getParamName() == null && parameter.getValue() != null) {
                        String targetValue = parameter.getResultValue();
                        return RAMLLogicalValidatorBase.isValueValid(this.getValue(), targetValue, this.getParameterToBeValidated().getValue());
                    }
                    List<String> targetValues = parameter.getConditionRelatedParameterValues();
                    return RAMLLogicalValidatorBase.isValueValid(this.getValue(), targetValues, this.getParameterToBeValidated().getValue());
                }
            } else if ((this.getValue().equals("EMPTY") || this.getValue().equals("NOT_EMPTY")) && this.getOperations().size() > 0 && (operation = this.getOperations().get(0)).areAllRequirementsTrue()) {
                return RAMLLogicalValidatorBase.isValueValid(this.getValue(), "", this.getParameterToBeValidated().getValue());
            }
        }
        return false;
    }

    public SortedSet<String> getReason() {
        return this.myReason;
    }

    private boolean hasSpecialValue() {
        return this.getValue().equals("SMALLER") || this.getValue().equals("SMALLER_OR_EQUAL") || this.getValue().equals("BIGGER") || this.getValue().equals("BIGGER_OR_EQUAL") || this.getValue().equals("EMPTY") || this.getValue().equals("NOT_EMPTY") || this.getValue().equals("EQUAL") || this.getValue().equals("NOT_EQUAL");
    }

    private boolean isCalculationTrue(String conditionValue) {
        String targetValue = this.getCalculationValue();
        if (this.getParameterToBeValidated() != null) {
            String ValueToBeValidated = this.getParameterToBeValidated().getValue();
            return RAMLLogicalValidatorBase.isValueValid(conditionValue, targetValue, ValueToBeValidated);
        }
        return false;
    }
}

