/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RAMLProductData
implements Serializable {
    private static final long serialVersionUID = 8367969779093761492L;
    private Map<String, String> myProperties = new HashMap<String, String>();
    private boolean myIsInstance = false;
    private boolean myIsCopy = false;
    private boolean myVendor = false;
    private String myName;
    private boolean myPrintableString = false;

    public RAMLProductData(Node productNode) {
        this.readAttributes(productNode);
        this.readProperties(productNode);
    }

    private void readAttributes(Node referenceNode) {
        NamedNodeMap attributes = referenceNode.getAttributes();
        this.myName = this.readAttribute(attributes, "name");
    }

    private String readAttribute(NamedNodeMap attributes, String name) {
        Node attr = attributes.getNamedItem(name);
        return attr == null ? null : attr.getNodeValue();
    }

    public void readProperties(Node productNode) {
        NodeList childNodes = productNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("property")) {
                NamedNodeMap attributes = childNode.getAttributes();
                String name = attributes.getNamedItem("name").getNodeValue();
                String value = attributes.getNamedItem("value").getNodeValue();
                this.myProperties.put(name, value);
                if (value.toLowerCase().indexOf("$instance") > -1) {
                    this.myIsInstance = true;
                }
                if (name.indexOf("Copy") > -1) {
                    this.myIsCopy = true;
                }
                if (name.indexOf("isVendorSpecific") > -1) {
                    this.myVendor = Boolean.parseBoolean(value);
                }
                if (name.indexOf("isPrintableString") > -1) {
                    this.myPrintableString = Boolean.parseBoolean(value);
                }
            }
            ++i;
        }
    }

    public Map<String, String> getProperties() {
        return this.myProperties;
    }

    public boolean isInstance() {
        return this.myIsInstance;
    }

    public boolean isCopyTarget() {
        return this.myIsCopy;
    }

    public boolean isVendorSpecific() {
        return this.myVendor;
    }

    public boolean isPrintableString() {
        return this.myPrintableString;
    }

    public String getValueWithKeyPhrase(String keyPhrase) {
        for (String key : this.myProperties.keySet()) {
            if (key.indexOf(keyPhrase) <= -1) continue;
            return this.myProperties.get(key);
        }
        return null;
    }

    public String getName() {
        return this.myName;
    }

    public String toXmlString() {
        StringBuilder tagData = new StringBuilder();
        tagData.append("<productData");
        tagData.append(" name=\"");
        tagData.append(this.getName());
        tagData.append("\">");
        tagData.append("\n");
        for (String key : this.myProperties.keySet()) {
            tagData.append("<property name=\"");
            tagData.append(key);
            tagData.append("\" value=\"");
            tagData.append(this.myProperties.get(key));
            tagData.append("\"/>");
            tagData.append("\n");
        }
        tagData.append("</productData>");
        tagData.append("\n");
        return tagData.toString();
    }
}

