/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import java.io.Serializable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RAMLReference
implements Serializable {
    private static final long serialVersionUID = -6011784006438789001L;
    private String myType;
    private String myText;
    private String myAccess;

    public RAMLReference(Node referenceNode) {
        this.readAttributes(referenceNode);
    }

    private void readAttributes(Node referenceNode) {
        NamedNodeMap attributes = referenceNode.getAttributes();
        this.myType = attributes.getNamedItem("type").getNodeValue();
        this.myText = attributes.getNamedItem("text").getNodeValue();
        this.myAccess = attributes.getNamedItem("access").getNodeValue();
    }

    public boolean isPublic() {
        return this.myAccess.equals("public");
    }

    public String getType() {
        return this.myType;
    }

    public String getText() {
        return this.myText;
    }

    public String getAccess() {
        return this.myAccess;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Reference type: ");
        sb.append(this.myType);
        sb.append(" access: ");
        sb.append(this.myAccess);
        sb.append(" text:");
        sb.append(this.myText);
        return sb.toString();
    }

    public String toXmlString() {
        StringBuilder tagData = new StringBuilder();
        tagData.append("<reference");
        tagData.append(" type=\"");
        tagData.append(this.myType);
        tagData.append("\" text=\"");
        tagData.append(this.myText);
        tagData.append("\" access=\"");
        tagData.append(this.myAccess);
        tagData.append("\"");
        tagData.append("/>");
        tagData.append("\n");
        return tagData.toString();
    }
}

