/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLCondition;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.RamlConditionRelatedParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RAMLRelatedConditions
implements RAMLValidator,
Serializable {
    private static final long serialVersionUID = 5564586866767725417L;
    private List<RAMLCondition> myConditions;
    private List<SortedSet<String>> myReasons = new ArrayList<SortedSet<String>>();
    private List<String> myRelationshipIds = new ArrayList<String>();
    protected transient ResourceBundle myRB;

    public RAMLRelatedConditions() {
        this.myConditions = new ArrayList<RAMLCondition>();
        this.myRB = I18n.getI18n().getBundle(this.getClass());
    }

    public void readChildNodes(Node paramNode) {
        NodeList childNodes = paramNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("condition")) {
                this.myConditions.add(new RAMLCondition(childNode));
            }
            ++i;
        }
    }

    public List<RamlConditionRelatedParameter> getRelatedParameters() {
        ArrayList<RamlConditionRelatedParameter> parameters = new ArrayList<RamlConditionRelatedParameter>();
        for (RAMLCondition condition : this.myConditions) {
            parameters.addAll(condition.getAllRelatedParameters());
        }
        return parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RAMLRelatedConditions: ");
        sb.append("\n");
        for (RAMLCondition c : this.myConditions) {
            sb.append(c);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        RAMLMetaParameter metaP = (RAMLMetaParameter)metaData;
        if (objectToBeValidated instanceof RAMLList) {
            RAMLList list = (RAMLList)objectToBeValidated;
            this.validateList(validationContext, metaP, list);
        } else if (objectToBeValidated instanceof RAMLParameter) {
            RAMLParameter parameter = (RAMLParameter)objectToBeValidated;
            this.validateParameter(validationContext, metaP, parameter);
        }
    }

    private void validateParameter(RAMLValidationContext validationContext, RAMLMetaParameter metaData, RAMLParameter objectToBeValidated) {
        for (RAMLCondition condition : this.myConditions) {
            condition.validate(validationContext, metaData, objectToBeValidated);
        }
    }

    private void validateList(RAMLValidationContext validationContext, RAMLMetaParameter metaData, RAMLList listToBeValidated) {
        for (RAMLCondition condition : this.myConditions) {
            condition.validate(validationContext, metaData, listToBeValidated);
        }
    }

    public boolean hasMinOccursCheck(RAMLManagedObject moToBeValidated) {
        for (RAMLCondition condition : this.myConditions) {
            if (!condition.hasMinOccursCheck(moToBeValidated)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMandatoryCheck(RAMLManagedObject moToBeValidated) {
        boolean flag = false;
        this.myReasons.clear();
        this.myRelationshipIds.clear();
        for (RAMLCondition condition : this.myConditions) {
            if (!condition.hasMandatoryCheck(moToBeValidated)) continue;
            this.myReasons.add(condition.getReasons());
            this.myRelationshipIds.add(condition.getRelationshipId());
            flag = true;
        }
        return flag;
    }

    public String getReason() {
        if (this.myReasons.isEmpty()) {
            return "";
        }
        return this.myReasons.get(0).first();
    }

    public List<SortedSet<String>> getReasons() {
        return this.myReasons;
    }

    public List<String> getRelationshipIds() {
        return this.myRelationshipIds;
    }

    public boolean isEmpty() {
        return this.myConditions == null || this.myConditions.isEmpty();
    }

    public void setParameter(RAMLMetaParameter metaParameter, RAMLManagedObject moToBeValidated) {
        RAMLParameter parameter = moToBeValidated.getParameter(metaParameter.getName());
        RAMLList<?> list = moToBeValidated.getList(metaParameter.getName());
        for (RAMLCondition condition : this.myConditions) {
            if (parameter != null) {
                condition.setRAMLParameter(metaParameter, parameter);
                continue;
            }
            if (list != null) {
                condition.setRAMLList(metaParameter, list);
                continue;
            }
            condition.setRAMLList(metaParameter, null);
            condition.setManagedObject(metaParameter, moToBeValidated);
        }
    }

    public void setRAMLParameter(RAMLParameter ramlParameter) {
        for (RAMLCondition condition : this.myConditions) {
            condition.setRAMLParameter(ramlParameter);
        }
    }

    public void setRAMLParameter(RAMLMetaParameter metaParameter, RAMLParameter ramlParameter) {
        for (RAMLCondition condition : this.myConditions) {
            condition.setMetaParameter(metaParameter);
            condition.setRAMLParameter(ramlParameter);
        }
    }

    public void setRAMLList(RAMLList ramlList) {
        for (RAMLCondition condition : this.myConditions) {
            condition.setRAMLList(ramlList);
        }
    }

    public void setRAMLList(RAMLMetaParameter metaParameter, RAMLList ramlList) {
        for (RAMLCondition condition : this.myConditions) {
            condition.setMetaParameter(metaParameter);
            condition.setRAMLList(ramlList);
        }
    }

    public void setParentRAMLItem(RAMLItem ramlItem) {
        for (RAMLCondition condition : this.myConditions) {
            condition.setParentRAMLItem(ramlItem);
        }
    }

    public void setParentRAMLItem(RAMLMetaParameter metaParameter, RAMLItem ramlItem) {
        for (RAMLCondition condition : this.myConditions) {
            condition.setMetaParameter(metaParameter);
            condition.setParentRAMLItem(ramlItem);
        }
    }

    public void setManagedObject(RAMLMetaParameter metaParameter, RAMLManagedObject managedObject) {
        for (RAMLCondition condition : this.myConditions) {
            condition.setMetaParameter(metaParameter);
            condition.setManagedObject(managedObject);
        }
    }

    public void setManagedObject(RAMLManagedObject managedObject) {
        for (RAMLCondition condition : this.myConditions) {
            condition.setManagedObject(managedObject);
        }
    }

    public void setMetaParameter(RAMLMetaParameter metaParameter) {
        for (RAMLCondition condition : this.myConditions) {
            condition.setMetaParameter(metaParameter);
        }
    }

    public String toXmlString() {
        StringBuilder tagData = new StringBuilder();
        tagData.append("<relatedConditions>");
        tagData.append("\n");
        for (RAMLCondition condition : this.myConditions) {
            tagData.append(condition.toXmlString());
        }
        tagData.append("</relatedConditions>");
        tagData.append("\n");
        return tagData.toString();
    }
}

