/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLDescription;
import java.io.Serializable;

public class RAMLRelatedParameter
implements Serializable,
Comparable<RAMLRelatedParameter> {
    private static final long serialVersionUID = 6366240014735300012L;
    private String myClassName;
    private String myParamName;
    private String myListName;
    private String myScope;
    private String myValue;
    private String myValueOperation;
    private RAMLDescription myDescription;
    private String myHidden;

    public RAMLRelatedParameter(String className, String pName) {
        this.myClassName = className;
        this.myParamName = pName;
        this.myScope = null;
        this.myListName = null;
        this.myValue = null;
        this.myValueOperation = null;
    }

    public RAMLRelatedParameter(String className, String pName, String pHidden) {
        this.myClassName = className;
        this.myParamName = pName;
        this.myHidden = pHidden;
        this.myScope = null;
        this.myListName = null;
        this.myValue = null;
        this.myValueOperation = null;
    }

    public RAMLRelatedParameter(String className, String listName, String pName, String valueOperation, String value, String scope) {
        this.myClassName = className;
        this.myParamName = pName;
        this.myListName = listName;
        this.myValue = value;
        this.myScope = scope;
        this.myValueOperation = valueOperation;
    }

    public RAMLRelatedParameter(String copyFormat) {
        this.initFromCopyFormat(copyFormat);
        this.myListName = null;
        this.myValue = null;
        this.myValueOperation = null;
        this.myScope = null;
    }

    private void initFromCopyFormat(String copyFormat) {
        String[] tmp = copyFormat.split("/");
        this.myClassName = tmp[0];
        this.myParamName = tmp[1];
    }

    public RAMLDescription getDescription() {
        return this.myDescription;
    }

    public void setDescription(RAMLDescription description) {
        this.myDescription = description;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public String getParamName() {
        return this.myParamName;
    }

    public String getListName() {
        return this.myListName;
    }

    public String getValue() {
        return this.myValue;
    }

    public String getValueOperation() {
        return this.myValueOperation;
    }

    public String getScope() {
        return this.myScope;
    }

    public String getHidden() {
        return this.myHidden;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Related param class: ");
        sb.append(this.myClassName);
        sb.append(" param: ");
        sb.append(this.myParamName);
        sb.append(" list: ");
        sb.append(this.myListName);
        sb.append(" valueOperation: ");
        sb.append(this.myValueOperation);
        sb.append(" value: ");
        sb.append(this.myValue);
        return sb.toString();
    }

    public String toXmlString() {
        StringBuilder tagData = new StringBuilder();
        tagData.append("<pRef");
        tagData.append(" class=\"");
        tagData.append(this.myClassName);
        tagData.append("\" name=\"");
        tagData.append(this.myParamName);
        tagData.append("\" hidden=\"");
        tagData.append(this.myHidden);
        tagData.append("\"");
        tagData.append(">");
        tagData.append("\n");
        if (this.myDescription != null) {
            tagData.append(this.myDescription.toXmlString());
        }
        tagData.append("</pRef>");
        tagData.append("\n");
        return tagData.toString();
    }

    @Override
    public int compareTo(RAMLRelatedParameter o) {
        if (this.getParamName() == null) {
            return -1;
        }
        if (o.getParamName() == null) {
            return 1;
        }
        return this.getParamName().compareTo(o.getParamName());
    }
}

