/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLDescription;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLRelatedParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RAMLRelatedParams
implements Serializable {
    private static final long serialVersionUID = -1130278006989780121L;
    private List<RAMLRelatedParameter> myRelatedParams = new ArrayList<RAMLRelatedParameter>();
    private RAMLDescription myDescription = null;

    public void readRelatedParameters(Node relatedParameters) {
        NodeList childNodes = relatedParameters.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("description")) {
                this.myDescription = new RAMLDescription(childNode);
            } else if (childNode.getNodeName().equals("pRef")) {
                NamedNodeMap attributes = childNode.getAttributes();
                String className = attributes.getNamedItem("class").getNodeValue();
                String pName = attributes.getNamedItem("name").getNodeValue();
                String pHidden = attributes.getNamedItem("hidden").getNodeValue();
                RAMLRelatedParameter rp = new RAMLRelatedParameter(className, pName, pHidden);
                this.setRelatedParamDesc(childNode, rp);
                this.myRelatedParams.add(rp);
            }
            ++i;
        }
    }

    private void setRelatedParamDesc(Node relatedParamNode, RAMLRelatedParameter relatedParam) {
        NodeList childNodes = relatedParamNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("pRefDesc")) {
                relatedParam.setDescription(new RAMLDescription(childNode));
            }
            ++i;
        }
    }

    public List<RAMLRelatedParameter> getRelatedParams() {
        return this.myRelatedParams;
    }

    public RAMLDescription getDescription() {
        return this.myDescription;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Related params description: ");
        sb.append(this.myDescription);
        sb.append(" params: ");
        sb.append(this.myRelatedParams);
        return sb.toString();
    }

    public String toXmlString() {
        StringBuilder tagData = new StringBuilder();
        tagData.append("<relatedParameters>");
        tagData.append("\n");
        for (RAMLRelatedParameter p : this.myRelatedParams) {
            tagData.append(p.toXmlString());
        }
        if (this.myDescription != null) {
            tagData.append(this.myDescription.toXmlString());
        }
        tagData.append("</relatedParameters>");
        tagData.append("\n");
        return tagData.toString();
    }
}

