/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata;

import com.nokia.em.poseidon.frameworks.raml.RAMLHelpper;
import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.metadata.AbstractRelationshipIDEnabledRAMLValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLCondition;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLLogicalValidatorBase;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLRelatedParameterCreationValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLRelatedParameterOccursValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLRelatedParameterValidatorFactory;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBoolean;
import com.nokia.em.poseidon.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RamlConditionRelatedParameter
extends AbstractRelationshipIDEnabledRAMLValidator
implements Serializable {
    private static final long serialVersionUID = -1877048021432406439L;
    private String myParentClass;
    private String myScope;
    private String myClassName;
    private String myListName;
    private String myParamName;
    private String myValue;
    private String myMaxOccurs;
    private String myMinOccurs;
    private String myExactOccurs;
    private String myMaxIncl;
    private String myMinIncl;
    private String myValueOperation;
    private String myBinding;
    private String myOperationScope;
    private RAMLParameter myRAMLParameter = null;
    private RAMLList myRAMLList = null;
    private RAMLMetaParameter myMetaParameter = null;
    private List<AbstractRelationshipIDEnabledRAMLValidator> myParameterValidators = new ArrayList<AbstractRelationshipIDEnabledRAMLValidator>();
    private RAMLManagedObject myManagedObject;
    private String myReason = "";
    private String myLocation = "";
    private RAMLCondition myParentCondition;
    private RAMLItem myParentRAMLItem;
    private boolean myIsErrorReasonVisible = true;
    private boolean myHasMinOccursCheck = false;
    private boolean myHasMandatoryCheck = false;

    public RamlConditionRelatedParameter(Node node, RAMLCondition condition) {
        this(node);
        this.myParentCondition = condition;
    }

    public RamlConditionRelatedParameter(Node node) {
        this.readAttributes(node);
        this.readElement(node);
        this.createParameterLocation();
        this.createReason();
        this.readBasicValidateCheck();
    }

    private void readBasicValidateCheck() {
        if (this.myParameterValidators != null && this.myParameterValidators.size() != 0) {
            for (RAMLValidator rAMLValidator : this.myParameterValidators) {
                if (rAMLValidator instanceof RAMLRelatedParameterOccursValidator) {
                    this.readMinOccursCheck(rAMLValidator);
                    continue;
                }
                if (!(rAMLValidator instanceof RAMLRelatedParameterCreationValidator)) continue;
                this.readMandatoryCheck(rAMLValidator);
            }
        }
    }

    private void readMandatoryCheck(RAMLValidator validator) {
        RAMLRelatedParameterCreationValidator creationValidator = (RAMLRelatedParameterCreationValidator)validator;
        if (creationValidator.getPriority() != null && creationValidator.getPriority().equals("mandatory")) {
            this.myHasMandatoryCheck = true;
        }
    }

    private void readMinOccursCheck(RAMLValidator validator) {
        RAMLRelatedParameterOccursValidator occursValidator = (RAMLRelatedParameterOccursValidator)validator;
        if (occursValidator.getMinOccurs() != null && RAMLLogicalValidatorBase.parseInt(occursValidator.getMinOccurs()) > this.getOccurrence()) {
            this.myHasMinOccursCheck = true;
        }
    }

    private void readAttributes(Node referenceNode) {
        NamedNodeMap attributes = referenceNode.getAttributes();
        this.myClassName = this.readAttribute(attributes, "class");
        this.myListName = this.readAttribute(attributes, "list");
        this.myParamName = this.readAttribute(attributes, "name");
        this.myValue = this.readAttribute(attributes, "value");
        this.myValueOperation = this.readAttribute(attributes, "valueOperation");
        this.myBinding = this.readAttribute(attributes, "binding");
        this.myMaxOccurs = this.readAttribute(attributes, "maxOccurs");
        this.myMinOccurs = this.readAttribute(attributes, "minOccurs");
        this.myExactOccurs = this.readAttribute(attributes, "exactOccurs");
        this.myMaxIncl = this.readAttribute(attributes, "maxIncl");
        this.myMinIncl = this.readAttribute(attributes, "minIncl");
        this.myParentClass = this.readAttribute(attributes, "parentClass");
        this.myScope = this.readAttribute(attributes, "scope");
        this.myOperationScope = this.readAttribute(attributes, "operationScope");
        String errorReasonVisibleAttribute = this.readAttribute(attributes, "errorReasonVisible");
        if (errorReasonVisibleAttribute != null) {
            this.myIsErrorReasonVisible = Boolean.valueOf(errorReasonVisibleAttribute);
        }
    }

    private String readAttribute(NamedNodeMap attributes, String name) {
        Node attr = attributes.getNamedItem(name);
        return attr == null ? null : attr.getNodeValue();
    }

    public boolean isValidationMatched() {
        if (this.ispRefEmpty()) {
            return true;
        }
        List<String> valuesToBeValidated = this.getConditionRelatedParameterValues();
        if (this.hasComparisonOperation() && !RAMLLogicalValidatorBase.isValueValid(this.myValueOperation, this.myValue, valuesToBeValidated, this.myOperationScope)) {
            return false;
        }
        if (this.myExactOccurs != null && RAMLLogicalValidatorBase.parseInt(this.myExactOccurs) != this.getOccurrence()) {
            return false;
        }
        if (this.myMinOccurs != null && RAMLLogicalValidatorBase.parseInt(this.myMinOccurs) > this.getOccurrence()) {
            return false;
        }
        if (this.myMaxOccurs != null && RAMLLogicalValidatorBase.parseInt(this.myMaxOccurs) < this.getOccurrence()) {
            return false;
        }
        if (this.myValue != null && this.myValueOperation == null && !RAMLLogicalValidatorBase.isValueValid("EQUAL", this.myValue, valuesToBeValidated, this.myOperationScope)) {
            return false;
        }
        return this.isRangeValidated(valuesToBeValidated);
    }

    public boolean hasSameValue(RamlConditionRelatedParameter relatedParameter) {
        String valueToBeValidated = this.getConditionRelatedParameterValue();
        String otherValueToBeValidated = relatedParameter.getConditionRelatedParameterValue();
        return valueToBeValidated != null && valueToBeValidated.equals(otherValueToBeValidated);
    }

    private int getOccurrence() {
        if (this.myParamName != null && this.myParamName.trim().length() != 0) {
            return this.getConditionRelatedParameterValues().size();
        }
        if (this.myListName != null && this.myListName.trim().length() != 0) {
            return this.getRelatedLists().size();
        }
        return -1;
    }

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        if (objectToBeValidated instanceof RAMLParameter) {
            this.myRAMLParameter = (RAMLParameter)objectToBeValidated;
        } else if (objectToBeValidated instanceof RAMLList) {
            this.myRAMLList = (RAMLList)objectToBeValidated;
        }
        this.myMetaParameter = (RAMLMetaParameter)metaData;
        for (AbstractRelationshipIDEnabledRAMLValidator validator : this.myParameterValidators) {
            if (validator == null) continue;
            validator.setRelationshipId(this.getRelationshipId());
            validator.validate(validationContext, metaData, objectToBeValidated);
        }
    }

    public String getConditionRelatedParameterValue() {
        if (this.myParamName == null) {
            return this.myValue;
        }
        if (this.myManagedObject.getMOClass().equals(this.myClassName)) {
            return RAMLLogicalValidatorBase.getParameterValue(this.myManagedObject, this.myListName, this.myParamName, this.myRAMLParameter);
        }
        List<String> stringValue = this.getConditionRelatedParameterValues();
        if (stringValue != null && !stringValue.isEmpty()) {
            return stringValue.get(0);
        }
        return null;
    }

    public List<String> getConditionRelatedParameterValues() {
        List<RAMLParameter> parameters = this.getRelatedParameters();
        ArrayList<String> values = new ArrayList<String>();
        if (parameters != null) {
            for (RAMLParameter parameter : parameters) {
                String value = parameter.getValue();
                if (TextUtils.isInteger(value)) {
                    value = parameter.getIntegerValueAsString();
                } else if (value != null && parameter.getMetaData().getValueType() instanceof RAMLBoolean) {
                    value = value.toLowerCase();
                }
                values.add(value);
            }
        }
        return values;
    }

    public List<RAMLParameter> getRelatedParameters() {
        ArrayList<RAMLParameter> parameters = new ArrayList<RAMLParameter>();
        if ("CURRENT".equals(this.myScope)) {
            if (this.myListName != null) {
                RAMLItem item = this.getParentRAMLItem();
                RAMLParameter parameter = item.getParameter(this.myParamName);
                if (parameter != null) {
                    parameters.add(parameter);
                }
            } else {
                RAMLParameter param = this.myManagedObject.getParameter(this.myParamName);
                if (param != null) {
                    parameters.add(param);
                }
            }
        } else if (this.myManagedObject != null) {
            return this.getParametersInScope();
        }
        return parameters;
    }

    public List<String> getTargetParameterValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (RAMLParameter parameter : this.getTargetParameters()) {
            values.add(parameter.getValue());
        }
        return values;
    }

    public List<RAMLParameter> getTargetParameters() {
        List<RAMLParameter> result = new ArrayList<RAMLParameter>();
        if (this.myRAMLParameter == null) {
            return result;
        }
        if (this.myRAMLParameter.getName() == null) {
            RAMLList<?> parameterList = this.myManagedObject.getList(this.myMetaParameter.getName());
            RAMLParameterList pList = (RAMLParameterList)parameterList;
            int n = 0;
            while (n < pList.getParameters().size()) {
                RAMLParameter p = pList.getParameters().get(n);
                result.add(p);
                ++n;
            }
            return result;
        }
        result = this.myParamName != null && this.myRAMLParameter.getName().equals(this.myParamName) ? this.getParametersInScope() : RAMLHelpper.getParameters(this.myManagedObject, this.myClassName, this.myListName, this.myRAMLParameter.getName(), RAMLHelpper.RAMLScope.WHOLE_RAML);
        return result;
    }

    private List<RAMLParameter> getParametersInScope() {
        List<RAMLParameter> result = null;
        if (this.hasScope() && !"CURRENT".equals(this.myScope)) {
            RAMLManagedObject parentMO = null;
            parentMO = this.myManagedObject.getMOClass().equals(this.myParentClass) ? this.myManagedObject : RAMLHelpper.getParentMOByName(this.myManagedObject, this.myParentClass);
            if (parentMO != null) {
                RAMLManagedObject parentMO2 = parentMO.getParentMO();
                if (parentMO2 != null && this.myScope.equals("ALL")) {
                    result = RAMLHelpper.getParameters(parentMO2, this.myClassName, this.myListName, this.myParamName, RAMLHelpper.RAMLScope.SINGLE_MO);
                } else if (this.myScope.equals("SINGLE")) {
                    result = RAMLHelpper.getParameters(parentMO, this.myClassName, this.myListName, this.myParamName, RAMLHelpper.RAMLScope.SINGLE_MO);
                }
            }
        } else {
            RAMLManagedObject parentMO = RAMLHelpper.getParentMOByName(this.myManagedObject, this.myClassName);
            result = parentMO == null ? RAMLHelpper.getParameters(this.myManagedObject, this.myClassName, this.myListName, this.myParamName, RAMLHelpper.RAMLScope.CURRENT_MO) : RAMLHelpper.getParameters(parentMO, this.myClassName, this.myListName, this.myParamName, RAMLHelpper.RAMLScope.CURRENT_MO);
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public List<RAMLList> getTargetLists() {
        if (this.myListName != null && this.myListName.equals(this.myMetaParameter.getName())) {
            return this.getListsInScope();
        }
        return RAMLHelpper.getLists(this.myManagedObject, this.myClassName, this.myMetaParameter.getName(), RAMLHelpper.RAMLScope.WHOLE_RAML);
    }

    private List<RAMLList> getRelatedLists() {
        if (this.myListName != null) {
            return this.getListsInScope();
        }
        return new ArrayList<RAMLList>();
    }

    private List<RAMLList> getListsInScope() {
        List<RAMLList> ramlLists = new ArrayList<RAMLList>();
        if (this.hasScope()) {
            RAMLManagedObject parentMO = RAMLHelpper.getParentMOByName(this.myManagedObject, this.myParentClass);
            if (parentMO != null) {
                if (this.myScope.equals("ALL")) {
                    ramlLists = RAMLHelpper.getLists(parentMO.getParentMO(), this.myClassName, this.myListName, RAMLHelpper.RAMLScope.SINGLE_MO);
                } else if (this.myScope.equals("SINGLE")) {
                    ramlLists = RAMLHelpper.getLists(parentMO, this.myClassName, this.myListName, RAMLHelpper.RAMLScope.SINGLE_MO);
                }
            }
        } else {
            ramlLists = RAMLHelpper.getLists(this.myManagedObject, this.myClassName, this.myListName, RAMLHelpper.RAMLScope.CURRENT_MO);
        }
        return ramlLists;
    }

    public String getResultValue() {
        if (this.myValueOperation != null && RAMLLogicalValidatorBase.isCalculativeOperation(this.myValueOperation)) {
            try {
                if (this.myValue == null) {
                    return this.getConditionRelatedParameterValue();
                }
                if (this.myClassName == null || this.myParamName == null) {
                    return this.myValue;
                }
                double parameterA = RAMLLogicalValidatorBase.parseDouble(this.getConditionRelatedParameterValue());
                double parameterB = RAMLLogicalValidatorBase.parseDouble(this.myValue);
                return String.valueOf(RAMLLogicalValidatorBase.calculate(parameterA, this.myValueOperation, parameterB));
            }
            catch (Exception e) {
                return null;
            }
        }
        if ("CONCATENATE".equals(this.myValueOperation)) {
            if (this.myBinding != null) {
                return String.valueOf(this.myBinding) + this.getConditionRelatedParameterValue();
            }
            return this.getConditionRelatedParameterValue();
        }
        if (this.myParamName == null) {
            return this.myValue;
        }
        return this.getConditionRelatedParameterValue();
    }

    public String getValueOperationType() {
        return this.myValueOperation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Related param class: ");
        sb.append(this.myClassName);
        sb.append(" param: ");
        sb.append(this.myParamName);
        sb.append(" list: ");
        sb.append(this.myListName);
        sb.append(" valueOperation: ");
        sb.append(this.myValueOperation);
        sb.append(" value: ");
        sb.append(this.myValue);
        return sb.toString();
    }

    private void readElement(Node conditionNode) {
        NodeList childNodes = conditionNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            this.myParameterValidators.add(RAMLRelatedParameterValidatorFactory.createValidator(childNode, this));
            ++i;
        }
    }

    public void setRAMLParameter(RAMLParameter parameter) {
        this.myRAMLParameter = parameter;
        if (this.myRAMLParameter.getParent() instanceof RAMLItem) {
            this.myParentRAMLItem = (RAMLItem)this.myRAMLParameter.getParent();
        }
        this.myManagedObject = this.myRAMLParameter.getManagedObject();
    }

    public void setRAMLList(RAMLList ramlList) {
        this.myRAMLList = ramlList;
        if (this.myRAMLList != null) {
            this.myManagedObject = this.myRAMLList.getManagedObject();
        }
    }

    public void setManagedObject(RAMLManagedObject managedObject) {
        this.myManagedObject = managedObject;
    }

    public void setMetaParameter(RAMLMetaParameter metaParameter) {
        this.myMetaParameter = metaParameter;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public String getParamName() {
        return this.myParamName;
    }

    public String getFullParamName() {
        RAMLMetaParameter metaParam = null;
        if (this.myManagedObject != null) {
            if (this.myManagedObject.getMOClass().equals(this.myClassName)) {
                metaParam = this.myListName == null ? this.myManagedObject.getMetaData().getMetaParameter(this.myParamName) : this.myManagedObject.getMetaData().getMetaParameterFromList(this.myListName, this.myParamName);
            }
            if (metaParam == null) {
                List<RAMLParameter> params = this.getRelatedParameters();
                int i = 0;
                while (params != null && i < params.size()) {
                    RAMLParameter param = params.get(i);
                    if (this.isConditionRelatedParameterFound(param)) {
                        metaParam = param.getMetaData();
                        break;
                    }
                    ++i;
                }
            }
        }
        if (metaParam != null) {
            return metaParam.getFullName();
        }
        return null;
    }

    public String getParentClass() {
        return this.myParentClass;
    }

    public String getScope() {
        return this.myScope;
    }

    public boolean hasScope() {
        return this.myParentClass != null && this.myScope != null;
    }

    public String getListName() {
        return this.myListName;
    }

    public String getValue() {
        return this.myValue;
    }

    public String getValueOperation() {
        return this.myValueOperation;
    }

    public String getMinOccurs() {
        return this.myMinOccurs;
    }

    public String getMaxOccurs() {
        return this.myMaxOccurs;
    }

    public String getExactOccurs() {
        return this.myExactOccurs;
    }

    public String getOperationScope() {
        return this.myOperationScope;
    }

    public boolean isPreCondition() {
        return this.hasValueCheck() || this.hasRangeCheck() || this.hasOccursCheck() || this.hasEmptyCheck();
    }

    private boolean hasValueCheck() {
        return this.myValue != null && this.myParamName != null && (this.myValueOperation == null || this.hasComparisonOperation());
    }

    private boolean hasRangeCheck() {
        return this.myParamName != null && (this.myMaxIncl != null || this.myMinIncl != null);
    }

    private boolean hasOccursCheck() {
        return !(this.myParamName == null && this.myListName == null || this.myMaxOccurs == null && this.myMinOccurs == null && this.myExactOccurs == null);
    }

    private boolean hasEmptyCheck() {
        return (this.myParamName != null || this.myListName != null) && this.hasEmptyOperation();
    }

    private boolean hasEmptyOperation() {
        return this.myValueOperation != null && (this.myValueOperation.equals("EMPTY") || this.myValueOperation.equals("NOT_EMPTY"));
    }

    public boolean hasMinOccursCheck(RAMLManagedObject moToBeValidated) {
        this.myManagedObject = moToBeValidated;
        if (this.isValidationMatched()) {
            return this.myHasMinOccursCheck;
        }
        return false;
    }

    public boolean hasMandatoryCheck(RAMLManagedObject moToBeValidated) {
        this.myManagedObject = moToBeValidated;
        if (this.isValidationMatched()) {
            return this.myHasMandatoryCheck;
        }
        return false;
    }

    public RAMLCondition getParentCondition() {
        return this.myParentCondition;
    }

    private boolean ispRefEmpty() {
        return this.myParamName == null && this.myListName == null;
    }

    private boolean hasComparisonOperation() {
        return this.myValueOperation != null && (this.myValueOperation.equals("EQUAL") || this.myValueOperation.equals("NOT_EQUAL") || this.myValueOperation.equals("BIGGER") || this.myValueOperation.equals("SMALLER") || this.myValueOperation.equals("BIGGER_OR_EQUAL") || this.myValueOperation.equals("SMALLER_OR_EQUAL") || this.myValueOperation.equals("EMPTY") || this.myValueOperation.equals("NOT_EMPTY") || this.myValueOperation.equals("MATCHES") || this.myValueOperation.equals("NOT_MATCHES"));
    }

    private boolean isRangeValidated(List<String> valuesToBeValidated) {
        if (this.myMinIncl == null && this.myMaxIncl == null) {
            return true;
        }
        if ("ALL".equals(this.myOperationScope)) {
            for (String valueToBeValidated : valuesToBeValidated) {
                boolean isMaxNotValidated;
                boolean isMinNotValidated = this.myMinIncl != null && RAMLLogicalValidatorBase.parseInt(this.myMinIncl) > RAMLLogicalValidatorBase.parseInt(valueToBeValidated);
                boolean bl = isMaxNotValidated = this.myMaxIncl != null && RAMLLogicalValidatorBase.parseInt(valueToBeValidated) > RAMLLogicalValidatorBase.parseInt(this.myMaxIncl);
                if (!isMinNotValidated || !isMaxNotValidated) continue;
                return false;
            }
            return true;
        }
        if (this.myOperationScope == null || "ANY".equals(this.myOperationScope)) {
            for (String valueToBeValidated : valuesToBeValidated) {
                boolean isMaxNotValidated;
                boolean isMinNotValidated = this.myMinIncl != null && RAMLLogicalValidatorBase.parseInt(this.myMinIncl) > RAMLLogicalValidatorBase.parseInt(valueToBeValidated);
                boolean bl = isMaxNotValidated = this.myMaxIncl != null && RAMLLogicalValidatorBase.parseInt(valueToBeValidated) > RAMLLogicalValidatorBase.parseInt(this.myMaxIncl);
                if (isMinNotValidated || isMaxNotValidated) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void setParentRAMLItem(RAMLItem item) {
        this.myParentRAMLItem = item;
    }

    private RAMLItem getParentRAMLItem() {
        if (this.myParentRAMLItem != null) {
            return this.myParentRAMLItem;
        }
        if (this.myRAMLParameter != null && this.myRAMLParameter.getParent() instanceof RAMLItem) {
            return (RAMLItem)this.myRAMLParameter.getParent();
        }
        return new RAMLItem();
    }

    public String getReason() {
        return this.myReason == null ? "" : this.myReason.toString();
    }

    protected void createReason() {
        this.myReason = RAMLValidationErrorMessageFactory.generateReasonClause(this);
    }

    public String getParameterLocation() {
        return this.myLocation == null ? "" : this.myLocation.toString();
    }

    protected void createParameterLocation() {
        this.myLocation = RAMLValidationErrorMessageFactory.generateParameterLocation(this);
    }

    public RAMLMetaParameter getListMetaParameter() {
        return this.getRelatedParameters().stream().filter(this::isConditionRelatedParameterFound).map(relParam -> relParam.getManagedObject()).map(mo -> mo.getMetaData()).map(metadata -> metadata.getMetaParameter(this.myListName)).findFirst().orElse(null);
    }

    private boolean isConditionRelatedParameterFound(RAMLParameter param) {
        return param != null && param.getName() != null && param.getManagedObject() != null && param.getManagedObject().getMOClass() != null && param.getName().equals(this.myParamName) && param.getManagedObject().getMOClass().equals(this.myClassName);
    }

    public String getFormsOfCalculation() {
        return RAMLValidationErrorMessageFactory.generateFormsOfCalculationClause(this);
    }

    public boolean isErrorReasonVisible() {
        return this.myIsErrorReasonVisible;
    }

    public String getMaxIncl() {
        return this.myMaxIncl;
    }

    public String getMinIncl() {
        return this.myMinIncl;
    }

    public RAMLManagedObject getManagedObject() {
        return this.myManagedObject;
    }

    public RAMLList<?> getRAMLList() {
        return this.myRAMLList;
    }
}

