/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.logical;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLHelpper;
import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLItemList;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaManagedObject;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLOperation;
import com.nokia.em.poseidon.frameworks.raml.metadata.RamlConditionRelatedParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDecimal;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDecimalValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLEnum;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLNumber;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLValue;
import com.nokia.em.poseidon.util.TextUtils;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class RAMLLogicalValidatorBase
implements Serializable {
    private static final long serialVersionUID = 5841560637076689018L;
    private static transient ResourceBundle myRB = I18n.getI18n().getBundle(RAMLLogicalValidatorBase.class);
    private static transient Logger myLogger = Logger.getLogger(RAMLLogicalValidatorBase.class);
    public static final String WHOLE_SCF = "WHOLE_RAML";
    public static final String SINGLE_MO = "SINGLE_MO";
    public static final String CURRENT_MO = "CURRENT_MO";

    private RAMLLogicalValidatorBase() {
    }

    public static boolean isValueValid(String valueType, String targetValue, String comparedValue) {
        switch (RAMLLogicalValidatorBase.getValue(valueType)) {
            case SMALLER: {
                return RAMLLogicalValidatorBase.areValuesNotEmpty(targetValue, comparedValue) && RAMLLogicalValidatorBase.isValueSmaller(targetValue, comparedValue);
            }
            case BIGGER: {
                return RAMLLogicalValidatorBase.areValuesNotEmpty(targetValue, comparedValue) && RAMLLogicalValidatorBase.isValueBigger(targetValue, comparedValue);
            }
            case SMALLER_OR_EQUAL: {
                return RAMLLogicalValidatorBase.areValuesNotEmpty(targetValue, comparedValue) && RAMLLogicalValidatorBase.isValueSmallerOrEqual(targetValue, comparedValue);
            }
            case BIGGER_OR_EQUAL: {
                return RAMLLogicalValidatorBase.areValuesNotEmpty(targetValue, comparedValue) && RAMLLogicalValidatorBase.isValueBiggerOrEqual(targetValue, comparedValue);
            }
            case EMPTY: {
                return RAMLLogicalValidatorBase.isValueEmpty(comparedValue);
            }
            case NOT_EMPTY: {
                return RAMLLogicalValidatorBase.isValueNotEmpty(comparedValue);
            }
            case EQUAL: {
                return RAMLLogicalValidatorBase.isEquals(targetValue, comparedValue);
            }
            case NOT_EQUAL: {
                return RAMLLogicalValidatorBase.isNotEquals(targetValue, comparedValue);
            }
            case MATCHES: {
                return RAMLLogicalValidatorBase.isMatches(targetValue, comparedValue);
            }
            case NOT_MATCHES: {
                return !RAMLLogicalValidatorBase.isMatches(targetValue, comparedValue);
            }
        }
        return RAMLLogicalValidatorBase.isEquals(targetValue, comparedValue);
    }

    private static boolean areValuesNotEmpty(String ... values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value == null || value.isEmpty()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isMatches(String targetValue, String comparedValue) {
        if (targetValue == null || comparedValue == null) {
            return false;
        }
        return Pattern.matches(targetValue, comparedValue);
    }

    public static boolean isValueValid(String valueType, List<String> targetValues, String comparedValue) {
        if (targetValues == null || targetValues.size() == 0) {
            if (RAMLLogicalValidatorBase.isValueValid(valueType, "", comparedValue)) {
                return true;
            }
        } else {
            for (String targetValue : targetValues) {
                if (!RAMLLogicalValidatorBase.isValueValid(valueType, targetValue, comparedValue)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValueValid(RAMLMetaParameter metaData, String valueType, List<String> targetValues, String comparedValue, String operationScope) {
        if (metaData == null || metaData.getValueType() instanceof RAMLDecimal && !TextUtils.isNumeric(comparedValue)) {
            return true;
        }
        return RAMLLogicalValidatorBase.isValueValid(valueType, targetValues, comparedValue, operationScope);
    }

    public static boolean isValueValid(String valueType, List<String> targetValues, String comparedValue, String operationScope) {
        if (operationScope == null || "ANY".equals(operationScope)) {
            for (String targetValue : targetValues) {
                if (!RAMLLogicalValidatorBase.isValueValid(valueType, targetValue, comparedValue)) continue;
                return true;
            }
            return false;
        }
        if ("ALL".equals(operationScope)) {
            for (String targetValue : targetValues) {
                if (RAMLLogicalValidatorBase.isValueValid(valueType, targetValue, comparedValue)) continue;
                return false;
            }
            return true;
        }
        if (operationScope.equals("CURRENT")) {
            return RAMLLogicalValidatorBase.isValueValid(valueType, targetValues.get(0), comparedValue);
        }
        return false;
    }

    public static boolean isValueValid(String valueType, String targetValue, List<String> comparedValues, String operationScope) {
        if (comparedValues.isEmpty()) {
            return "EMPTY".equals(valueType);
        }
        if (operationScope == null || "ANY".equals(operationScope)) {
            for (String comparedValue : comparedValues) {
                if (!RAMLLogicalValidatorBase.isValueValid(valueType, targetValue, comparedValue)) continue;
                return true;
            }
            return false;
        }
        if ("ALL".equals(operationScope)) {
            for (String comparedValue : comparedValues) {
                if (RAMLLogicalValidatorBase.isValueValid(valueType, targetValue, comparedValue)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isValueBiggerOrEqual(String targetValue, String comparedValue) {
        return RAMLLogicalValidatorBase.isValueBigger(targetValue, comparedValue) || RAMLLogicalValidatorBase.isEquals(targetValue, comparedValue);
    }

    private static boolean isNotEquals(String targetValue, String comparedValue) {
        return !RAMLLogicalValidatorBase.isEquals(targetValue, comparedValue);
    }

    private static boolean isEquals(String targetValue, String comparedValue) {
        if (TextUtils.isNumeric(targetValue) && TextUtils.isNumeric(comparedValue)) {
            return Double.parseDouble(targetValue) == Double.parseDouble(comparedValue);
        }
        if (targetValue != null) {
            return targetValue.equals(comparedValue);
        }
        return comparedValue == null;
    }

    private static boolean isValueNotEmpty(String comparedValue) {
        return comparedValue != null && comparedValue.length() > 0;
    }

    private static boolean isValueEmpty(String comparedValue) {
        return comparedValue == null || comparedValue.length() == 0;
    }

    private static boolean isValueSmallerOrEqual(String targetValue, String comparedValue) {
        return RAMLLogicalValidatorBase.isValueSmaller(targetValue, comparedValue) || RAMLLogicalValidatorBase.isEquals(targetValue, comparedValue);
    }

    private static boolean isValueBigger(String targetValue, String comparedValue) {
        try {
            Double target = Double.parseDouble(targetValue);
            Double compared = Double.parseDouble(comparedValue);
            return compared.compareTo(target) > 0;
        }
        catch (Exception e) {
            return comparedValue.compareTo(targetValue) > 0;
        }
    }

    private static boolean isValueSmaller(String targetValue, String comparedValue) {
        try {
            Double target = Double.parseDouble(targetValue);
            Double compared = Double.parseDouble(comparedValue);
            return compared.compareTo(target) < 0;
        }
        catch (Exception e) {
            return comparedValue.compareTo(targetValue) < 0;
        }
    }

    private static Value getValue(String value) {
        if ("SMALLER".equalsIgnoreCase(value)) {
            return Value.SMALLER;
        }
        if ("BIGGER".equalsIgnoreCase(value)) {
            return Value.BIGGER;
        }
        if ("SMALLER_OR_EQUAL".equalsIgnoreCase(value)) {
            return Value.SMALLER_OR_EQUAL;
        }
        if ("BIGGER_OR_EQUAL".equalsIgnoreCase(value)) {
            return Value.BIGGER_OR_EQUAL;
        }
        if ("EMPTY".equalsIgnoreCase(value)) {
            return Value.EMPTY;
        }
        if ("NOT_EMPTY".equalsIgnoreCase(value)) {
            return Value.NOT_EMPTY;
        }
        if ("EQUAL".equalsIgnoreCase(value)) {
            return Value.EQUAL;
        }
        if ("NOT_EQUAL".equalsIgnoreCase(value)) {
            return Value.NOT_EQUAL;
        }
        if ("MATCHES".equalsIgnoreCase(value)) {
            return Value.MATCHES;
        }
        if ("NOT_MATCHES".equalsIgnoreCase(value)) {
            return Value.NOT_MATCHES;
        }
        return Value.VALUE;
    }

    public static RAMLValidationResult generateValidationError(RAMLMetaParameter metaP, Object object, String details) {
        RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationErrorWithoutParameterName(metaP, object, details);
        result.setParameterName(metaP.getName());
        return result;
    }

    public static RAMLValidationResult generateValidationErrorWithoutParameterName(RAMLMetaParameter metaP, Object object, String details) {
        String disName = "";
        String version = "";
        String value = "";
        if (object instanceof RAMLParameter) {
            RAMLParameter ramlParameter = (RAMLParameter)object;
            disName = ramlParameter.getManagedObject().getDistName();
            version = ramlParameter.getManagedObject().getVersion();
            value = ramlParameter.getValue();
        } else if (object instanceof RAMLList) {
            RAMLList ramlList = (RAMLList)object;
            disName = ramlList.getManagedObject().getDistName();
            version = ramlList.getManagedObject().getVersion();
        }
        RAMLValidationResult result = RAMLValidationResult.createErrorResult();
        result.setDistName(disName);
        result.setVersion(version);
        if (value.length() > 0) {
            result.setText(myRB.getString("RAMLValidation.Incorrect.Parameter"));
        } else {
            result.setText(myRB.getString("RAMLValidation.Incomplete.Configuration"));
        }
        result.setDetails(details);
        return result;
    }

    public static RAMLValidationResult generateValidationError(RAMLMetaManagedObject object, String details) {
        RAMLValidationResult result = RAMLValidationResult.createErrorResult();
        result.setDistName(object.getClassName());
        result.setParameterName("");
        result.setVersion(object.getVersion());
        result.setText(myRB.getString("RAMLValidation.Incomplete.Configuration"));
        result.setDetails(details);
        return result;
    }

    public static RAMLValidationResult generateValidationError(RAMLManagedObject object, String details) {
        RAMLValidationResult result = RAMLValidationResult.createErrorResult();
        result.setDistName(object.getDistName());
        result.setParameterName("");
        result.setVersion(object.getVersion());
        result.setText(myRB.getString("RAMLValidation.Incomplete.Configuration"));
        result.setDetails(details);
        return result;
    }

    public static boolean isCalculativeOperation(String operation) {
        String oper = operation.toUpperCase();
        return oper.equals("ADD") || oper.equals("SUBTRACT") || oper.equals("MULTIPLY") || oper.equals("DIVIDE") || oper.equals("MODULO") || oper.equals("POWER");
    }

    public static boolean isComparativeOperation(String operation) {
        String oper = operation.toUpperCase();
        return oper.equals("EQUAL") || oper.equals("NOT_EQUAL") || oper.equals("SMALLER") || oper.equals("SMALLER_OR_EQUAL") || oper.equals("BIGGER") || oper.equals("BIGGER_OR_EQUAL") || oper.equals("MATCHES") || oper.equals("NOT_MATCHES");
    }

    public static String doCalculation(List<RAMLOperation> operations, double parameter) {
        double parameterA = parameter;
        for (RAMLOperation operation : operations) {
            String operationValue = operation.getOperationValue();
            double parameterB = operation.getParameterValue();
            parameterA = RAMLLogicalValidatorBase.calculate(parameterA, operationValue, parameterB);
        }
        return String.valueOf(parameterA);
    }

    public static String doCalculation(RAMLOperation operation) {
        String parameterA;
        block3: {
            List<RamlConditionRelatedParameter> parameters;
            block2: {
                parameters = operation.getAllRelatedParameters();
                parameterA = parameters.get(0).getConditionRelatedParameterValue();
                if (!operation.getOperationValue().trim().equals("MIN")) break block2;
                int i = 1;
                while (i < parameters.size()) {
                    String parameterB = parameters.get(i).getConditionRelatedParameterValue();
                    parameterA = RAMLLogicalValidatorBase.parseInt(parameterA) < RAMLLogicalValidatorBase.parseInt(parameterB) ? parameterA : parameterB;
                    ++i;
                }
                break block3;
            }
            if (!operation.getOperationValue().trim().equals("MAX")) break block3;
            int i = 1;
            while (i < parameters.size()) {
                String parameterB = parameters.get(i).getConditionRelatedParameterValue();
                parameterA = RAMLLogicalValidatorBase.parseInt(parameterA) > RAMLLogicalValidatorBase.parseInt(parameterB) ? parameterA : parameterB;
                ++i;
            }
        }
        return parameterA;
    }

    public static double calculate(double parameterA, String calculateType, double parameterB) {
        if (calculateType.equals("ADD")) {
            return parameterA + parameterB;
        }
        if (calculateType.equals("SUBTRACT")) {
            return parameterA - parameterB;
        }
        if (calculateType.equals("MULTIPLY")) {
            return parameterA * parameterB;
        }
        if (calculateType.equals("DIVIDE")) {
            return parameterA / parameterB;
        }
        if (calculateType.equals("MODULO")) {
            return parameterA % parameterB;
        }
        if (calculateType.equals("POWER")) {
            return Math.pow(parameterA, parameterB);
        }
        return -1.0;
    }

    public static boolean shouldRelatedParamCal(List<RamlConditionRelatedParameter> parameters) {
        if (parameters != null && parameters.size() > 0) {
            if (parameters.size() == 1) {
                RamlConditionRelatedParameter param = parameters.get(0);
                if (param.getValueOperation() != null && (RAMLLogicalValidatorBase.isCalculativeOperation(param.getValueOperation()) || param.getValueOperation().equals("CONCATENATE"))) {
                    return true;
                }
                return param.getValue() != null && param.getParamName() == null;
            }
            int i = 1;
            while (i < parameters.size()) {
                RamlConditionRelatedParameter param = parameters.get(i);
                if (!RAMLLogicalValidatorBase.isCalculativeOperation(param.getValueOperation()) && !param.getValueOperation().equals("CONCATENATE")) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String doRelatedParamCal(List<RamlConditionRelatedParameter> parameters) {
        String parameterA = parameters.get(0).getResultValue();
        int i = 1;
        while (i < parameters.size()) {
            String parameterB = parameters.get(i).getResultValue().toString();
            String operationType = parameters.get(i).getValueOperationType();
            if (operationType.equals("CONCATENATE")) {
                parameterA = String.valueOf(parameterA) + parameterB;
            } else if (RAMLLogicalValidatorBase.isCalculativeOperation(operationType.toString())) {
                parameterA = String.valueOf(RAMLLogicalValidatorBase.calculate(RAMLLogicalValidatorBase.parseDouble(parameterA), operationType.toString(), RAMLLogicalValidatorBase.parseDouble(parameterB)));
            }
            ++i;
        }
        return parameterA;
    }

    public static String getParameterValue(RAMLManagedObject mObject, String listName, String parameterName, RAMLParameter parameterToBeValidated) {
        RAMLParameter parameter = null;
        if (listName == null || "".equals(listName.trim())) {
            parameter = mObject.getParameter(parameterName);
        } else {
            RAMLList<?> list = mObject.getList(listName);
            if (list instanceof RAMLItemList) {
                RAMLItemList itemList = (RAMLItemList)list;
                if (parameterToBeValidated != null && itemList.getItems().size() > 1) {
                    int i = 0;
                    while (i < itemList.getItems().size()) {
                        RAMLItem item = itemList.getItems().get(i);
                        if (item.getParameter(parameterToBeValidated.getName()) == parameterToBeValidated) {
                            parameter = item.getParameter(parameterName);
                        }
                        ++i;
                    }
                } else if (itemList.getItems().size() > 0) {
                    RAMLItem item = itemList.getItems().get(0);
                    parameter = item.getParameter(parameterName);
                }
            }
        }
        if (parameter != null) {
            String value = parameter.getValue();
            if (TextUtils.isInteger(value)) {
                return parameter.getIntegerValueAsString();
            }
            return value;
        }
        if (mObject.getMetaData().getInstanceParameter().getName().equals(parameterName)) {
            return mObject.getId();
        }
        return null;
    }

    @Deprecated
    public static List<RAMLList> getLists(RAMLManagedObject mObject, String className, String listName, String scope) {
        return RAMLHelpper.getLists(mObject, className, listName, RAMLHelpper.RAMLScope.valueOf(scope));
    }

    @Deprecated
    public static RAMLManagedObject getParentMOByName(RAMLManagedObject mo, String parentName) {
        return RAMLHelpper.getParentMOByName(mo, parentName);
    }

    @Deprecated
    public static List<String> getParameterValues(RAMLManagedObject mObject, String className, String listName, String parameterName, String scope) {
        return RAMLHelpper.getParameterValues(mObject, className, listName, parameterName, RAMLHelpper.RAMLScope.valueOf(scope));
    }

    @Deprecated
    public static List<RAMLParameter> getParameters(RAMLManagedObject mObject, String className, String listName, String parameterName, String scope) {
        return RAMLHelpper.getParameters(mObject, className, listName, parameterName, RAMLHelpper.RAMLScope.valueOf(scope));
    }

    @Deprecated
    public static List<RAMLManagedObject> getMOsByScope(RAMLManagedObject mObject, String className, String scope) {
        return RAMLHelpper.getMOsByScope(mObject, className, RAMLHelpper.RAMLScope.valueOf(scope));
    }

    public static int parseInt(String number) {
        if (number == null || "".equals(number.trim())) {
            return -1;
        }
        try {
            return new Double(number).intValue();
        }
        catch (NumberFormatException e) {
            myLogger.error(e.toString());
            return -1;
        }
    }

    public static double parseDouble(String number) {
        if (number == null || "".equals(number.trim())) {
            return -1.0;
        }
        try {
            return Double.parseDouble(number);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            myLogger.error("Incorrect number format");
            return -1.0;
        }
    }

    public static String getUIValue(RAMLParameter parameter) {
        return RAMLLogicalValidatorBase.getUIValue(parameter, parameter.getValue());
    }

    public static String getUIValue(RAMLParameter parameter, String internalValue) {
        if (parameter == null || parameter.getMetaData() == null) {
            return internalValue;
        }
        RAMLValue metadataValue = (RAMLValue)parameter.getMetaData().getValueType();
        if (RAMLValue.Type.SIMPLE.equals((Object)metadataValue.getType())) {
            String baseType = ((RAMLSimpleType)metadataValue).getBaseType();
            if (baseType.equals("decimal") && internalValue.length() != 0 && TextUtils.isNumeric(internalValue)) {
                return RAMLLogicalValidatorBase.getUIValueForDecimalParameter(metadataValue, internalValue);
            }
            if ("enumeration".equals(baseType) && !((RAMLEnum)metadataValue).getTexts().contains(internalValue) && TextUtils.isInteger(internalValue)) {
                Double value = Double.parseDouble(internalValue);
                return String.valueOf(value.intValue());
            }
        }
        return internalValue;
    }

    private static String getUIValueForDecimalParameter(RAMLValue metadataValue, String internalValue) {
        Double value = Double.parseDouble(internalValue);
        RAMLDecimal decimalMetadata = (RAMLDecimal)metadataValue;
        Integer multiplier = (Integer)decimalMetadata.getMultiplier();
        Integer divisor = (Integer)decimalMetadata.getDivisor();
        Double shift = (Double)decimalMetadata.getShift();
        if (!(RAMLDecimalValidator.isSpecialValue(value, decimalMetadata.getSpecialValues()) || multiplier == 1 && divisor == 1 && shift == 0.0)) {
            value = value * (double)multiplier.intValue();
            value = RAMLLogicalValidatorBase.safeDivide(value, divisor);
            if (TextUtils.isInteger(String.valueOf(value = Double.valueOf(value + shift))) && RAMLLogicalValidatorBase.isUIValueInteger(decimalMetadata)) {
                return String.valueOf(value.intValue());
            }
            return String.valueOf(value);
        }
        if (TextUtils.isInteger(String.valueOf(value))) {
            return String.valueOf(value.intValue());
        }
        return internalValue;
    }

    private static boolean isUIValueInteger(RAMLDecimal decimalMetadata) {
        Double step = (Double)decimalMetadata.getStep();
        Double maxValue = (Double)decimalMetadata.getMaxValue();
        Double minValue = (Double)decimalMetadata.getMinValue();
        return TextUtils.isInteger(String.valueOf(step)) && TextUtils.isInteger(String.valueOf(maxValue)) && TextUtils.isInteger(String.valueOf(minValue));
    }

    public static Double safeDivide(Double value, Integer divisor) {
        if (value == null || divisor == null) {
            return null;
        }
        Double result = value;
        Integer tempDivisor = divisor;
        String str = String.valueOf(value);
        if (str.contains(".") && !str.endsWith(".")) {
            int count = str.substring(str.lastIndexOf(".") + 1).length();
            int raise = new Double(Math.pow(10.0, count)).intValue();
            result = result * (double)raise;
            tempDivisor = tempDivisor * raise;
            result = result / (double)tempDivisor.intValue();
        } else {
            result = result / (double)tempDivisor.intValue();
        }
        return result;
    }

    public static void createInvalidValueError(RAMLValidationContext validationContext, RAMLParameter param, String value, RAMLMetaParameter metaP, RAMLNumber metaData) {
        String details = RAMLValidationErrorMessageFactory.createInvalidValueErrorMessage(metaP, param);
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
        result.setParameterName(param.getName());
        result.setDistName(param.getManagedObject().getDistName());
        result.setVersion(param.getManagedObject().getVersion());
        result.setText(myRB.getString("RAMLValidation.Incorrect.Parameter"));
        result.setDetails(details);
        result.setInvalidValueCheckIssue(true);
        validationContext.addResult(result);
    }

    public static enum Value {
        SMALLER,
        BIGGER,
        SMALLER_OR_EQUAL,
        BIGGER_OR_EQUAL,
        EMPTY,
        NOT_EMPTY,
        EQUAL,
        NOT_EQUAL,
        VALUE,
        MATCHES,
        NOT_MATCHES;

    }
}

