/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.logical;

import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RamlConditionRelatedParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLLogicalValidatorBase;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLRelatedParameterValidator;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RAMLRelatedParameterOccursValidator
extends RAMLRelatedParameterValidator {
    private static final long serialVersionUID = -5547660547553302741L;
    private String myMinOccurs;
    private String myExactOccurs;
    private String myMaxOccurs;
    private String myMaxDifferentOccurs;
    private transient Logger myLogger = Logger.getLogger(this.getClass());

    public RAMLRelatedParameterOccursValidator(Node node, RamlConditionRelatedParameter parent) {
        super(node, parent);
        this.readAttributes(node);
    }

    private void readAttributes(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        this.myMinOccurs = this.readAttribute(attributes, "minOccurs");
        this.myMaxOccurs = this.readAttribute(attributes, "maxOccurs");
        this.myExactOccurs = this.readAttribute(attributes, "exactOccurs");
        this.myMaxDifferentOccurs = this.readAttribute(attributes, "maxDifferentOccurs");
    }

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        String details;
        RAMLList myListToBeValidated = null;
        RAMLMetaParameter metaParameter = (RAMLMetaParameter)metaData;
        int occurrence = 0;
        if (objectToBeValidated instanceof RAMLParameter) {
            occurrence = this.myParentParameter.getTargetParameterValues().size();
        } else if (objectToBeValidated instanceof RAMLList) {
            occurrence = this.myParentParameter.getTargetLists().size();
            myListToBeValidated = (RAMLList)objectToBeValidated;
        }
        if (this.myExactOccurs != null && RAMLLogicalValidatorBase.parseInt(this.myExactOccurs) != occurrence) {
            details = RAMLValidationErrorMessageFactory.createParameterOccurrenceErrorMessage(this, metaParameter, objectToBeValidated, "exactOccurs");
            validationContext.setValidatedObject(objectToBeValidated);
            validationContext.addResult(RAMLLogicalValidatorBase.generateValidationError(metaParameter, objectToBeValidated, details));
        }
        if (this.myMinOccurs != null && RAMLLogicalValidatorBase.parseInt(this.myMinOccurs) > occurrence) {
            details = RAMLValidationErrorMessageFactory.createParameterOccurrenceErrorMessage(this, metaParameter, objectToBeValidated, "minOccurs");
            validationContext.setValidatedObject(objectToBeValidated);
            validationContext.addResult(RAMLLogicalValidatorBase.generateValidationError(metaParameter, objectToBeValidated, details));
        }
        if (this.myMaxOccurs != null && RAMLLogicalValidatorBase.parseInt(this.myMaxOccurs) < occurrence) {
            details = RAMLValidationErrorMessageFactory.createParameterOccurrenceErrorMessage(this, metaParameter, objectToBeValidated, "maxOccurs");
            validationContext.setValidatedObject(objectToBeValidated);
            validationContext.addResult(RAMLLogicalValidatorBase.generateValidationError(metaParameter, objectToBeValidated, details));
        }
        if (this.myMaxDifferentOccurs != null && myListToBeValidated != null) {
            ArrayList<String> values = new ArrayList<String>();
            try {
                for (Object item : myListToBeValidated.getListObjects()) {
                    RAMLParameter parameter = ((RAMLItem)item).getParameter(this.myParentParameter.getParamName());
                    if (parameter == null || values.contains(parameter.getValue())) continue;
                    values.add(parameter.getValue());
                }
                if (RAMLLogicalValidatorBase.parseInt(this.myMaxDifferentOccurs) < values.size()) {
                    Object[] texts = new Object[]{this.myParentParameter.getParamName(), metaParameter.getName(), metaParameter.getFullName(), this.myMaxDifferentOccurs, values.size()};
                    String details2 = String.valueOf(MessageFormat.format(this.myRB.getString("RAMLValidation.MaxDifferentOccur.ParameterPerList_Text"), texts)) + this.getDetailReason();
                    validationContext.setValidatedObject(objectToBeValidated);
                    validationContext.addResult(RAMLLogicalValidatorBase.generateValidationError(metaParameter, objectToBeValidated, details2));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.myLogger.debug("Failed to validate Parameter/List:" + metaParameter.getName() + ", please check the definition of relatedConditions in PDDB.");
            }
        }
    }

    public String getMinOccurs() {
        return this.myMinOccurs;
    }

    public String getExactOccurs() {
        return this.myExactOccurs;
    }

    public String getMaxOccurs() {
        return this.myMaxOccurs;
    }

    public String getMaxDifferentOccurs() {
        return this.myMaxDifferentOccurs;
    }
}

