/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.logical;

import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RamlConditionRelatedParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLLogicalValidatorBase;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLRelatedParameterValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLValue;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public class RAMLRelatedParameterPatternValidator
extends RAMLRelatedParameterValidator {
    private static final long serialVersionUID = -1419810384181407893L;

    public RAMLRelatedParameterPatternValidator(Node node, RamlConditionRelatedParameter parent) {
        super(node, parent);
    }

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        RAMLMetaParameter metaParameter = (RAMLMetaParameter)metaData;
        if (objectToBeValidated instanceof RAMLParameterList) {
            RAMLParameterList paramListToBeValidated = (RAMLParameterList)objectToBeValidated;
            int i = 0;
            while (i < paramListToBeValidated.size()) {
                validationContext.setValidatedObjectIndex(i);
                RAMLParameter ramlParameter = paramListToBeValidated.getParameters().get(i);
                String listParamName = MessageFormat.format(this.myRB.getString("RAMLValidation.List.Parameter.Name.Index"), paramListToBeValidated.getName(), Integer.toString(i + 1));
                RAMLSimpleType simpleType = (RAMLSimpleType)metaParameter.getValueType();
                simpleType.putProperty("listName", listParamName);
                this.generatePatternValidationError(validationContext, metaParameter, ramlParameter);
                ++i;
            }
        } else {
            RAMLParameter parameterToBeValidated = (RAMLParameter)objectToBeValidated;
            this.generatePatternValidationError(validationContext, metaParameter, parameterToBeValidated);
        }
    }

    private void generatePatternValidationError(RAMLValidationContext validationContext, RAMLMetaParameter metaParameter, RAMLParameter parameterToBeValidated) {
        String validatedValue = this.getPatternValidateValue(parameterToBeValidated);
        if (!Pattern.matches(this.myValue, validatedValue)) {
            String details = this.getErrorDetails(metaParameter, parameterToBeValidated);
            RAMLValidationResult result = RAMLLogicalValidatorBase.generateValidationError(metaParameter, parameterToBeValidated, details);
            result.setText(this.myRB.getString("RAMLValidation.Incorrect.Parameter"));
            result.setSource(parameterToBeValidated);
            result.setRelationshipId(this.getRelationshipId());
            validationContext.addResult(result);
        }
    }

    private String getPatternValidateValue(RAMLParameter parameter) {
        try {
            String uiValue = RAMLLogicalValidatorBase.getUIValue(parameter);
            Double value = Double.parseDouble(uiValue);
            if (value - (double)value.intValue() == 0.0) {
                return String.valueOf(value.intValue());
            }
            return uiValue;
        }
        catch (Exception e) {
            return parameter.getValue();
        }
    }

    private String getErrorDetails(RAMLMetaParameter metaP, RAMLParameter p) {
        RAMLValue valueType = (RAMLValue)metaP.getValueType();
        String list = null;
        if (valueType instanceof RAMLSimpleType) {
            list = ((RAMLSimpleType)valueType).getProperty("listName");
        }
        if (list == null) {
            Object[] texts = new Object[]{p.getName(), metaP.getFullName(), RAMLLogicalValidatorBase.getUIValue(p), this.myValue};
            return String.valueOf(MessageFormat.format(this.myRB.getString("RAMLValidation.ValuePattern.Details_SimpleText"), texts)) + this.getDetailReason();
        }
        Object[] texts = new Object[]{p.getName(), metaP.getFullName(), list, RAMLLogicalValidatorBase.getUIValue(p), this.myValue};
        return String.valueOf(MessageFormat.format(this.myRB.getString("RAMLValidation.ValuePattern.Details_Text"), texts)) + this.getDetailReason();
    }
}

