/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.logical;

import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RamlConditionRelatedParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLLogicalValidatorBase;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLRelatedParameterValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDecimal;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDecimalValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.util.GeneralUtils;
import java.text.MessageFormat;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RAMLRelatedParameterRangeValidator
extends RAMLRelatedParameterValidator {
    private static final long serialVersionUID = 4167026462106877104L;
    private String myMinIncl;
    private String myMaxIncl;
    private String myStep;

    public RAMLRelatedParameterRangeValidator(Node node, RamlConditionRelatedParameter parent) {
        super(node, parent);
        NamedNodeMap attributes = node.getAttributes();
        this.myMinIncl = this.readAttribute(attributes, "minIncl");
        this.myMaxIncl = this.readAttribute(attributes, "maxIncl");
        this.myStep = this.readAttribute(attributes, "step");
    }

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        if (objectToBeValidated instanceof RAMLParameter) {
            this.validateParameter(validationContext, metaData, objectToBeValidated);
        } else if (objectToBeValidated instanceof RAMLParameterList) {
            RAMLParameterList pList = (RAMLParameterList)objectToBeValidated;
            List<RAMLParameter> pListParameters = pList.getParameters();
            RAMLSimpleType simpleType = (RAMLSimpleType)((RAMLMetaParameter)metaData).getValueType();
            int i = 0;
            while (i < pListParameters.size()) {
                validationContext.setValidatedObjectIndex(i);
                RAMLParameter ramlParameter = pListParameters.get(i);
                String listParamName = MessageFormat.format(this.myRB.getString("RAMLValidation.List.Parameter.Name.Index"), pList.getName(), Integer.toString(i + 1));
                simpleType.putProperty("listName", listParamName);
                this.validateParameter(validationContext, metaData, ramlParameter);
                ++i;
            }
        }
    }

    private void validateParameter(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        RAMLParameter parameterToBeValidated = (RAMLParameter)objectToBeValidated;
        RAMLMetaParameter metaParameter = (RAMLMetaParameter)metaData;
        String value = parameterToBeValidated.getValue();
        if (value == null || GeneralUtils.isEmptyString(value)) {
            this.addValidationError(validationContext, metaParameter, parameterToBeValidated, "", "mandatory");
            return;
        }
        String uiValue = value;
        double valueToBeValidated = RAMLLogicalValidatorBase.parseDouble(value);
        RAMLSimpleType parameterType = (RAMLSimpleType)metaParameter.getValueType();
        if (parameterType instanceof RAMLDecimal) {
            Integer multiplier = (Integer)((RAMLDecimal)parameterType).getMultiplier();
            Integer divisor = (Integer)((RAMLDecimal)parameterType).getDivisor();
            Double shift = (Double)((RAMLDecimal)parameterType).getShift();
            if (!RAMLDecimalValidator.isSpecialValue(valueToBeValidated, ((RAMLDecimal)parameterType).getSpecialValues())) {
                valueToBeValidated *= (double)multiplier.intValue();
                valueToBeValidated /= (double)divisor.intValue();
                valueToBeValidated += shift.doubleValue();
                if (multiplier != 1 || divisor != 1 || shift != 0.0) {
                    uiValue = String.valueOf(valueToBeValidated);
                }
            }
        }
        if (this.myMinIncl != null && RAMLLogicalValidatorBase.parseDouble(this.myMinIncl) > valueToBeValidated) {
            this.addValidationError(validationContext, metaParameter, parameterToBeValidated, uiValue, "minIncl");
        }
        if (this.myMaxIncl != null && RAMLLogicalValidatorBase.parseDouble(this.myMaxIncl) < valueToBeValidated) {
            this.addValidationError(validationContext, metaParameter, parameterToBeValidated, uiValue, "maxIncl");
        }
        if (this.myStep != null && valueToBeValidated % RAMLLogicalValidatorBase.parseDouble(this.myStep) != 0.0) {
            this.addValidationError(validationContext, metaParameter, parameterToBeValidated, uiValue, "step");
        }
    }

    private void addValidationError(RAMLValidationContext validationContext, RAMLMetaParameter metaParameter, RAMLParameter parameterToBeValidated, String uiValue, String errorType) {
        String details = RAMLValidationErrorMessageFactory.createRangeErrorMessage(this, metaParameter, parameterToBeValidated, uiValue, errorType);
        RAMLValidationResult validationError = RAMLLogicalValidatorBase.generateValidationError(metaParameter, parameterToBeValidated, details);
        validationError.setRelationshipId(this.getRelationshipId());
        validationContext.addResult(validationError);
    }

    public String getMinIncl() {
        return this.myMinIncl;
    }

    public String getMaxIncl() {
        return this.myMaxIncl;
    }

    public String getStep() {
        return this.myStep;
    }
}

